/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import java.util.Arrays;

public class FloatIndirectHeaps {
    private FloatIndirectHeaps() {
    }

    public static int downHeap(float[] refArray, int[] heap, int[] inv, int size, int i, FloatComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        int e = heap[i];
        float E = refArray[e];
        if (c == null) {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && Float.compare(refArray[heap[child + 1]], refArray[heap[child]]) < 0) {
                    ++child;
                }
                if (Float.compare(E, refArray[heap[child]]) > 0) {
                    heap[i] = heap[child];
                    inv[heap[i]] = i;
                    i = child;
                    continue;
                }
                break;
            }
        } else {
            int child;
            while ((child = 2 * i + 1) < size) {
                if (child + 1 < size && c.compare(refArray[heap[child + 1]], refArray[heap[child]]) < 0) {
                    ++child;
                }
                if (c.compare(E, refArray[heap[child]]) > 0) {
                    heap[i] = heap[child];
                    inv[heap[i]] = i;
                    i = child;
                    continue;
                }
                break;
            }
        }
        heap[i] = e;
        inv[e] = i;
        return i;
    }

    public static int upHeap(float[] refArray, int[] heap, int[] inv, int size, int i, FloatComparator c) {
        if (i >= size) {
            throw new IllegalArgumentException("Heap position (" + i + ") is larger than or equal to heap size (" + size + ")");
        }
        int e = heap[i];
        float E = refArray[e];
        if (c == null) {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && Float.compare(refArray[heap[parent]], E) > 0) {
                heap[i] = heap[parent];
                inv[heap[i]] = i;
                i = parent;
            }
        } else {
            int parent;
            while (i != 0 && (parent = (i - 1) / 2) >= 0 && c.compare(refArray[heap[parent]], E) > 0) {
                heap[i] = heap[parent];
                inv[heap[i]] = i;
                i = parent;
            }
        }
        heap[i] = e;
        inv[e] = i;
        return i;
    }

    public static void makeHeap(float[] refArray, int offset, int length, int[] heap, int[] inv, FloatComparator c) {
        FloatArrays.ensureOffsetLength(refArray, offset, length);
        if (heap.length < length) {
            throw new IllegalArgumentException("The heap length (" + heap.length + ") is smaller than the number of elements (" + length + ")");
        }
        if (inv.length < refArray.length) {
            throw new IllegalArgumentException("The inversion array length (" + heap.length + ") is smaller than the length of the reference array (" + refArray.length + ")");
        }
        Arrays.fill(inv, 0, refArray.length, -1);
        int i = length;
        while (i-- != 0) {
            heap[i] = offset + i;
            inv[heap[i]] = i;
        }
        i = length / 2;
        while (i-- != 0) {
            FloatIndirectHeaps.downHeap(refArray, heap, inv, length, i, c);
        }
    }

    public static void makeHeap(float[] refArray, int[] heap, int[] inv, int size, FloatComparator c) {
        int i = size / 2;
        while (i-- != 0) {
            FloatIndirectHeaps.downHeap(refArray, heap, inv, size, i, c);
        }
    }
}

