/*
 * Decompiled with CFR 0.152.
 */
package junit.util;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class PropertyUtil {
    public static Properties flatCopy(Properties props) {
        Properties tmp = new Properties();
        tmp.putAll((Map<?, ?>)PropertyUtil.flatten(props));
        return tmp;
    }

    public static Map flatten(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, String> out = new TreeMap<String, String>();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            String propertyValue = properties.getProperty(property);
            out.put(property, propertyValue);
        }
        return out;
    }

    public static void list(String msg, Properties properties, PrintStream ps) {
        ps.println(msg + "-- listing properties --");
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            String propertyValue = properties.getProperty(property);
            ps.println(property + "=" + propertyValue);
        }
    }

    public static Properties fuse(Map defaults, Map override) {
        boolean ignoreConflicts = true;
        return PropertyUtil.fuse(defaults, override, true);
    }

    public static Properties fuse(Map defaults, Map override, boolean ignoreConflicts) {
        if (defaults == null) {
            throw new IllegalArgumentException();
        }
        if (override == null) {
            throw new IllegalArgumentException();
        }
        if (override instanceof Properties) {
            override = PropertyUtil.flatten((Properties)override);
        }
        if (!(defaults instanceof Properties)) {
            Properties tmp = new Properties();
            tmp.putAll((Map<?, ?>)defaults);
            defaults = tmp;
        }
        PropertyUtil.list("defaults : ", (Properties)defaults, System.err);
        for (Map.Entry entry : override.entrySet()) {
            String property = (String)entry.getKey();
            String overrideValue = (String)entry.getValue();
            String existingValue = ((Properties)defaults).getProperty(property);
            System.err.println("property=" + property + " : existingValue=" + existingValue + ", overrideValue=" + overrideValue);
            if (existingValue != null) {
                if (existingValue.equals(overrideValue)) continue;
                if (ignoreConflicts) {
                    defaults.put(property, overrideValue);
                    continue;
                }
                throw new RuntimeException("Would override property=" + property + ": existingValue=" + existingValue + ", overrideValue=" + overrideValue);
            }
            defaults.put(property, overrideValue);
        }
        return (Properties)defaults;
    }

    public static Properties convert(Map configParams) {
        Properties properties = null;
        if (configParams instanceof Properties) {
            properties = new Properties((Properties)configParams);
        } else {
            properties = new Properties();
            properties.putAll((Map<?, ?>)configParams);
        }
        return properties;
    }
}

