/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.plaintext;

import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastAnnouncementDecoder;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.MulticastRequestEncoder;
import com.sun.jini.discovery.UnicastDiscoveryClient;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.Plaintext;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;

public class Client
implements MulticastRequestEncoder,
MulticastAnnouncementDecoder,
UnicastDiscoveryClient {
    public String getFormatName() {
        return "net.jini.discovery.plaintext";
    }

    public void encodeMulticastRequest(MulticastRequest request, DatagramBufferFactory bufs, InvocationConstraints constraints) throws IOException {
        Plaintext.checkConstraints(constraints);
        Plaintext.encodeMulticastRequest(request, bufs);
    }

    public MulticastAnnouncement decodeMulticastAnnouncement(ByteBuffer buf, InvocationConstraints constraints) throws IOException {
        Plaintext.checkConstraints(constraints);
        return Plaintext.decodeMulticastAnnouncement(buf);
    }

    public void checkUnicastDiscoveryConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        Plaintext.checkConstraints(constraints);
    }

    public UnicastResponse doUnicastDiscovery(Socket socket, InvocationConstraints constraints, ClassLoader defaultLoader, ClassLoader verifierLoader, Collection context, ByteBuffer sent, ByteBuffer received) throws IOException, ClassNotFoundException {
        Plaintext.checkConstraints(constraints);
        return Plaintext.readUnicastResponse(new BufferedInputStream(socket.getInputStream()), defaultLoader, false, null, context);
    }
}

