/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyAxiomImpl;

public class OWLSubPropertyChainAxiomImpl
extends OWLPropertyAxiomImpl
implements OWLSubPropertyChainOfAxiom {
    private final List<OWLObjectPropertyExpression> propertyChain;
    private final OWLObjectPropertyExpression superProperty;

    public OWLSubPropertyChainAxiomImpl(List<? extends OWLObjectPropertyExpression> propertyChain, OWLObjectPropertyExpression superProperty, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.propertyChain = new ArrayList<OWLObjectPropertyExpression>((Collection)OWLAPIPreconditions.checkNotNull(propertyChain, "propertyChain cannot be null"));
        this.superProperty = OWLAPIPreconditions.checkNotNull(superProperty, "superProperty cannot be null");
    }

    @Override
    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> anns) {
        return (T)new OWLSubPropertyChainAxiomImpl(this.getPropertyChain(), this.getSuperProperty(), this.mergeAnnos(anns));
    }

    @Override
    public OWLSubPropertyChainOfAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLSubPropertyChainAxiomImpl(this.getPropertyChain(), this.getSuperProperty(), NO_ANNOTATIONS);
    }

    @Override
    public List<OWLObjectPropertyExpression> getPropertyChain() {
        return new ArrayList<OWLObjectPropertyExpression>(this.propertyChain);
    }

    @Override
    public OWLObjectPropertyExpression getSuperProperty() {
        return this.superProperty;
    }

    @Override
    public boolean isEncodingOfTransitiveProperty() {
        if (this.propertyChain.size() == 2) {
            return this.superProperty.equals(this.propertyChain.get(0)) && this.superProperty.equals(this.propertyChain.get(1));
        }
        return false;
    }
}

