/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasComponents;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLAPIStreamUtils {
    private OWLAPIStreamUtils() {
    }

    public static <T> Set<T> asSet(Stream<T> s) {
        LinkedHashSet set = new LinkedHashSet();
        OWLAPIStreamUtils.add(set, s);
        return set;
    }

    public static <T> Set<T> asSet(Stream<?> s, Class<T> type) {
        LinkedHashSet set = new LinkedHashSet();
        OWLAPIStreamUtils.add(set, s.map(x -> x));
        return set;
    }

    public static <T> Set<T> asUnorderedSet(Stream<T> s) {
        return s.collect(Collectors.toSet());
    }

    public static <T> Set<T> asUnorderedSet(Stream<?> s, Class<T> type) {
        return s.map(x -> x).collect(Collectors.toSet());
    }

    public static <T> List<T> asList(Stream<T> s) {
        ArrayList set = new ArrayList();
        OWLAPIStreamUtils.add(set, s);
        return set;
    }

    public static <T> List<T> asListNullsForbidden(Stream<T> s) {
        return OWLAPIStreamUtils.asList(s.map(OWLAPIPreconditions::checkNotNull));
    }

    public static <T> List<T> asList(Stream<?> s, Class<T> type) {
        return OWLAPIStreamUtils.asList(s.map(x -> x));
    }

    public static <T, Q> Map<T, Q> asMap(Stream<Q> s, Function<Q, T> f) {
        return OWLAPIStreamUtils.asMap(s, f, v -> v);
    }

    public static <K, V, Q> Map<K, V> asMap(Stream<Q> s, Function<Q, K> key, Function<Q, V> val) {
        return s.collect(Collectors.toConcurrentMap(v -> key.apply(v), v -> val.apply(v)));
    }

    public static boolean contains(Stream<?> s, Object o) {
        return s.anyMatch(x -> x.equals(o));
    }

    public static <T> boolean add(Collection<? super T> c, Stream<T> s) {
        int size = c.size();
        s.forEach(c::add);
        return c.size() != size;
    }

    public static int compareCollections(Collection<? extends OWLObject> set1, Collection<? extends OWLObject> set2) {
        TreeSet<? extends OWLObject> ss1 = set1 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set1 : new TreeSet<OWLObject>(set1);
        TreeSet<? extends OWLObject> ss2 = set2 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set2 : new TreeSet<OWLObject>(set2);
        return OWLAPIStreamUtils.compareIterators(ss1.iterator(), ss2.iterator());
    }

    public static int compareStreams(Stream<?> set1, Stream<?> set2) {
        return OWLAPIStreamUtils.compareIterators(set1.sorted().iterator(), set2.sorted().iterator());
    }

    public static int compareIterators(Iterator<?> set1, Iterator<?> set2) {
        while (set1.hasNext() && set2.hasNext()) {
            int diff;
            Object o1 = set1.next();
            Object o2 = set2.next();
            if (o1 instanceof Stream && o2 instanceof Stream) {
                diff = OWLAPIStreamUtils.compareIterators(((Stream)o1).iterator(), ((Stream)o2).iterator());
            } else if (o1 instanceof Collection && o2 instanceof Collection) {
                diff = OWLAPIStreamUtils.compareIterators(((Collection)o1).iterator(), ((Collection)o2).iterator());
            } else if (o1 instanceof Comparable && o2 instanceof Comparable) {
                diff = ((Comparable)o1).compareTo(o2);
            } else {
                throw new IllegalArgumentException("Incomparable types: '" + o1 + "' with class " + o1.getClass() + ", '" + o2 + "' with class " + o2.getClass() + " found while comparing iterators");
            }
            if (diff == 0) continue;
            return diff;
        }
        return Boolean.compare(set1.hasNext(), set2.hasNext());
    }

    public static boolean equalIterators(Iterator<?> set1, Iterator<?> set2) {
        while (set1.hasNext() && set2.hasNext()) {
            Object o1 = set1.next();
            Object o2 = set2.next();
            if (!(o1 instanceof Stream && o2 instanceof Stream ? !OWLAPIStreamUtils.equalStreams((Stream)o1, (Stream)o2) : !o1.equals(o2))) continue;
            return false;
        }
        return set1.hasNext() == set2.hasNext();
    }

    public static boolean equalStreams(Stream<?> set1, Stream<?> set2) {
        return OWLAPIStreamUtils.equalIterators(set1.iterator(), set2.iterator());
    }

    public static int compareLists(List<? extends OWLObject> set1, List<? extends OWLObject> set2) {
        return OWLAPIStreamUtils.compareIterators(set1.iterator(), set2.iterator());
    }

    public static <T> Stream<T> empty() {
        return Stream.empty();
    }

    public static Stream<?> allComponents(HasComponents root) {
        ArrayList<Stream<HasComponents>> streams = new ArrayList<Stream<HasComponents>>();
        streams.add(Stream.of(root));
        root.components().forEach(o -> {
            if (o != root) {
                if (o instanceof HasComponents) {
                    streams.add(OWLAPIStreamUtils.allComponents((HasComponents)o));
                } else {
                    streams.add(Stream.of(o));
                }
            }
        });
        return streams.stream().flatMap(x -> x);
    }

    public static Stream<?> flatComponents(HasComponents root) {
        ArrayList<HasComponents> streams = new ArrayList<HasComponents>();
        streams.add(root);
        root.components().filter(o -> o != root).forEach(o -> OWLAPIStreamUtils.flatIteration(streams, o));
        return streams.stream();
    }

    protected static void flatIteration(List streams, Object o) {
        if (o instanceof Stream) {
            ((Stream)o).forEach(o1 -> OWLAPIStreamUtils.flatIteration(streams, o1));
        } else if (o instanceof Collection) {
            ((Collection)o).forEach(o1 -> OWLAPIStreamUtils.flatIteration(streams, o1));
        } else if (o instanceof HasComponents) {
            streams.add(o);
            ((HasComponents)o).components().forEach(o1 -> OWLAPIStreamUtils.flatIteration(streams, o1));
        } else {
            streams.add(o);
        }
    }

    public static Stream<int[]> pairs(int size) {
        ArrayList<int[]> values = new ArrayList<int[]>((size * size - size) / 2);
        for (int i = 0; i < size - 1; ++i) {
            int j = i + 1;
            while (j < size) {
                values.add(new int[]{i, j++});
            }
        }
        return values.stream();
    }

    public static Stream<int[]> allPairs(int size) {
        ArrayList<int[]> values = new ArrayList<int[]>(size * size - size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (i == j) continue;
                values.add(new int[]{i, j});
            }
        }
        return values.stream();
    }

    public static <T> Stream<Pair<T>> pairs(Collection<T> input) {
        ArrayList<T> l = input instanceof List ? (ArrayList<T>)input : new ArrayList<T>(input);
        int size = l.size();
        ArrayList values = new ArrayList((size * size - size) / 2);
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                values.add(OWLAPIStreamUtils.pair(l.get(i), l.get(j)));
            }
        }
        return values.stream();
    }

    public static <T> Stream<Pair<T>> allPairs(Collection<T> input) {
        ArrayList<T> l = input instanceof List ? (ArrayList<T>)input : new ArrayList<T>(input);
        int size = l.size();
        ArrayList values = new ArrayList(size * size - size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (i == j) continue;
                values.add(OWLAPIStreamUtils.pair(l.get(i), l.get(j)));
            }
        }
        return values.stream();
    }

    public static <T> Stream<Pair<T>> pairs(Stream<T> input) {
        return OWLAPIStreamUtils.pairs(OWLAPIStreamUtils.asList(input));
    }

    public static <T> Stream<Pair<T>> allPairs(Stream<T> input) {
        return OWLAPIStreamUtils.allPairs(OWLAPIStreamUtils.asList(input));
    }

    public static <T> Pair<T> pair(T i, T j) {
        return new Pair<T>(i, j);
    }

    public static class Pair<T> {
        public final T i;
        public final T j;

        public Pair(T i, T j) {
            this.i = i;
            this.j = j;
        }
    }
}

