/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.model;

import gnu.trove.map.custom_hash.TObjectIntCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.rdf.model.AbstractTranslator;
import org.semanticweb.owlapi.util.AxiomAppearance;
import org.semanticweb.owlapi.util.IndividualAppearance;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RDFTranslator
extends AbstractTranslator<RDFNode, RDFResource, RDFResourceIRI, RDFLiteral> {
    protected final AxiomAppearance axiomOccurrences;
    private final AtomicInteger nextBlankNodeId;
    private TObjectIntCustomHashMap<Object> blankNodeMap = new TObjectIntCustomHashMap((HashingStrategy)new IdentityHashingStrategy());

    public RDFTranslator(OWLOntologyManager manager, OWLOntology ontology, boolean useStrongTyping, IndividualAppearance occurrences, AxiomAppearance axiomOccurrences, AtomicInteger counter) {
        super(manager, ontology, useStrongTyping, occurrences);
        this.axiomOccurrences = axiomOccurrences;
        this.nextBlankNodeId = counter;
    }

    @Override
    protected void addTriple(RDFResource subject, RDFResourceIRI pred, @Nonnull RDFNode object) {
        this.graph.addTriple(new RDFTriple(subject, pred, object));
    }

    @Override
    protected RDFResourceBlankNode getAnonymousNode(Object key) {
        OWLAPIPreconditions.checkNotNull(key, "key cannot be null");
        boolean isIndividual = key instanceof OWLAnonymousIndividual;
        boolean isAxiom = false;
        boolean needId = false;
        if (isIndividual) {
            OWLAnonymousIndividual anonymousIndividual = (OWLAnonymousIndividual)key;
            needId = this.multipleOccurrences.appearsMultipleTimes(anonymousIndividual);
            return this.getBlankNodeFor(anonymousIndividual.getID().getID(), isIndividual, isAxiom, needId);
        }
        if (key instanceof OWLAxiom) {
            isIndividual = false;
            isAxiom = true;
            needId = this.axiomOccurrences.appearsMultipleTimes((OWLAxiom)key);
        }
        return this.getBlankNodeFor(key, isIndividual, isAxiom, needId);
    }

    protected RDFResourceBlankNode getBlankNodeFor(Object key, boolean isIndividual, boolean isAxiom, boolean needId) {
        int id = this.blankNodeMap.get(key);
        if (id == 0) {
            id = this.nextBlankNodeId.getAndIncrement();
            this.blankNodeMap.put(key, id);
        }
        return new RDFResourceBlankNode(id, isIndividual, needId, isAxiom);
    }

    @Override
    protected RDFLiteral getLiteralNode(@Nonnull OWLLiteral literal) {
        return new RDFLiteral(literal);
    }

    @Override
    protected RDFResourceIRI getPredicateNode(@Nonnull IRI iri) {
        return new RDFResourceIRI(iri);
    }

    @Override
    protected RDFResourceIRI getResourceNode(@Nonnull IRI iri) {
        return new RDFResourceIRI(iri);
    }
}

