/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.normalform;

import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.normalform.NormalFormRewriter;
import org.semanticweb.owlapi.normalform.OWLObjectComplementOfExtractor;
import org.semanticweb.owlapi.util.NNF;

public class NegationalNormalFormConverter
implements NormalFormRewriter {
    private final NNF nnf;
    private final OWLObjectComplementOfExtractor extractor = new OWLObjectComplementOfExtractor();

    public NegationalNormalFormConverter(OWLDataFactory dataFactory) {
        this.nnf = new NNF(dataFactory);
    }

    @Override
    public boolean isInNormalForm(OWLClassExpression c) {
        this.extractor.getComplementedClassExpressions(c);
        return !this.extractor.getComplementedClassExpressions(c).stream().anyMatch(IsAnonymous::isAnonymous);
    }

    @Override
    public OWLClassExpression convertToNormalForm(OWLClassExpression classExpression) {
        this.nnf.reset();
        return classExpression.accept(this.nnf.getClassVisitor());
    }
}

