/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.modularity.locality;

import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticLocalityEvaluator
implements LocalityEvaluator {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SemanticLocalityEvaluator.class);
    protected final OWLDataFactory df;
    protected final OWLReasoner reasoner;
    private final AxiomLocalityVisitor axiomVisitor = new AxiomLocalityVisitor();
    private final BottomReplacer bottomReplacer = new BottomReplacer();

    public SemanticLocalityEvaluator(OWLOntologyManager man, OWLReasonerFactory reasonerFactory) {
        this.df = OWLAPIPreconditions.checkNotNull(man, "man cannot be null").getOWLDataFactory();
        try {
            this.reasoner = OWLAPIPreconditions.checkNotNull(reasonerFactory, "reasonerFactory cannot be null").createNonBufferingReasoner(man.createOntology());
        }
        catch (Exception e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public boolean isLocal(OWLAxiom axiom, Collection<OWLEntity> signature) {
        LOGGER.info("Replacing axiom by Bottom");
        OWLAxiom newAxiom = this.bottomReplacer.replaceBottom(OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null"), OWLAPIPreconditions.checkNotNull(signature, "signature cannot be null"));
        return this.axiomVisitor.isLocal(newAxiom);
    }

    private class BottomReplacer
    implements OWLAxiomVisitor,
    OWLClassExpressionVisitor {
        @Nullable
        private OWLAxiom newAxiom;
        @Nullable
        private OWLClassExpression newClassExpression;
        private Collection<OWLEntity> signature;

        BottomReplacer() {
        }

        public OWLAxiom getResult() {
            return OWLAPIPreconditions.verifyNotNull(this.newAxiom);
        }

        public OWLAxiom replaceBottom(OWLAxiom axiom, Collection<OWLEntity> sig) {
            this.reset(OWLAPIPreconditions.checkNotNull(sig, "sig cannot be null"));
            OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null").accept(this);
            return this.getResult();
        }

        public OWLClassExpression replaceBottom(OWLClassExpression desc) {
            this.newClassExpression = null;
            OWLAPIPreconditions.checkNotNull(desc, "desc cannot be null").accept(this);
            if (this.newClassExpression == null) {
                throw new OWLRuntimeException("Unsupported class expression " + desc);
            }
            return OWLAPIPreconditions.verifyNotNull(this.newClassExpression);
        }

        public Set<OWLClassExpression> replaceBottom(Stream<? extends OWLClassExpression> exps) {
            OWLAPIPreconditions.checkNotNull(exps, "exps cannot be null");
            return OWLAPIStreamUtils.asUnorderedSet(exps.map(this::replaceBottom));
        }

        public void reset(Collection<OWLEntity> s) {
            this.signature = OWLAPIPreconditions.checkNotNull(s, "s cannot be null");
            this.newAxiom = null;
        }

        @Override
        public void visit(OWLClass ce) {
            this.newClassExpression = this.signature.contains(ce) ? ce : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLDataAllValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        @Override
        public void visit(OWLDataExactCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLDataMaxCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        @Override
        public void visit(OWLDataMinCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLDataSomeValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().asOWLDataProperty()) ? ce : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLDataHasValue ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            Set<OWLClassExpression> disjointclasses = this.replaceBottom(axiom.classExpressions());
            this.newAxiom = SemanticLocalityEvaluator.this.df.getOWLDisjointClassesAxiom(disjointclasses);
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            Set<OWLClassExpression> eqclasses = this.replaceBottom(axiom.classExpressions());
            this.newAxiom = SemanticLocalityEvaluator.this.df.getOWLEquivalentClassesAxiom(eqclasses);
        }

        @Override
        public void visit(OWLObjectAllValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? SemanticLocalityEvaluator.this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)ce.getProperty(), this.replaceBottom((OWLClassExpression)ce.getFiller())) : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        @Override
        public void visit(OWLObjectComplementOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLObjectComplementOf(this.replaceBottom(ce.getOperand()));
        }

        @Override
        public void visit(OWLObjectExactCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? ce : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLObjectIntersectionOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLObjectIntersectionOf(this.replaceBottom(ce.operands()));
        }

        @Override
        public void visit(OWLObjectMaxCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? ce : SemanticLocalityEvaluator.this.df.getOWLThing();
        }

        @Override
        public void visit(OWLObjectMinCardinality ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? ce : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLObjectOneOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLObjectHasSelf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLObjectSomeValuesFrom ce) {
            this.newClassExpression = this.signature.contains(ce.getProperty().getNamedProperty()) ? SemanticLocalityEvaluator.this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)ce.getProperty(), this.replaceBottom((OWLClassExpression)ce.getFiller())) : SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLObjectUnionOf ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLObjectUnionOf(this.replaceBottom(ce.operands()));
        }

        @Override
        public void visit(OWLObjectHasValue ce) {
            this.newClassExpression = SemanticLocalityEvaluator.this.df.getOWLNothing();
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            OWLClassExpression sup = this.replaceBottom(axiom.getSuperClass());
            OWLClassExpression sub = this.replaceBottom(axiom.getSubClass());
            this.newAxiom = SemanticLocalityEvaluator.this.df.getOWLSubClassOfAxiom(sub, sup);
        }
    }

    private class AxiomLocalityVisitor
    implements OWLAxiomVisitor {
        private boolean isLocal;

        AxiomLocalityVisitor() {
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public boolean isLocal(OWLAxiom axiom) {
            this.reset();
            axiom.accept(this);
            return this.isLocal();
        }

        public void reset() {
            this.isLocal = false;
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            this.isLocal = true;
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            if (axiom.classExpressions().count() != 2L) {
                return;
            }
            LOGGER.info("Calling the Reasoner");
            this.isLocal = SemanticLocalityEvaluator.this.reasoner.isEntailed((OWLAxiom)axiom);
            LOGGER.info("DONE Calling the Reasoner. isLocal = {}", (Object)this.isLocal);
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            LOGGER.info("Calling the Reasoner");
            this.isLocal = SemanticLocalityEvaluator.this.reasoner.isEntailed((OWLAxiom)axiom);
            LOGGER.info("DONE Calling the Reasoner. isLocal = {}", (Object)this.isLocal);
        }
    }
}

