/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.sparse;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.sparse.AbstractAtomicRowReadOrWrite;
import com.bigdata.sparse.INameFilter;
import com.bigdata.sparse.Schema;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.sparse.TPS;
import com.bigdata.sparse.TimestampChooser;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtomicRowDelete
extends AbstractAtomicRowReadOrWrite {
    private static final long serialVersionUID = 7481235291210326044L;
    private static final Logger log = Logger.getLogger(AtomicRowDelete.class);
    private long writeTime;

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    public AtomicRowDelete() {
    }

    public AtomicRowDelete(Schema schema, Object primaryKey, long fromTime, long toTime, long writeTime, INameFilter filter) {
        super(schema, primaryKey, fromTime, toTime, filter);
        SparseRowStore.assertWriteTime(writeTime);
        this.writeTime = writeTime;
    }

    @Override
    public TPS apply(IIndex ndx) {
        long timestamp = TimestampChooser.chooseTimestamp(ndx, this.writeTime);
        byte[] fromKey = this.schema.getPrefix(ndx.getIndexMetadata().getKeyBuilder(), this.primaryKey);
        TPS tps = this.atomicDelete(ndx, fromKey, this.schema, timestamp, this.filter);
        if (tps == null && log.isInfoEnabled()) {
            log.info((Object)("No data for primaryKey: " + this.primaryKey));
        }
        return tps;
    }

    private TPS atomicDelete(IIndex ndx, byte[] fromKey, Schema schema, long writeTime, INameFilter filter) {
        TPS tps = AtomicRowDelete.atomicRead(ndx, fromKey, schema, this.fromTime, this.toTime, filter, new TPS(schema, writeTime));
        if (tps != null) {
            Map<String, Object> map = tps.asMap();
            if (log.isInfoEnabled()) {
                log.info((Object)("Will delete " + map.size() + " properties: names=" + map.keySet()));
            }
            IKeyBuilder keyBuilder = ndx.getIndexMetadata().getKeyBuilder();
            for (String col : map.keySet()) {
                byte[] key = schema.getKey(keyBuilder, this.primaryKey, col, writeTime);
                ndx.insert(key, null);
            }
        }
        return tps;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.writeTime = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.writeTime);
    }
}

