/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.search.ConfigurableAnalyzerFactory;
import com.bigdata.search.ConfiguredAnalyzerFactory;
import com.bigdata.search.FullTextIndex;
import com.bigdata.search.IAnalyzerFactory;
import com.bigdata.search.PatternAnalyzerImpl;
import com.bigdata.search.TermCompletionAnalyzer;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;

class NeedsConfiguringAnalyzerFactory
implements IAnalyzerFactory {
    private static final transient Logger log = Logger.getLogger(NeedsConfiguringAnalyzerFactory.class);
    private static final Map<UUID, ConfiguredAnalyzerFactory> allConfigs = Collections.synchronizedMap(new WeakHashMap());
    private static final String ALL_LUCENE_NATURAL_LANGUAGES = "com.bigdata.search.ConfigurableAnalyzerFactory.analyzer.*.like=eng\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.por.analyzerClass=org.apache.lucene.analysis.br.BrazilianAnalyzer\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.pt.like=por\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.zho.analyzerClass=org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.chi.like=zho\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.zh.like=zho\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.jpn.analyzerClass=org.apache.lucene.analysis.cjk.CJKAnalyzer\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.ja.like=jpn\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.kor.like=jpn\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.ko.like=kor\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.ces.analyzerClass=org.apache.lucene.analysis.cz.CzechAnalyzer\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.cze.like=ces\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.cs.like=ces\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.dut.analyzerClass=org.apache.lucene.analysis.nl.DutchAnalyzer\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.nld.like=dut\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.nl.like=dut\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.deu.analyzerClass=org.apache.lucene.analysis.de.GermanAnalyzer\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.ger.like=deu\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.de.like=deu\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.gre.analyzerClass=org.apache.lucene.analysis.el.GreekAnalyzer\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.ell.like=gre\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.el.like=gre\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.rus.analyzerClass=org.apache.lucene.analysis.ru.RussianAnalyzer\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.ru.like=rus\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.tha.analyzerClass=org.apache.lucene.analysis.th.ThaiAnalyzer\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.th.like=tha\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.eng.analyzerClass=org.apache.lucene.analysis.standard.StandardAnalyzer\ncom.bigdata.search.ConfigurableAnalyzerFactory.analyzer.en.like=eng\n";
    private static final String LUCENE_STANDARD_ANALYZER = "com.bigdata.search.ConfigurableAnalyzerFactory.analyzer.*.analyzerClass=org.apache.lucene.analysis.standard.StandardAnalyzer\n";
    static int loggerIdCounter = 0;
    private final FullTextIndex<?> fullTextIndex;
    private final ConfigurableAnalyzerFactory parent;

    NeedsConfiguringAnalyzerFactory(ConfigurableAnalyzerFactory parent, FullTextIndex<?> fullTextIndex) {
        if (fullTextIndex == null) {
            throw new IllegalArgumentException();
        }
        this.fullTextIndex = fullTextIndex;
        this.parent = parent;
    }

    private ConfiguredAnalyzerFactory init() {
        UUID uuid = this.fullTextIndex.getIndex().getIndexMetadata().getIndexUUID();
        ConfiguredAnalyzerFactory configuration = allConfigs.get(uuid);
        if (configuration == null) {
            Properties properties = this.initProperties();
            HashMap<String, ConfigOptionsToAnalyzer> analyzers = new HashMap<String, ConfigOptionsToAnalyzer>();
            this.properties2analyzers(properties, analyzers);
            if (!analyzers.containsKey("*")) {
                throw new RuntimeException("Bad config: must specify behavior on language range '*'");
            }
            for (ConfigOptionsToAnalyzer a : analyzers.values()) {
                a.validate();
            }
            try {
                for (ConfigOptionsToAnalyzer a : analyzers.values()) {
                    a.setAnalyzerPair(a.construct());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot construct ConfigurableAnalyzerFactory", e);
            }
            int sz = analyzers.size();
            for (ConfigOptionsToAnalyzer a : analyzers.values()) {
                a.followLikesToAnalyzerPair(0, sz, analyzers);
            }
            Object[] allPairs = new AnalyzerPair[sz];
            int i = 0;
            for (ConfigOptionsToAnalyzer a : analyzers.values()) {
                allPairs[i++] = a.result;
            }
            Arrays.sort(allPairs);
            if (log.isInfoEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Installed text Analyzer's: ");
                for (Object ap : allPairs) {
                    sb.append(((ConfiguredAnalyzerFactory.AnalyzerPair)ap).toString());
                    sb.append(", ");
                }
                log.info((Object)sb.toString());
            }
            configuration = new ConfiguredAnalyzerFactory((ConfiguredAnalyzerFactory.AnalyzerPair[])allPairs, this.getDefaultLanguage());
            allConfigs.put(uuid, configuration);
        }
        return configuration;
    }

    private String getDefaultLanguage() {
        IKeyBuilder keyBuilder = this.fullTextIndex.getKeyBuilder();
        if (keyBuilder.isUnicodeSupported()) {
            Locale locale = ((KeyBuilder)keyBuilder).getSortKeyGenerator().getLocale();
            return locale.getLanguage();
        }
        return "en";
    }

    private static boolean hasConstructor(Class<? extends Analyzer> cls, Class<?> ... parameterTypes) {
        return NeedsConfiguringAnalyzerFactory.getConstructor(cls, parameterTypes) != null;
    }

    protected static Constructor<? extends Analyzer> getConstructor(Class<? extends Analyzer> cls, Class<?> ... parameterTypes) {
        try {
            return cls.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            return null;
        }
    }

    private void properties2analyzers(Properties props, Map<String, ConfigOptionsToAnalyzer> analyzers) {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String[] languageRangeAndProperty;
            String prop = (String)en.nextElement();
            if (prop.equals(ConfigurableAnalyzerFactory.Options.NATURAL_LANGUAGE_SUPPORT)) continue;
            if (prop.startsWith(ConfigurableAnalyzerFactory.Options.ANALYZER) && (languageRangeAndProperty = prop.substring(ConfigurableAnalyzerFactory.Options.ANALYZER.length()).replaceAll("_", "*").split("[.]")).length == 2) {
                String languageRange = languageRangeAndProperty[0].toLowerCase(Locale.US);
                String shortProperty = languageRangeAndProperty[1];
                String value = props.getProperty(prop);
                log.info((Object)("Setting language range: " + languageRange + "/" + shortProperty + " = " + value));
                ConfigOptionsToAnalyzer cons = analyzers.get(languageRange);
                if (cons == null) {
                    cons = new ConfigOptionsToAnalyzer(languageRange);
                    analyzers.put(languageRange, cons);
                }
                if (cons.setProperty(shortProperty, value)) continue;
            }
            log.warn((Object)("Failed to process configuration property: " + prop));
        }
    }

    protected Properties initProperties() {
        Properties parentProperties = this.fullTextIndex.getProperties();
        Properties myProps = Boolean.valueOf(parentProperties.getProperty(ConfigurableAnalyzerFactory.Options.NATURAL_LANGUAGE_SUPPORT, "false")) != false ? this.loadPropertyString(ALL_LUCENE_NATURAL_LANGUAGES) : (this.hasPropertiesForStarLanguageRange(parentProperties) ? new Properties() : this.loadPropertyString(LUCENE_STANDARD_ANALYZER));
        this.copyRelevantProperties(this.fullTextIndex.getProperties(), myProps);
        return myProps;
    }

    Properties loadPropertyString(String props) {
        Properties rslt = new Properties();
        try {
            rslt.load(new StringReader(props));
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible - well clearly not!", e);
        }
        return rslt;
    }

    private void copyRelevantProperties(Properties from, Properties to) {
        Enumeration<?> en = from.propertyNames();
        while (en.hasMoreElements()) {
            String prop = (String)en.nextElement();
            if (!prop.startsWith(ConfigurableAnalyzerFactory.class.getName())) continue;
            to.setProperty(prop, from.getProperty(prop));
        }
    }

    private boolean hasPropertiesForStarLanguageRange(Properties from) {
        Enumeration<?> en = from.propertyNames();
        while (en.hasMoreElements()) {
            String prop = (String)en.nextElement();
            if (!prop.startsWith(ConfigurableAnalyzerFactory.Options.ANALYZER + "_.") && !prop.startsWith(ConfigurableAnalyzerFactory.Options.ANALYZER + "*.")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Analyzer getAnalyzer(String languageCode, boolean filterStopwords) {
        ConfiguredAnalyzerFactory realDelegate = this.init();
        this.parent.delegate = realDelegate;
        return realDelegate.getAnalyzer(languageCode, filterStopwords);
    }

    private static class ConfigOptionsToAnalyzer {
        String like;
        String className;
        String stopwords;
        Pattern pattern;
        final String languageRange;
        AnalyzerPair result;
        Pattern wordBoundary;
        Pattern subWordBoundary;
        Pattern softHyphens;
        Boolean alwaysRemoveSoftHyphens;

        public ConfigOptionsToAnalyzer(String languageRange) {
            this.languageRange = languageRange;
        }

        public Set<?> getStopWords() {
            if (this.doNotUseStopWords()) {
                return CharArraySet.EMPTY_SET;
            }
            if (this.useDefaultStopWords()) {
                return this.getStopWordsForClass(this.className);
            }
            return this.getStopWordsForClass(this.stopwords);
        }

        boolean doNotUseStopWords() {
            return "none".equals(this.stopwords) || this.stopwords == null && this.pattern != null;
        }

        protected Set<?> getStopWordsForClass(String clazzName) {
            Class<? extends Analyzer> analyzerClass = this.getAnalyzerClass(clazzName);
            try {
                return (Set)analyzerClass.getMethod("getDefaultStopSet", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                if (StandardAnalyzer.class.equals(analyzerClass)) {
                    return StandardAnalyzer.STOP_WORDS_SET;
                }
                if (StopAnalyzer.class.equals(analyzerClass)) {
                    return StopAnalyzer.ENGLISH_STOP_WORDS_SET;
                }
                throw new RuntimeException("Failed to find stop words from " + clazzName + " for language range " + this.languageRange);
            }
        }

        protected boolean useDefaultStopWords() {
            return this.stopwords == null && this.pattern == null || "default".equals(this.stopwords);
        }

        public boolean setProperty(String shortProperty, String value) {
            if (shortProperty.equals("like")) {
                this.like = value;
            } else if (shortProperty.equals("analyzerClass")) {
                this.className = value;
            } else if (shortProperty.equals("stopwords")) {
                this.stopwords = value;
            } else if (shortProperty.equals("pattern")) {
                this.pattern = Pattern.compile(value, 256);
            } else if (shortProperty.equals("wordBoundary")) {
                this.wordBoundary = Pattern.compile(value, 256);
            } else if (shortProperty.equals("subWordBoundary")) {
                this.subWordBoundary = Pattern.compile(value, 256);
            } else if (shortProperty.equals("softHyphens")) {
                this.softHyphens = Pattern.compile(value, 256);
            } else if (shortProperty.equals("alwaysRemoveSoftHyphens")) {
                this.alwaysRemoveSoftHyphens = Boolean.valueOf(value);
            } else {
                return false;
            }
            return true;
        }

        public void validate() {
            if (this.pattern != null) {
                if (this.className != null && this.className != PatternTokenizer.class.getName()) {
                    throw new RuntimeException("Bad Option: Language range " + this.languageRange + " with pattern propety for class " + this.className);
                }
                this.className = PatternTokenizer.class.getName();
            }
            if (this.wordBoundary != null) {
                if (this.className != null && this.className != TermCompletionAnalyzer.class.getName()) {
                    throw new RuntimeException("Bad Option: Language range " + this.languageRange + " with pattern propety for class " + this.className);
                }
                this.className = TermCompletionAnalyzer.class.getName();
                if (this.subWordBoundary == null) {
                    this.subWordBoundary = ConfigurableAnalyzerFactory.AnalyzerOptions.DEFAULT_SUB_WORD_BOUNDARY;
                }
                if (this.alwaysRemoveSoftHyphens != null && this.softHyphens == null) {
                    throw new RuntimeException("Bad option: Language range " + this.languageRange + ": must specify softHypens when setting alwaysRemoveSoftHyphens");
                }
                if (this.softHyphens != null && this.alwaysRemoveSoftHyphens == null) {
                    this.alwaysRemoveSoftHyphens = false;
                }
            } else if (this.subWordBoundary != null || this.softHyphens != null || this.alwaysRemoveSoftHyphens != null || TermCompletionAnalyzer.class.getName().equals(this.className)) {
                throw new RuntimeException("Bad option: Language range " + this.languageRange + ": must specify wordBoundary for TermCompletionAnalyzer");
            }
            if (PatternTokenizer.class.getName().equals(this.className) && this.pattern == null) {
                throw new RuntimeException("Bad Option: Language range " + this.languageRange + " must specify pattern for PatternTokenizer.");
            }
            if (this.like != null == (this.className != null)) {
                throw new RuntimeException("Bad Option: Language range " + this.languageRange + " must specify exactly one of implementation class or like.");
            }
            if (this.stopwords != null && this.like != null) {
                throw new RuntimeException("Bad Option: Language range " + this.languageRange + " must not specify stopwords with like.");
            }
        }

        private AnalyzerPair construct() throws Exception {
            if (this.className == null) {
                return null;
            }
            if (this.pattern != null) {
                return new PatternAnalyzer(this, this.pattern);
            }
            if (this.softHyphens != null) {
                return new AnalyzerPair(this.languageRange, new TermCompletionAnalyzer(this.wordBoundary, this.subWordBoundary, this.softHyphens, this.alwaysRemoveSoftHyphens));
            }
            if (this.wordBoundary != null) {
                return new AnalyzerPair(this.languageRange, new TermCompletionAnalyzer(this.wordBoundary, this.subWordBoundary));
            }
            Class<? extends Analyzer> cls = this.getAnalyzerClass();
            if (NeedsConfiguringAnalyzerFactory.hasConstructor(cls, new Class[]{CharArraySet.class})) {
                return new AnalyzerPair(this.languageRange, cls.getConstructor(CharArraySet.class).newInstance(new CharArraySet(this.getStopWords(), false)), cls.getConstructor(CharArraySet.class).newInstance(new CharArraySet(Collections.emptySet(), false)));
            }
            if (NeedsConfiguringAnalyzerFactory.hasConstructor(cls, new Class[]{Version.class, Set.class})) {
                if (RussianAnalyzer.class.equals(cls)) {
                    if (this.useDefaultStopWords()) {
                        return new AnalyzerPair(this.languageRange, (Analyzer)new RussianAnalyzer(), (Analyzer)new RussianAnalyzer(CharArraySet.EMPTY_SET));
                    }
                    if (this.doNotUseStopWords()) {
                        return new AnalyzerPair(this.languageRange, (Analyzer)new RussianAnalyzer(CharArraySet.EMPTY_SET));
                    }
                }
                return new VersionSetAnalyzerPair(this, cls);
            }
            if (this.stopwords != null && !this.stopwords.equals("none")) {
                throw new RuntimeException("Bad option: language range: " + this.languageRange + " stopwords are not supported by " + this.className);
            }
            if (NeedsConfiguringAnalyzerFactory.hasConstructor(cls, new Class[]{Version.class})) {
                return new VersionAnalyzerPair(this.languageRange, cls);
            }
            if (NeedsConfiguringAnalyzerFactory.hasConstructor(cls, new Class[0])) {
                return new AnalyzerPair(this.languageRange, cls.newInstance());
            }
            throw new RuntimeException("Bad option: cannot find constructor for class " + this.className + " for language range " + this.languageRange);
        }

        AnalyzerPair followLikesToAnalyzerPair(int depth, int max, Map<String, ConfigOptionsToAnalyzer> analyzers) {
            if (this.result == null) {
                if (depth == max) {
                    throw new RuntimeException("Bad configuration: - 'like' loop for language range " + this.languageRange);
                }
                ConfigOptionsToAnalyzer next = analyzers.get(this.like);
                if (next == null) {
                    throw new RuntimeException("Bad option: - 'like' not found for language range " + this.languageRange + " (not found: '" + this.like + "')");
                }
                this.result = new AnalyzerPair(this.languageRange, next.followLikesToAnalyzerPair(depth + 1, max, analyzers));
            }
            return this.result;
        }

        protected Class<? extends Analyzer> getAnalyzerClass() {
            return this.getAnalyzerClass(this.className);
        }

        protected Class<? extends Analyzer> getAnalyzerClass(String className2) {
            Class<?> cls;
            try {
                cls = Class.forName(className2);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Bad option: cannot find class " + className2 + " for language range " + this.languageRange, e);
            }
            return cls;
        }

        void setAnalyzerPair(AnalyzerPair ap) {
            this.result = ap;
        }
    }

    private static class PatternAnalyzer
    extends AnalyzerPair {
        public PatternAnalyzer(ConfigOptionsToAnalyzer lro, Pattern pattern, CharArraySet stopWords) throws Exception {
            super(lro.languageRange, new PatternAnalyzerImpl(pattern, stopWords), new PatternAnalyzerImpl(pattern, CharArraySet.EMPTY_SET));
        }

        public PatternAnalyzer(ConfigOptionsToAnalyzer lro, Pattern pattern) throws Exception {
            super(lro.languageRange, new PatternAnalyzerImpl(pattern, CharArraySet.EMPTY_SET));
        }
    }

    private static class VersionAnalyzerPair
    extends AnalyzerPair {
        public VersionAnalyzerPair(String range, Class<? extends Analyzer> cls) throws Exception {
            super(range, NeedsConfiguringAnalyzerFactory.getConstructor(cls, Version.class).newInstance(Version.LUCENE_CURRENT));
        }
    }

    private static class VersionSetAnalyzerPair
    extends AnalyzerPair {
        public VersionSetAnalyzerPair(ConfigOptionsToAnalyzer lro, Class<? extends Analyzer> cls) throws Exception {
            super(lro.languageRange, NeedsConfiguringAnalyzerFactory.getConstructor(cls, Version.class, Set.class), Version.LUCENE_CURRENT, lro.getStopWords());
        }
    }

    private static class AnalyzerPair
    extends ConfiguredAnalyzerFactory.AnalyzerPair {
        AnalyzerPair(String range, Analyzer withStopWords, Analyzer withOutStopWords) {
            super(range, withStopWords, withOutStopWords);
        }

        AnalyzerPair(String range, AnalyzerPair copyMe) {
            super(range, copyMe);
        }

        AnalyzerPair(String range, Constructor<? extends Analyzer> cons, Object ... params) throws Exception {
            this(range, cons.newInstance(params), cons.newInstance(AnalyzerPair.useEmptyStopWordSet(params)));
        }

        AnalyzerPair(String range, Analyzer stopWordsNotSupported) {
            this(range, stopWordsNotSupported, stopWordsNotSupported);
        }

        private static Object[] useEmptyStopWordSet(Object[] params) {
            Object[] rslt = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                rslt[i] = params[i] instanceof Set ? CharArraySet.EMPTY_SET : params[i];
            }
            return rslt;
        }
    }
}

