/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.search.CountIndexTask;
import com.bigdata.search.Hit;
import com.bigdata.search.IHitCollector;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class MultiTokenHitCollector<V extends Comparable<V>>
implements IHitCollector<V> {
    protected static final transient Logger log = Logger.getLogger(MultiTokenHitCollector.class);
    final ConcurrentHashMap<V, Hit<V>> hits;

    public MultiTokenHitCollector(Collection<CountIndexTask<V>> tasks) {
        int initialCapacity = 0;
        for (CountIndexTask<V> task : tasks) {
            long rangeCount = task.getRangeCount();
            if (rangeCount > Integer.MAX_VALUE) {
                throw new RuntimeException("too many hits");
            }
            int i = (int)rangeCount;
            if (i <= initialCapacity) continue;
            initialCapacity = i;
        }
        int concurrencyLevel = tasks.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("initial capacity: " + initialCapacity));
        }
        this.hits = new ConcurrentHashMap(initialCapacity, 0.75f, concurrencyLevel);
    }

    @Override
    public Hit<V> putIfAbsent(V v, Hit<V> hit) {
        return this.hits.putIfAbsent((Hit<V>)v, (Hit<Hit<V>>)hit);
    }

    @Override
    public Hit<V>[] getHits() {
        return this.hits.values().toArray(new Hit[this.hits.size()]);
    }
}

