/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import java.util.Locale;

public class LanguageRange
implements Comparable<LanguageRange> {
    private final String[] range;
    final String full;

    public LanguageRange(String range) {
        this.range = range.split("-");
        this.full = range;
    }

    @Override
    public int compareTo(LanguageRange o) {
        if (this.equals(o)) {
            return 0;
        }
        int diff = o.range.length - this.range.length;
        if (diff != 0) {
            return diff;
        }
        if (this.range.length == 1) {
            if (this.range[0].equals("*")) {
                return 1;
            }
            if (o.range[0].equals("*")) {
                return -1;
            }
        }
        for (int i = 0; i < this.range.length; ++i) {
            diff = this.range[i].compareTo(o.range[i]);
            if (diff == 0) continue;
            return diff;
        }
        throw new RuntimeException("Impossible - supposedly");
    }

    public boolean equals(Object o) {
        return o instanceof LanguageRange && ((LanguageRange)o).full.equals(this.full);
    }

    public int hashCode() {
        return this.full.hashCode();
    }

    public boolean extendedFilterMatch(String langTag) {
        return this.extendedFilterMatch(langTag.toLowerCase(Locale.ROOT).split("-"));
    }

    boolean extendedFilterMatch(String[] language) {
        if (!this.matchSubTag(language[0], this.range[0])) {
            return false;
        }
        int rPos = 1;
        int lPos = 1;
        if (language[0].equals("x") && this.range[0].equals("*")) {
            lPos = 0;
        }
        while (rPos < this.range.length) {
            if (this.range[rPos].equals("*")) {
                ++rPos;
                continue;
            }
            if (lPos >= language.length) {
                return false;
            }
            if (this.matchSubTag(language[lPos], this.range[rPos])) {
                ++lPos;
                ++rPos;
                continue;
            }
            if (language[lPos].length() == 1) {
                return false;
            }
            ++lPos;
        }
        return true;
    }

    private boolean matchSubTag(String langSubTag, String rangeSubTag) {
        return langSubTag.equals(rangeSubTag) || "*".equals(rangeSubTag);
    }
}

