/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore.sector;

import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.ICommitter;
import com.bigdata.rawstore.IAllocationContext;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.rwstore.IRawTx;
import com.bigdata.rwstore.PSOutputStream;
import com.bigdata.rwstore.sector.IMemoryManager;
import com.bigdata.rwstore.sector.MemoryManager;
import com.bigdata.rwstore.sector.PSInputStream;
import com.bigdata.rwstore.sector.SectorAllocator;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class AllocationContext
implements IAllocationContext,
IMemoryManager {
    private static final transient Logger log = Logger.getLogger(AllocationContext.class);
    private final MemoryManager m_root;
    private final IMemoryManager m_parent;
    private final Lock writeLock;
    private final Lock readLock;
    private final LinkedHashSet<Long> m_addresses = new LinkedHashSet();
    private final AtomicLong m_allocCount = new AtomicLong();
    private final AtomicLong m_userBytes = new AtomicLong();
    private final AtomicLong m_slotBytes = new AtomicLong();
    private final AtomicBoolean m_active = new AtomicBoolean(true);
    final boolean m_isolated;

    @Override
    public final void checkActive() {
        if (!this.m_active.get()) {
            throw new IllegalStateException();
        }
    }

    public AllocationContext(MemoryManager root, boolean isolated) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        this.m_isolated = isolated;
        this.m_root = root;
        this.m_parent = root;
        this.writeLock = root.m_allocationLock.writeLock();
        this.readLock = this.m_root.m_allocationLock.readLock();
    }

    public AllocationContext(AllocationContext parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.m_root = parent.m_root;
        this.m_parent = parent;
        this.writeLock = this.m_root.m_allocationLock.writeLock();
        this.readLock = this.m_root.m_allocationLock.readLock();
        this.m_isolated = parent.m_isolated;
    }

    @Override
    public boolean isIsolated() {
        return this.m_isolated;
    }

    @Override
    public long allocate(ByteBuffer data) {
        return this.allocate(data, this.m_root.isBlocking());
    }

    @Override
    public long allocate(ByteBuffer data, boolean blocks) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        long addr = this.allocate(data.remaining(), blocks);
        ByteBuffer[] bufs = this.get(addr);
        MemoryManager.copyData(data, bufs);
        return addr;
    }

    @Override
    public long allocate(int nbytes) {
        return this.allocate(nbytes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long allocate(int nbytes, boolean blocks) {
        this.writeLock.lock();
        try {
            long addr = this.m_parent.allocate(nbytes, blocks);
            int rwaddr = MemoryManager.getAllocationAddress(addr);
            SectorAllocator sector = this.m_root.getSector(rwaddr);
            this.m_addresses.add(addr);
            this.m_allocCount.incrementAndGet();
            this.m_userBytes.addAndGet(nbytes);
            this.m_slotBytes.addAndGet(sector.getPhysicalSize(SectorAllocator.getSectorOffset(rwaddr)));
            long l = addr;
            return l;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"");
            }
            for (Long addr : this.m_addresses) {
                this.m_parent.free(addr);
            }
            this.m_addresses.clear();
            this.m_allocCount.set(0L);
            this.m_userBytes.set(0L);
            this.m_slotBytes.set(0L);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(long addr) {
        int rwaddr = MemoryManager.getAllocationAddress(addr);
        int size = MemoryManager.getAllocationSize(addr);
        int offset = SectorAllocator.getSectorOffset(rwaddr);
        this.writeLock.lock();
        try {
            SectorAllocator sector = this.m_root.getSector(rwaddr);
            this.m_parent.free(addr);
            this.m_addresses.remove(addr);
            this.m_allocCount.decrementAndGet();
            this.m_userBytes.addAndGet(-size);
            this.m_slotBytes.addAndGet(-sector.getPhysicalSize(offset));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ByteBuffer[] get(long addr) {
        return this.m_root.get(addr);
    }

    @Override
    public byte[] read(long addr) {
        return MemoryManager.read(this, addr);
    }

    @Override
    public IMemoryManager createAllocationContext() {
        return new AllocationContext(this);
    }

    @Override
    public int allocationSize(long addr) {
        return this.m_root.allocationSize(addr);
    }

    @Override
    public long getAllocationCount() {
        return this.m_allocCount.get();
    }

    @Override
    public long getSlotBytes() {
        return this.m_slotBytes.get();
    }

    @Override
    public long getUserBytes() {
        return this.m_userBytes.get();
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.addCounter("slotBytes", new OneShotInstrument<Long>(this.getUserBytes()));
        root.addCounter("userBytes", new OneShotInstrument<Long>(this.getUserBytes()));
        root.addCounter("allocationCount", new OneShotInstrument<Long>(this.getAllocationCount()));
        return root;
    }

    @Override
    public IPSOutputStream getOutputStream() {
        return PSOutputStream.getNew(this, 4100, null);
    }

    @Override
    public IPSOutputStream getOutputStream(IAllocationContext context) {
        return PSOutputStream.getNew(this, 4100, context);
    }

    @Override
    public InputStream getInputStream(long addr) {
        return new PSInputStream(this, addr);
    }

    @Override
    public long alloc(byte[] buf, int size, IAllocationContext context) {
        if (context != null) {
            throw new IllegalArgumentException("Nested AllocationContexts are not supported");
        }
        return MemoryManager.getAllocationAddress(this.allocate(ByteBuffer.wrap(buf, 0, size)));
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void free(long addr, int size) {
        this.free((addr << 32) + (long)size);
    }

    @Override
    public int getAssociatedSlotSize(int addr) {
        return this.m_root.allocationSize(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getData(long l, byte[] buf) {
        this.readLock.lock();
        try {
            ByteBuffer rbuf = this.m_root.getBuffer((int)l, buf.length);
            rbuf.get(buf);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public File getStoreFile() {
        throw new UnsupportedOperationException("The MemoryManager does not provdie a StoreFile");
    }

    @Override
    public int getSectorSize() {
        return this.m_root.getSectorSize();
    }

    @Override
    public int getMaxSectors() {
        return this.m_root.getMaxSectors();
    }

    @Override
    public int getSectorCount() {
        return this.m_root.getSectorCount();
    }

    @Override
    public void commit() {
        this.m_root.commit();
    }

    @Override
    public Lock getCommitLock() {
        return this.m_root.getCommitLock();
    }

    @Override
    public void postCommit() {
        this.m_root.postCommit();
    }

    @Override
    public void registerExternalCache(ConcurrentWeakValueCache<Long, ICommitter> historicalIndexCache, int byteCount) {
        this.m_root.registerExternalCache(historicalIndexCache, byteCount);
    }

    @Override
    public int checkDeferredFrees(AbstractJournal abstractJournal) {
        return this.m_root.checkDeferredFrees(abstractJournal);
    }

    @Override
    public IRawTx newTx() {
        return this.m_root.newTx();
    }

    @Override
    public long saveDeferrals() {
        return this.m_root.saveDeferrals();
    }

    @Override
    public long getLastReleaseTime() {
        return this.m_root.getLastReleaseTime();
    }

    @Override
    public void abortContext(IAllocationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void detachContext(IAllocationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCommitted(long addr) {
        return this.m_root.isCommitted(addr);
    }

    @Override
    public long getPhysicalAddress(long addr) {
        return this.m_root.getPhysicalAddress(addr);
    }

    @Override
    public long allocate(ByteBuffer data, IAllocationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(ByteBuffer data, IAllocationContext context) {
        return this.allocate(data, context);
    }

    @Override
    public void free(long addr, IAllocationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(long addr, IAllocationContext context) {
        this.free(addr, context);
    }

    @Override
    public IAllocationContext newAllocationContext(boolean isolated) {
        return this;
    }

    @Override
    public void release() {
        this.checkActive();
        this.m_active.set(false);
    }
}

