/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BigdataTriplePattern;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.AbstractChunkedResolverator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.util.concurrent.LatchedExecutor;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.system.SystemUtil;

public class BigdataTriplePatternMaterializer
extends AbstractChunkedResolverator<BigdataTriplePattern, ISPO, AbstractTripleStore>
implements ICloseableIterator<ISPO> {
    private final int nthreads;
    private final AtomicReference<LatchedExecutor> helperService = new AtomicReference();

    public BigdataTriplePatternMaterializer(AbstractTripleStore db, IChunkedOrderedIterator<BigdataTriplePattern> src) {
        this(db, src, 4);
    }

    public BigdataTriplePatternMaterializer(AbstractTripleStore db, IChunkedOrderedIterator<BigdataTriplePattern> src, int nthreads) {
        super(db, src, new BlockingBuffer<F[]>(db.getChunkOfChunksCapacity(), db.getChunkCapacity(), db.getChunkTimeout(), TimeUnit.MILLISECONDS));
        if (nthreads < 0) {
            throw new IllegalArgumentException();
        }
        this.nthreads = Math.max(Math.min(nthreads, SystemUtil.numProcessors() * 2), 1);
    }

    public BigdataTriplePatternMaterializer start(ExecutorService service) {
        this.helperService.set(new LatchedExecutor(service, this.nthreads));
        super.start(service);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected ISPO[] resolveChunk(BigdataTriplePattern[] chunk) {
        LatchedExecutor helperService = this.helperService.get();
        if (helperService == null) {
            throw new IllegalStateException();
        }
        ConcurrentLinkedQueue<ISPO[]> out = new ConcurrentLinkedQueue<ISPO[]>();
        LinkedList<1> tasks = new LinkedList<1>();
        try {
            final CountDownLatch latch = new CountDownLatch(chunk.length);
            for (BigdataTriplePattern bigdataTriplePattern : chunk) {
                FutureTask<Long> ft = new FutureTask<Long>((Callable)new ResolveTriplePatternTask(bigdataTriplePattern, out)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            super.run();
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                };
                tasks.add(ft);
            }
            for (FutureTask futureTask : tasks) {
                helperService.execute(futureTask);
            }
            latch.await();
            long nfound = 0L;
            for (FutureTask futureTask : tasks) {
                if ((nfound += ((Long)futureTask.get()).longValue()) <= Integer.MAX_VALUE) continue;
                throw new UnsupportedOperationException();
            }
            ISPO[] dest = new ISPO[(int)nfound];
            boolean bl = false;
            ISPO[] src = null;
            while ((src = (ISPO[])out.poll()) != null) {
                void var9_18;
                System.arraycopy(src, 0, dest, (int)var9_18, src.length);
                var9_18 += src.length;
            }
            ISPO[] iSPOArray = dest;
            return iSPOArray;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            for (FutureTask futureTask : tasks) {
                futureTask.cancel(true);
            }
        }
    }

    private class ResolveTriplePatternTask
    implements Callable<Long> {
        private final BigdataTriplePattern stmt;
        private final Queue<ISPO[]> out;

        public ResolveTriplePatternTask(BigdataTriplePattern stmt, Queue<ISPO[]> out) {
            this.stmt = stmt;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            IAccessPath<ISPO> ap = ((AbstractTripleStore)BigdataTriplePatternMaterializer.this.state).getAccessPath(this.stmt.getSubject(), this.stmt.getPredicate(), this.stmt.getObject(), this.stmt.getContext());
            long n = 0L;
            try (IChunkedOrderedIterator<ISPO> itr = ap.iterator();){
                while (itr.hasNext()) {
                    ISPO[] a = (ISPO[])itr.nextChunk();
                    boolean result = this.out.offer(a);
                    assert (result) : "insertion failed - expects an unbounded queue";
                    n += (long)a.length;
                }
                Long l = n;
                return l;
            }
        }
    }
}

