/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.BatchLookup;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOTupleSerializer;
import com.bigdata.striterator.IChunkConverter;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Arrays;

public class BulkCompleteConverter
implements IChunkConverter<ISPO, ISPO> {
    private final IIndex ndx;
    private final SPOTupleSerializer tupleSer;

    public BulkCompleteConverter(IIndex ndx) {
        this.ndx = ndx;
        this.tupleSer = (SPOTupleSerializer)ndx.getIndexMetadata().getTupleSerializer();
    }

    public ISPO[] convert(IChunkedOrderedIterator<ISPO> src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        ISPO[] chunk = (ISPO[])src.nextChunk();
        if (!this.tupleSer.getKeyOrder().equals(src.getKeyOrder())) {
            Arrays.sort(chunk, this.tupleSer.getKeyOrder().getComparator());
        }
        return this.convert(chunk);
    }

    public ISPO[] convert(ISPO[] chunk) {
        byte[][] keys = new byte[chunk.length][];
        for (int i = 0; i < chunk.length; ++i) {
            keys[i] = this.tupleSer.serializeKey(chunk[i]);
        }
        AbstractKeyArrayIndexProcedure.ResultBufferHandler resultHandler = new AbstractKeyArrayIndexProcedure.ResultBufferHandler(keys.length, this.ndx.getIndexMetadata().getTupleSerializer().getLeafValuesCoder());
        this.ndx.submit(0, keys.length, keys, null, BatchLookup.BatchLookupConstructor.INSTANCE, resultHandler);
        IRaba vals = resultHandler.getResult().getValues();
        for (int i = 0; i < chunk.length; ++i) {
            byte[] val = vals.get(i);
            if (val != null) {
                this.tupleSer.decodeValue(chunk[i], val);
                continue;
            }
            chunk[i].setStatementType(StatementEnum.Inferred);
        }
        return chunk;
    }
}

