/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.service;

import com.bigdata.rdf.sail.Sesame2BigdataIterator;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import com.bigdata.rdf.sparql.ast.service.IRemoteSparqlQueryBuilder;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceCall;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceOptions;
import com.bigdata.rdf.sparql.ast.service.RemoteSparqlBuilderFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResult;

public class RemoteServiceCallImpl
implements RemoteServiceCall {
    private final ServiceCallCreateParams params;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{params=" + this.params);
        sb.append("}");
        return sb.toString();
    }

    public RemoteServiceCallImpl(ServiceCallCreateParams params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        this.params = params;
    }

    @Override
    public RemoteServiceOptions getServiceOptions() {
        return (RemoteServiceOptions)this.params.getServiceOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICloseableIterator<BindingSet> call(BindingSet[] bindingSets) throws Exception {
        TupleQueryResult queryResult;
        String uriStr = this.params.getServiceURI().stringValue();
        RemoteServiceOptions serviceOptions = this.getServiceOptions();
        ConnectOptions o = new ConnectOptions(uriStr);
        String acceptHeader = serviceOptions.getAcceptHeader();
        if (acceptHeader != null) {
            o.setAcceptHeader(acceptHeader);
        } else {
            o.setAcceptHeader(ConnectOptions.DEFAULT_SOLUTIONS_ACCEPT_HEADER);
        }
        o.method = serviceOptions.isGET() ? "GET" : "POST";
        IRemoteSparqlQueryBuilder queryBuilder = RemoteSparqlBuilderFactory.get(serviceOptions, this.params.getServiceNode(), bindingSets);
        String queryStr = queryBuilder.getSparqlQuery(bindingSets);
        UUID queryId = UUID.randomUUID();
        o.addRequestParam("query", queryStr);
        o.addRequestParam("queryId", queryId.toString());
        HttpClient client = this.params.getClientConnectionManager();
        try (RemoteRepositoryManager repo = new RemoteRepositoryManager(uriStr, this.params.getServiceOptions().isBigdataLBS(), client, (Executor)this.params.getTripleStore().getExecutorService());){
            queryResult = repo.tupleResults(o, queryId, null);
        }
        return new Sesame2BigdataIterator(queryResult);
    }
}

