/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUtility;
import com.bigdata.rdf.sparql.ast.eval.DataSetSummary;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.InvalidGraphContextException;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import org.openrdf.query.algebra.StatementPattern;

public class ASTGraphGroupOptimizer
implements IASTOptimizer {
    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        if (!(queryNode instanceof QueryRoot)) {
            return new QueryNodeWithBindingSet(queryNode, bindingSets);
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        DatasetNode dataSet = queryRoot.getDataset();
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot namedSubquery : queryRoot.getNamedSubqueries()) {
                this.visitGroups(context, dataSet, namedSubquery.getWhereClause(), null);
            }
        }
        this.visitGroups(context, dataSet, queryRoot.getWhereClause(), null);
        return new QueryNodeWithBindingSet(queryNode, bindingSets);
    }

    private void visitGroups(IEvaluationContext context, DatasetNode dataSet, IGroupNode<IGroupMemberNode> group, TermNode graphContext) {
        if (group instanceof JoinGroupNode && group.getContext() != null) {
            StatementPatternNode sp;
            TermNode innerGraphContext = group.getContext();
            if (innerGraphContext.isConstant()) {
                this.assertGraphInNamedDataset((BigdataURI)innerGraphContext.getValue(), dataSet);
            }
            if (graphContext == null) {
                graphContext = innerGraphContext;
            } else if (graphContext.isConstant() && innerGraphContext.isConstant()) {
                this.assertSameURI(graphContext, innerGraphContext);
            } else if (graphContext.isVariable() && innerGraphContext.isVariable() && !graphContext.equals(innerGraphContext)) {
                FilterNode filterNode = new FilterNode(FunctionNode.sameTerm(graphContext, innerGraphContext));
                GlobalAnnotations globals = new GlobalAnnotations(context.getLexiconNamespace(), context.getTimestamp());
                AST2BOpUtility.toVE(context.getBOpContext(), globals, filterNode.getValueExpressionNode());
                group.addChild(filterNode);
            }
            if (group.isEmpty() && graphContext.isVariable()) {
                sp = new StatementPatternNode(VarNode.freshVarNode(), VarNode.freshVarNode(), VarNode.freshVarNode(), graphContext, StatementPattern.Scope.NAMED_CONTEXTS);
                sp.setDistinctTermScanVar((VarNode)graphContext);
                group.addChild(sp);
            } else if (group.isEmpty() && graphContext.isConstant()) {
                sp = new StatementPatternNode(VarNode.freshVarNode(), VarNode.freshVarNode(), VarNode.freshVarNode(), graphContext, StatementPattern.Scope.NAMED_CONTEXTS);
                SubqueryRoot subquery = new SubqueryRoot(QueryType.ASK);
                ProjectionNode projection = new ProjectionNode();
                subquery.setProjection(projection);
                subquery.addArg(new JoinGroupNode((IGroupMemberNode)sp));
                group.addChild(sp);
            }
        }
        for (IGroupMemberNode child : group) {
            if (child instanceof ServiceNode) continue;
            if (graphContext != null && child instanceof StatementPatternNode) {
                StatementPatternNode sp = (StatementPatternNode)child;
                StatementPattern.Scope scope = sp.getScope();
                if (scope == null) {
                    throw new AssertionError((Object)("No scope? " + sp));
                }
                switch (scope) {
                    case NAMED_CONTEXTS: {
                        break;
                    }
                    case DEFAULT_CONTEXTS: {
                        throw new AssertionError((Object)("Statement pattern bounded by GRAPH but has default context scope: " + sp));
                    }
                }
                if (sp.c() == null) {
                    sp.setArg(3, graphContext);
                }
            }
            if (!(child instanceof IGroupNode)) continue;
            this.visitGroups(context, dataSet, (IGroupNode)child, graphContext);
        }
    }

    private void assertSameURI(TermNode context, TermNode innerContext) {
        if (!context.getValue().equals(innerContext.getValue())) {
            throw new InvalidGraphContextException("Conflicting GRAPH IRIs: " + context + " and " + innerContext.getValue());
        }
    }

    private void assertGraphInNamedDataset(BigdataURI uri, DatasetNode dataSet) {
        if (dataSet == null) {
            return;
        }
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        DataSetSummary namedGraphs = dataSet.getNamedGraphs();
        if (namedGraphs == null) {
            return;
        }
        if (!namedGraphs.getGraphs().contains(uri.getIV())) {
            // empty if block
        }
    }
}

