/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.lexicon.ITextIndexer;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.ASTSearchOptimizer;
import com.bigdata.rdf.sparql.ast.eval.AbstractServiceFactoryBase;
import com.bigdata.rdf.sparql.ast.service.BigdataNativeServiceOptions;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.IServiceOptions;
import com.bigdata.rdf.sparql.ast.service.ServiceCallCreateParams;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BDS;
import com.bigdata.search.Hiterator;
import com.bigdata.search.IHit;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.SingleValueChunkedIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class SearchServiceFactory
extends AbstractServiceFactoryBase {
    private static final Logger log = Logger.getLogger(SearchServiceFactory.class);
    private final BigdataNativeServiceOptions serviceOptions = new BigdataNativeServiceOptions();

    public SearchServiceFactory() {
        this.serviceOptions.setRunFirst(true);
    }

    @Override
    public BigdataNativeServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    public BigdataServiceCall create(ServiceCallCreateParams params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        AbstractTripleStore store = params.getTripleStore();
        if (store == null) {
            throw new IllegalArgumentException();
        }
        ServiceNode serviceNode = params.getServiceNode();
        if (serviceNode == null) {
            throw new IllegalArgumentException();
        }
        Map<IVariable<?>, Map<URI, StatementPatternNode>> map = this.verifyGraphPattern(store, serviceNode.getGraphPattern());
        if (map == null) {
            throw new RuntimeException("Not a search request.");
        }
        if (map.size() != 1) {
            throw new RuntimeException("Multiple search requests may not be combined.");
        }
        Map.Entry<IVariable<?>, Map<URI, StatementPatternNode>> e = map.entrySet().iterator().next();
        IVariable<?> searchVar = e.getKey();
        Map<URI, StatementPatternNode> statementPatterns = e.getValue();
        this.validateSearch(searchVar, statementPatterns);
        return new SearchCall(store, searchVar, statementPatterns, this.getServiceOptions());
    }

    private Map<IVariable<?>, Map<URI, StatementPatternNode>> verifyGraphPattern(AbstractTripleStore database, GroupNodeBase<IGroupMemberNode> group) {
        LinkedHashMap<IVariable<IV>, LinkedHashMap<URI, StatementPatternNode>> tmp = null;
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            LinkedHashMap<URI, StatementPatternNode> statementPatterns;
            BOp child = group.get(i);
            if (child instanceof GroupNodeBase) {
                throw new RuntimeException("Nested groups are not allowed.");
            }
            if (!(child instanceof StatementPatternNode)) continue;
            StatementPatternNode sp = (StatementPatternNode)child;
            TermNode p = sp.p();
            if (!p.isConstant()) {
                throw new RuntimeException("Expecting search predicate: " + sp);
            }
            URI uri = (URI)((ConstantNode)p).getValue();
            if (!uri.stringValue().startsWith("http://www.bigdata.com/rdf/search#")) {
                throw new RuntimeException("Expecting search predicate: " + sp);
            }
            if (!ASTSearchOptimizer.searchUris.contains(uri)) {
                throw new RuntimeException("Unknown search predicate: " + uri);
            }
            TermNode s = sp.s();
            if (!s.isVariable()) {
                throw new RuntimeException("Subject of search predicate is constant: " + sp);
            }
            IVariable<IV> searchVar = ((VarNode)s).getValueExpression();
            if (tmp == null) {
                tmp = new LinkedHashMap<IVariable<IV>, LinkedHashMap<URI, StatementPatternNode>>();
            }
            if ((statementPatterns = (LinkedHashMap<URI, StatementPatternNode>)tmp.get(searchVar)) == null) {
                statementPatterns = new LinkedHashMap<URI, StatementPatternNode>();
                tmp.put(searchVar, statementPatterns);
            }
            statementPatterns.put(uri, sp);
        }
        return tmp;
    }

    private void validateSearch(IVariable<?> searchVar, Map<URI, StatementPatternNode> statementPatterns) {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        for (StatementPatternNode sp : statementPatterns.values()) {
            URI uri = (URI)sp.p().getValue();
            if (!uris.add(uri)) {
                throw new RuntimeException("Search predicate appears multiple times for same search variable: predicate=" + uri + ", searchVar=" + searchVar);
            }
            if (uri.equals((Object)BDS.SEARCH)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals((Object)BDS.RELEVANCE) || uri.equals((Object)BDS.RANK)) {
                this.assertObjectIsVariable(sp);
                continue;
            }
            if (uri.equals((Object)BDS.MIN_RANK) || uri.equals((Object)BDS.MAX_RANK)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals((Object)BDS.MIN_RELEVANCE) || uri.equals((Object)BDS.MAX_RELEVANCE)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals((Object)BDS.MATCH_ALL_TERMS)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals((Object)BDS.MATCH_EXACT)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals((Object)BDS.SUBJECT_SEARCH)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals((Object)BDS.SEARCH_TIMEOUT)) {
                this.assertObjectIsLiteral(sp);
                continue;
            }
            if (uri.equals((Object)BDS.RANGE_COUNT)) {
                this.assertObjectIsVariable(sp);
                continue;
            }
            if (!uri.equals((Object)BDS.MATCH_REGEX)) {
                throw new AssertionError((Object)("Unverified search predicate: " + sp));
            }
        }
        if (!uris.contains(BDS.SEARCH)) {
            throw new RuntimeException("Required search predicate not found: " + BDS.SEARCH + " for searchVar=" + searchVar);
        }
    }

    private void assertObjectIsLiteral(StatementPatternNode sp) {
        TermNode o = sp.o();
        if (!o.isConstant() || !(((ConstantNode)o).getValue() instanceof Literal)) {
            throw new IllegalArgumentException("Object is not literal: " + sp);
        }
    }

    private void assertObjectIsVariable(StatementPatternNode sp) {
        TermNode o = sp.o();
        if (!o.isVariable()) {
            throw new IllegalArgumentException("Object must be variable: " + sp);
        }
    }

    private static class SearchCall
    implements BigdataServiceCall {
        private final AbstractTripleStore store;
        private final IServiceOptions serviceOptions;
        private final Literal query;
        private final IVariable<IV> search;
        private final IVariable<?>[] vars;
        private final Literal minRank;
        private final Literal maxRank;
        private final Literal minRelevance;
        private final Literal maxRelevance;
        private final boolean matchAllTerms;
        private final boolean matchExact;
        @Deprecated
        private final boolean subjectSearch;
        private final Literal searchTimeout;
        private final Literal matchRegex;
        private final IVariable<?> rangeCountVar;

        public SearchCall(AbstractTripleStore store, IVariable<?> searchVar, Map<URI, StatementPatternNode> statementPatterns, IServiceOptions serviceOptions) {
            if (store == null) {
                throw new IllegalArgumentException();
            }
            if (searchVar == null) {
                throw new IllegalArgumentException();
            }
            if (statementPatterns == null) {
                throw new IllegalArgumentException();
            }
            if (serviceOptions == null) {
                throw new IllegalArgumentException();
            }
            this.store = store;
            this.serviceOptions = serviceOptions;
            StatementPatternNode sp = statementPatterns.get(BDS.SEARCH);
            this.query = (Literal)sp.o().getValue();
            TermNode searchQuery = sp.o();
            if (searchQuery instanceof ConstantNode) {
                ConstantNode cNode = (ConstantNode)searchQuery;
                IConstant<IV> c = cNode.getValueExpression();
                this.search = (IVariable)c.getProperty(Constant.Annotations.VAR);
            } else {
                this.search = null;
            }
            IVariable relVar = null;
            IVariable rankVar = null;
            IVariable rangeCountVar = null;
            Literal minRank = null;
            Literal maxRank = null;
            Literal minRelevance = null;
            Literal maxRelevance = null;
            boolean matchAllTerms = false;
            boolean matchExact = false;
            boolean subjectSearch = false;
            Literal searchTimeout = null;
            Literal matchRegex = null;
            for (StatementPatternNode meta : statementPatterns.values()) {
                IVariable oVar;
                URI p = (URI)meta.p().getValue();
                Literal oVal = meta.o().isConstant() ? (Literal)meta.o().getValue() : null;
                IVariable iVariable = oVar = meta.o().isVariable() ? (IVariable)meta.o().getValueExpression() : null;
                if (BDS.RELEVANCE.equals((Object)p)) {
                    relVar = oVar;
                    continue;
                }
                if (BDS.RANK.equals((Object)p)) {
                    rankVar = oVar;
                    continue;
                }
                if (BDS.RANGE_COUNT.equals((Object)p)) {
                    rangeCountVar = oVar;
                    continue;
                }
                if (BDS.MIN_RANK.equals((Object)p)) {
                    minRank = oVal;
                    continue;
                }
                if (BDS.MAX_RANK.equals((Object)p)) {
                    maxRank = oVal;
                    continue;
                }
                if (BDS.MIN_RELEVANCE.equals((Object)p)) {
                    minRelevance = oVal;
                    continue;
                }
                if (BDS.MAX_RELEVANCE.equals((Object)p)) {
                    maxRelevance = oVal;
                    continue;
                }
                if (BDS.MATCH_ALL_TERMS.equals((Object)p)) {
                    matchAllTerms = oVal.booleanValue();
                    continue;
                }
                if (BDS.MATCH_EXACT.equals((Object)p)) {
                    matchExact = oVal.booleanValue();
                    continue;
                }
                if (BDS.SUBJECT_SEARCH.equals((Object)p)) {
                    subjectSearch = oVal.booleanValue();
                    continue;
                }
                if (BDS.SEARCH_TIMEOUT.equals((Object)p)) {
                    searchTimeout = oVal;
                    continue;
                }
                if (!BDS.MATCH_REGEX.equals((Object)p)) continue;
                matchRegex = oVal;
            }
            this.vars = this.search == null ? new IVariable[]{searchVar, relVar == null ? Var.var() : relVar, rankVar == null ? Var.var() : rankVar} : new IVariable[]{searchVar, relVar == null ? Var.var() : relVar, rankVar == null ? Var.var() : rankVar, this.search};
            this.minRank = minRank;
            this.maxRank = maxRank;
            this.minRelevance = minRelevance;
            this.maxRelevance = maxRelevance;
            this.matchAllTerms = matchAllTerms;
            this.matchExact = matchExact;
            this.subjectSearch = subjectSearch;
            this.searchTimeout = searchTimeout;
            this.matchRegex = matchRegex;
            this.rangeCountVar = rangeCountVar;
        }

        private Hiterator<IHit<?>> getHiterator() {
            boolean prefixMatch;
            ITextIndexer<?> textIndex;
            ITextIndexer<?> iTextIndexer = textIndex = this.subjectSearch ? this.store.getLexiconRelation().getSubjectCentricSearchEngine() : this.store.getLexiconRelation().getSearchEngine();
            if (textIndex == null) {
                throw new UnsupportedOperationException("No free text index?");
            }
            String s = this.query.getLabel();
            if (s.indexOf(42) >= 0) {
                prefixMatch = true;
                s = s.replaceAll("\\*", "");
            } else {
                prefixMatch = false;
            }
            return textIndex.search(new ITextIndexer.FullTextQuery(s, this.query.getLanguage(), prefixMatch, this.matchRegex == null ? null : this.matchRegex.stringValue(), this.matchAllTerms, this.matchExact, this.minRelevance == null ? 0.0 : this.minRelevance.doubleValue(), this.maxRelevance == null ? 1.0 : this.maxRelevance.doubleValue(), this.minRank == null ? 1 : this.minRank.intValue(), this.maxRank == null ? Integer.MAX_VALUE : this.maxRank.intValue(), this.searchTimeout == null ? Long.MAX_VALUE : this.searchTimeout.longValue(), TimeUnit.MILLISECONDS));
        }

        private int getRangeCount() {
            boolean prefixMatch;
            ITextIndexer<?> textIndex;
            ITextIndexer<?> iTextIndexer = textIndex = this.subjectSearch ? this.store.getLexiconRelation().getSubjectCentricSearchEngine() : this.store.getLexiconRelation().getSearchEngine();
            if (textIndex == null) {
                throw new UnsupportedOperationException("No free text index?");
            }
            String s = this.query.getLabel();
            if (s.indexOf(42) >= 0) {
                prefixMatch = true;
                s = s.replaceAll("\\*", "");
            } else {
                prefixMatch = false;
            }
            return textIndex.count(new ITextIndexer.FullTextQuery(s, this.query.getLanguage(), prefixMatch, this.matchRegex == null ? null : this.matchRegex.stringValue(), this.matchAllTerms, this.matchExact, this.minRelevance == null ? 0.0 : this.minRelevance.doubleValue(), this.maxRelevance == null ? 1.0 : this.maxRelevance.doubleValue(), this.minRank == null ? 1 : this.minRank.intValue(), this.maxRank == null ? Integer.MAX_VALUE : this.maxRank.intValue(), this.searchTimeout == null ? Long.MAX_VALUE : this.searchTimeout.longValue(), TimeUnit.MILLISECONDS));
        }

        public ICloseableIterator<IBindingSet> call(IBindingSet[] bindingsClause) {
            if (bindingsClause.length > 1) {
                for (IBindingSet bs : bindingsClause) {
                    if (this.rangeCountVar != null) {
                        if (!bs.isBound(this.rangeCountVar)) continue;
                        throw new UnsupportedOperationException();
                    }
                    for (int i = 0; i < this.vars.length; ++i) {
                        if (!bs.isBound(this.vars[i])) continue;
                        throw new UnsupportedOperationException();
                    }
                }
            }
            if (bindingsClause.length != 1 || !bindingsClause[0].isEmpty()) {
                // empty if block
            }
            if (this.rangeCountVar != null) {
                int i = this.getRangeCount();
                ListBindingSet bs = new ListBindingSet(new IVariable[]{this.rangeCountVar}, new IConstant[]{new Constant(new XSDNumericIV(i))});
                return new SingleValueChunkedIterator<IBindingSet>(bs);
            }
            Striterator sitr = new Striterator(this.getHiterator());
            sitr.addFilter((IFilter)new Resolver(){
                private static final long serialVersionUID = 1L;

                protected Object resolve(Object obj) {
                    return SearchCall.this.bind((IHit)obj);
                }
            });
            return new ChunkedWrappedIterator<IBindingSet>((Iterator<IBindingSet>)sitr);
        }

        private IBindingSet bind(IHit<?> hit) {
            IConstant[] iConstantArray;
            if (this.search == null) {
                IConstant[] iConstantArray2 = new IConstant[3];
                iConstantArray2[0] = new Constant(hit.getDocId());
                iConstantArray2[1] = new Constant(new XSDNumericIV(hit.getCosine()));
                iConstantArray = iConstantArray2;
                iConstantArray2[2] = new Constant(new XSDNumericIV(hit.getRank()));
            } else {
                IConstant[] iConstantArray3 = new IConstant[4];
                iConstantArray3[0] = new Constant(hit.getDocId());
                iConstantArray3[1] = new Constant(new XSDNumericIV(hit.getCosine()));
                iConstantArray3[2] = new Constant(new XSDNumericIV(hit.getRank()));
                iConstantArray = iConstantArray3;
                iConstantArray3[3] = new Constant<IV>(((BigdataLiteral)this.query).getIV());
            }
            IConstant[] vals = iConstantArray;
            ListBindingSet bs = new ListBindingSet(this.vars, vals);
            if (log.isTraceEnabled()) {
                log.trace((Object)bs);
                log.trace(this.query.getClass());
                log.trace((Object)((BigdataLiteral)this.query).getIV());
                log.trace(((BigdataLiteral)this.query).getIV().getClass());
            }
            return bs;
        }

        @Override
        public IServiceOptions getServiceOptions() {
            return this.serviceOptions;
        }
    }
}

