/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.util.HTMLUtility;
import java.io.IOException;
import java.io.Writer;

public class XMLBuilder {
    private final boolean xml;
    private final Writer m_writer;

    public Writer getWriter() {
        return this.m_writer;
    }

    public XMLBuilder(Writer w) throws IOException {
        this(true, null, w);
    }

    public XMLBuilder(boolean xml, String encoding, Writer w) throws IOException {
        if (w == null) {
            throw new IllegalArgumentException();
        }
        this.xml = xml;
        this.m_writer = w;
        if (xml) {
            if (encoding != null) {
                this.m_writer.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            } else {
                this.m_writer.write("<?xml version=\"1.0\"?>");
            }
        } else {
            this.m_writer.write("<!DOCTYPE HTML PUBLIC");
            this.m_writer.write(" \"-//W3C//DTD HTML 4.01 Transitional//EN\"");
            this.m_writer.write(" \"http://www.w3.org/TR/html4/loose.dtd\">");
        }
    }

    public Node root(String name) throws IOException {
        return new Node(name, null);
    }

    public Node root(String name, String nodeText) throws IOException {
        Node root = new Node(name, null);
        root.text(nodeText);
        return root.close();
    }

    public void closeAll(Node node) throws IOException {
        while (node != null) {
            node = node.close();
        }
    }

    private static String cdata(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return HTMLUtility.escapeForXHTML((String)s);
    }

    private static String attrib(String s) {
        return HTMLUtility.escapeForXHTML((String)s);
    }

    public class Node {
        private boolean m_open = true;
        private String m_tag;
        private Node m_parent;
        private int m_attrs = 0;
        private int m_text = 0;
        private int m_nodes = 0;

        Node(String name, Node parent) throws IOException {
            this.m_tag = name;
            this.m_parent = parent;
            XMLBuilder.this.m_writer.write("<" + this.m_tag);
        }

        public String toString() {
            return "<" + this.m_tag + "...>" + (this.m_parent == null ? "" : "(parent=" + this.m_parent.m_tag + ")");
        }

        public XMLBuilder getBuilder() {
            return XMLBuilder.this;
        }

        public Node attr(String attr, Object value) throws IOException {
            XMLBuilder.this.m_writer.write(" " + attr + "=\"" + XMLBuilder.attrib(value.toString()) + "\"");
            ++this.m_attrs;
            return this;
        }

        public Node text(String text) throws IOException {
            this.closeHead();
            XMLBuilder.this.m_writer.write(XMLBuilder.cdata(text));
            ++this.m_text;
            return this;
        }

        public Node textNoEncode(String text) throws IOException {
            this.closeHead();
            XMLBuilder.this.m_writer.write(text);
            ++this.m_text;
            return this;
        }

        public Node node(String tag) throws IOException {
            this.closeHead();
            ++this.m_nodes;
            return new Node(tag, this);
        }

        public Node node(String tag, String text) throws IOException {
            this.closeHead();
            ++this.m_nodes;
            Node tmp = new Node(tag, this);
            tmp.text(text);
            Node ret = tmp.close();
            assert (ret == this);
            return ret;
        }

        public Node close() throws IOException {
            if (XMLBuilder.this.xml) {
                return this.close(false);
            }
            return this.close(this.isSimpleEndTagForHTML());
        }

        private boolean isSimpleEndTagForHTML() {
            return !"form".equalsIgnoreCase(this.m_tag);
        }

        public Node close(boolean simpleEnd) throws IOException {
            assert (this.m_open);
            if (this.emptyBody()) {
                if (simpleEnd) {
                    XMLBuilder.this.m_writer.write(">");
                } else {
                    XMLBuilder.this.m_writer.write("/>");
                }
            } else {
                XMLBuilder.this.m_writer.write("</" + this.m_tag + "\n>");
            }
            this.m_open = false;
            if (this.m_parent == null) {
                XMLBuilder.this.m_writer.flush();
            }
            return this.m_parent;
        }

        private void closeHead() throws IOException {
            if (this.emptyBody()) {
                XMLBuilder.this.m_writer.write(">");
            }
        }

        private boolean emptyBody() {
            return this.m_nodes == 0 && this.m_text == 0;
        }
    }
}

