/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.literal.FullyInlineTypedLiteralIV;
import com.bigdata.rdf.internal.impl.literal.UUIDLiteralIV;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.internal.impl.literal.XSDDecimalIV;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedByteIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedIntIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedLongIV;
import com.bigdata.rdf.internal.impl.literal.XSDUnsignedShortIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.sail.sparql.ASTVisitorBase;
import com.bigdata.rdf.sail.sparql.ast.ASTBlankNode;
import com.bigdata.rdf.sail.sparql.ast.ASTFalse;
import com.bigdata.rdf.sail.sparql.ast.ASTIRI;
import com.bigdata.rdf.sail.sparql.ast.ASTNumericLiteral;
import com.bigdata.rdf.sail.sparql.ast.ASTOperationContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTQName;
import com.bigdata.rdf.sail.sparql.ast.ASTRDFLiteral;
import com.bigdata.rdf.sail.sparql.ast.ASTRDFValue;
import com.bigdata.rdf.sail.sparql.ast.ASTString;
import com.bigdata.rdf.sail.sparql.ast.ASTTrue;
import com.bigdata.rdf.sail.sparql.ast.SyntaxTreeBuilderVisitor;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.store.BD;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.MalformedQueryException;

public class ASTDeferredIVResolutionInitializer
extends ASTVisitorBase {
    private static final Logger log = Logger.getLogger(ASTDeferredIVResolutionInitializer.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final List<URI> RDF_VOCAB = Arrays.asList(RDF.FIRST, RDF.REST, RDF.NIL, BD.VIRTUAL_GRAPH);
    private final Map<Value, BigdataValue> vocab;
    private final BigdataValueFactory valueFactory = new BigdataValueFactoryImpl();
    private final LinkedHashMap<ASTRDFValue, BigdataValue> nodes = new LinkedHashMap();

    public Map<Value, BigdataValue> getValues() {
        return this.vocab;
    }

    public ASTDeferredIVResolutionInitializer() {
        this.vocab = new LinkedHashMap<Value, BigdataValue>();
    }

    public void process(ASTOperationContainer qc) throws MalformedQueryException {
        try {
            qc.jjtAccept((SyntaxTreeBuilderVisitor)new RDFValueResolver(), null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException((Throwable)e);
        }
        for (Map.Entry<ASTRDFValue, BigdataValue> entry : this.nodes.entrySet()) {
            ASTRDFLiteral rdfNode;
            ASTRDFValue value = entry.getKey();
            IV<BigdataValue, Void> iv = null;
            BigdataValue bigdataValue = null;
            if (value.getRDFValue() != null && ((BigdataValue)value.getRDFValue()).getIV() != null) {
                bigdataValue = (BigdataValue)value.getRDFValue();
                iv = bigdataValue.getIV();
            } else if (value instanceof ASTIRI) {
                iv = new TermId(VTE.URI, 0L);
                bigdataValue = this.valueFactory.createURI(((ASTIRI)value).getValue());
                if (!bigdataValue.isRealIV()) {
                    bigdataValue.clearInternalValue();
                    bigdataValue.setIV(iv);
                }
                iv.setValue(bigdataValue);
            } else if (value instanceof ASTRDFLiteral) {
                rdfNode = (ASTRDFLiteral)value;
                String lang = rdfNode.getLang();
                ASTIRI dataTypeIri = rdfNode.getDatatype();
                URIImpl dataTypeUri = null;
                DTE dte = null;
                if (dataTypeIri != null && dataTypeIri.getValue() != null) {
                    dataTypeUri = new URIImpl(dataTypeIri.getValue());
                    dte = DTE.valueOf((URI)dataTypeUri);
                }
                if (dte != null) {
                    bigdataValue = this.getBigdataValue(rdfNode.getLabel().getValue(), dte);
                    if (!bigdataValue.stringValue().equals(rdfNode.getLabel().getValue())) {
                        bigdataValue = this.valueFactory.createLiteral(rdfNode.getLabel().getValue(), (URI)dataTypeUri);
                        iv = TermId.mockIV(VTE.valueOf(bigdataValue));
                        bigdataValue.setIV(iv);
                        iv.setValue(bigdataValue);
                    }
                } else {
                    iv = new TermId(VTE.LITERAL, 0L);
                    bigdataValue = lang != null ? this.valueFactory.createLiteral(rdfNode.getLabel().getValue(), lang) : this.valueFactory.createLiteral(rdfNode.getLabel().getValue(), (URI)dataTypeUri);
                    iv.setValue(bigdataValue);
                    bigdataValue.setIV(iv);
                }
            } else if (value instanceof ASTNumericLiteral) {
                rdfNode = (ASTNumericLiteral)value;
                URI dataTypeUri = rdfNode.getDatatype();
                DTE dte = DTE.valueOf(dataTypeUri);
                bigdataValue = this.getBigdataValue(rdfNode.getValue(), dte);
                if (!bigdataValue.stringValue().equals(rdfNode.getValue())) {
                    bigdataValue = this.valueFactory.createLiteral(rdfNode.getValue(), dataTypeUri);
                }
            } else if (value instanceof ASTTrue) {
                bigdataValue = this.valueFactory.createLiteral(true);
                if (bigdataValue.isRealIV()) {
                    iv = bigdataValue.getIV();
                } else {
                    iv = TermId.mockIV(VTE.valueOf(bigdataValue));
                    iv.setValue(bigdataValue);
                    bigdataValue.setIV(iv);
                }
            } else if (value instanceof ASTFalse) {
                bigdataValue = this.valueFactory.createLiteral(false);
                if (bigdataValue.isRealIV()) {
                    iv = bigdataValue.getIV();
                } else {
                    iv = TermId.mockIV(VTE.valueOf(bigdataValue));
                    iv.setValue(bigdataValue);
                    bigdataValue.setIV(iv);
                }
            } else {
                iv = new FullyInlineTypedLiteralIV(value.toString(), true);
                bigdataValue = iv.getValue();
            }
            if (bigdataValue == null) continue;
            value.setRDFValue((Value)bigdataValue);
            this.fillInDummyIV(bigdataValue);
            this.vocab.put(bigdataValue, bigdataValue);
        }
        for (Value value : RDF_VOCAB) {
            BigdataValue bigdataValue = this.valueFactory.asValue(value);
            this.fillInDummyIV(bigdataValue);
            this.vocab.put(value, bigdataValue);
        }
    }

    private void fillInDummyIV(BigdataValue value) {
        IV iv = value.getIV();
        if (iv == null) {
            if (INFO) {
                log.info((Object)("Not in knowledge base: " + value));
            }
            TermId<?> dummyIV = TermId.mockIV(VTE.valueOf(value));
            value.setIV(dummyIV);
            dummyIV.setValue(value);
        } else {
            iv.setValue(value);
        }
    }

    private BigdataValue getBigdataValue(String value, DTE dte) {
        Object bigdataValue;
        if (value.isEmpty()) {
            BigdataLiteral bigdataValue2 = this.valueFactory.createLiteral(value, dte.getDatatypeURI());
            FullyInlineTypedLiteralIV<BigdataLiteral> iv = new FullyInlineTypedLiteralIV<BigdataLiteral>("", null, dte.getDatatypeURI(), true);
            bigdataValue2.setIV(iv);
            iv.setValue(bigdataValue2);
            return bigdataValue2;
        }
        IV iv = ASTDeferredIVResolutionInitializer.decode(value, dte.name());
        if (!iv.hasValue() && iv instanceof AbstractLiteralIV) {
            switch (dte) {
                case XSDByte: {
                    bigdataValue = this.valueFactory.createLiteral(((AbstractLiteralIV)iv).byteValue());
                    break;
                }
                case XSDShort: {
                    bigdataValue = this.valueFactory.createLiteral(((AbstractLiteralIV)iv).shortValue());
                    break;
                }
                case XSDInt: {
                    bigdataValue = this.valueFactory.createLiteral(((AbstractLiteralIV)iv).intValue());
                    break;
                }
                case XSDLong: {
                    bigdataValue = this.valueFactory.createLiteral(((AbstractLiteralIV)iv).longValue());
                    break;
                }
                case XSDFloat: {
                    bigdataValue = this.valueFactory.createLiteral(((AbstractLiteralIV)iv).floatValue());
                    break;
                }
                case XSDDouble: {
                    bigdataValue = this.valueFactory.createLiteral(((AbstractLiteralIV)iv).doubleValue());
                    break;
                }
                case XSDBoolean: {
                    bigdataValue = this.valueFactory.createLiteral(((AbstractLiteralIV)iv).booleanValue());
                    break;
                }
                case XSDString: {
                    bigdataValue = this.valueFactory.createLiteral(((AbstractLiteralIV)iv).stringValue(), dte.getDatatypeURI());
                    break;
                }
                case XSDInteger: {
                    bigdataValue = this.valueFactory.createLiteral(((AbstractLiteralIV)iv).stringValue(), XMLSchema.INTEGER);
                    break;
                }
                case XSDDecimal: {
                    bigdataValue = this.valueFactory.createLiteral(iv.stringValue(), DTE.XSDDecimal.getDatatypeURI());
                    break;
                }
                case XSDUnsignedShort: {
                    bigdataValue = this.valueFactory.createLiteral(iv.stringValue(), DTE.XSDUnsignedShort.getDatatypeURI());
                    break;
                }
                case XSDUnsignedInt: {
                    bigdataValue = this.valueFactory.createLiteral(iv.stringValue(), DTE.XSDUnsignedInt.getDatatypeURI());
                    break;
                }
                case XSDUnsignedByte: {
                    bigdataValue = this.valueFactory.createLiteral(iv.stringValue(), DTE.XSDUnsignedByte.getDatatypeURI());
                    break;
                }
                case XSDUnsignedLong: {
                    bigdataValue = this.valueFactory.createLiteral(iv.stringValue(), DTE.XSDUnsignedLong.getDatatypeURI());
                    break;
                }
                default: {
                    throw new RuntimeException("unknown DTE " + (Object)((Object)dte));
                }
            }
            bigdataValue.setIV(iv);
            iv.setValue(bigdataValue);
        } else {
            bigdataValue = iv.getValue();
        }
        return bigdataValue;
    }

    public static IV decode(String val, String type) {
        DTE dte = Enum.valueOf(DTE.class, type);
        switch (dte) {
            case XSDBoolean: {
                return XSDBooleanIV.valueOf(Boolean.valueOf(val));
            }
            case XSDByte: {
                byte x = Byte.valueOf(val);
                return new XSDNumericIV(x);
            }
            case XSDShort: {
                short x = Short.valueOf(val);
                return new XSDNumericIV(x);
            }
            case XSDInt: {
                int x = Integer.valueOf(val);
                return new XSDNumericIV(x);
            }
            case XSDLong: {
                long x = Long.valueOf(val);
                return new XSDNumericIV(x);
            }
            case XSDFloat: {
                float x = Float.valueOf(val).floatValue();
                return new XSDNumericIV(x);
            }
            case XSDDouble: {
                double x = Double.valueOf(val);
                return new XSDNumericIV(x);
            }
            case UUID: {
                UUID x = UUID.fromString(val);
                return new UUIDLiteralIV(x);
            }
            case XSDInteger: {
                BigInteger x = new BigInteger(val);
                return new XSDIntegerIV(x);
            }
            case XSDDecimal: {
                BigDecimal x = new BigDecimal(val);
                return new XSDDecimalIV(x);
            }
            case XSDString: {
                return new FullyInlineTypedLiteralIV(val, null, XMLSchema.STRING, true);
            }
            case XSDUnsignedByte: {
                return new XSDUnsignedByteIV((byte)(Byte.valueOf(val) + -128));
            }
            case XSDUnsignedShort: {
                return new XSDUnsignedShortIV((short)(Short.valueOf(val) + Short.MIN_VALUE));
            }
            case XSDUnsignedInt: {
                return new XSDUnsignedIntIV(Integer.valueOf(val) + Integer.MIN_VALUE);
            }
            case XSDUnsignedLong: {
                return new XSDUnsignedLongIV(Long.valueOf(val) + Long.MIN_VALUE);
            }
        }
        throw new UnsupportedOperationException("dte=" + (Object)((Object)dte));
    }

    private class RDFValueResolver
    extends ASTVisitorBase {
        private RDFValueResolver() {
        }

        @Override
        public Object visit(ASTQName node, Object data) throws VisitorException {
            throw new VisitorException("QNames must be resolved before resolving RDF Values");
        }

        @Override
        public Object visit(ASTBlankNode node, Object data) throws VisitorException {
            throw new VisitorException("Blank nodes must be replaced with variables before resolving RDF Values");
        }

        @Override
        public Void visit(ASTIRI node, Object data) throws VisitorException {
            try {
                ASTDeferredIVResolutionInitializer.this.nodes.put(node, ASTDeferredIVResolutionInitializer.this.valueFactory.createURI(node.getValue()));
                return null;
            }
            catch (IllegalArgumentException e) {
                throw new VisitorException(e.getMessage());
            }
        }

        @Override
        public Void visit(ASTRDFLiteral node, Object data) throws VisitorException {
            BigdataLiteral literal;
            String label = (String)node.getLabel().jjtAccept((SyntaxTreeBuilderVisitor)this, null);
            String lang = node.getLang();
            ASTIRI datatypeNode = node.getDatatype();
            if (datatypeNode != null) {
                BigdataURI datatype;
                try {
                    datatype = ASTDeferredIVResolutionInitializer.this.valueFactory.createURI(datatypeNode.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new VisitorException((Throwable)e);
                }
                literal = ASTDeferredIVResolutionInitializer.this.valueFactory.createLiteral(label, datatype);
            } else {
                literal = lang != null ? ASTDeferredIVResolutionInitializer.this.valueFactory.createLiteral(label, lang) : ASTDeferredIVResolutionInitializer.this.valueFactory.createLiteral(label);
            }
            ASTDeferredIVResolutionInitializer.this.nodes.put(node, literal);
            return null;
        }

        @Override
        public Void visit(ASTNumericLiteral node, Object data) throws VisitorException {
            ASTDeferredIVResolutionInitializer.this.nodes.put(node, ASTDeferredIVResolutionInitializer.this.valueFactory.createLiteral(node.getValue(), node.getDatatype()));
            return null;
        }

        @Override
        public Void visit(ASTTrue node, Object data) throws VisitorException {
            ASTDeferredIVResolutionInitializer.this.nodes.put(node, ASTDeferredIVResolutionInitializer.this.valueFactory.createLiteral(true));
            return null;
        }

        @Override
        public Void visit(ASTFalse node, Object data) throws VisitorException {
            ASTDeferredIVResolutionInitializer.this.nodes.put(node, ASTDeferredIVResolutionInitializer.this.valueFactory.createLiteral(false));
            return null;
        }

        @Override
        public String visit(ASTString node, Object data) throws VisitorException {
            return node.getValue();
        }
    }
}

