/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio.json;

import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.rio.json.BigdataSPARQLResultsJSONWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.WriterConfig;

public class BigdataSPARQLResultsJSONWriterForConstruct
implements RDFWriter {
    private final BigdataSPARQLResultsJSONWriter writer;

    public BigdataSPARQLResultsJSONWriterForConstruct(Writer writer) {
        this.writer = new BigdataSPARQLResultsJSONWriter(writer);
    }

    public BigdataSPARQLResultsJSONWriterForConstruct(OutputStream out) {
        this.writer = new BigdataSPARQLResultsJSONWriter(out);
    }

    public RDFFormat getRDFFormat() {
        return ServiceProviderHook.JSON_RDR;
    }

    public void startRDF() throws RDFHandlerException {
        try {
            this.writer.startDocument();
            this.writer.startHeader();
            this.writer.startQueryResult((List)Arrays.asList("subject", "predicate", "object", "context"));
            this.writer.endHeader();
        }
        catch (QueryResultHandlerException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void endRDF() throws RDFHandlerException {
        try {
            this.writer.endQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        try {
            this.writer.handleNamespace(prefix, uri);
        }
        catch (QueryResultHandlerException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        MapBindingSet bs = new MapBindingSet();
        bs.addBinding("subject", (Value)st.getSubject());
        bs.addBinding("predicate", (Value)st.getPredicate());
        bs.addBinding("object", st.getObject());
        if (st.getContext() != null) {
            bs.addBinding("context", (Value)st.getContext());
        }
        try {
            this.writer.handleSolution((BindingSet)bs);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public void setWriterConfig(WriterConfig config) {
        this.writer.setWriterConfig(config);
    }

    public WriterConfig getWriterConfig() {
        return this.writer.getWriterConfig();
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        return this.writer.getSupportedSettings();
    }
}

