/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.lexicon.ITermIndexCodes;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class LexiconKeyBuilder
implements ITermIndexCodes {
    public final IKeyBuilder keyBuilder;

    protected LexiconKeyBuilder(IKeyBuilder keyBuilder) {
        this.keyBuilder = keyBuilder;
    }

    public byte[] uri2key(String uri) {
        return this.keyBuilder.reset().append((byte)1).append(uri).getKey();
    }

    public byte[] plainLiteral2key(String text) {
        return this.keyBuilder.reset().append((byte)2).append(text).getKey();
    }

    public byte[] languageCodeLiteral2key(String languageCode, String text) {
        assert (languageCode.length() > 0);
        this.keyBuilder.reset().append((byte)3);
        this.keyBuilder.appendASCII(languageCode.toUpperCase()).appendNul();
        return this.keyBuilder.append(text).getKey();
    }

    public byte[] datatypeLiteral2key(URI datatype, String value) {
        if (datatype == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.keyBuilder.reset().append((byte)4);
        this.keyBuilder.append(datatype.stringValue());
        this.keyBuilder.append(value);
        this.keyBuilder.appendNul();
        return this.keyBuilder.getKey();
    }

    public byte[] blankNode2Key(String id) {
        return this.keyBuilder.reset().append((byte)5).append(id).getKey();
    }

    public byte[] value2Key(Value value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value instanceof URI) {
            URI uri = (URI)value;
            String term = uri.toString();
            return this.uri2key(term);
        }
        if (value instanceof Literal) {
            Literal lit = (Literal)value;
            String text = lit.getLabel();
            String languageCode = lit.getLanguage();
            URI datatypeUri = lit.getDatatype();
            if (languageCode != null) {
                return this.languageCodeLiteral2key(languageCode, text);
            }
            if (datatypeUri != null) {
                return this.datatypeLiteral2key(datatypeUri, text);
            }
            return this.plainLiteral2key(text);
        }
        if (value instanceof BNode) {
            String bnodeId = ((BNode)value).getID();
            return this.blankNode2Key(bnodeId);
        }
        throw new AssertionError((Object)("Unknown value type: " + value.getClass()));
    }
}

