/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.search.Hiterator;
import com.bigdata.search.IHit;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public interface ITextIndexer<A extends IHit> {
    public void create();

    public void destroy();

    public boolean getIndexDatatypeLiterals();

    public Hiterator<A> search(FullTextQuery var1);

    public int count(FullTextQuery var1);

    public static class FullTextQuery
    implements Serializable {
        private static final long serialVersionUID = 4159873519447769476L;
        final String query;
        final String languageCode;
        final boolean prefixMatch;
        final double minCosine;
        final double maxCosine;
        final int minRank;
        final int maxRank;
        final boolean matchAllTerms;
        final boolean matchExact;
        final long timeout;
        final TimeUnit unit;
        final String matchRegex;

        public FullTextQuery(String query) {
            this(query, null, false, null, false, false, 0.0, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }

        public FullTextQuery(String query, String languageCode, boolean prefixMatch) {
            this(query, languageCode, prefixMatch, null, false, false, 0.0, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }

        public FullTextQuery(String query, String languageCode, boolean prefixMatch, String matchRegex, boolean matchAllTerms, boolean matchExact) {
            this(query, languageCode, prefixMatch, matchRegex, matchAllTerms, matchExact, 0.0, 1.0, 1, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }

        public FullTextQuery(String query, String languageCode, boolean prefixMatch, String matchRegex, boolean matchAllTerms, boolean matchExact, double minCosine, double maxCosine, int minRank, int maxRank) {
            this(query, languageCode, prefixMatch, matchRegex, matchAllTerms, matchExact, minCosine, maxCosine, minRank, maxRank, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }

        public FullTextQuery(String query, String languageCode, boolean prefixMatch, String matchRegex, boolean matchAllTerms, boolean matchExact, double minCosine, double maxCosine, int minRank, int maxRank, long timeout, TimeUnit unit) {
            this.query = query;
            this.languageCode = languageCode;
            this.prefixMatch = prefixMatch;
            this.matchRegex = matchRegex;
            this.matchAllTerms = matchAllTerms;
            this.matchExact = matchExact;
            this.minCosine = minCosine;
            this.maxCosine = maxCosine;
            this.minRank = minRank;
            this.maxRank = maxRank;
            this.timeout = timeout;
            this.unit = unit;
        }

        public String getQuery() {
            return this.query;
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public boolean isPrefixMatch() {
            return this.prefixMatch;
        }

        public String getMatchRegex() {
            return this.matchRegex;
        }

        public boolean isMatchAllTerms() {
            return this.matchAllTerms;
        }

        public boolean isMatchExact() {
            return this.matchExact;
        }

        public double getMinCosine() {
            return this.minCosine;
        }

        public double getMaxCosine() {
            return this.maxCosine;
        }

        public int getMinRank() {
            return this.minRank;
        }

        public int getMaxRank() {
            return this.maxRank;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public TimeUnit getTimeUnit() {
            return this.unit;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.languageCode == null ? 0 : this.languageCode.hashCode());
            result = 31 * result + (this.matchAllTerms ? 1231 : 1237);
            result = 31 * result + (this.matchExact ? 1231 : 1237);
            result = 31 * result + (this.prefixMatch ? 1231 : 1237);
            result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
            result = 31 * result + (this.matchRegex == null ? 0 : this.matchRegex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FullTextQuery other = (FullTextQuery)obj;
            if (this.languageCode == null ? other.languageCode != null : !this.languageCode.equals(other.languageCode)) {
                return false;
            }
            if (this.matchAllTerms != other.matchAllTerms) {
                return false;
            }
            if (this.matchExact != other.matchExact) {
                return false;
            }
            if (this.prefixMatch != other.prefixMatch) {
                return false;
            }
            if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
                return false;
            }
            return !(this.matchRegex == null ? other.matchRegex != null : !this.matchRegex.equals(other.matchRegex));
        }
    }
}

