/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.lexicon.ITermCache;
import com.bigdata.rdf.lexicon.ResolveTermTask;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class BatchResolveTermIVsTask
implements Callable<Void> {
    private final ExecutorService service;
    private final IIndex ndx;
    private final Collection<TermId<?>> ivs;
    private final ConcurrentHashMap<IV<?, ?>, BigdataValue> ret;
    private final ITermCache<IV<?, ?>, BigdataValue> termCache;
    private final BigdataValueFactory valueFactory;
    private final int MAX_CHUNK;

    public BatchResolveTermIVsTask(ExecutorService service, IIndex ndx, Collection<TermId<?>> ivs, ConcurrentHashMap<IV<?, ?>, BigdataValue> ret, ITermCache<IV<?, ?>, BigdataValue> termCache, BigdataValueFactory valueFactory, int chunkSize) {
        this.service = service;
        this.ndx = ndx;
        this.ivs = ivs;
        this.ret = ret;
        this.termCache = termCache;
        this.valueFactory = valueFactory;
        this.MAX_CHUNK = chunkSize;
    }

    @Override
    public Void call() throws Exception {
        int numNotFound = this.ivs.size();
        Object[] notFound = this.ivs.toArray(new TermId[numNotFound]);
        Arrays.sort(notFound, 0, numNotFound);
        byte[][] keys = new byte[numNotFound][];
        IKeyBuilder keyBuilder = KeyBuilder.newInstance();
        for (int i = 0; i < numNotFound; ++i) {
            keys[i] = ((TermId)notFound[i]).encode(keyBuilder.reset()).getKey();
        }
        if (numNotFound < this.MAX_CHUNK) {
            new ResolveTermTask(this.ndx, 0, numNotFound, keys, (TermId<?>[])notFound, this.ret, this.termCache, this.valueFactory).call();
        } else {
            int N = numNotFound;
            int M2 = this.MAX_CHUNK;
            int nchunks = (int)Math.ceil((double)N / (double)M2);
            int perChunk = N / nchunks;
            ArrayList<ResolveTermTask> tasks = new ArrayList<ResolveTermTask>(nchunks);
            int fromIndex = 0;
            int remaining = numNotFound;
            for (int i = 0; i < nchunks; ++i) {
                boolean lastChunk = i + 1 == nchunks;
                int chunkSize = lastChunk ? remaining : perChunk;
                int toIndex = fromIndex + chunkSize;
                remaining -= chunkSize;
                tasks.add(new ResolveTermTask(this.ndx, fromIndex, toIndex, keys, (TermId<?>[])notFound, this.ret, this.termCache, this.valueFactory));
                fromIndex = toIndex;
            }
            try {
                List futures = this.service.invokeAll(tasks);
                for (Future f : futures) {
                    f.get();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

