/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rawstore;

import com.bigdata.rawstore.IAddressManager;
import java.math.BigInteger;
import java.text.NumberFormat;

public class WormAddressManager
implements IAddressManager {
    protected static final String _NULL_ = "NULL";
    public static final int MIN_OFFSET_BITS = 31;
    public static final int MAX_OFFSET_BITS = 60;
    public static final int SCALE_UP_OFFSET_BITS = 42;
    public static final int SCALE_OUT_OFFSET_BITS = 38;
    final int offsetBits;
    final int byteCountBits;
    final long maxOffset;
    final long maxByteCount;
    final long offsetMask;
    final long byteCountMask;

    public final int getOffsetBits() {
        return this.offsetBits;
    }

    public final long getMaxOffset() {
        return this.maxOffset;
    }

    public final int getMaxByteCount() {
        if (this.maxByteCount > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.maxByteCount;
    }

    public static final boolean assertOffsetBits(int offsetBits) {
        if (offsetBits < 31 || offsetBits > 60) {
            throw new IllegalArgumentException("offsetBits must be in [31:60], not: " + offsetBits);
        }
        return true;
    }

    public static final int getMaxByteCount(int offsetBits) {
        WormAddressManager.assertOffsetBits(offsetBits);
        int byteCountBits = 64 - offsetBits;
        long maxByteCount = BigInteger.valueOf(2L).pow(byteCountBits).longValue();
        if (maxByteCount > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)maxByteCount;
    }

    public WormAddressManager(int offsetBits) {
        WormAddressManager.assertOffsetBits(offsetBits);
        this.offsetBits = offsetBits;
        this.byteCountBits = 64 - offsetBits;
        long mask = 0L;
        for (int i = 0; i < this.byteCountBits; ++i) {
            long bit = 1L << i;
            mask |= bit;
        }
        this.byteCountMask = mask;
        this.offsetMask = this.byteCountMask ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxOffset = this.offsetMask >>> this.byteCountBits;
        assert (this.maxOffset > 0L);
        this.maxByteCount = this.byteCountMask;
        assert (this.maxByteCount > 0L);
    }

    public final boolean assertByteCount(int nbytes) {
        if (nbytes < 0 || (long)nbytes > this.maxByteCount) {
            throw new IllegalArgumentException("Maximum record length exceeded: nbytes must be in [0:" + this.maxByteCount + "], but was " + nbytes);
        }
        return true;
    }

    public final boolean assertOffset(long offset) {
        if (offset < 0L || offset > this.maxOffset) {
            throw new IllegalArgumentException("Maximum offset exceeded: offset must be in [0:" + this.maxOffset + "], but was " + offset);
        }
        return true;
    }

    @Override
    public final long toAddr(int nbytes, long offset) {
        this.assertByteCount(nbytes);
        this.assertOffset(offset);
        return offset << this.byteCountBits | (long)nbytes;
    }

    @Override
    public final int getByteCount(long addr) {
        return (int)(this.byteCountMask & addr);
    }

    @Override
    public long getOffset(long addr) {
        return (this.offsetMask & addr) >>> this.byteCountBits;
    }

    @Override
    public long getPhysicalAddress(long addr) {
        return this.getOffset(addr);
    }

    @Override
    public String toString(long addr) {
        if (addr == 0L) {
            return _NULL_;
        }
        long offset = this.getOffset(addr);
        int nbytes = this.getByteCount(addr);
        return "{off=" + offset + ",len=" + nbytes + "}";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{ offsetBits=" + this.offsetBits);
        sb.append(", byteCountBits=" + this.byteCountBits);
        sb.append(", maxOffset=" + Long.toHexString(this.maxOffset));
        sb.append(", maxByteCount=" + Long.toHexString(this.maxByteCount));
        sb.append(", offsetMask=" + Long.toHexString(this.offsetMask));
        sb.append(", byteCountMask=" + Long.toHexString(this.byteCountMask));
        sb.append("}");
        return sb.toString();
    }

    public static void main(String[] args) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(true);
        System.out.println("#offsetBits\tmaxOffset\tmaxByteCount");
        for (int offsetBits = 31; offsetBits <= 60; ++offsetBits) {
            WormAddressManager am = new WormAddressManager(offsetBits);
            long maxRecords = am.getMaxOffset();
            int maxRecordSize = am.getMaxByteCount();
            System.out.println("" + offsetBits + "\t" + nf.format(maxRecords) + "\t" + nf.format(maxRecordSize));
        }
    }
}

