/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.mdi;

import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import com.bigdata.io.LongPacker;
import com.bigdata.mdi.IMetadataIndex;
import com.bigdata.mdi.MetadataIndexView;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.service.MetadataService;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

public class MetadataIndex
extends BTree
implements IMetadataIndex {
    private final transient MetadataIndexView view;
    private int nextPartitionId;

    @Override
    public MetadataIndexMetadata getIndexMetadata() {
        return (MetadataIndexMetadata)super.getIndexMetadata();
    }

    @Override
    public IndexMetadata getScaleOutIndexMetadata() {
        return this.getIndexMetadata().getManagedIndexMetadata();
    }

    public int incrementAndGetNextPartitionId() {
        int tmp = this.nextPartitionId++;
        this.fireDirtyEvent();
        return tmp;
    }

    public static MetadataIndex create(IRawStore store, UUID indexUUID, IndexMetadata managedIndexMetadata) {
        MetadataIndexMetadata metadata = new MetadataIndexMetadata(managedIndexMetadata.getName(), indexUUID, managedIndexMetadata);
        metadata.setDeleteMarkers(true);
        metadata.setBTreeClassName(MetadataIndex.class.getName());
        metadata.setCheckpointClassName(MetadataIndexCheckpoint.class.getName());
        metadata.setTupleSerializer(PartitionLocatorTupleSerializer.newInstance());
        return (MetadataIndex)BTree.create(store, metadata);
    }

    public MetadataIndex(IRawStore store, Checkpoint checkpoint, IndexMetadata metadata, boolean readOnly) {
        super(store, checkpoint, metadata, readOnly);
        this.nextPartitionId = ((MetadataIndexCheckpoint)checkpoint).getNextPartitionId();
        this.view = new MetadataIndexView(this);
    }

    @Override
    public boolean needsCheckpoint() {
        if (this.nextPartitionId != ((MetadataIndexCheckpoint)this.getCheckpoint()).getNextPartitionId()) {
            return true;
        }
        return super.needsCheckpoint();
    }

    @Override
    public PartitionLocator get(byte[] key) {
        return (PartitionLocator)super.lookup((Object)key);
    }

    @Override
    public PartitionLocator find(byte[] key) {
        return this.view.find(key);
    }

    @Override
    public void staleLocator(PartitionLocator locator) {
        this.view.staleLocator(locator);
    }

    public static class PartitionLocatorTupleSerializer
    extends DefaultTupleSerializer<byte[], PartitionLocator> {
        private static final long serialVersionUID = -4178430896409893596L;
        private static final transient byte VERSION0 = 0;
        private static final transient byte VERSION = 0;

        public static PartitionLocatorTupleSerializer newInstance() {
            return new PartitionLocatorTupleSerializer(PartitionLocatorTupleSerializer.getDefaultKeyBuilderFactory());
        }

        public PartitionLocatorTupleSerializer() {
        }

        public PartitionLocatorTupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
            super(keyBuilderFactory);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            byte version = in.readByte();
            switch (version) {
                case 0: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown version: " + version);
                }
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeByte(0);
        }
    }

    public static class MetadataIndexMetadata
    extends IndexMetadata
    implements Externalizable {
        private static final long serialVersionUID = -7309267778881420043L;
        private IndexMetadata scaleOutIndexMetadata;
        private static final transient int VERSION0 = 0;

        public final IndexMetadata getManagedIndexMetadata() {
            return this.scaleOutIndexMetadata;
        }

        public MetadataIndexMetadata() {
        }

        public MetadataIndexMetadata(String managedIndexName, UUID indexUUID, IndexMetadata managedIndexMetadata) {
            super(MetadataService.getMetadataIndexName(managedIndexName), indexUUID);
            if (managedIndexMetadata == null) {
                throw new IllegalArgumentException();
            }
            this.scaleOutIndexMetadata = managedIndexMetadata;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            int version = (int)LongPacker.unpackLong(in);
            if (version != 0) {
                throw new IOException("Unknown version: version=" + version);
            }
            this.scaleOutIndexMetadata = (IndexMetadata)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            LongPacker.packLong(out, 0L);
            out.writeObject(this.scaleOutIndexMetadata);
        }
    }

    public static class MetadataIndexCheckpoint
    extends Checkpoint {
        private static final long serialVersionUID = 6482587101150014793L;
        private int nextPartitionId;
        private static final transient int VERSION0 = 0;

        public int getNextPartitionId() {
            return this.nextPartitionId;
        }

        public MetadataIndexCheckpoint() {
        }

        public MetadataIndexCheckpoint(BTree btree) {
            super(btree);
            this.nextPartitionId = ((MetadataIndex)btree).nextPartitionId;
        }

        public MetadataIndexCheckpoint(IndexMetadata metadata) {
            super(metadata);
            this.nextPartitionId = 0;
        }

        public MetadataIndexCheckpoint(IndexMetadata metadata, Checkpoint oldCheckpoint) {
            super(metadata, oldCheckpoint);
            this.nextPartitionId = ((MetadataIndexCheckpoint)oldCheckpoint).nextPartitionId;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            int version = (int)LongPacker.unpackLong(in);
            if (version != 0) {
                throw new IOException("Unknown version: " + version);
            }
            this.nextPartitionId = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            LongPacker.packLong(out, 0L);
            out.writeInt(this.nextPartitionId);
        }
    }
}

