/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SliceInputStream
extends FilterInputStream {
    private final int limit;
    private int nread = 0;

    public SliceInputStream(InputStream in, int limit) {
        super(in);
        if (in == null) {
            throw new IllegalArgumentException();
        }
        if (limit < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.nread >= this.limit) {
            return -1;
        }
        int b = this.in.read();
        if (b == -1) {
            return -1;
        }
        ++this.nread;
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0) {
            throw new IllegalArgumentException();
        }
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (off + len > b.length) {
            throw new IllegalArgumentException();
        }
        int nremaining = this.limit - this.nread;
        int nrequested = len - off;
        if (nremaining == 0 && nrequested > 0) {
            return -1;
        }
        int nallowed = Math.min(nremaining, nrequested);
        int n = this.in.read(b, off, nallowed);
        if (n == -1) {
            return -1;
        }
        this.nread += n;
        return n;
    }
}

