/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.htree.AbstractPage;
import com.bigdata.htree.DirectoryPage;
import java.lang.ref.Reference;
import java.util.Iterator;
import java.util.NoSuchElementException;

class DirtyChildIterator
implements Iterator<AbstractPage> {
    private final DirectoryPage node;
    private int index = 0;
    private int lastVisited = -1;
    private AbstractPage child = null;

    public DirtyChildIterator(DirectoryPage node) {
        assert (node != null);
        this.node = node;
    }

    @Override
    public boolean hasNext() {
        if (this.child != null && this.child.isDirty()) {
            return true;
        }
        int slotsPerPage = 1 << this.node.htree.addressBits;
        while (this.index < slotsPerPage) {
            Reference<AbstractPage> childRef = this.node.getChildRef(this.index);
            if (childRef != null) {
                this.child = childRef.get();
                if (this.child != null && this.child.isDirty()) {
                    while (this.index + 1 < slotsPerPage && this.node.childRefs[this.index + 1] == childRef) {
                        ++this.index;
                    }
                    break;
                }
            }
            ++this.index;
        }
        return this.index < slotsPerPage;
    }

    @Override
    public AbstractPage next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.child != null);
        assert (this.child.isDirty());
        AbstractPage tmp = this.child;
        this.lastVisited = this.index++;
        this.child = null;
        return tmp;
    }

    public AbstractPage getNode() {
        if (this.lastVisited == -1) {
            throw new IllegalStateException();
        }
        return this.node.getChild(this.lastVisited);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

