/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.ICounter;
import com.bigdata.counters.ICounterNode;
import com.bigdata.counters.ICounterSet;
import com.bigdata.counters.IInstrument;

final class Counter<T>
implements ICounter {
    ICounterSet parent;
    private final String name;
    private final IInstrument<T> instrument;

    Counter(ICounterSet parent, String name, IInstrument<T> instrument) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (instrument == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.name = name;
        this.instrument = instrument;
    }

    @Override
    public ICounterSet getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        if (this.parent.isRoot()) {
            return this.parent.getPath() + this.name;
        }
        return this.parent.getPath() + "/" + this.name;
    }

    @Override
    public int getDepth() {
        int depth = 0;
        ICounterNode t = this;
        while (!t.isRoot()) {
            t = t.getParent();
            ++depth;
        }
        return depth;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public ICounterSet getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public T getValue() {
        return this.instrument.getValue();
    }

    @Override
    public void setValue(Object value, long timestamp) {
        this.instrument.setValue(value, timestamp);
    }

    @Override
    public long lastModified() {
        return this.instrument.lastModified();
    }

    @Override
    public final boolean isCounterSet() {
        return false;
    }

    @Override
    public final boolean isCounter() {
        return true;
    }

    @Override
    public ICounterNode getChild(String name) {
        return null;
    }

    @Override
    public ICounterNode getPath(String path) {
        return null;
    }

    @Override
    public IInstrument<T> getInstrument() {
        return this.instrument;
    }
}

