/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.view;

import com.bigdata.btree.DelegateTuple;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.util.BytesUtil;
import java.util.NoSuchElementException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class FusedTupleIterator<I extends ITupleIterator<E>, E>
implements ITupleIterator<E> {
    protected static final Logger log = Logger.getLogger(FusedTupleIterator.class);
    protected final boolean INFO = log.getEffectiveLevel().toInt() <= Level.INFO.toInt();
    protected final boolean DEBUG = log.getEffectiveLevel().toInt() <= Level.DEBUG.toInt();
    protected final int flags;
    protected final boolean deleted;
    protected final int n;
    protected final I[] sourceIterator;
    protected final ITuple<E>[] sourceTuple;
    protected int current = -1;
    protected int lastVisited = -1;
    private long nvisited = 0L;

    public FusedTupleIterator(int flags, boolean deleted, I[] sourceIterators) {
        assert (sourceIterators != null);
        assert (sourceIterators.length > 0);
        this.flags = flags;
        this.n = sourceIterators.length;
        this.deleted = deleted;
        for (int i = 0; i < this.n; ++i) {
            assert (sourceIterators[i] != null);
        }
        this.sourceIterator = sourceIterators;
        this.sourceTuple = new ITuple[this.n];
        if (this.INFO) {
            log.info((Object)("nsources=" + this.n + ", deleted=" + deleted));
        }
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.current != -1) {
                if (this.INFO) {
                    log.info((Object)("Already matched: source=" + this.current));
                }
                return true;
            }
            int nexhausted = 0;
            for (int i = 0; i < this.n; ++i) {
                if (this.sourceTuple[i] != null) continue;
                if (this.sourceIterator[i].hasNext()) {
                    this.sourceTuple[i] = this.sourceIterator[i].next();
                    if (!this.DEBUG) continue;
                    log.debug((Object)("read sourceTuple[" + i + "]=" + this.sourceTuple[i]));
                    continue;
                }
                ++nexhausted;
            }
            if (nexhausted == this.n) {
                return false;
            }
            assert (this.current == -1);
            byte[] key = null;
            for (int i = 0; i < this.n; ++i) {
                if (this.sourceTuple[i] == null) continue;
                if (this.current == -1) {
                    this.current = i;
                    key = this.sourceTuple[i].getKey();
                    assert (key != null);
                    continue;
                }
                byte[] tmp = this.sourceTuple[i].getKey();
                int ret = BytesUtil.compareBytes((byte[])tmp, (byte[])key);
                if (ret >= 0) continue;
                this.current = i;
                key = tmp;
            }
            assert (this.current != -1);
            if (!this.sourceTuple[this.current].isDeletedVersion() || this.deleted) break;
            if (this.INFO) {
                log.info((Object)("Skipping deleted: source=" + this.current + ", tuple=" + this.sourceTuple[this.current]));
            }
            this.clearCurrent();
        }
        if (this.INFO) {
            log.info((Object)("Will visit next: source=" + this.current + ", tuple: " + this.sourceTuple[this.current]));
        }
        return true;
    }

    @Override
    public ITuple<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.consumeLookaheadTuple();
    }

    protected ITuple<E> consumeLookaheadTuple() {
        long nvisited = this.nvisited++;
        int sourceIndex = this.lastVisited = this.current;
        FusedTuple<E> tuple = new FusedTuple<E>(this.sourceTuple[this.current], sourceIndex, nvisited, this.deleted);
        this.clearCurrent();
        if (this.INFO) {
            log.info((Object)("returning: tuple=" + tuple));
        }
        return tuple;
    }

    protected void clearCurrent() {
        assert (this.current != -1);
        byte[] key = this.sourceTuple[this.current].getKey();
        for (int i = this.current + 1; i < this.n; ++i) {
            byte[] tmp;
            int ret;
            if (this.sourceTuple[i] == null || (ret = BytesUtil.compareBytes((byte[])key, (byte[])(tmp = this.sourceTuple[i].getKey()))) != 0) continue;
            this.sourceTuple[i] = null;
        }
        this.sourceTuple[this.current] = null;
        this.current = -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class FusedTuple<E>
    extends DelegateTuple<E> {
        private final int sourceIndex;
        private final long nvisited;
        private final boolean deleted;

        public FusedTuple(ITuple<E> delegate, int sourceIndex, long nvisited, boolean deleted) {
            super(delegate);
            this.sourceIndex = sourceIndex;
            this.nvisited = nvisited;
            this.deleted = deleted;
        }

        @Override
        public int flags() {
            int flags = super.flags();
            if (!this.deleted) {
                flags &= 0xFFFFFFFB;
            }
            return flags;
        }

        @Override
        public int getSourceIndex() {
            return this.sourceIndex;
        }

        @Override
        public long getVisitCount() {
            return this.nvisited;
        }
    }
}

