/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.btree.raba.AbstractRaba;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.MutableKeysRaba;
import com.bigdata.btree.raba.MutableValuesRaba;
import com.bigdata.btree.raba.ReadOnlyKeysRaba;
import com.bigdata.btree.raba.ReadOnlyValuesRaba;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.FixedByteArrayBuffer;
import com.bigdata.io.LongPacker;
import com.bigdata.io.ShortPacker;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.util.BytesUtil;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class ResultSet
implements ILeafData,
Externalizable {
    private static final long serialVersionUID = 1334143885190084268L;
    private static final transient Logger log = Logger.getLogger(ResultSet.class);
    private boolean sendKeys;
    private boolean sendVals;
    private int ntuples;
    private boolean exhausted;
    private byte[] lastKey;
    private IRaba keys;
    private IRaba vals;
    private long[] versionTimestamps;
    private long minimumVersionTimestamp;
    private long maximumVersionTimestamp;
    private byte[] deleteMarkers;
    private byte[] sourceIndices;
    private IResourceMetadata[] sources;
    private long commitTime;
    private ITupleSerializer tupleSerializer;
    private transient int limit;
    private transient IndexMetadata indexMetadata;
    private boolean init = false;
    private boolean done = false;
    protected static short VERSION0 = 0;

    public final int getNumTuples() {
        return this.ntuples;
    }

    public final boolean isExhausted() {
        return this.exhausted;
    }

    public final byte[] getLastKey() {
        return this.lastKey;
    }

    public final ITupleSerializer getTupleSerializer() {
        return this.tupleSerializer;
    }

    @Override
    public final IRaba getKeys() {
        if (this.keys == null) {
            throw new UnsupportedOperationException();
        }
        return this.keys;
    }

    @Override
    public final IRaba getValues() {
        if (this.vals == null) {
            throw new UnsupportedOperationException();
        }
        return this.vals;
    }

    public final int getSourceIndex(int index) {
        if (this.sources.length == 1) {
            return 0;
        }
        return this.sourceIndices[index];
    }

    public final long getCommitTime() {
        return this.commitTime;
    }

    public final IResourceMetadata[] getSources() {
        return this.sources;
    }

    protected int getLimit() {
        return this.limit;
    }

    protected void init(int limit) {
        if (this.init) {
            throw new IllegalStateException();
        }
        this.init = true;
        this.limit = limit;
        if (limit < 0) {
            limit = -limit;
        }
        this.keys = this.sendKeys ? new MutableKeysRaba(0, 0, limit, new byte[limit][]) : null;
        IRaba iRaba = this.vals = this.sendVals ? new MutableValuesRaba(0, 0, limit, new byte[limit][]) : null;
        if (this.indexMetadata.getDeleteMarkers()) {
            this.deleteMarkers = new byte[limit];
        }
        if (this.indexMetadata.getVersionTimestamps()) {
            this.versionTimestamps = new long[limit];
            this.minimumVersionTimestamp = Long.MIN_VALUE;
            this.maximumVersionTimestamp = Long.MAX_VALUE;
        }
        byte[] byArray = this.sourceIndices = this.sources.length > 1 ? new byte[limit] : null;
        if (log.isInfoEnabled()) {
            log.info((Object)("limit=" + limit + ", sendKeys=" + this.sendKeys + ", sendVals=" + this.sendVals + ", deleteMarkers=" + (this.deleteMarkers != null) + ", timestamps=" + (this.versionTimestamps != null) + ", #sources=" + this.sources.length));
        }
    }

    private void resize() {
        assert (this.limit < 0);
        this.limit *= 2;
        int limit = this.limit;
        if (limit < 0) {
            limit = -limit;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("resizing buffers: ntuples=" + this.ntuples + ", new limit=" + limit));
        }
        if (this.keys != null) {
            this.keys = ((AbstractRaba)this.keys).resize(limit);
        }
        if (this.vals != null) {
            this.vals = ((AbstractRaba)this.vals).resize(limit);
        }
        if (this.deleteMarkers != null) {
            byte[] deleteMarkers = new byte[limit];
            System.arraycopy(this.deleteMarkers, 0, deleteMarkers, 0, this.ntuples);
            this.deleteMarkers = deleteMarkers;
        }
        if (this.versionTimestamps != null) {
            long[] versionTimestamps = new long[limit];
            System.arraycopy(this.versionTimestamps, 0, versionTimestamps, 0, this.ntuples);
            this.versionTimestamps = versionTimestamps;
        }
        if (this.sourceIndices != null) {
            byte[] sourceIndices = new byte[limit];
            System.arraycopy(this.sourceIndices, 0, sourceIndices, 0, this.ntuples);
            this.sourceIndices = sourceIndices;
        }
    }

    protected void done(boolean exhausted, byte[] lastKey) {
        if (!exhausted && lastKey == null) {
            throw new IllegalArgumentException();
        }
        if (this.done) {
            throw new IllegalStateException();
        }
        this.done = true;
        this.exhausted = exhausted;
        this.lastKey = lastKey;
        if (log.isInfoEnabled()) {
            log.info((Object)("ntuples=" + this.ntuples + ", exhausted=" + exhausted + ", sendKeys=" + this.sendKeys + ", sendVals=" + this.sendVals + ", deleteMarkers=" + (this.deleteMarkers != null) + ", timestamps=" + (this.versionTimestamps != null) + ", commitTime=" + this.commitTime + ", lastKey=" + BytesUtil.toString((byte[])lastKey)));
        }
    }

    protected boolean isFull() {
        return this.ntuples >= this.limit;
    }

    protected void copyTuple(ITuple<?> tuple) {
        if (tuple == null) {
            throw new IllegalArgumentException();
        }
        this.assertRunning();
        if (this.isFull() && this.limit < 0) {
            this.resize();
        }
        if (this.sendKeys) {
            this.keys.add(tuple.getKey());
        }
        if (this.sendVals) {
            this.vals.add(tuple.getValue());
        }
        if (this.deleteMarkers != null) {
            this.deleteMarkers[this.ntuples] = (byte)(tuple.isDeletedVersion() ? 1 : 0);
        }
        if (this.versionTimestamps != null) {
            long t;
            this.versionTimestamps[this.ntuples] = t = tuple.getVersionTimestamp();
            if (t < this.minimumVersionTimestamp) {
                this.minimumVersionTimestamp = t;
            }
            if (t > this.maximumVersionTimestamp) {
                this.maximumVersionTimestamp = t;
            }
        }
        if (this.sourceIndices != null) {
            int sourceIndex = tuple.getSourceIndex();
            assert (sourceIndex < 127);
            this.sourceIndices[this.ntuples] = (byte)sourceIndex;
        }
        ++this.ntuples;
    }

    protected void assertRunning() {
        if (this.init && !this.done) {
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] a;
        int len;
        boolean haveVals;
        boolean haveKeys;
        short version = ShortPacker.unpackShort(in);
        if (version != VERSION0) {
            throw new IOException("Unknown version=" + version);
        }
        this.ntuples = (int)LongPacker.unpackLong(in);
        this.commitTime = in.readLong();
        int nsources = (int)LongPacker.unpackLong(in);
        this.sources = new IResourceMetadata[nsources];
        this.exhausted = in.readBoolean();
        this.sendKeys = haveKeys = in.readBoolean();
        this.sendVals = haveVals = in.readBoolean();
        boolean haveDeleteMarkers = in.readBoolean();
        boolean haveVersionTimestamps = in.readBoolean();
        int lastKeySize = (int)LongPacker.unpackLong(in);
        if (lastKeySize != 0) {
            this.lastKey = new byte[lastKeySize];
            in.readFully(this.lastKey);
        } else {
            this.lastKey = null;
        }
        for (int i = 0; i < this.sources.length; ++i) {
            this.sources[i] = (IResourceMetadata)in.readObject();
        }
        this.tupleSerializer = (ITupleSerializer)in.readObject();
        if (haveKeys) {
            if (this.ntuples == 0) {
                this.keys = ReadOnlyKeysRaba.EMPTY;
            } else {
                len = in.readInt();
                a = new byte[len];
                in.readFully(a);
                this.keys = this.tupleSerializer.getLeafKeysCoder().decode(FixedByteArrayBuffer.wrap(a));
            }
        } else {
            this.keys = null;
        }
        if (haveVals) {
            if (this.ntuples == 0) {
                this.vals = ReadOnlyValuesRaba.EMPTY;
            } else {
                len = in.readInt();
                a = new byte[len];
                in.readFully(a);
                this.vals = this.tupleSerializer.getLeafValuesCoder().decode(FixedByteArrayBuffer.wrap(a));
            }
        } else {
            this.vals = null;
        }
        if (haveDeleteMarkers) {
            this.deleteMarkers = new byte[this.ntuples];
            if (this.ntuples > 0) {
                InputBitStream ibs = new InputBitStream((InputStream)((Object)in), 0, false);
                for (int i = 0; i < this.ntuples; ++i) {
                    this.deleteMarkers[i] = (byte)(ibs.readBit() != 0 ? 1 : 0);
                }
            }
        }
        if (haveVersionTimestamps) {
            this.minimumVersionTimestamp = in.readLong();
            this.maximumVersionTimestamp = in.readLong();
            this.versionTimestamps = new long[this.ntuples];
            for (int i = 0; i < this.ntuples; ++i) {
                this.versionTimestamps[i] = in.readLong();
            }
        }
        if (this.sources.length > 1) {
            this.sourceIndices = new byte[this.ntuples];
            for (int i = 0; i < this.ntuples; ++i) {
                this.sourceIndices[i] = in.readByte();
            }
        } else {
            this.sourceIndices = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        AbstractFixedByteArrayBuffer slice;
        DataOutputBuffer buf;
        ShortPacker.packShort(out, VERSION0);
        LongPacker.packLong(out, (long)this.ntuples);
        out.writeLong(this.commitTime);
        LongPacker.packLong(out, (long)this.sources.length);
        out.writeBoolean(this.exhausted);
        out.writeBoolean(this.keys != null);
        out.writeBoolean(this.vals != null);
        out.writeBoolean(this.deleteMarkers != null);
        out.writeBoolean(this.versionTimestamps != null);
        LongPacker.packLong(out, this.lastKey == null ? 0L : (long)this.lastKey.length);
        if (this.lastKey != null) {
            out.write(this.lastKey);
        }
        for (int i = 0; i < this.sources.length; ++i) {
            out.writeObject(this.sources[i]);
        }
        out.writeObject(this.tupleSerializer);
        DataOutputBuffer dataOutputBuffer = buf = this.keys != null || this.vals != null ? new DataOutputBuffer() : null;
        if (this.keys != null && this.ntuples > 0) {
            buf.reset();
            slice = this.tupleSerializer.getLeafKeysCoder().encode(this.keys, buf);
            out.writeInt(slice.len());
            slice.writeOn(out);
        }
        if (this.vals != null && this.ntuples > 0) {
            buf.reset();
            slice = this.tupleSerializer.getLeafValuesCoder().encode(this.vals, buf);
            out.writeInt(slice.len());
            slice.writeOn(out);
        }
        if (this.deleteMarkers != null && this.ntuples > 0) {
            OutputBitStream obs = new OutputBitStream((OutputStream)((Object)out), 0, false);
            for (int i = 0; i < this.ntuples; ++i) {
                obs.writeBit(this.deleteMarkers[i] == 1);
            }
            obs.flush();
        }
        if (this.versionTimestamps != null) {
            out.writeLong(this.minimumVersionTimestamp);
            out.writeLong(this.maximumVersionTimestamp);
            for (int i = 0; i < this.ntuples; ++i) {
                out.writeLong(this.versionTimestamps[i]);
            }
        }
        if (this.sources.length > 1) {
            for (int i = 0; i < this.ntuples; ++i) {
                out.writeByte(this.sourceIndices[i]);
            }
        }
    }

    public ResultSet() {
    }

    protected ResultSet(IIndex ndx, int flags) {
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        this.sendKeys = (flags & 1) != 0;
        this.sendVals = (flags & 2) != 0;
        this.indexMetadata = ndx.getIndexMetadata();
        this.sources = ndx.getResourceMetadata();
        this.commitTime = ((ILocalBTreeView)ndx).getMutableBTree().getLastCommitTime();
    }

    public ResultSet(IIndex ndx, int capacity, int flags, ITupleIterator itr) {
        this(ndx, flags);
        this.init(capacity);
        ITuple tuple = null;
        while (!this.isFull() && itr.hasNext()) {
            tuple = itr.next();
            if (this.tupleSerializer == null) {
                this.tupleSerializer = tuple.getTupleSerializer();
            }
            this.copyTuple(tuple);
        }
        byte[] lastKey = tuple == null ? null : tuple.getKey();
        boolean exhausted = !itr.hasNext();
        this.done(exhausted, lastKey);
    }

    private boolean rangeCheckIndex(int index) {
        if (index < 0 || index >= this.ntuples) {
            throw new IndexOutOfBoundsException();
        }
        return true;
    }

    @Override
    public final boolean hasDeleteMarkers() {
        return this.deleteMarkers != null;
    }

    @Override
    public final boolean hasVersionTimestamps() {
        return this.versionTimestamps != null;
    }

    @Override
    public final long getVersionTimestamp(int index) {
        if (this.versionTimestamps == null) {
            throw new UnsupportedOperationException();
        }
        assert (this.rangeCheckIndex(index));
        return this.versionTimestamps[index];
    }

    @Override
    public final boolean getDeleteMarker(int index) {
        if (this.deleteMarkers == null) {
            throw new UnsupportedOperationException();
        }
        assert (this.rangeCheckIndex(index));
        return this.deleteMarkers[index] != 0;
    }

    @Override
    public final int getKeyCount() {
        return this.ntuples;
    }

    @Override
    public final int getValueCount() {
        return this.ntuples;
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public final boolean isCoded() {
        return false;
    }

    @Override
    public final AbstractFixedByteArrayBuffer data() {
        if (!this.isCoded()) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isDoubleLinked() {
        return false;
    }

    @Override
    public final long getNextAddr() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getPriorAddr() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getMinimumVersionTimestamp() {
        if (!this.hasVersionTimestamps()) {
            throw new UnsupportedOperationException();
        }
        return this.minimumVersionTimestamp;
    }

    @Override
    public final long getMaximumVersionTimestamp() {
        if (!this.hasVersionTimestamps()) {
            throw new UnsupportedOperationException();
        }
        return this.maximumVersionTimestamp;
    }

    @Override
    public final long getRawRecord(int index) {
        return 0L;
    }

    @Override
    public final boolean hasRawRecords() {
        return false;
    }
}

