/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IReadWriteLockManager;
import com.bigdata.journal.ICommitter;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadWriteLockManager
implements IReadWriteLockManager {
    private static final long LOCK_TIMEOUT_MILLIS = Long.MAX_VALUE;
    private final boolean readOnly;
    private final WrappedWriteLock writeLock;
    private final Lock readLock;
    private static final WeakHashMap<ICommitter, ReadWriteLockManager> locks = new WeakHashMap();
    private static final Lock READ_ONLY_LOCK = new ConcurrentReaderLock();

    @Override
    public int getReadLockCount() {
        if (this.readOnly) {
            return 0;
        }
        Integer readLockCounter = (Integer)((WrappedReadLock)this.readLock).threadLockMap.get(Thread.currentThread().getId());
        if (readLockCounter == null) {
            return 0;
        }
        return readLockCounter;
    }

    @Override
    public Lock readLock() {
        return this.readLock;
    }

    @Override
    public Lock writeLock() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Read-only");
        }
        return this.writeLock;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadWriteLockManager getLockManager(ICheckpointProtocol index) {
        if (index == null) {
            throw new IllegalArgumentException();
        }
        WeakHashMap<ICommitter, ReadWriteLockManager> weakHashMap = locks;
        synchronized (weakHashMap) {
            ReadWriteLockManager lockManager = locks.get(index);
            if (lockManager == null) {
                lockManager = new ReadWriteLockManager(index);
                locks.put(index, lockManager);
            }
            return lockManager;
        }
    }

    private ReadWriteLockManager(ICheckpointProtocol index) {
        this.readOnly = index.isReadOnly();
        if (this.readOnly) {
            this.readLock = READ_ONLY_LOCK;
            this.writeLock = null;
        } else {
            ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);
            this.readLock = new WrappedReadLock(readWriteLock.readLock());
            this.writeLock = new WrappedWriteLock(readWriteLock.writeLock());
        }
    }

    private static class ConcurrentReaderLock
    implements Lock {
        private ConcurrentReaderLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    private class WrappedWriteLock
    implements Lock {
        private final Lock delegate;

        WrappedWriteLock(Lock delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException();
            }
            this.delegate = delegate;
        }

        @Override
        public void lock() {
            try {
                this.lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (!this.delegate.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Timeout");
            }
        }

        @Override
        public boolean tryLock() {
            return this.delegate.tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.delegate.tryLock(time, unit);
        }

        @Override
        public void unlock() {
            this.delegate.unlock();
        }

        @Override
        public Condition newCondition() {
            return this.delegate.newCondition();
        }
    }

    private class WrappedReadLock
    implements Lock {
        private final Lock delegate;
        private final ConcurrentHashMap<Long, Integer> threadLockMap;

        private void readLockedThread() {
            long thisThreadId = Thread.currentThread().getId();
            Integer entry = this.threadLockMap.get(thisThreadId);
            Integer newVal = entry == null ? 1 : 1 + entry;
            this.threadLockMap.put(thisThreadId, newVal);
        }

        private void readUnlockedThread() {
            long thisThreadId = Thread.currentThread().getId();
            Integer entry = this.threadLockMap.get(thisThreadId);
            assert (entry != null);
            if (entry == 1) {
                this.threadLockMap.remove(thisThreadId);
            } else {
                this.threadLockMap.put(thisThreadId, entry - 1);
            }
        }

        WrappedReadLock(Lock delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException();
            }
            this.delegate = delegate;
            int initialCapacity = 4;
            int concurrencyLevel = 4;
            float loadFactor = 0.75f;
            this.threadLockMap = new ConcurrentHashMap(4, 0.75f, 4);
        }

        @Override
        public void lock() {
            try {
                this.lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            if (!this.delegate.tryLock(Long.MAX_VALUE, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Timeout");
            }
            this.readLockedThread();
        }

        @Override
        public boolean tryLock() {
            boolean ret = this.delegate.tryLock();
            if (ret) {
                this.readLockedThread();
            }
            return ret;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            boolean ret = this.delegate.tryLock(time, unit);
            if (ret) {
                this.readLockedThread();
            }
            return ret;
        }

        @Override
        public void unlock() {
            this.delegate.unlock();
            this.readUnlockedThread();
        }

        @Override
        public Condition newCondition() {
            return this.delegate.newCondition();
        }
    }
}

