/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.MutableKeyBuffer;
import com.bigdata.btree.raba.MutableValueBuffer;
import com.bigdata.io.AbstractFixedByteArrayBuffer;

public class MutableLeafData
implements ILeafData {
    final MutableKeyBuffer keys;
    final MutableValueBuffer vals;
    final boolean[] deleteMarkers;
    final long[] versionTimestamps;
    long minimumVersionTimestamp;
    long maximumVersionTimestamp;
    final boolean[] rawRecords;

    public MutableLeafData(int branchingFactor, boolean hasVersionTimestamps, boolean hasDeleteMarkers, boolean hasRawRecords) {
        this.keys = new MutableKeyBuffer(branchingFactor + 1);
        this.vals = new MutableValueBuffer(branchingFactor + 1);
        this.versionTimestamps = hasVersionTimestamps ? new long[branchingFactor + 1] : null;
        this.minimumVersionTimestamp = Long.MAX_VALUE;
        this.maximumVersionTimestamp = Long.MIN_VALUE;
        this.deleteMarkers = hasDeleteMarkers ? new boolean[branchingFactor + 1] : null;
        this.rawRecords = hasRawRecords ? new boolean[branchingFactor + 1] : null;
    }

    public MutableLeafData(int branchingFactor, ILeafData src) {
        int i;
        this.keys = new MutableKeyBuffer(branchingFactor + 1, src.getKeys());
        this.vals = new MutableValueBuffer(branchingFactor + 1, src.getValues());
        this.versionTimestamps = src.hasVersionTimestamps() ? new long[branchingFactor + 1] : null;
        this.deleteMarkers = src.hasDeleteMarkers() ? new boolean[branchingFactor + 1] : null;
        this.rawRecords = src.hasRawRecords() ? new boolean[branchingFactor + 1] : null;
        int nkeys = this.keys.size();
        if (this.versionTimestamps != null) {
            for (i = 0; i < nkeys; ++i) {
                this.versionTimestamps[i] = src.getVersionTimestamp(i);
            }
            this.minimumVersionTimestamp = src.getMinimumVersionTimestamp();
            this.maximumVersionTimestamp = src.getMaximumVersionTimestamp();
        } else {
            this.minimumVersionTimestamp = Long.MAX_VALUE;
            this.maximumVersionTimestamp = Long.MIN_VALUE;
        }
        if (this.deleteMarkers != null) {
            for (i = 0; i < nkeys; ++i) {
                this.deleteMarkers[i] = src.getDeleteMarker(i);
            }
        }
        if (this.rawRecords != null) {
            for (i = 0; i < nkeys; ++i) {
                this.rawRecords[i] = src.getRawRecord(i) != 0L;
            }
        }
    }

    MutableLeafData(MutableKeyBuffer keys, MutableValueBuffer values, long[] versionTimestamps, boolean[] deleteMarkers, boolean[] rawRecords) {
        assert (keys != null);
        assert (values != null);
        assert (keys.capacity() == values.capacity());
        if (versionTimestamps != null) assert (versionTimestamps.length == keys.capacity());
        if (deleteMarkers != null) assert (deleteMarkers.length == keys.capacity());
        if (rawRecords != null) assert (rawRecords.length == keys.capacity());
        this.keys = keys;
        this.vals = values;
        this.versionTimestamps = versionTimestamps;
        this.deleteMarkers = deleteMarkers;
        this.rawRecords = rawRecords;
        if (versionTimestamps != null) {
            this.recalcMinMaxVersionTimestamp();
        }
    }

    protected final boolean rangeCheckTupleIndex(int index) {
        if (index < 0 || index > this.getKeys().size()) {
            throw new IndexOutOfBoundsException();
        }
        return true;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final boolean isCoded() {
        return false;
    }

    @Override
    public final AbstractFixedByteArrayBuffer data() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getVersionTimestamp(int index) {
        if (this.versionTimestamps == null) {
            throw new UnsupportedOperationException();
        }
        assert (this.rangeCheckTupleIndex(index));
        return this.versionTimestamps[index];
    }

    @Override
    public final long getMinimumVersionTimestamp() {
        if (this.versionTimestamps == null) {
            throw new UnsupportedOperationException();
        }
        return this.minimumVersionTimestamp;
    }

    @Override
    public final long getMaximumVersionTimestamp() {
        if (this.versionTimestamps == null) {
            throw new UnsupportedOperationException();
        }
        return this.maximumVersionTimestamp;
    }

    @Override
    public final boolean getDeleteMarker(int index) {
        if (this.deleteMarkers == null) {
            throw new UnsupportedOperationException();
        }
        assert (this.rangeCheckTupleIndex(index));
        return this.deleteMarkers[index];
    }

    @Override
    public final long getRawRecord(int index) {
        if (this.rawRecords == null) {
            throw new UnsupportedOperationException();
        }
        assert (this.rangeCheckTupleIndex(index));
        if (!this.rawRecords[index]) {
            return 0L;
        }
        byte[] val = this.vals.get(index);
        long addr = AbstractBTree.decodeRecordAddr(val);
        return addr;
    }

    @Override
    public final IRaba getValues() {
        return this.vals;
    }

    @Override
    public final IRaba getKeys() {
        return this.keys;
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    @Override
    public final int getValueCount() {
        return this.vals.size();
    }

    @Override
    public final boolean hasRawRecords() {
        return this.rawRecords != null;
    }

    @Override
    public final boolean hasDeleteMarkers() {
        return this.deleteMarkers != null;
    }

    @Override
    public final boolean hasVersionTimestamps() {
        return this.versionTimestamps != null;
    }

    @Override
    public final int getKeyCount() {
        return this.keys.size();
    }

    @Override
    public final boolean isDoubleLinked() {
        return false;
    }

    @Override
    public final long getNextAddr() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getPriorAddr() {
        throw new UnsupportedOperationException();
    }

    void recalcMinMaxVersionTimestamp() {
        if (this.versionTimestamps == null) {
            throw new UnsupportedOperationException();
        }
        int nkeys = this.keys.nkeys;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (int i = 0; i < nkeys; ++i) {
            long t = this.versionTimestamps[i];
            if (t < min) {
                min = t;
            }
            if (t <= max) continue;
            max = t;
        }
        this.minimumVersionTimestamp = min;
        this.maximumVersionTimestamp = max;
    }
}

