/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.io.LongPacker;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class AsynchronousIndexWriteConfiguration
implements Externalizable {
    private static final long serialVersionUID = -5142532074728169578L;
    private int masterQueueCapacity;
    private int masterChunkSize;
    private long masterChunkTimeoutNanos;
    private long sinkIdleTimeoutNanos;
    private long sinkPollTimeoutNanos;
    private int sinkQueueCapacity;
    private int sinkChunkSize;
    private long sinkChunkTimeoutNanos;
    private static final transient int VERSION0 = 0;

    public int getMasterQueueCapacity() {
        return this.masterQueueCapacity;
    }

    public void setMasterQueueCapacity(int masterQueueCapacity) {
        this.masterQueueCapacity = masterQueueCapacity;
    }

    public int getMasterChunkSize() {
        return this.masterChunkSize;
    }

    public void setMasterChunkSize(int masterChunkSize) {
        this.masterChunkSize = masterChunkSize;
    }

    public long getMasterChunkTimeoutNanos() {
        return this.masterChunkTimeoutNanos;
    }

    public void setMasterChunkTimeoutNanos(long masterChunkTimeoutNanos) {
        this.masterChunkTimeoutNanos = masterChunkTimeoutNanos;
    }

    public long getSinkIdleTimeoutNanos() {
        return this.sinkIdleTimeoutNanos;
    }

    public void setSinkIdleTimeoutNanos(long sinkIdleTimeoutNanos) {
        this.sinkIdleTimeoutNanos = sinkIdleTimeoutNanos;
    }

    public long getSinkPollTimeoutNanos() {
        return this.sinkPollTimeoutNanos;
    }

    public void setSinkPollTimeoutNanos(long sinkPollTimeoutNanos) {
        this.sinkPollTimeoutNanos = sinkPollTimeoutNanos;
    }

    public int getSinkQueueCapacity() {
        return this.sinkQueueCapacity;
    }

    public void setSinkQueueCapacity(int sinkQueueCapacity) {
        this.sinkQueueCapacity = sinkQueueCapacity;
    }

    public int getSinkChunkSize() {
        return this.sinkChunkSize;
    }

    public void setSinkChunkSize(int sinkChunkSize) {
        this.sinkChunkSize = sinkChunkSize;
    }

    public long getSinkChunkTimeoutNanos() {
        return this.sinkChunkTimeoutNanos;
    }

    public void setSinkChunkTimeoutNanos(long sinkChunkTimeoutNanos) {
        this.sinkChunkTimeoutNanos = sinkChunkTimeoutNanos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{ masterQueueCapacity=" + this.masterQueueCapacity);
        sb.append(", masterChunkSize=" + this.masterChunkSize);
        sb.append(", masterChunkTimeoutNanos=" + this.masterChunkTimeoutNanos);
        sb.append(", sinkIdleTimeoutNanos=" + this.sinkIdleTimeoutNanos);
        sb.append(", sinkPollTimeoutNanos=" + this.sinkPollTimeoutNanos);
        sb.append(", sinkQueueCapacity=" + this.sinkQueueCapacity);
        sb.append(", sinkChunkSize=" + this.sinkChunkSize);
        sb.append(", sinkChunkTimeoutNanos=" + this.sinkChunkTimeoutNanos);
        sb.append("}");
        return sb.toString();
    }

    public AsynchronousIndexWriteConfiguration() {
    }

    public AsynchronousIndexWriteConfiguration(int masterQueueCapacity, int masterChunkSize, long masterChunkTimeoutNanos, long sinkIdleTimeoutNanos, long sinkPollTimeoutNanos, int sinkQueueCapacity, int sinkChunkSize, long sinkChunkTimeoutNanos) {
        if (masterQueueCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (masterChunkSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (masterChunkTimeoutNanos <= 0L) {
            throw new IllegalArgumentException();
        }
        if (sinkIdleTimeoutNanos <= 0L) {
            throw new IllegalArgumentException();
        }
        if (sinkPollTimeoutNanos <= 0L) {
            throw new IllegalArgumentException();
        }
        if (sinkQueueCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (sinkChunkTimeoutNanos <= 0L) {
            throw new IllegalArgumentException();
        }
        if (sinkIdleTimeoutNanos <= 0L) {
            throw new IllegalArgumentException();
        }
        this.masterQueueCapacity = masterQueueCapacity;
        this.masterChunkSize = masterChunkSize;
        this.masterChunkTimeoutNanos = masterChunkTimeoutNanos;
        this.sinkIdleTimeoutNanos = sinkIdleTimeoutNanos;
        this.sinkPollTimeoutNanos = sinkPollTimeoutNanos;
        this.sinkQueueCapacity = sinkQueueCapacity;
        this.sinkChunkSize = sinkChunkSize;
        this.sinkChunkTimeoutNanos = sinkChunkTimeoutNanos;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = (int)LongPacker.unpackLong(in);
        if (version != 0) {
            throw new IOException("Unknown version: " + version);
        }
        this.masterQueueCapacity = (int)LongPacker.unpackLong(in);
        this.masterChunkSize = (int)LongPacker.unpackLong(in);
        this.masterChunkTimeoutNanos = LongPacker.unpackLong(in);
        this.sinkIdleTimeoutNanos = LongPacker.unpackLong(in);
        this.sinkPollTimeoutNanos = LongPacker.unpackLong(in);
        this.sinkQueueCapacity = (int)LongPacker.unpackLong(in);
        this.sinkChunkSize = (int)LongPacker.unpackLong(in);
        this.sinkChunkTimeoutNanos = LongPacker.unpackLong(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        LongPacker.packLong(out, 0L);
        LongPacker.packLong(out, (long)this.masterQueueCapacity);
        LongPacker.packLong(out, (long)this.masterChunkSize);
        LongPacker.packLong(out, this.masterChunkTimeoutNanos);
        LongPacker.packLong(out, this.sinkIdleTimeoutNanos);
        LongPacker.packLong(out, this.sinkPollTimeoutNanos);
        LongPacker.packLong(out, (long)this.sinkQueueCapacity);
        LongPacker.packLong(out, (long)this.sinkChunkSize);
        LongPacker.packLong(out, this.sinkChunkTimeoutNanos);
    }
}

