/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.joinGraph;

import com.bigdata.bop.IPredicate;
import com.bigdata.bop.joinGraph.IRangeCountFactory;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.rule.eval.IJoinNexus;
import org.apache.log4j.Logger;

public class DefaultRangeCountFactory
implements IRangeCountFactory {
    protected static final transient Logger log = Logger.getLogger(DefaultRangeCountFactory.class);
    protected static final transient boolean DEBUG = log.isDebugEnabled();
    private final IJoinNexus joinNexus;

    public DefaultRangeCountFactory(IJoinNexus joinNexus) {
        if (joinNexus == null) {
            throw new IllegalArgumentException();
        }
        this.joinNexus = joinNexus;
    }

    @Override
    public long rangeCount(IPredicate predicate) {
        IRelation relation = this.joinNexus.getTailRelationView(predicate);
        IAccessPath accessPath = this.joinNexus.getTailAccessPath(relation, predicate);
        long rangeCount = accessPath.rangeCount(false);
        if (DEBUG) {
            log.debug((Object)("rangeCount=" + rangeCount + ", tail=" + predicate + ", accessPath=" + accessPath));
        }
        return rangeCount;
    }
}

