/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.AccessPathJoinAnnotations;
import com.bigdata.rdf.internal.impl.literal.XSDIntegerIV;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class FastRangeCountOp<E>
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public FastRangeCountOp(FastRangeCountOp<E> op) {
        super(op);
    }

    public FastRangeCountOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.getRequiredProperty(Annotations.COUNT_VAR);
        this.getRequiredProperty(Annotations.PREDICATE);
        if (this.isOptional()) {
            throw new UnsupportedOperationException();
        }
    }

    public FastRangeCountOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    protected IVariable<?> getCountVar() {
        return (IVariable)this.getRequiredProperty(Annotations.COUNT_VAR);
    }

    protected IVariable<?>[] getSelect() {
        return this.getProperty(Annotations.SELECT, null);
    }

    protected IConstraint[] constraints() {
        return this.getProperty(Annotations.CONSTRAINTS, null);
    }

    public IPredicate<E> getPredicate() {
        return (IPredicate)this.getRequiredProperty(Annotations.PREDICATE);
    }

    private boolean isOptional() {
        return this.getPredicate().isOptional();
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(this, context));
    }

    protected static class ChunkTask<E>
    implements Callable<Void> {
        protected final FastRangeCountOp<E> op;
        protected final BOpContext<IBindingSet> context;
        protected final IVariable<?> countVar;
        protected final IPredicate<E> predicate;
        protected final IRelation<E> relation;

        protected ChunkTask(FastRangeCountOp<E> op, BOpContext<IBindingSet> context) {
            this.op = op;
            this.context = context;
            this.countVar = op.getCountVar();
            this.predicate = op.getPredicate();
            this.relation = context.getRelation(this.predicate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BOpStats stats = this.context.getStats();
            IBindingSet[] leftSolutions = BOpUtility.toArray(this.context.getSource(), stats);
            IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
            UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(leftSolutions.length, sink);
            IVariable<?>[] selectVars = this.op.getSelect();
            IConstraint[] constraints = this.op.constraints();
            try {
                for (IBindingSet bindingSet : leftSolutions) {
                    IPredicate<E> asBound = this.predicate.asBound(bindingSet);
                    if (asBound == null) continue;
                    long rangeCount = this.determineRangeCount(asBound);
                    ListBindingSet right = new ListBindingSet();
                    right.set(this.countVar, new Constant(new XSDIntegerIV(BigInteger.valueOf(rangeCount))));
                    IBindingSet outSolution = BOpContext.bind(bindingSet, right, constraints, selectVars);
                    if (outSolution == null) continue;
                    unsyncBuffer.add(outSolution);
                }
                unsyncBuffer.flush();
                sink.flush();
                Void void_ = null;
                return void_;
            }
            finally {
                sink.close();
                this.context.getSource().close();
            }
        }

        protected long determineRangeCount(IPredicate<E> pred) {
            IAccessPath<E> accessPath = this.context.getAccessPath(this.relation, pred);
            if (accessPath.getPredicate().getIndexLocalFilter() != null) {
                throw new AssertionError();
            }
            if (accessPath.getPredicate().getAccessPathFilter() != null) {
                throw new AssertionError();
            }
            return accessPath.rangeCount(true);
        }
    }

    public static interface Annotations
    extends AccessPathJoinAnnotations {
        public static final String COUNT_VAR = FastRangeCountOp.class.getName() + ".countVar";
    }
}

