/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.BOpContextBase;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.ContextBindingSet;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IElement;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IQueryAttributes;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NamedSolutionSetRefUtility;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.join.BaseJoinStats;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.btree.ISimpleIndexAccess;
import com.bigdata.journal.IBTreeManager;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.sparql.ast.ssets.SolutionSetManager;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.rwstore.sector.IMemoryManager;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.striterator.ChunkedFilter;
import com.bigdata.striterator.ChunkedStriterator;
import com.bigdata.striterator.Chunkerator;
import com.bigdata.striterator.CloseableChunkedIteratorWrapperConverter;
import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IChunkedStriterator;
import com.bigdata.striterator.Resolver;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.eclipse.jetty.client.HttpClient;

public class BOpContext<E>
extends BOpContextBase {
    private final IRunningQuery runningQuery;
    private final int partitionId;
    private final BOpStats stats;
    private final ICloseableIterator<E[]> source;
    private final IBlockingBuffer<E[]> sink;
    private final IBlockingBuffer<E[]> sink2;
    private final PipelineOp op;
    private final boolean lastInvocation;

    public boolean isLastInvocation() {
        return this.lastInvocation;
    }

    public IRunningQuery getRunningQuery() {
        return this.runningQuery;
    }

    public final int getPartitionId() {
        return this.partitionId;
    }

    public final BOpStats getStats() {
        return this.stats;
    }

    public PipelineOp getOperator() {
        return this.op;
    }

    public final ICloseableIterator<E[]> getSource() {
        return this.source;
    }

    public final IBlockingBuffer<E[]> getSink() {
        return this.sink;
    }

    public final IBlockingBuffer<E[]> getSink2() {
        return this.sink2;
    }

    public BOpContext(IRunningQuery runningQuery, int partitionId, BOpStats stats, PipelineOp op, boolean lastInvocation, ICloseableIterator<E[]> source, IBlockingBuffer<E[]> sink, IBlockingBuffer<E[]> sink2) {
        this(runningQuery, runningQuery.getFederation(), runningQuery.getLocalIndexManager(), partitionId, stats, op, lastInvocation, source, sink, sink2);
    }

    BOpContext(IRunningQuery runningQuery, IBigdataFederation<?> fed, IIndexManager localIndexManager, int partitionId, BOpStats stats, PipelineOp op, boolean lastInvocation, ICloseableIterator<E[]> source, IBlockingBuffer<E[]> sink, IBlockingBuffer<E[]> sink2) {
        super(fed, localIndexManager);
        if (stats == null) {
            throw new IllegalArgumentException();
        }
        if (op == null) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (sink == null) {
            throw new IllegalArgumentException();
        }
        this.runningQuery = runningQuery;
        this.partitionId = partitionId;
        this.stats = stats;
        this.op = op;
        this.lastInvocation = lastInvocation;
        this.source = new SetContextIterator(this, source);
        this.sink = sink;
        this.sink2 = sink2;
    }

    public static <E> BOpContext<E> newMock(IRunningQuery runningQuery, IBigdataFederation<?> fed, IIndexManager localIndexManager, int partitionId, BOpStats stats, PipelineOp op, boolean lastInvocation, ICloseableIterator<E[]> source, IBlockingBuffer<E[]> sink, IBlockingBuffer<E[]> sink2) {
        return new BOpContext<E>(runningQuery, fed, localIndexManager, partitionId, stats, op, lastInvocation, source, sink, sink2);
    }

    public IRunningQuery getRunningQuery(UUID queryId) {
        IRunningQuery runningQuery;
        try {
            runningQuery = queryId.equals(this.runningQuery.getQueryId()) ? this.runningQuery : this.getRunningQuery().getQueryEngine().getRunningQuery(queryId);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Query halted? : " + ex, ex);
        }
        if (runningQuery == null) {
            throw new RuntimeException("IRunningQuery not found.");
        }
        return runningQuery;
    }

    public IQueryAttributes getQueryAttributes(UUID queryId) {
        if (queryId == null) {
            return this.getRunningQuery().getAttributes();
        }
        return this.getRunningQuery(queryId).getAttributes();
    }

    public IQueryAttributes getQueryAttributes() {
        return this.getRunningQuery().getAttributes();
    }

    public ICloseableIterator<IBindingSet[]> getAlternateSource(INamedSolutionSetRef namedSetRef) {
        String localName = namedSetRef.getLocalName();
        UUID queryId = namedSetRef.getQueryId();
        if (queryId != null) {
            Object src;
            IQueryAttributes queryAttributes = this.getQueryAttributes(queryId);
            Object tmp = queryAttributes.get(namedSetRef);
            if (tmp == null) {
                throw new RuntimeException("Not found: name=" + localName + ", namedSetRef=" + namedSetRef);
            }
            if (tmp instanceof IHashJoinUtility) {
                IHashJoinUtility state = (IHashJoinUtility)tmp;
                src = state.indexScan();
            } else if (tmp instanceof ISimpleIndexAccess) {
                src = ((ISimpleIndexAccess)tmp).scan();
            } else {
                throw new UnsupportedOperationException("namedSetRef=" + namedSetRef + ", class=" + tmp.getClass());
            }
            return new Chunkerator<IBindingSet>((Iterator<IBindingSet>)src, this.op.getChunkCapacity(), IBindingSet.class);
        }
        String namespace = namedSetRef.getNamespace();
        long timestamp = namedSetRef.getTimestamp();
        IBTreeManager localIndexManager = (IBTreeManager)this.getIndexManager();
        SolutionSetManager sparqlCache = new SolutionSetManager(localIndexManager, namespace, timestamp);
        return NamedSolutionSetRefUtility.getSolutionSet(sparqlCache, localIndexManager, namespace, timestamp, localName, namedSetRef.getJoinVars(), this.op.getChunkCapacity());
    }

    public IMemoryManager getMemoryManager(UUID queryId) {
        if (queryId == null) {
            return this.getRunningQuery().getMemoryManager();
        }
        return this.getRunningQuery(queryId).getMemoryManager();
    }

    public HttpClient getClientConnectionManager() {
        return this.getRunningQuery().getQueryEngine().getClientConnectionManager();
    }

    @Deprecated
    public static final boolean bind(IPredicate<?> pred, IConstraint[] constraints, Object e, IBindingSet bindings) {
        BOpContext.copyValues((IElement)e, pred, bindings);
        if (constraints != null) {
            return BOpUtility.isConsistent(constraints, bindings);
        }
        return true;
    }

    public static void copyValues(IElement e, IPredicate<?> pred, IBindingSet bindingSet) {
        SPOPredicate tmp;
        IVariable<IV> sidVar;
        int arity = pred.arity();
        for (int i = 0; i < arity; ++i) {
            Object val;
            IVariable var;
            IVariableOrConstant t = pred.get(i);
            if (t.isVar()) {
                var = (IVariable)t;
                val = e.get(i);
                if (val == null) continue;
                bindingSet.set(var, new Constant<Object>(val));
                continue;
            }
            var = (IVariable)t.getProperty(Constant.Annotations.VAR);
            if (var == null || (val = e.get(i)) == null) continue;
            bindingSet.set(var, new Constant<Object>(val));
        }
        if (pred instanceof SPOPredicate && (sidVar = (tmp = (SPOPredicate)pred).sid()) != null) {
            IV s = (IV)e.get(0);
            IV p = (IV)e.get(1);
            IV o = (IV)e.get(2);
            SPO spo = new SPO(s, p, o);
            SidIV sidIV = new SidIV(spo);
            bindingSet.set(sidVar, new Constant(sidIV));
        }
    }

    public static IBindingSet bind(IBindingSet left, IBindingSet right, IConstraint[] constraints, IVariable[] varsToKeep) {
        IVariable var;
        if (constraints == null && varsToKeep == null) {
            if (left.isEmpty()) {
                return right;
            }
            if (right.isEmpty()) {
                return left;
            }
        }
        IBindingSet src = right;
        IBindingSet dst = left.clone();
        for (Map.Entry e : src) {
            var = (IVariable)e.getKey();
            IConstant sval = (IConstant)e.getValue();
            if (sval == null) continue;
            IConstant dval = dst.get(var);
            if (dval != null) {
                if (!sval.equals(dval)) {
                    return null;
                }
                if (!(sval.get() instanceof IV)) continue;
                IV siv = (IV)sval.get();
                IV div = (IV)dval.get();
                if (!siv.hasValue() || div.hasValue()) continue;
                div.setValue(siv.getValue());
                continue;
            }
            dst.set(var, sval);
        }
        if (constraints != null && !BOpUtility.isConsistent(constraints, dst)) {
            return null;
        }
        if (varsToKeep != null && varsToKeep.length > 0) {
            Iterator itr = dst.iterator();
            while (itr.hasNext()) {
                Map.Entry e;
                e = (Map.Entry)itr.next();
                var = (IVariable)e.getKey();
                boolean found = false;
                for (int i = 0; i < varsToKeep.length; ++i) {
                    if (var != varsToKeep[i]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                itr.remove();
            }
        }
        return dst;
    }

    public ICloseableIterator<IBindingSet[]> solutions(IChunkedIterator<?> src, final IPredicate<?> pred, final BaseJoinStats stats) {
        IChunkedStriterator itr1 = new ChunkedStriterator(src).addFilter(new ChunkedFilter<IChunkedIterator<Object>, Object, Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Object[] filterChunk(Object[] chunk) {
                stats.accessPathChunksIn.increment();
                stats.accessPathUnitsIn.add(chunk.length);
                return chunk;
            }
        }).addFilter(new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object obj) {
                IElement e = (IElement)obj;
                ContextBindingSet bset = new ContextBindingSet(BOpContext.this, new ListBindingSet());
                BOpContext.copyValues(e, pred, bset);
                return bset;
            }
        });
        CloseableChunkedIteratorWrapperConverter itr2 = new CloseableChunkedIteratorWrapperConverter(itr1);
        return itr2;
    }

    private static class SetContextIterator
    implements ICloseableIterator<IBindingSet[]> {
        private final BOpContext<?> context;
        private final ICloseableIterator<IBindingSet[]> src;
        private IBindingSet[] cur = null;
        private boolean open = true;

        public SetContextIterator(BOpContext<?> context, ICloseableIterator<IBindingSet[]> src) {
            this.src = src;
            this.context = context;
        }

        public void close() {
            if (this.open) {
                this.src.close();
                this.open = false;
            }
        }

        public boolean hasNext() {
            if (!this.open) {
                return false;
            }
            if (this.cur != null) {
                return true;
            }
            if (!this.src.hasNext()) {
                this.close();
                return false;
            }
            IBindingSet[] nxt = (IBindingSet[])this.src.next();
            this.cur = nxt.getClass().getComponentType() == IBindingSet.class ? nxt : new IBindingSet[nxt.length];
            for (int i = 0; i < nxt.length; ++i) {
                IBindingSet bset = nxt[i];
                this.cur[i] = bset instanceof ContextBindingSet ? bset : new ContextBindingSet(this.context, bset);
            }
            return true;
        }

        public IBindingSet[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IBindingSet[] ret = this.cur;
            this.cur = null;
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

