/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.bfs.Document;
import com.bigdata.bfs.DocumentHeader;
import com.bigdata.bfs.FileMetadataSchema;
import com.bigdata.sparse.ITPS;
import com.bigdata.sparse.ITPV;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class RepositoryDocumentImpl
implements DocumentHeader,
Document {
    private final BigdataFileSystem repo;
    private final String id;
    final ITPS tps;
    final int version;
    private final Map<String, Object> metadata;

    public RepositoryDocumentImpl(BigdataFileSystem repo, String id, ITPS tps) {
        if (repo == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.repo = repo;
        this.id = id;
        this.tps = tps;
        if (tps != null) {
            ITPV tmp = tps.get(FileMetadataSchema.VERSION);
            if (tmp.getValue() != null) {
                this.version = (Integer)tmp.getValue();
                this.metadata = tps.asMap();
                BigdataFileSystem.log.info((Object)("id=" + id + ", current version=" + this.version));
            } else {
                this.version = -1;
                this.metadata = null;
                BigdataFileSystem.log.warn((Object)("id=" + id + " : no current version"));
            }
        } else {
            this.version = -1;
            this.metadata = null;
            BigdataFileSystem.log.warn((Object)("id=" + id + " : no record of any version(s)"));
        }
        if (BigdataFileSystem.DEBUG && this.metadata != null) {
            for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
                BigdataFileSystem.log.debug((Object)("id=" + id + ", version=" + this.getVersion() + ", [" + entry.getKey() + "]=[" + entry.getValue() + "]"));
            }
        }
    }

    public RepositoryDocumentImpl(BigdataFileSystem repo, String id) {
        this(repo, id, repo.getFileMetadataIndex().read(BigdataFileSystem.metadataSchema, id, 1L, Long.MIN_VALUE, null));
    }

    protected final void assertExists() {
        if (this.version == -1) {
            throw new IllegalStateException("No current version: id=" + this.id);
        }
    }

    @Override
    public final boolean exists() {
        return this.version != -1;
    }

    @Override
    public final int getVersion() {
        this.assertExists();
        return (Integer)this.metadata.get(FileMetadataSchema.VERSION);
    }

    @Override
    public final long getEarliestVersionCreateTime() {
        this.assertExists();
        Iterator<ITPV> itr = this.tps.iterator();
        while (itr.hasNext()) {
            ITPV tpv = itr.next();
            if (!tpv.getName().equals(FileMetadataSchema.ID)) continue;
            return tpv.getTimestamp();
        }
        throw new AssertionError();
    }

    @Override
    public final long getVersionCreateTime() {
        this.assertExists();
        long createTime = this.tps.get(FileMetadataSchema.VERSION).getTimestamp();
        return createTime;
    }

    @Override
    public final long getMetadataUpdateTime() {
        this.assertExists();
        long metadataUpdateTime = this.tps.get(FileMetadataSchema.ID).getTimestamp();
        return metadataUpdateTime;
    }

    public final ITPV[] getAllVersionInfo() {
        return this.repo.getAllVersionInfo(this.id);
    }

    @Override
    public final InputStream getInputStream() {
        this.assertExists();
        return this.repo.inputStream(this.id, this.getVersion());
    }

    @Override
    public final Reader getReader() throws UnsupportedEncodingException {
        this.assertExists();
        return this.repo.reader(this.id, this.getVersion(), this.getContentEncoding());
    }

    @Override
    public final String getContentEncoding() {
        this.assertExists();
        return (String)this.metadata.get(FileMetadataSchema.CONTENT_ENCODING);
    }

    @Override
    public final String getContentType() {
        this.assertExists();
        return (String)this.metadata.get(FileMetadataSchema.CONTENT_TYPE);
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final Object getProperty(String name) {
        return this.metadata.get(name);
    }

    @Override
    public final Map<String, Object> asMap() {
        this.assertExists();
        return Collections.unmodifiableMap(this.metadata);
    }
}

