# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['valo_api', 'valo_api.endpoints', 'valo_api.responses', 'valo_api.utils']

package_data = \
{'': ['*']}

install_requires = \
['rich>=10.14.0,<11.0.0']

entry_points = \
{'console_scripts': ['valorant_api = valorant_api.__main__:app']}

setup_kwargs = {
    'name': 'valo-api',
    'version': '0.1.0',
    'description': 'Valorant API Wrapper for https://github.com/Henrik-3/unofficial-valorant-api',
    'long_description': '# valorant_api\n\n<div align="center">\n\n[![Build status](https://github.com/raimannma/ValorantAPI/workflows/build/badge.svg?branch=master&event=push)](https://github.com/raimannma/ValorantAPI/actions?query=workflow%3Abuild)\n[![Python Version](https://img.shields.io/pypi/pyversions/valorant_api.svg)](https://pypi.org/project/valorant_api/)\n[![Dependencies Status](https://img.shields.io/badge/dependencies-up%20to%20date-brightgreen.svg)](https://github.com/raimannma/ValorantAPI/pulls?utf8=%E2%9C%93&q=is%3Apr%20author%3Aapp%2Fdependabot)\n\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Security: bandit](https://img.shields.io/badge/security-bandit-green.svg)](https://github.com/PyCQA/bandit)\n[![Pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/raimannma/ValorantAPI/blob/master/.pre-commit-config.yaml)\n[![Semantic Versions](https://img.shields.io/badge/%20%20%F0%9F%93%A6%F0%9F%9A%80-semantic--versions-e10079.svg)](https://github.com/raimannma/ValorantAPI/releases)\n[![License](https://img.shields.io/github/license/raimannma/ValorantAPI)](https://github.com/raimannma/ValorantAPI/blob/master/LICENSE)\n![Coverage Report](assets/images/coverage.svg)\n\nValorant API Wrapper for https://github.com/Henrik-3/unofficial-valorant-api\n\n</div>\n',
    'author': 'Manuel Raimann',
    'author_email': 'raimannma@outlook.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/raimannma/ValorantAPI',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
