"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttiniRunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const index_1 = require("./index");
class AttiniRunner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let copy = { ...props };
        if (props.awsVpcConfiguration?.subnets) {
            copy.awsVpcConfiguration.subnets = props.awsVpcConfiguration.subnets.join(',');
        }
        if (props.awsVpcConfiguration?.securityGroups) {
            copy.awsVpcConfiguration.securityGroups = props.awsVpcConfiguration.securityGroups.join(',');
        }
        if (props.awsVpcConfiguration?.assignPublicIp) {
            copy.awsVpcConfiguration.assignPublicIp = props.awsVpcConfiguration?.assignPublicIp ? 'ENABLED' : 'DISABLED';
        }
        if (props.awsVpcConfiguration) {
            copy.awsVpcConfiguration = index_1.PropsUtil.fixCase(copy.awsVpcConfiguration);
        }
        if (props.runnerConfiguration) {
            copy.runnerConfiguration = index_1.PropsUtil.fixCase(copy.runnerConfiguration);
        }
        if (props.startup) {
            copy.startup = index_1.PropsUtil.fixCase(props.startup);
        }
        let cfnResource = new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::Runner',
            properties: index_1.PropsUtil.fixCase(copy),
        });
        this.runnerName = cfnResource.logicalId;
    }
}
exports.AttiniRunner = AttiniRunner;
_a = JSII_RTTI_SYMBOL_1;
AttiniRunner[_a] = { fqn: "@attini/cdk.AttiniRunner", version: "0.0.37" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXR0aW5pLXJ1bm5lci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9hdHRpbmktcnVubmVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQTBDO0FBQzFDLDJDQUF1QztBQUN2QyxtQ0FBb0M7QUEyQ3BDLE1BQWEsWUFBYSxTQUFRLHNCQUFTO0lBSXpDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBd0I7UUFDaEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNqQixJQUFJLElBQUksR0FBUSxFQUFFLEdBQUcsS0FBSyxFQUFFLENBQUM7UUFHN0IsSUFBSSxLQUFLLENBQUMsbUJBQW1CLEVBQUUsT0FBTyxFQUFFO1lBQ3RDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7U0FDaEY7UUFDRCxJQUFJLEtBQUssQ0FBQyxtQkFBbUIsRUFBRSxjQUFjLEVBQUU7WUFDN0MsSUFBSSxDQUFDLG1CQUFtQixDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsbUJBQW1CLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztTQUM5RjtRQUNELElBQUksS0FBSyxDQUFDLG1CQUFtQixFQUFFLGNBQWMsRUFBRTtZQUM3QyxJQUFJLENBQUMsbUJBQW1CLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxtQkFBbUIsRUFBRSxjQUFjLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQSxDQUFDLENBQUMsVUFBVSxDQUFDO1NBQzdHO1FBRUQsSUFBSSxLQUFLLENBQUMsbUJBQW1CLEVBQUU7WUFDN0IsSUFBSSxDQUFDLG1CQUFtQixHQUFHLGlCQUFTLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO1NBQ3hFO1FBRUQsSUFBSSxLQUFLLENBQUMsbUJBQW1CLEVBQUU7WUFDN0IsSUFBSSxDQUFDLG1CQUFtQixHQUFHLGlCQUFTLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO1NBQ3hFO1FBRUQsSUFBSSxLQUFLLENBQUMsT0FBTyxFQUFFO1lBQ2pCLElBQUksQ0FBQyxPQUFPLEdBQUcsaUJBQVMsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1NBQ2pEO1FBR0QsSUFBSSxXQUFXLEdBQUcsSUFBSSx5QkFBVyxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUU7WUFDMUMsSUFBSSxFQUFFLHdCQUF3QjtZQUM5QixVQUFVLEVBQUUsaUJBQVMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDO1NBQ3BDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxVQUFVLEdBQUcsV0FBVyxDQUFDLFNBQVMsQ0FBQztJQUMxQyxDQUFDOztBQXRDSCxvQ0F1Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgUHJvcHNVdGlsIH0gZnJvbSAnLi9pbmRleCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXR0aW5pUnVubmVyUHJvcHMge1xuICByZWFkb25seSB0YXNrRGVmaW5pdGlvbkFybj86IHN0cmluZztcbiAgcmVhZG9ubHkgY29udGFpbmVyTmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgZWNzQ2x1c3Rlcj86IHN0cmluZztcbiAgcmVhZG9ubHkgcm9sZUFybj86IHN0cmluZztcbiAgcmVhZG9ubHkgaW1hZ2U/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJ1bm5lckNvbmZpZ3VyYXRpb24/OiBSdW5uZXJDb25maWd1cmF0aW9uO1xuICByZWFkb25seSBhd3NWcGNDb25maWd1cmF0aW9uPzogQXdzVnBjQ29uZmlndXJhdGlvbjtcbiAgcmVhZG9ubHkgc3RhcnR1cD86IFN0YXJ0dXA7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUnVubmVyQ29uZmlndXJhdGlvbiB7XG4gIC8qKlxuICAgKiBUaGUgbWF4IGFtb3VudCBvZiBjb25jdXJyZW50IGpvYnMgdGhlIEF0dGluaSBSdW5uZXIgd2lsbCBleGVjdXRlLlxuICAgKi9cbiAgcmVhZG9ubHkgbWF4Q29uY3VycmVudEpvYnM/OiBudW1iZXI7XG4gIC8qKlxuICAgKlRoZSBudW1iZXIgb2Ygc2Vjb25kcyB0aGUgQXR0aW5pIFJ1bm5lciB3aWxsIHN0YXkgYWxpdmUgd2l0aG91dCBhbnkgam9icyBleGVjdXRpbmcuIE5ldyBqb2JzIHdpbGwgcmVzZXQgdGhlIGNvdW50ZG93bi5cbiAgICovXG4gIHJlYWRvbmx5IGlkbGVUaW1lVG9MaXZlPzogbnVtYmVyO1xuICAvKipcbiAgICogVGhlIG51bWJlciBvZiBzZWNvbmRzIGEgam9iIGNhbiBleGVjdXRlIGJlZm9yZSB0aGUgQXR0aW5pIFJ1bm5lciBhYm9ydHMgdGhlIGV4ZWN1dGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IGpvYlRpbWVvdXQ/OiBudW1iZXI7XG4gIC8qKlxuICAgKiBUaGUgbG9nIGxldmVsIG9mIHRoZSBBdHRpbmkgUnVubmVyLlxuICAgKi9cbiAgcmVhZG9ubHkgbG9nTGV2ZWw/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXdzVnBjQ29uZmlndXJhdGlvbiB7XG4gIHJlYWRvbmx5IHN1Ym5ldHM/OiBBcnJheTxzdHJpbmc+O1xuICByZWFkb25seSBzZWN1cml0eUdyb3Vwcz86IEFycmF5PHN0cmluZz47XG4gIHJlYWRvbmx5IGFzc2lnblB1YmxpY0lwPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBTdGFydHVwIHtcbiAgcmVhZG9ubHkgY29tbWFuZHM/OiBBcnJheTxzdHJpbmc+O1xuICByZWFkb25seSBjb21tYW5kc1RpbWVvdXQ/OiBudW1iZXI7XG59XG5cbmV4cG9ydCBjbGFzcyBBdHRpbmlSdW5uZXIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuXG4gIHJlYWRvbmx5IHJ1bm5lck5hbWU6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQXR0aW5pUnVubmVyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIGxldCBjb3B5OiBhbnkgPSB7IC4uLnByb3BzIH07XG5cblxuICAgIGlmIChwcm9wcy5hd3NWcGNDb25maWd1cmF0aW9uPy5zdWJuZXRzKSB7XG4gICAgICBjb3B5LmF3c1ZwY0NvbmZpZ3VyYXRpb24uc3VibmV0cyA9IHByb3BzLmF3c1ZwY0NvbmZpZ3VyYXRpb24uc3VibmV0cy5qb2luKCcsJyk7XG4gICAgfVxuICAgIGlmIChwcm9wcy5hd3NWcGNDb25maWd1cmF0aW9uPy5zZWN1cml0eUdyb3Vwcykge1xuICAgICAgY29weS5hd3NWcGNDb25maWd1cmF0aW9uLnNlY3VyaXR5R3JvdXBzID0gcHJvcHMuYXdzVnBjQ29uZmlndXJhdGlvbi5zZWN1cml0eUdyb3Vwcy5qb2luKCcsJyk7XG4gICAgfVxuICAgIGlmIChwcm9wcy5hd3NWcGNDb25maWd1cmF0aW9uPy5hc3NpZ25QdWJsaWNJcCkge1xuICAgICAgY29weS5hd3NWcGNDb25maWd1cmF0aW9uLmFzc2lnblB1YmxpY0lwID0gcHJvcHMuYXdzVnBjQ29uZmlndXJhdGlvbj8uYXNzaWduUHVibGljSXAgPyAnRU5BQkxFRCc6ICdESVNBQkxFRCc7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLmF3c1ZwY0NvbmZpZ3VyYXRpb24pIHtcbiAgICAgIGNvcHkuYXdzVnBjQ29uZmlndXJhdGlvbiA9IFByb3BzVXRpbC5maXhDYXNlKGNvcHkuYXdzVnBjQ29uZmlndXJhdGlvbik7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLnJ1bm5lckNvbmZpZ3VyYXRpb24pIHtcbiAgICAgIGNvcHkucnVubmVyQ29uZmlndXJhdGlvbiA9IFByb3BzVXRpbC5maXhDYXNlKGNvcHkucnVubmVyQ29uZmlndXJhdGlvbik7XG4gICAgfVxuXG4gICAgaWYgKHByb3BzLnN0YXJ0dXApIHtcbiAgICAgIGNvcHkuc3RhcnR1cCA9IFByb3BzVXRpbC5maXhDYXNlKHByb3BzLnN0YXJ0dXApO1xuICAgIH1cblxuXG4gICAgbGV0IGNmblJlc291cmNlID0gbmV3IENmblJlc291cmNlKHRoaXMsIGlkLCB7XG4gICAgICB0eXBlOiAnQXR0aW5pOjpEZXBsb3k6OlJ1bm5lcicsXG4gICAgICBwcm9wZXJ0aWVzOiBQcm9wc1V0aWwuZml4Q2FzZShjb3B5KSxcbiAgICB9KTtcblxuICAgIHRoaXMucnVubmVyTmFtZSA9IGNmblJlc291cmNlLmxvZ2ljYWxJZDtcbiAgfVxufVxuIl19