import { Construct } from 'constructs';
export interface AttiniRunnerProps {
    readonly taskDefinitionArn?: string;
    readonly containerName?: string;
    readonly ecsCluster?: string;
    readonly roleArn?: string;
    readonly image?: string;
    readonly runnerConfiguration?: RunnerConfiguration;
    readonly awsVpcConfiguration?: AwsVpcConfiguration;
    readonly startup?: Startup;
}
export interface RunnerConfiguration {
    /**
     * The max amount of concurrent jobs the Attini Runner will execute.
     */
    readonly maxConcurrentJobs?: number;
    /**
     *The number of seconds the Attini Runner will stay alive without any jobs executing. New jobs will reset the countdown.
     */
    readonly idleTimeToLive?: number;
    /**
     * The number of seconds a job can execute before the Attini Runner aborts the execution.
     */
    readonly jobTimeout?: number;
    /**
     * The log level of the Attini Runner.
     */
    readonly logLevel?: string;
}
export interface AwsVpcConfiguration {
    readonly subnets?: Array<string>;
    readonly securityGroups?: Array<string>;
    readonly assignPublicIp?: boolean;
}
export interface Startup {
    readonly commands?: Array<string>;
    readonly commandsTimeout?: number;
}
export declare class AttiniRunner extends Construct {
    readonly runnerName: string;
    constructor(scope: Construct, id: string, props: AttiniRunnerProps);
}
