import { LambdaInvocationType } from 'aws-cdk-lib/aws-stepfunctions-tasks/lib/lambda/invoke';
import { Construct } from 'constructs';
import { AttiniState } from './attini-state';
export interface AttiniLambdaInvokeProps {
    /**
     * Lambda function to invoke.
     *
     */
    readonly functionName: string;
    /**
     * The JSON that will be supplied as input to the Lambda function.
     *
     */
    readonly payload?: object;
    /**
     * Invocation type of the Lambda function.
     */
    readonly invocationType?: LambdaInvocationType;
    /**
     * Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function.
     *
     */
    readonly clientContext?: string;
    /**
     * Version or alias to invoke a published version of the function.
     *
     */
    readonly qualifier?: string;
}
export declare class AttiniLambdaInvoke extends AttiniState {
    private props;
    type: string;
    constructor(scope: Construct, id: string, props: AttiniLambdaInvokeProps);
    protected renderProps(): object;
}
