/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
  "/": {
    /** Get Hypermedia links to resources accessible in GitHub's REST API */
    get: operations["meta/root"];
  };
  "/app": {
    /**
     * Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/rest/reference/apps#list-installations-for-the-authenticated-app)" endpoint.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-authenticated"];
  };
  "/app-manifests/{code}/conversions": {
    /** Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`. */
    post: operations["apps/create-from-manifest"];
  };
  "/app/hook/config": {
    /**
     * Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-webhook-config-for-app"];
    /**
     * Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    patch: operations["apps/update-webhook-config-for-app"];
  };
  "/app/hook/deliveries": {
    /**
     * Returns a list of webhook deliveries for the webhook configured for a GitHub App.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/list-webhook-deliveries"];
  };
  "/app/hook/deliveries/{delivery_id}": {
    /**
     * Returns a delivery for the webhook configured for a GitHub App.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-webhook-delivery"];
  };
  "/app/hook/deliveries/{delivery_id}/attempts": {
    /**
     * Redeliver a delivery for the webhook configured for a GitHub App.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    post: operations["apps/redeliver-webhook-delivery"];
  };
  "/app/installations": {
    /**
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     *
     * The permissions the installation has are included under the `permissions` key.
     */
    get: operations["apps/list-installations"];
  };
  "/app/installations/{installation_id}": {
    /**
     * Enables an authenticated GitHub App to find an installation's information using the installation id.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-installation"];
    /**
     * Uninstalls a GitHub App on a user, organization, or business account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/rest/reference/apps/#suspend-an-app-installation)" endpoint.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    delete: operations["apps/delete-installation"];
  };
  "/app/installations/{installation_id}/access_tokens": {
    /**
     * Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access. To restrict the access to specific repositories, you can provide the `repository_ids` when creating the token. When you omit `repository_ids`, the response does not contain the `repositories` key.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    post: operations["apps/create-installation-access-token"];
  };
  "/app/installations/{installation_id}/suspended": {
    /**
     * Suspends a GitHub App on a user, organization, or business account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub API or webhook events is blocked for that account.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    put: operations["apps/suspend-installation"];
    /**
     * Removes a GitHub App installation suspension.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    delete: operations["apps/unsuspend-installation"];
  };
  "/applications/grants": {
    /**
     * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * You can use this API to list the set of OAuth applications that have been granted access to your account. Unlike the [list your authorizations](https://docs.github.com/rest/reference/oauth-authorizations#list-your-authorizations) API, this API does not manage individual tokens. This API will return one entry for each OAuth application that has been granted access to your account, regardless of the number of tokens an application has generated for your user. The list of OAuth applications returned matches what is shown on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized). The `scopes` returned are the union of scopes authorized for the application. For example, if an application has one token with `repo` scope and another token with `user` scope, the grant will return `["repo", "user"]`.
     */
    get: operations["oauth-authorizations/list-grants"];
  };
  "/applications/grants/{grant_id}": {
    /** **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
    get: operations["oauth-authorizations/get-grant"];
    /**
     * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for your user. Once deleted, the application has no access to your account and is no longer listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
     */
    delete: operations["oauth-authorizations/delete-grant"];
  };
  "/applications/{client_id}/grant": {
    /**
     * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
     * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
     */
    delete: operations["apps/delete-authorization"];
  };
  "/applications/{client_id}/token": {
    /** OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) to use this endpoint, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`. */
    post: operations["apps/check-token"];
    /** OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. */
    delete: operations["apps/delete-token"];
    /** OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`. */
    patch: operations["apps/reset-token"];
  };
  "/applications/{client_id}/token/scoped": {
    /** Use a non-scoped user-to-server OAuth access token to create a repository scoped and/or permission scoped user-to-server OAuth access token. You can specify which repositories the token can access and which permissions are granted to the token. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`. */
    post: operations["apps/scope-token"];
  };
  "/apps/{app_slug}": {
    /**
     * **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
     *
     * If the GitHub App you specify is public, you can access this endpoint without authenticating. If the GitHub App you specify is private, you must authenticate with a [personal access token](https://docs.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    get: operations["apps/get-by-slug"];
  };
  "/authorizations": {
    /** **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
    get: operations["oauth-authorizations/list-authorizations"];
    /**
     * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * Creates OAuth tokens using [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication). If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     *
     * To create tokens for a particular OAuth application using this endpoint, you must authenticate as the user you want to create an authorization for and provide the app's client ID and secret, found on your OAuth application's settings page. If your OAuth application intends to create multiple tokens for one user, use `fingerprint` to differentiate between them.
     *
     * You can also create tokens on GitHub from the [personal access tokens settings](https://github.com/settings/tokens) page. Read more about these tokens in [the GitHub Help documentation](https://docs.github.com/articles/creating-an-access-token-for-command-line-use).
     *
     * Organizations that enforce SAML SSO require personal access tokens to be allowed. Read more about allowing tokens in [the GitHub Help documentation](https://docs.github.com/articles/about-identity-and-access-management-with-saml-single-sign-on).
     */
    post: operations["oauth-authorizations/create-authorization"];
  };
  "/authorizations/clients/{client_id}": {
    /**
     * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * Creates a new authorization for the specified OAuth application, only if an authorization for that application doesn't already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
     *
     * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     *
     * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     */
    put: operations["oauth-authorizations/get-or-create-authorization-for-app"];
  };
  "/authorizations/clients/{client_id}/{fingerprint}": {
    /**
     * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
     *
     * This method will create a new authorization for the specified OAuth application, only if an authorization for that application and fingerprint do not already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. `fingerprint` is a unique string to distinguish an authorization from others created for the same client ID and user. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
     *
     * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     */
    put: operations["oauth-authorizations/get-or-create-authorization-for-app-and-fingerprint"];
  };
  "/authorizations/{authorization_id}": {
    /** **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
    get: operations["oauth-authorizations/get-authorization"];
    /** **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
    delete: operations["oauth-authorizations/delete-authorization"];
    /**
     * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
     *
     * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
     *
     * You can only send one of these scope keys at a time.
     */
    patch: operations["oauth-authorizations/update-authorization"];
  };
  "/codes_of_conduct": {
    get: operations["codes-of-conduct/get-all-codes-of-conduct"];
  };
  "/codes_of_conduct/{key}": {
    get: operations["codes-of-conduct/get-conduct-code"];
  };
  "/emojis": {
    /** Lists all the emojis available to use on GitHub. */
    get: operations["emojis/get"];
  };
  "/enterprise-installation/{enterprise_or_org}/server-statistics": {
    /**
     * Returns aggregate usage metrics for your GitHub Enterprise Server 3.5+ instance for a specified time period up to 365 days.
     *
     * To use this endpoint, your GitHub Enterprise Server instance must be connected to GitHub Enterprise Cloud using GitHub Connect. You must enable Server Statistics, and for the API request provide your enterprise account name or organization name connected to the GitHub Enterprise Server. For more information, see "[Enabling Server Statistics for your enterprise](/admin/configuration/configuring-github-connect/enabling-server-statistics-for-your-enterprise)" in the GitHub Enterprise Server documentation.
     *
     * You'll need to use a personal access token:
     *   - If you connected your GitHub Enterprise Server to an enterprise account and enabled Server Statistics, you'll need a personal access token with the `read:enterprise` permission.
     *   - If you connected your GitHub Enterprise Server to an organization account and enabled Server Statistics, you'll need a personal access token with the `read:org` permission.
     *
     * For more information on creating a personal access token, see "[Creating a personal access token](/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token)."
     */
    get: operations["enterprise-admin/get-server-statistics"];
  };
  "/enterprises/{enterprise}/actions/cache/usage": {
    /**
     * Gets the total GitHub Actions cache usage for an enterprise.
     * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["actions/get-actions-cache-usage-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/oidc/customization/issuer": {
    /**
     * Sets the GitHub Actions OpenID Connect (OIDC) custom issuer policy for an enterprise.
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     * GitHub Apps must have the `enterprise_administration:write` permission to use this endpoint.
     */
    put: operations["actions/set-actions-oidc-custom-issuer-policy-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions": {
    /**
     * Gets the GitHub Actions permissions policy for organizations and allowed actions and reusable workflows in an enterprise.
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-github-actions-permissions-enterprise"];
    /**
     * Sets the GitHub Actions permissions policy for organizations and allowed actions and reusable workflows in an enterprise.
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-github-actions-permissions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/organizations": {
    /**
     * Lists the organizations that are selected to have GitHub Actions enabled in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-selected-organizations-enabled-github-actions-enterprise"];
    /**
     * Replaces the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-selected-organizations-enabled-github-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/organizations/{org_id}": {
    /**
     * Adds an organization to the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/enable-selected-organization-github-actions-enterprise"];
    /**
     * Removes an organization from the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/disable-selected-organization-github-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/selected-actions": {
    /**
     * Gets the selected actions and reusable workflows that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-allowed-actions-enterprise"];
    /**
     * Sets the actions and reusable workflows that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-allowed-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/workflow": {
    /**
     * Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an enterprise,
     * as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
     * "[Enforcing a policy for workflow permissions in your enterprise](https://docs.github.com/enterprise-cloud@latest/admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise#enforcing-a-policy-for-workflow-permissions-in-your-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     * GitHub Apps must have the `enterprise_administration:write` permission to use this endpoint.
     */
    get: operations["actions/get-github-actions-default-workflow-permissions-enterprise"];
    /**
     * Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an enterprise, and sets
     * whether GitHub Actions can submit approving pull request reviews. For more information, see
     * "[Enforcing a policy for workflow permissions in your enterprise](https://docs.github.com/enterprise-cloud@latest/admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise#enforcing-a-policy-for-workflow-permissions-in-your-enterprise)."
     *
     * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
     * GitHub Apps must have the `enterprise_administration:write` permission to use this endpoint.
     */
    put: operations["actions/set-github-actions-default-workflow-permissions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups": {
    /**
     * Lists all self-hosted runner groups for an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-self-hosted-runner-groups-for-enterprise"];
    /**
     * Creates a new self-hosted runner group for an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    post: operations["enterprise-admin/create-self-hosted-runner-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}": {
    /**
     * Gets a specific self-hosted runner group for an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-self-hosted-runner-group-for-enterprise"];
    /**
     * Deletes a self-hosted runner group for an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/delete-self-hosted-runner-group-from-enterprise"];
    /**
     * Updates the `name` and `visibility` of a self-hosted runner group in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    patch: operations["enterprise-admin/update-self-hosted-runner-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations": {
    /**
     * Lists the organizations with access to a self-hosted runner group.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-org-access-to-self-hosted-runner-group-in-enterprise"];
    /**
     * Replaces the list of organizations that have access to a self-hosted runner configured in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-org-access-to-self-hosted-runner-group-in-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}": {
    /**
     * Adds an organization to the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/add-org-access-to-self-hosted-runner-group-in-enterprise"];
    /**
     * Removes an organization from the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/remove-org-access-to-self-hosted-runner-group-in-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners": {
    /**
     * Lists the self-hosted runners that are in a specific enterprise group.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-self-hosted-runners-in-group-for-enterprise"];
    /**
     * Replaces the list of self-hosted runners that are part of an enterprise runner group.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-self-hosted-runners-in-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}": {
    /**
     * Adds a self-hosted runner to a runner group configured in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise`
     * scope to use this endpoint.
     */
    put: operations["enterprise-admin/add-self-hosted-runner-to-group-for-enterprise"];
    /**
     * Removes a self-hosted runner from a group configured in an enterprise. The runner is then returned to the default group.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/remove-self-hosted-runner-from-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners": {
    /**
     * Lists all self-hosted runners configured for an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-self-hosted-runners-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/downloads": {
    /**
     * Lists binaries for the runner application that you can download and run.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-runner-applications-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/registration-token": {
    /**
     * Returns a token that you can pass to the `config` script. The token expires after one hour.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     *
     * #### Example using registration token
     *
     * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
     *
     * ```
     * ./config.sh --url https://github.com/enterprises/octo-enterprise --token TOKEN
     * ```
     */
    post: operations["enterprise-admin/create-registration-token-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/remove-token": {
    /**
     * Returns a token that you can pass to the `config` script to remove a self-hosted runner from an enterprise. The token expires after one hour.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     *
     * #### Example using remove token
     *
     * To remove your self-hosted runner from an enterprise, replace `TOKEN` with the remove token provided by this
     * endpoint.
     *
     * ```
     * ./config.sh remove --token TOKEN
     * ```
     */
    post: operations["enterprise-admin/create-remove-token-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/{runner_id}": {
    /**
     * Gets a specific self-hosted runner configured in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/get-self-hosted-runner-for-enterprise"];
    /**
     * Forces the removal of a self-hosted runner from an enterprise. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/delete-self-hosted-runner-from-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/{runner_id}/labels": {
    /**
     * Lists all labels for a self-hosted runner configured in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    get: operations["enterprise-admin/list-labels-for-self-hosted-runner-for-enterprise"];
    /**
     * Remove all previous custom labels and set the new custom labels for a specific
     * self-hosted runner configured in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    put: operations["enterprise-admin/set-custom-labels-for-self-hosted-runner-for-enterprise"];
    /**
     * Add custom labels to a self-hosted runner configured in an enterprise.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    post: operations["enterprise-admin/add-custom-labels-to-self-hosted-runner-for-enterprise"];
    /**
     * Remove all custom labels from a self-hosted runner configured in an
     * enterprise. Returns the remaining read-only labels from the runner.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/remove-all-custom-labels-from-self-hosted-runner-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/{runner_id}/labels/{name}": {
    /**
     * Remove a custom label from a self-hosted runner configured
     * in an enterprise. Returns the remaining labels from the runner.
     *
     * This endpoint returns a `404 Not Found` status if the custom label is not
     * present on the runner.
     *
     * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
     */
    delete: operations["enterprise-admin/remove-custom-label-from-self-hosted-runner-for-enterprise"];
  };
  "/enterprises/{enterprise}/audit-log": {
    /** Gets the audit log for an enterprise. To use this endpoint, you must be an enterprise admin, and you must use an access token with the `admin:enterprise` scope. */
    get: operations["enterprise-admin/get-audit-log"];
  };
  "/enterprises/{enterprise}/secret-scanning/alerts": {
    /**
     * Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.
     * To use this endpoint, you must be a member of the enterprise, and you must use an access token with the `repo` scope or `security_events` scope. Alerts are only returned for organizations in the enterprise for which you are an organization owner or a [security manager](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).
     */
    get: operations["secret-scanning/list-alerts-for-enterprise"];
  };
  "/enterprises/{enterprise}/settings/billing/actions": {
    /**
     * Gets the summary of the free and paid GitHub Actions minutes used.
     *
     * Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
     *
     * The authenticated user must be an enterprise admin.
     */
    get: operations["billing/get-github-actions-billing-ghe"];
  };
  "/enterprises/{enterprise}/settings/billing/advanced-security": {
    /**
     * Gets the GitHub Advanced Security active committers for an enterprise per repository.
     * Each distinct user login across all repositories is counted as a single Advanced Security seat, so the total_advanced_security_committers is not the sum of active_users for each repository.
     */
    get: operations["billing/get-github-advanced-security-billing-ghe"];
  };
  "/enterprises/{enterprise}/settings/billing/packages": {
    /**
     * Gets the free and paid storage used for GitHub Packages in gigabytes.
     *
     * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
     *
     * The authenticated user must be an enterprise admin.
     */
    get: operations["billing/get-github-packages-billing-ghe"];
  };
  "/enterprises/{enterprise}/settings/billing/shared-storage": {
    /**
     * Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.
     *
     * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
     *
     * The authenticated user must be an enterprise admin.
     */
    get: operations["billing/get-shared-storage-billing-ghe"];
  };
  "/events": {
    /** We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago. */
    get: operations["activity/list-public-events"];
  };
  "/feeds": {
    /**
     * GitHub provides several timeline resources in [Atom](http://en.wikipedia.org/wiki/Atom_(standard)) format. The Feeds API lists all the feeds available to the authenticated user:
     *
     * *   **Timeline**: The GitHub global public timeline
     * *   **User**: The public timeline for any user, using [URI template](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia)
     * *   **Current user public**: The public timeline for the authenticated user
     * *   **Current user**: The private timeline for the authenticated user
     * *   **Current user actor**: The private timeline for activity created by the authenticated user
     * *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
     * *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.
     *
     * **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
     */
    get: operations["activity/get-feeds"];
  };
  "/gists": {
    /** Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists: */
    get: operations["gists/list"];
    /**
     * Allows you to add a new gist with one or more files.
     *
     * **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
     */
    post: operations["gists/create"];
  };
  "/gists/public": {
    /**
     * List public gists sorted by most recently updated to least recently updated.
     *
     * Note: With [pagination](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
     */
    get: operations["gists/list-public"];
  };
  "/gists/starred": {
    /** List the authenticated user's starred gists: */
    get: operations["gists/list-starred"];
  };
  "/gists/{gist_id}": {
    get: operations["gists/get"];
    delete: operations["gists/delete"];
    /** Allows you to update or delete a gist file and rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged. */
    patch: operations["gists/update"];
  };
  "/gists/{gist_id}/comments": {
    get: operations["gists/list-comments"];
    post: operations["gists/create-comment"];
  };
  "/gists/{gist_id}/comments/{comment_id}": {
    get: operations["gists/get-comment"];
    delete: operations["gists/delete-comment"];
    patch: operations["gists/update-comment"];
  };
  "/gists/{gist_id}/commits": {
    get: operations["gists/list-commits"];
  };
  "/gists/{gist_id}/forks": {
    get: operations["gists/list-forks"];
    /** **Note**: This was previously `/gists/:gist_id/fork`. */
    post: operations["gists/fork"];
  };
  "/gists/{gist_id}/star": {
    get: operations["gists/check-is-starred"];
    /** Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)." */
    put: operations["gists/star"];
    delete: operations["gists/unstar"];
  };
  "/gists/{gist_id}/{sha}": {
    get: operations["gists/get-revision"];
  };
  "/gitignore/templates": {
    /** List all templates available to pass as an option when [creating a repository](https://docs.github.com/rest/reference/repos#create-a-repository-for-the-authenticated-user). */
    get: operations["gitignore/get-all-templates"];
  };
  "/gitignore/templates/{name}": {
    /**
     * The API also allows fetching the source of a single template.
     * Use the raw [media type](https://docs.github.com/rest/overview/media-types/) to get the raw contents.
     */
    get: operations["gitignore/get-template"];
  };
  "/installation/repositories": {
    /**
     * List repositories that an app installation can access.
     *
     * You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    get: operations["apps/list-repos-accessible-to-installation"];
  };
  "/installation/token": {
    /**
     * Revokes the installation token you're using to authenticate as an installation and access this endpoint.
     *
     * Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/rest/reference/apps#create-an-installation-access-token-for-an-app)" endpoint.
     *
     * You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
     */
    delete: operations["apps/revoke-installation-access-token"];
  };
  "/issues": {
    /**
     * List issues assigned to the authenticated user across all visible repositories including owned repositories, member
     * repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
     * necessarily assigned to you.
     *
     *
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
     */
    get: operations["issues/list"];
  };
  "/licenses": {
    get: operations["licenses/get-all-commonly-used"];
  };
  "/licenses/{license}": {
    get: operations["licenses/get"];
  };
  "/markdown": {
    post: operations["markdown/render"];
  };
  "/markdown/raw": {
    /** You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less. */
    post: operations["markdown/render-raw"];
  };
  "/marketplace_listing/accounts/{account_id}": {
    /**
     * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
     *
     * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    get: operations["apps/get-subscription-plan-for-account"];
  };
  "/marketplace_listing/plans": {
    /**
     * Lists all plans that are part of your GitHub Marketplace listing.
     *
     * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    get: operations["apps/list-plans"];
  };
  "/marketplace_listing/plans/{plan_id}/accounts": {
    /**
     * Returns user and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
     *
     * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    get: operations["apps/list-accounts-for-plan"];
  };
  "/marketplace_listing/stubbed/accounts/{account_id}": {
    /**
     * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
     *
     * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    get: operations["apps/get-subscription-plan-for-account-stubbed"];
  };
  "/marketplace_listing/stubbed/plans": {
    /**
     * Lists all plans that are part of your GitHub Marketplace listing.
     *
     * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    get: operations["apps/list-plans-stubbed"];
  };
  "/marketplace_listing/stubbed/plans/{plan_id}/accounts": {
    /**
     * Returns repository and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
     *
     * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
     */
    get: operations["apps/list-accounts-for-plan-stubbed"];
  };
  "/meta": {
    /**
     * Returns meta information about GitHub, including a list of GitHub's IP addresses. For more information, see "[About GitHub's IP addresses](https://docs.github.com/articles/about-github-s-ip-addresses/)."
     *
     * **Note:** The IP addresses shown in the documentation's response are only example values. You must always query the API directly to get the latest list of IP addresses.
     */
    get: operations["meta/get"];
  };
  "/networks/{owner}/{repo}/events": {
    get: operations["activity/list-public-events-for-repo-network"];
  };
  "/notifications": {
    /** List all notifications for the current user, sorted by most recently updated. */
    get: operations["activity/list-notifications-for-authenticated-user"];
    /** Marks all notifications as "read" removes it from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/rest/reference/activity#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`. */
    put: operations["activity/mark-notifications-as-read"];
  };
  "/notifications/threads/{thread_id}": {
    get: operations["activity/get-thread"];
    patch: operations["activity/mark-thread-as-read"];
  };
  "/notifications/threads/{thread_id}/subscription": {
    /**
     * This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/rest/reference/activity#get-a-repository-subscription).
     *
     * Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
     */
    get: operations["activity/get-thread-subscription-for-authenticated-user"];
    /**
     * If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
     *
     * You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
     *
     * Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/rest/reference/activity#delete-a-thread-subscription) endpoint.
     */
    put: operations["activity/set-thread-subscription"];
    /** Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/rest/reference/activity#set-a-thread-subscription) endpoint and set `ignore` to `true`. */
    delete: operations["activity/delete-thread-subscription"];
  };
  "/octocat": {
    /** Get the octocat as ASCII art */
    get: operations["meta/get-octocat"];
  };
  "/organizations": {
    /**
     * Lists all organizations, in the order that they were created on GitHub.
     *
     * **Note:** Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of organizations.
     */
    get: operations["orgs/list"];
  };
  "/organizations/{organization_id}/custom_roles": {
    /**
     * List the custom repository roles available in this organization. In order to see custom
     * repository roles in an organization, the authenticated user must be an organization owner.
     *
     * For more information on custom repository roles, see "[Managing custom repository roles for an organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-custom-repository-roles-for-an-organization)".
     */
    get: operations["orgs/list-custom-roles"];
  };
  "/orgs/{org_id}/codespaces": {
    /**
     * Lists the codespaces associated to a specified organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["codespaces/list-in-organization"];
  };
  "/orgs/{org}": {
    /**
     * To see many of the organization response values, you need to be an authenticated organization owner with the `admin:org` scope. When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, and outside collaborators to enable [two-factor authentication](https://docs.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
     *
     * GitHub Apps with the `Organization plan` permission can use this endpoint to retrieve information about an organization's GitHub plan. See "[Authenticating with GitHub Apps](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/)" for details. For an example response, see 'Response with GitHub plan information' below."
     */
    get: operations["orgs/get"];
    /**
     * **Parameter Deprecation Notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
     *
     * Enables an authenticated organization owner with the `admin:org` scope to update the organization's profile and member privileges.
     */
    patch: operations["orgs/update"];
  };
  "/orgs/{org}/actions/cache/usage": {
    /**
     * Gets the total GitHub Actions cache usage for an organization.
     * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
     * You must authenticate using an access token with the `read:org` scope to use this endpoint. GitHub Apps must have the `organization_admistration:read` permission to use this endpoint.
     */
    get: operations["actions/get-actions-cache-usage-for-org"];
  };
  "/orgs/{org}/actions/cache/usage-by-repository": {
    /**
     * Lists repositories and their GitHub Actions cache usage for an organization.
     * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
     * You must authenticate using an access token with the `read:org` scope to use this endpoint. GitHub Apps must have the `organization_admistration:read` permission to use this endpoint.
     */
    get: operations["actions/get-actions-cache-usage-by-repo-for-org"];
  };
  "/orgs/{org}/actions/oidc/customization/sub": {
    /**
     * Gets the customization template for an OpenID Connect (OIDC) subject claim.
     * You must authenticate using an access token with the `read:org` scope to use this endpoint.
     * GitHub Apps must have the `organization_administration:write` permission to use this endpoint.
     */
    get: operations["oidc/get-oidc-custom-sub-template-for-org"];
    /**
     * Creates or updates the customization template for an OpenID Connect (OIDC) subject claim.
     * You must authenticate using an access token with the `write:org` scope to use this endpoint.
     * GitHub Apps must have the `admin:org` permission to use this endpoint.
     */
    put: operations["oidc/update-oidc-custom-sub-template-for-org"];
  };
  "/orgs/{org}/actions/permissions": {
    /**
     * Gets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    get: operations["actions/get-github-actions-permissions-organization"];
    /**
     * Sets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
     *
     * If the organization belongs to an enterprise that has set restrictive permissions at the enterprise level, such as `allowed_actions` to `selected` actions and reusable workflows, then you cannot override them for the organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    put: operations["actions/set-github-actions-permissions-organization"];
  };
  "/orgs/{org}/actions/permissions/repositories": {
    /**
     * Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    get: operations["actions/list-selected-repositories-enabled-github-actions-organization"];
    /**
     * Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    put: operations["actions/set-selected-repositories-enabled-github-actions-organization"];
  };
  "/orgs/{org}/actions/permissions/repositories/{repository_id}": {
    /**
     * Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    put: operations["actions/enable-selected-repository-github-actions-organization"];
    /**
     * Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    delete: operations["actions/disable-selected-repository-github-actions-organization"];
  };
  "/orgs/{org}/actions/permissions/selected-actions": {
    /**
     * Gets the selected actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization).""
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    get: operations["actions/get-allowed-actions-organization"];
    /**
     * Sets the actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
     *
     * If the organization belongs to an enterprise that has `selected` actions and reusable workflows set at the enterprise level, then you cannot override any of the enterprise's allowed actions and reusable workflows settings.
     *
     * To use the `patterns_allowed` setting for private repositories, the organization must belong to an enterprise. If the organization does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories in the organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    put: operations["actions/set-allowed-actions-organization"];
  };
  "/orgs/{org}/actions/permissions/workflow": {
    /**
     * Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization,
     * as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
     * "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    get: operations["actions/get-github-actions-default-workflow-permissions-organization"];
    /**
     * Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization, and sets if GitHub Actions
     * can submit approving pull request reviews. For more information, see
     * "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
     */
    put: operations["actions/set-github-actions-default-workflow-permissions-organization"];
  };
  "/orgs/{org}/actions/runner-groups": {
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-self-hosted-runner-groups-for-org"];
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Creates a new self-hosted runner group for an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    post: operations["actions/create-self-hosted-runner-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}": {
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Gets a specific self-hosted runner group for an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/get-self-hosted-runner-group-for-org"];
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Deletes a self-hosted runner group for an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/delete-self-hosted-runner-group-from-org"];
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Updates the `name` and `visibility` of a self-hosted runner group in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    patch: operations["actions/update-self-hosted-runner-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories": {
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Lists the repositories with access to a self-hosted runner group configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-repo-access-to-self-hosted-runner-group-in-org"];
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-repo-access-to-self-hosted-runner-group-in-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}": {
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     *
     * Adds a repository to the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
     *
     * You must authenticate using an access token with the `admin:org`
     * scope to use this endpoint.
     */
    put: operations["actions/add-repo-access-to-self-hosted-runner-group-in-org"];
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     *
     * Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/remove-repo-access-to-self-hosted-runner-group-in-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/runners": {
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Lists self-hosted runners that are in a specific organization group.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-self-hosted-runners-in-group-for-org"];
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     * Replaces the list of self-hosted runners that are part of an organization runner group.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-self-hosted-runners-in-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}": {
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     *
     * Adds a self-hosted runner to a runner group configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org`
     * scope to use this endpoint.
     */
    put: operations["actions/add-self-hosted-runner-to-group-for-org"];
    /**
     * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
     *
     *
     * Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/remove-self-hosted-runner-from-group-for-org"];
  };
  "/orgs/{org}/actions/runners": {
    /**
     * Lists all self-hosted runners configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-self-hosted-runners-for-org"];
  };
  "/orgs/{org}/actions/runners/downloads": {
    /**
     * Lists binaries for the runner application that you can download and run.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-runner-applications-for-org"];
  };
  "/orgs/{org}/actions/runners/registration-token": {
    /**
     * Returns a token that you can pass to the `config` script. The token expires after one hour.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     *
     * #### Example using registration token
     *
     * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
     *
     * ```
     * ./config.sh --url https://github.com/octo-org --token TOKEN
     * ```
     */
    post: operations["actions/create-registration-token-for-org"];
  };
  "/orgs/{org}/actions/runners/remove-token": {
    /**
     * Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     *
     * #### Example using remove token
     *
     * To remove your self-hosted runner from an organization, replace `TOKEN` with the remove token provided by this
     * endpoint.
     *
     * ```
     * ./config.sh remove --token TOKEN
     * ```
     */
    post: operations["actions/create-remove-token-for-org"];
  };
  "/orgs/{org}/actions/runners/{runner_id}": {
    /**
     * Gets a specific self-hosted runner configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/get-self-hosted-runner-for-org"];
    /**
     * Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/delete-self-hosted-runner-from-org"];
  };
  "/orgs/{org}/actions/runners/{runner_id}/labels": {
    /**
     * Lists all labels for a self-hosted runner configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    get: operations["actions/list-labels-for-self-hosted-runner-for-org"];
    /**
     * Remove all previous custom labels and set the new custom labels for a specific
     * self-hosted runner configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    put: operations["actions/set-custom-labels-for-self-hosted-runner-for-org"];
    /**
     * Add custom labels to a self-hosted runner configured in an organization.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    post: operations["actions/add-custom-labels-to-self-hosted-runner-for-org"];
    /**
     * Remove all custom labels from a self-hosted runner configured in an
     * organization. Returns the remaining read-only labels from the runner.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/remove-all-custom-labels-from-self-hosted-runner-for-org"];
  };
  "/orgs/{org}/actions/runners/{runner_id}/labels/{name}": {
    /**
     * Remove a custom label from a self-hosted runner configured
     * in an organization. Returns the remaining labels from the runner.
     *
     * This endpoint returns a `404 Not Found` status if the custom label is not
     * present on the runner.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["actions/remove-custom-label-from-self-hosted-runner-for-org"];
  };
  "/orgs/{org}/actions/secrets": {
    /** Lists all secrets available in an organization without revealing their encrypted values. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    get: operations["actions/list-org-secrets"];
  };
  "/orgs/{org}/actions/secrets/public-key": {
    /** Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    get: operations["actions/get-org-public-key"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}": {
    /** Gets a single organization secret without revealing its encrypted value. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    get: operations["actions/get-org-secret"];
    /**
     * Creates or updates an organization secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to
     * use this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["actions/create-or-update-org-secret"];
    /** Deletes a secret in an organization using the secret name. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    delete: operations["actions/delete-org-secret"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}/repositories": {
    /** Lists all repositories that have been selected when the `visibility` for repository access to a secret is set to `selected`. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    get: operations["actions/list-selected-repos-for-org-secret"];
    /** Replaces all repositories for an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    put: operations["actions/set-selected-repos-for-org-secret"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}": {
    /** Adds a repository to an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    put: operations["actions/add-selected-repo-to-org-secret"];
    /** Removes a repository from an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
    delete: operations["actions/remove-selected-repo-from-org-secret"];
  };
  "/orgs/{org}/audit-log": {
    /**
     * Gets the audit log for an organization. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization)."
     *
     * This endpoint is available for organizations on GitHub Enterprise Cloud. To use this endpoint, you must be an organization owner, and you must use an access token with the `admin:org` scope. GitHub Apps must have the `organization_administration` read permission to use this endpoint.
     *
     * By default, the response includes up to 30 events from the past three months. Use the `phrase` parameter to filter results and retrieve older events. For example, use the `phrase` parameter with the `created` qualifier to filter events based on when the events occurred. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/organizations/keeping-your-organization-secure/managing-security-settings-for-your-organization/reviewing-the-audit-log-for-your-organization#searching-the-audit-log)."
     *
     * Use pagination to retrieve fewer or more than 30 events. For more information, see "[Resources in the REST API](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination)."
     */
    get: operations["orgs/get-audit-log"];
  };
  "/orgs/{org}/blocks": {
    /** List the users blocked by an organization. */
    get: operations["orgs/list-blocked-users"];
  };
  "/orgs/{org}/blocks/{username}": {
    get: operations["orgs/check-blocked-user"];
    put: operations["orgs/block-user"];
    delete: operations["orgs/unblock-user"];
  };
  "/orgs/{org}/code-scanning/alerts": {
    /**
     * Lists all code scanning alerts for the default branch (usually `main`
     * or `master`) for all eligible repositories in an organization.
     * To use this endpoint, you must be an administrator or security manager for the organization, and you must use an access token with the `repo` scope or `security_events` scope.
     *
     * GitHub Apps must have the `security_events` read permission to use this endpoint.
     */
    get: operations["code-scanning/list-alerts-for-org"];
  };
  "/orgs/{org}/credential-authorizations": {
    /**
     * Listing and deleting credential authorizations is available to organizations with GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products).
     *
     * An authenticated organization owner with the `read:org` scope can list all credential authorizations for an organization that uses SAML single sign-on (SSO). The credentials are either personal access tokens or SSH keys that organization members have authorized for the organization. For more information, see [About authentication with SAML single sign-on](https://docs.github.com/en/articles/about-authentication-with-saml-single-sign-on).
     */
    get: operations["orgs/list-saml-sso-authorizations"];
  };
  "/orgs/{org}/credential-authorizations/{credential_id}": {
    /**
     * Listing and deleting credential authorizations is available to organizations with GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products).
     *
     * An authenticated organization owner with the `admin:org` scope can remove a credential authorization for an organization that uses SAML SSO. Once you remove someone's credential authorization, they will need to create a new personal access token or SSH key and authorize it for the organization they want to access.
     */
    delete: operations["orgs/remove-saml-sso-authorization"];
  };
  "/orgs/{org}/dependabot/secrets": {
    /** Lists all secrets available in an organization without revealing their encrypted values. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
    get: operations["dependabot/list-org-secrets"];
  };
  "/orgs/{org}/dependabot/secrets/public-key": {
    /** Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
    get: operations["dependabot/get-org-public-key"];
  };
  "/orgs/{org}/dependabot/secrets/{secret_name}": {
    /** Gets a single organization secret without revealing its encrypted value. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
    get: operations["dependabot/get-org-secret"];
    /**
     * Creates or updates an organization secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization
     * permission to use this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["dependabot/create-or-update-org-secret"];
    /** Deletes a secret in an organization using the secret name. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
    delete: operations["dependabot/delete-org-secret"];
  };
  "/orgs/{org}/dependabot/secrets/{secret_name}/repositories": {
    /** Lists all repositories that have been selected when the `visibility` for repository access to a secret is set to `selected`. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
    get: operations["dependabot/list-selected-repos-for-org-secret"];
    /** Replaces all repositories for an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/dependabot#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
    put: operations["dependabot/set-selected-repos-for-org-secret"];
  };
  "/orgs/{org}/dependabot/secrets/{secret_name}/repositories/{repository_id}": {
    /** Adds a repository to an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/dependabot#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
    put: operations["dependabot/add-selected-repo-to-org-secret"];
    /** Removes a repository from an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/dependabot#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
    delete: operations["dependabot/remove-selected-repo-from-org-secret"];
  };
  "/orgs/{org}/events": {
    get: operations["activity/list-public-org-events"];
  };
  "/orgs/{org}/external-group/{group_id}": {
    /**
     * Displays information about the specific group's usage.  Provides a list of the group's external members as well as a list of teams that this group is connected to.
     *
     * You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.
     */
    get: operations["teams/external-idp-group-info-for-org"];
  };
  "/orgs/{org}/external-groups": {
    /**
     * Lists external groups available in an organization. You can query the groups using the `display_name` parameter, only groups with a `group_name` containing the text provided in the `display_name` parameter will be returned.  You can also limit your page results using the `per_page` parameter. GitHub generates a url-encoded `page` token using a cursor value for where the next page begins. For more information on cursor pagination, see "[Offset and Cursor Pagination explained](https://dev.to/jackmarchant/offset-and-cursor-pagination-explained-b89)."
     *
     * You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.
     */
    get: operations["teams/list-external-idp-groups-for-org"];
  };
  "/orgs/{org}/failed_invitations": {
    /** The return hash contains `failed_at` and `failed_reason` fields which represent the time at which the invitation failed and the reason for the failure. */
    get: operations["orgs/list-failed-invitations"];
  };
  "/orgs/{org}/hooks": {
    get: operations["orgs/list-webhooks"];
    /** Here's how you can create a hook that posts payloads in JSON format: */
    post: operations["orgs/create-webhook"];
  };
  "/orgs/{org}/hooks/{hook_id}": {
    /** Returns a webhook configured in an organization. To get only the webhook `config` properties, see "[Get a webhook configuration for an organization](/rest/reference/orgs#get-a-webhook-configuration-for-an-organization)." */
    get: operations["orgs/get-webhook"];
    delete: operations["orgs/delete-webhook"];
    /** Updates a webhook configured in an organization. When you update a webhook, the `secret` will be overwritten. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for an organization](/rest/reference/orgs#update-a-webhook-configuration-for-an-organization)." */
    patch: operations["orgs/update-webhook"];
  };
  "/orgs/{org}/hooks/{hook_id}/config": {
    /**
     * Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/reference/orgs#get-an-organization-webhook)."
     *
     * Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:read` permission.
     */
    get: operations["orgs/get-webhook-config-for-org"];
    /**
     * Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/reference/orgs#update-an-organization-webhook)."
     *
     * Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:write` permission.
     */
    patch: operations["orgs/update-webhook-config-for-org"];
  };
  "/orgs/{org}/hooks/{hook_id}/deliveries": {
    /** Returns a list of webhook deliveries for a webhook configured in an organization. */
    get: operations["orgs/list-webhook-deliveries"];
  };
  "/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}": {
    /** Returns a delivery for a webhook configured in an organization. */
    get: operations["orgs/get-webhook-delivery"];
  };
  "/orgs/{org}/hooks/{hook_id}/deliveries/{delivery_id}/attempts": {
    /** Redeliver a delivery for a webhook configured in an organization. */
    post: operations["orgs/redeliver-webhook-delivery"];
  };
  "/orgs/{org}/hooks/{hook_id}/pings": {
    /** This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook. */
    post: operations["orgs/ping-webhook"];
  };
  "/orgs/{org}/installation": {
    /**
     * Enables an authenticated GitHub App to find the organization's installation information.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-org-installation"];
  };
  "/orgs/{org}/installations": {
    /** Lists all GitHub Apps in an organization. The installation count includes all GitHub Apps installed on repositories in the organization. You must be an organization owner with `admin:read` scope to use this endpoint. */
    get: operations["orgs/list-app-installations"];
  };
  "/orgs/{org}/interaction-limits": {
    /** Shows which type of GitHub user can interact with this organization and when the restriction expires. If there is no restrictions, you will see an empty response. */
    get: operations["interactions/get-restrictions-for-org"];
    /** Temporarily restricts interactions to a certain type of GitHub user in any public repository in the given organization. You must be an organization owner to set these restrictions. Setting the interaction limit at the organization level will overwrite any interaction limits that are set for individual repositories owned by the organization. */
    put: operations["interactions/set-restrictions-for-org"];
    /** Removes all interaction restrictions from public repositories in the given organization. You must be an organization owner to remove restrictions. */
    delete: operations["interactions/remove-restrictions-for-org"];
  };
  "/orgs/{org}/invitations": {
    /** The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`. */
    get: operations["orgs/list-pending-invitations"];
    /**
     * Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["orgs/create-invitation"];
  };
  "/orgs/{org}/invitations/{invitation_id}": {
    /**
     * Cancel an organization invitation. In order to cancel an organization invitation, the authenticated user must be an organization owner.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications).
     */
    delete: operations["orgs/cancel-invitation"];
  };
  "/orgs/{org}/invitations/{invitation_id}/teams": {
    /** List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner. */
    get: operations["orgs/list-invitation-teams"];
  };
  "/orgs/{org}/issues": {
    /**
     * List issues in an organization assigned to the authenticated user.
     *
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
     */
    get: operations["issues/list-for-org"];
  };
  "/orgs/{org}/members": {
    /** List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned. */
    get: operations["orgs/list-members"];
  };
  "/orgs/{org}/members/{username}": {
    /** Check if a user is, publicly or privately, a member of the organization. */
    get: operations["orgs/check-membership-for-user"];
    /** Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories. */
    delete: operations["orgs/remove-member"];
  };
  "/orgs/{org}/members/{username}/codespaces/{codespace_name}": {
    /**
     * Deletes a user's codespace.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    delete: operations["codespaces/delete-from-organization"];
  };
  "/orgs/{org}/members/{username}/codespaces/{codespace_name}/stop": {
    /**
     * Stops a user's codespace.
     *
     * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
     */
    post: operations["codespaces/stop-in-organization"];
  };
  "/orgs/{org}/memberships/{username}": {
    /** In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status. */
    get: operations["orgs/get-membership-for-user"];
    /**
     * Only authenticated organization owners can add a member to the organization or update the member's role.
     *
     * *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/rest/reference/orgs#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
     *
     * *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
     *
     * **Rate limits**
     *
     * To prevent abuse, the authenticated user is limited to 50 organization invitations per 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
     */
    put: operations["orgs/set-membership-for-user"];
    /**
     * In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
     *
     * If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
     */
    delete: operations["orgs/remove-membership-for-user"];
  };
  "/orgs/{org}/migrations": {
    /** Lists the most recent migrations. */
    get: operations["migrations/list-for-org"];
    /** Initiates the generation of a migration archive. */
    post: operations["migrations/start-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}": {
    /**
     * Fetches the status of a migration.
     *
     * The `state` of a migration can be one of the following values:
     *
     * *   `pending`, which means the migration hasn't started yet.
     * *   `exporting`, which means the migration is in progress.
     * *   `exported`, which means the migration finished successfully.
     * *   `failed`, which means the migration failed.
     */
    get: operations["migrations/get-status-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}/archive": {
    /** Fetches the URL to a migration archive. */
    get: operations["migrations/download-archive-for-org"];
    /** Deletes a previous migration archive. Migration archives are automatically deleted after seven days. */
    delete: operations["migrations/delete-archive-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock": {
    /** Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/rest/reference/repos#delete-a-repository) when the migration is complete and you no longer need the source data. */
    delete: operations["migrations/unlock-repo-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}/repositories": {
    /** List all the repositories for this organization migration. */
    get: operations["migrations/list-repos-for-org"];
  };
  "/orgs/{org}/outside_collaborators": {
    /** List all users who are outside collaborators of an organization. */
    get: operations["orgs/list-outside-collaborators"];
  };
  "/orgs/{org}/outside_collaborators/{username}": {
    /** When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://docs.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)". Converting an organization member to an outside collaborator may be restricted by enterprise administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/enterprise-cloud@latest/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)." */
    put: operations["orgs/convert-member-to-outside-collaborator"];
    /** Removing a user from this list will remove them from all the organization's repositories. */
    delete: operations["orgs/remove-outside-collaborator"];
  };
  "/orgs/{org}/packages": {
    /**
     * Lists all packages in an organization readable by the user.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/list-packages-for-organization"];
  };
  "/orgs/{org}/packages/{package_type}/{package_name}": {
    /**
     * Gets a specific package in an organization.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/get-package-for-organization"];
    /**
     * Deletes an entire package in an organization. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
     *
     * To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:delete` scopes. In addition:
     * - If `package_type` is not `container`, your token must also include the `repo` scope.
     * - If `package_type` is `container`, you must also have admin permissions to the container you want to delete.
     */
    delete: operations["packages/delete-package-for-org"];
  };
  "/orgs/{org}/packages/{package_type}/{package_name}/restore": {
    /**
     * Restores an entire package in an organization.
     *
     * You can restore a deleted package under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:write` scopes. In addition:
     * - If `package_type` is not `container`, your token must also include the `repo` scope.
     * - If `package_type` is `container`, you must also have admin permissions to the container that you want to restore.
     */
    post: operations["packages/restore-package-for-org"];
  };
  "/orgs/{org}/packages/{package_type}/{package_name}/versions": {
    /**
     * Returns all package versions for a package owned by an organization.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/get-all-package-versions-for-package-owned-by-org"];
  };
  "/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}": {
    /**
     * Gets a specific package version in an organization.
     *
     * You must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/get-package-version-for-organization"];
    /**
     * Deletes a specific package version in an organization. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
     *
     * To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:delete` scopes. In addition:
     * - If `package_type` is not `container`, your token must also include the `repo` scope.
     * - If `package_type` is `container`, you must also have admin permissions to the container you want to delete.
     */
    delete: operations["packages/delete-package-version-for-org"];
  };
  "/orgs/{org}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore": {
    /**
     * Restores a specific package version in an organization.
     *
     * You can restore a deleted package under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:write` scopes. In addition:
     * - If `package_type` is not `container`, your token must also include the `repo` scope.
     * - If `package_type` is `container`, you must also have admin permissions to the container that you want to restore.
     */
    post: operations["packages/restore-package-version-for-org"];
  };
  "/orgs/{org}/projects": {
    /** Lists the projects in an organization. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    get: operations["projects/list-for-org"];
    /** Creates an organization project board. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    post: operations["projects/create-for-org"];
  };
  "/orgs/{org}/public_members": {
    /** Members of an organization can choose to have their membership publicized or not. */
    get: operations["orgs/list-public-members"];
  };
  "/orgs/{org}/public_members/{username}": {
    get: operations["orgs/check-public-membership-for-user"];
    /**
     * The user can publicize their own membership. (A user cannot publicize the membership for another user.)
     *
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
     */
    put: operations["orgs/set-public-membership-for-authenticated-user"];
    delete: operations["orgs/remove-public-membership-for-authenticated-user"];
  };
  "/orgs/{org}/repos": {
    /** Lists repositories for the specified organization. */
    get: operations["repos/list-for-org"];
    /**
     * Creates a new repository in the specified organization. The authenticated user must be a member of the organization.
     *
     * **OAuth scope requirements**
     *
     * When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
     *
     * *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
     * *   `repo` scope to create a private repository
     */
    post: operations["repos/create-in-org"];
  };
  "/orgs/{org}/secret-scanning/alerts": {
    /**
     * Lists secret scanning alerts for eligible repositories in an organization, from newest to oldest.
     * To use this endpoint, you must be an administrator or security manager for the organization, and you must use an access token with the `repo` scope or `security_events` scope.
     * For public repositories, you may instead use the `public_repo` scope.
     *
     * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
     */
    get: operations["secret-scanning/list-alerts-for-org"];
  };
  "/orgs/{org}/settings/billing/actions": {
    /**
     * Gets the summary of the free and paid GitHub Actions minutes used.
     *
     * Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
     *
     * Access tokens must have the `repo` or `admin:org` scope.
     */
    get: operations["billing/get-github-actions-billing-org"];
  };
  "/orgs/{org}/settings/billing/advanced-security": {
    /**
     * Gets the GitHub Advanced Security active committers for an organization per repository.
     * Each distinct user login across all repositories is counted as a single Advanced Security seat, so the total_advanced_security_committers is not the sum of advanced_security_committers for each repository.
     * If this organization defers to an enterprise for billing, the total_advanced_security_committers returned from the organization API may include some users that are in more than one organization, so they will only consume a single Advanced Security seat at the enterprise level.
     */
    get: operations["billing/get-github-advanced-security-billing-org"];
  };
  "/orgs/{org}/settings/billing/packages": {
    /**
     * Gets the free and paid storage used for GitHub Packages in gigabytes.
     *
     * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
     *
     * Access tokens must have the `repo` or `admin:org` scope.
     */
    get: operations["billing/get-github-packages-billing-org"];
  };
  "/orgs/{org}/settings/billing/shared-storage": {
    /**
     * Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.
     *
     * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
     *
     * Access tokens must have the `repo` or `admin:org` scope.
     */
    get: operations["billing/get-shared-storage-billing-org"];
  };
  "/orgs/{org}/team-sync/groups": {
    /**
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * List IdP groups available in an organization. You can limit your page results using the `per_page` parameter. GitHub generates a url-encoded `page` token using a cursor value for where the next page begins. For more information on cursor pagination, see "[Offset and Cursor Pagination explained](https://dev.to/jackmarchant/offset-and-cursor-pagination-explained-b89)."
     */
    get: operations["teams/list-idp-groups-for-org"];
  };
  "/orgs/{org}/teams": {
    /** Lists all teams in an organization that are visible to the authenticated user. */
    get: operations["teams/list"];
    /**
     * To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://docs.github.com/en/articles/setting-team-creation-permissions-in-your-organization)."
     *
     * When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://docs.github.com/en/github/setting-up-and-managing-organizations-and-teams/about-teams)".
     */
    post: operations["teams/create"];
  };
  "/orgs/{org}/teams/{team_slug}": {
    /**
     * Gets a team using the team's `slug`. GitHub generates the `slug` from the team `name`.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
     */
    get: operations["teams/get-by-name"];
    /**
     * To delete a team, the authenticated user must be an organization owner or team maintainer.
     *
     * If you are an organization owner, deleting a parent team will delete all of its child teams as well.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
     */
    delete: operations["teams/delete-in-org"];
    /**
     * To edit a team, the authenticated user must either be an organization owner or a team maintainer.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
     */
    patch: operations["teams/update-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions": {
    /**
     * List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
     */
    get: operations["teams/list-discussions-in-org"];
    /**
     * Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
     */
    post: operations["teams/create-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}": {
    /**
     * Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
     */
    get: operations["teams/get-discussion-in-org"];
    /**
     * Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
     */
    delete: operations["teams/delete-discussion-in-org"];
    /**
     * Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
     */
    patch: operations["teams/update-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments": {
    /**
     * List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
     */
    get: operations["teams/list-discussion-comments-in-org"];
    /**
     * Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
     */
    post: operations["teams/create-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}": {
    /**
     * Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
     */
    get: operations["teams/get-discussion-comment-in-org"];
    /**
     * Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
     */
    delete: operations["teams/delete-discussion-comment-in-org"];
    /**
     * Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
     */
    patch: operations["teams/update-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions": {
    /**
     * List the reactions to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments/). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
     */
    get: operations["reactions/list-for-team-discussion-comment-in-org"];
    /**
     * Create a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
     */
    post: operations["reactions/create-for-team-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.
     *
     * Delete a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    delete: operations["reactions/delete-for-team-discussion-comment"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions": {
    /**
     * List the reactions to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
     */
    get: operations["reactions/list-for-team-discussion-in-org"];
    /**
     * Create a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
     */
    post: operations["reactions/create-for-team-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.
     *
     * Delete a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    delete: operations["reactions/delete-for-team-discussion"];
  };
  "/orgs/{org}/teams/{team_slug}/external-groups": {
    /**
     * Lists a connection between a team and an external group.
     *
     * You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.
     */
    get: operations["teams/list-linked-external-idp-groups-to-team-for-org"];
    /**
     * Deletes a connection between a team and an external group.
     *
     * You can manage team membership with your IdP using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     */
    delete: operations["teams/unlink-external-idp-group-from-team-for-org"];
    /**
     * Creates a connection between a team and an external group.  Only one external group can be linked to a team.
     *
     * You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.
     */
    patch: operations["teams/link-external-idp-group-to-team-for-org"];
  };
  "/orgs/{org}/teams/{team_slug}/invitations": {
    /**
     * The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/invitations`.
     */
    get: operations["teams/list-pending-invitations-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/members": {
    /**
     * Team members will include the members of child teams.
     *
     * To list members in a team, the team must be visible to the authenticated user.
     */
    get: operations["teams/list-members-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/memberships/{username}": {
    /**
     * Team members will include the members of child teams.
     *
     * To get a user's membership with a team, the team must be visible to the authenticated user.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.
     *
     * **Note:**
     * The response contains the `state` of the membership and the member's `role`.
     *
     * The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see see [Create a team](https://docs.github.com/rest/reference/teams#create-a-team).
     */
    get: operations["teams/get-membership-for-user-in-org"];
    /**
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.
     *
     * If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.
     */
    put: operations["teams/add-or-update-membership-for-user-in-org"];
    /**
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.
     */
    delete: operations["teams/remove-membership-for-user-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/projects": {
    /**
     * Lists the organization projects for a team.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects`.
     */
    get: operations["teams/list-projects-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/projects/{project_id}": {
    /**
     * Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
     */
    get: operations["teams/check-permissions-for-project-in-org"];
    /**
     * Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
     */
    put: operations["teams/add-or-update-project-permissions-in-org"];
    /**
     * Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. This endpoint removes the project from the team, but does not delete the project.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
     */
    delete: operations["teams/remove-project-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/repos": {
    /**
     * Lists a team's repositories visible to the authenticated user.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.
     */
    get: operations["teams/list-repos-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}": {
    /**
     * Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.
     *
     * You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `application/vnd.github.v3.repository+json` accept header.
     *
     * If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
     */
    get: operations["teams/check-permissions-for-repo-in-org"];
    /**
     * To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
     *
     * For more information about the permission levels, see "[Repository permission levels for an organization](https://docs.github.com/en/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
     */
    put: operations["teams/add-or-update-repo-permissions-in-org"];
    /**
     * If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
     */
    delete: operations["teams/remove-repo-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/team-sync/group-mappings": {
    /**
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * List IdP groups connected to a team on GitHub.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.
     */
    get: operations["teams/list-idp-groups-in-org"];
    /**
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.
     */
    patch: operations["teams/create-or-update-idp-group-connections-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/teams": {
    /**
     * Lists the child teams of the team specified by `{team_slug}`.
     *
     * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.
     */
    get: operations["teams/list-child-in-org"];
  };
  "/projects/columns/cards/{card_id}": {
    get: operations["projects/get-card"];
    delete: operations["projects/delete-card"];
    patch: operations["projects/update-card"];
  };
  "/projects/columns/cards/{card_id}/moves": {
    post: operations["projects/move-card"];
  };
  "/projects/columns/{column_id}": {
    get: operations["projects/get-column"];
    delete: operations["projects/delete-column"];
    patch: operations["projects/update-column"];
  };
  "/projects/columns/{column_id}/cards": {
    get: operations["projects/list-cards"];
    post: operations["projects/create-card"];
  };
  "/projects/columns/{column_id}/moves": {
    post: operations["projects/move-column"];
  };
  "/projects/{project_id}": {
    /** Gets a project by its `id`. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    get: operations["projects/get"];
    /** Deletes a project board. Returns a `404 Not Found` status if projects are disabled. */
    delete: operations["projects/delete"];
    /** Updates a project board's information. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    patch: operations["projects/update"];
  };
  "/projects/{project_id}/collaborators": {
    /** Lists the collaborators for an organization project. For a project, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners. You must be an organization owner or a project `admin` to list collaborators. */
    get: operations["projects/list-collaborators"];
  };
  "/projects/{project_id}/collaborators/{username}": {
    /** Adds a collaborator to an organization project and sets their permission level. You must be an organization owner or a project `admin` to add a collaborator. */
    put: operations["projects/add-collaborator"];
    /** Removes a collaborator from an organization project. You must be an organization owner or a project `admin` to remove a collaborator. */
    delete: operations["projects/remove-collaborator"];
  };
  "/projects/{project_id}/collaborators/{username}/permission": {
    /** Returns the collaborator's permission level for an organization project. Possible values for the `permission` key: `admin`, `write`, `read`, `none`. You must be an organization owner or a project `admin` to review a user's permission level. */
    get: operations["projects/get-permission-for-user"];
  };
  "/projects/{project_id}/columns": {
    get: operations["projects/list-columns"];
    post: operations["projects/create-column"];
  };
  "/rate_limit": {
    /**
     * **Note:** Accessing this endpoint does not count against your REST API rate limit.
     *
     * **Note:** The `rate` object is deprecated. If you're writing new API client code or updating existing code, you should use the `core` object instead of the `rate` object. The `core` object contains the same information that is present in the `rate` object.
     */
    get: operations["rate-limit/get"];
  };
  "/repos/{owner}/{repo}": {
    /** The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network. */
    get: operations["repos/get"];
    /**
     * Deleting a repository requires admin access. If OAuth is used, the `delete_repo` scope is required.
     *
     * If an organization owner has configured the organization to prevent members from deleting organization-owned
     * repositories, you will get a `403 Forbidden` response.
     */
    delete: operations["repos/delete"];
    /** **Note**: To edit a repository's topics, use the [Replace all repository topics](https://docs.github.com/rest/reference/repos#replace-all-repository-topics) endpoint. */
    patch: operations["repos/update"];
  };
  "/repos/{owner}/{repo}/actions/artifacts": {
    /** Lists all artifacts for a repository. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/list-artifacts-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/artifacts/{artifact_id}": {
    /** Gets a specific artifact for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/get-artifact"];
    /** Deletes an artifact for a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. */
    delete: operations["actions/delete-artifact"];
  };
  "/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}": {
    /**
     * Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
     * the response header to find the URL for the download. The `:archive_format` must be `zip`. Anyone with read access to
     * the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
     * GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/download-artifact"];
  };
  "/repos/{owner}/{repo}/actions/cache/usage": {
    /**
     * Gets GitHub Actions cache usage for a repository.
     * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
     * Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/get-actions-cache-usage"];
  };
  "/repos/{owner}/{repo}/actions/caches": {
    /**
     * Lists the GitHub Actions caches for a repository.
     * You must authenticate using an access token with the `repo` scope to use this endpoint.
     * GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/get-actions-cache-list"];
    /**
     * Deletes one or more GitHub Actions caches for a repository, using a complete cache key. By default, all caches that match the provided key are deleted, but you can optionally provide a Git ref to restrict deletions to caches that match both the provided key and the Git ref.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint.
     *
     * GitHub Apps must have the `actions:write` permission to use this endpoint.
     */
    delete: operations["actions/delete-actions-cache-by-key"];
  };
  "/repos/{owner}/{repo}/actions/caches/{cache_id}": {
    /**
     * Deletes a GitHub Actions cache for a repository, using a cache ID.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint.
     *
     * GitHub Apps must have the `actions:write` permission to use this endpoint.
     */
    delete: operations["actions/delete-actions-cache-by-id"];
  };
  "/repos/{owner}/{repo}/actions/jobs/{job_id}": {
    /** Gets a specific job in a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/get-job-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/jobs/{job_id}/logs": {
    /**
     * Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
     * for `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can
     * use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must
     * have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/download-job-logs-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/jobs/{job_id}/rerun": {
    /** Re-run a job and its dependent jobs in a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. */
    post: operations["actions/re-run-job-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/oidc/customization/sub": {
    /**
     * Gets the `opt-out` flag of a GitHub Actions OpenID Connect (OIDC) subject claim customization for a repository.
     * You must authenticate using an access token with the `repo` scope to use this
     * endpoint. GitHub Apps must have the `organization_administration:read` permission to use this endpoint.
     */
    get: operations["actions/get-custom-oidc-sub-claim-for-repo"];
    /**
     * Sets the `opt-out` flag of a GitHub Actions OpenID Connect (OIDC) subject claim customization for a repository.
     * You must authenticate using an access token with the `repo` scope to use this
     * endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
     */
    put: operations["actions/set-custom-oidc-sub-claim-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/permissions": {
    /**
     * Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions and reusable workflows allowed to run in the repository.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
     */
    get: operations["actions/get-github-actions-permissions-repository"];
    /**
     * Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions and reusable workflows in the repository.
     *
     * If the repository belongs to an organization or enterprise that has set restrictive permissions at the organization or enterprise levels, such as `allowed_actions` to `selected` actions and reusable workflows, then you cannot override them for the repository.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
     */
    put: operations["actions/set-github-actions-permissions-repository"];
  };
  "/repos/{owner}/{repo}/actions/permissions/access": {
    /**
     * Gets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
     * This endpoint only applies to internal repositories. For more information, see "[Managing GitHub Actions settings for a repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-an-internal-repository)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the
     * repository `administration` permission to use this endpoint.
     */
    get: operations["actions/get-workflow-access-to-repository"];
    /**
     * Sets the level of access that workflows outside of the repository have to actions and reusable workflows in the repository.
     * This endpoint only applies to internal repositories. For more information, see "[Managing GitHub Actions settings for a repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#allowing-access-to-components-in-an-internal-repository)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the
     * repository `administration` permission to use this endpoint.
     */
    put: operations["actions/set-workflow-access-to-repository"];
  };
  "/repos/{owner}/{repo}/actions/permissions/selected-actions": {
    /**
     * Gets the settings for selected actions and reusable workflows that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
     */
    get: operations["actions/get-allowed-actions-repository"];
    /**
     * Sets the actions and reusable workflows that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
     *
     * If the repository belongs to an organization or enterprise that has `selected` actions and reusable workflows set at the organization or enterprise levels, then you cannot override any of the allowed actions and reusable workflows settings.
     *
     * To use the `patterns_allowed` setting for private repositories, the repository must belong to an enterprise. If the repository does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
     */
    put: operations["actions/set-allowed-actions-repository"];
  };
  "/repos/{owner}/{repo}/actions/permissions/workflow": {
    /**
     * Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository,
     * as well as if GitHub Actions can submit approving pull request reviews.
     * For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the repository `administration` permission to use this API.
     */
    get: operations["actions/get-github-actions-default-workflow-permissions-repository"];
    /**
     * Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in a repository, and sets if GitHub Actions
     * can submit approving pull request reviews.
     * For more information, see "[Setting the permissions of the GITHUB_TOKEN for your repository](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/enabling-features-for-your-repository/managing-github-actions-settings-for-a-repository#setting-the-permissions-of-the-github_token-for-your-repository)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the repository `administration` permission to use this API.
     */
    put: operations["actions/set-github-actions-default-workflow-permissions-repository"];
  };
  "/repos/{owner}/{repo}/actions/runners": {
    /** Lists all self-hosted runners configured in a repository. You must authenticate using an access token with the `repo` scope to use this endpoint. */
    get: operations["actions/list-self-hosted-runners-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/downloads": {
    /**
     * Lists binaries for the runner application that you can download and run.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint.
     */
    get: operations["actions/list-runner-applications-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/registration-token": {
    /**
     * Returns a token that you can pass to the `config` script. The token expires after one hour. You must authenticate
     * using an access token with the `repo` scope to use this endpoint.
     *
     * #### Example using registration token
     *
     * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
     *
     * ```
     * ./config.sh --url https://github.com/octo-org/octo-repo-artifacts --token TOKEN
     * ```
     */
    post: operations["actions/create-registration-token-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/remove-token": {
    /**
     * Returns a token that you can pass to remove a self-hosted runner from a repository. The token expires after one hour.
     * You must authenticate using an access token with the `repo` scope to use this endpoint.
     *
     * #### Example using remove token
     *
     * To remove your self-hosted runner from a repository, replace TOKEN with the remove token provided by this endpoint.
     *
     * ```
     * ./config.sh remove --token TOKEN
     * ```
     */
    post: operations["actions/create-remove-token-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/{runner_id}": {
    /**
     * Gets a specific self-hosted runner configured in a repository.
     *
     * You must authenticate using an access token with the `repo` scope to use this
     * endpoint.
     */
    get: operations["actions/get-self-hosted-runner-for-repo"];
    /**
     * Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
     *
     * You must authenticate using an access token with the `repo`
     * scope to use this endpoint.
     */
    delete: operations["actions/delete-self-hosted-runner-from-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/{runner_id}/labels": {
    /**
     * Lists all labels for a self-hosted runner configured in a repository.
     *
     * You must authenticate using an access token with the `repo` scope to use this
     * endpoint.
     */
    get: operations["actions/list-labels-for-self-hosted-runner-for-repo"];
    /**
     * Remove all previous custom labels and set the new custom labels for a specific
     * self-hosted runner configured in a repository.
     *
     * You must authenticate using an access token with the `repo` scope to use this
     * endpoint.
     */
    put: operations["actions/set-custom-labels-for-self-hosted-runner-for-repo"];
    /**
     * Add custom labels to a self-hosted runner configured in a repository.
     *
     * You must authenticate using an access token with the `repo` scope to use this
     * endpoint.
     */
    post: operations["actions/add-custom-labels-to-self-hosted-runner-for-repo"];
    /**
     * Remove all custom labels from a self-hosted runner configured in a
     * repository. Returns the remaining read-only labels from the runner.
     *
     * You must authenticate using an access token with the `repo` scope to use this
     * endpoint.
     */
    delete: operations["actions/remove-all-custom-labels-from-self-hosted-runner-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/{runner_id}/labels/{name}": {
    /**
     * Remove a custom label from a self-hosted runner configured
     * in a repository. Returns the remaining labels from the runner.
     *
     * This endpoint returns a `404 Not Found` status if the custom label is not
     * present on the runner.
     *
     * You must authenticate using an access token with the `repo` scope to use this
     * endpoint.
     */
    delete: operations["actions/remove-custom-label-from-self-hosted-runner-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runs": {
    /**
     * Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/list-workflow-runs-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}": {
    /** Gets a specific workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/get-workflow-run"];
    /**
     * Delete a specific workflow run. Anyone with write access to the repository can use this endpoint. If the repository is
     * private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:write` permission to use
     * this endpoint.
     */
    delete: operations["actions/delete-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/approvals": {
    /** Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/get-reviews-for-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/approve": {
    /**
     * Approves a workflow run for a pull request from a public fork of a first time contributor. For more information, see ["Approving workflow runs from public forks](https://docs.github.com/actions/managing-workflow-runs/approving-workflow-runs-from-public-forks)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
     */
    post: operations["actions/approve-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts": {
    /** Lists artifacts for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/list-workflow-run-artifacts"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}": {
    /**
     * Gets a specific workflow run attempt. Anyone with read access to the repository
     * can use this endpoint. If the repository is private you must use an access token
     * with the `repo` scope. GitHub Apps must have the `actions:read` permission to
     * use this endpoint.
     */
    get: operations["actions/get-workflow-run-attempt"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/jobs": {
    /** Lists jobs for a specific workflow run attempt. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters). */
    get: operations["actions/list-jobs-for-workflow-run-attempt"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/attempts/{attempt_number}/logs": {
    /**
     * Gets a redirect URL to download an archive of log files for a specific workflow run attempt. This link expires after
     * 1 minute. Look for `Location:` in the response header to find the URL for the download. Anyone with read access to
     * the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
     * GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/download-workflow-run-attempt-logs"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/cancel": {
    /** Cancels a workflow run using its `id`. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. */
    post: operations["actions/cancel-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/jobs": {
    /** Lists jobs for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters). */
    get: operations["actions/list-jobs-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/logs": {
    /**
     * Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
     * `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can use
     * this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have
     * the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/download-workflow-run-logs"];
    /** Deletes all logs for a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. */
    delete: operations["actions/delete-workflow-run-logs"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/pending_deployments": {
    /**
     * Get all deployment environments for a workflow run that are waiting for protection rules to pass.
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/get-pending-deployments-for-run"];
    /**
     * Approve or reject pending deployments that are waiting on approval by a required reviewer.
     *
     * Anyone with read access to the repository contents and deployments can use this endpoint.
     */
    post: operations["actions/review-pending-deployments-for-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/rerun": {
    /** Re-runs your workflow run using its `id`. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. */
    post: operations["actions/re-run-workflow"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/rerun-failed-jobs": {
    /** Re-run all of the failed jobs and their dependent jobs in a workflow run using the `id` of the workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. */
    post: operations["actions/re-run-workflow-failed-jobs"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/timing": {
    /**
     * Gets the number of billable minutes and total run time for a specific workflow run. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/get-workflow-run-usage"];
  };
  "/repos/{owner}/{repo}/actions/secrets": {
    /** Lists all secrets available in a repository without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/list-repo-secrets"];
  };
  "/repos/{owner}/{repo}/actions/secrets/public-key": {
    /** Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/get-repo-public-key"];
  };
  "/repos/{owner}/{repo}/actions/secrets/{secret_name}": {
    /** Gets a single repository secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/get-repo-secret"];
    /**
     * Creates or updates a repository secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use
     * this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["actions/create-or-update-repo-secret"];
    /** Deletes a secret in a repository using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    delete: operations["actions/delete-repo-secret"];
  };
  "/repos/{owner}/{repo}/actions/workflows": {
    /** Lists the workflows in a repository. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/list-repo-workflows"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}": {
    /** Gets a specific workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["actions/get-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable": {
    /**
     * Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
     */
    put: operations["actions/disable-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches": {
    /**
     * You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
     *
     * You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. For more information, see "[Creating a personal access token for the command line](https://docs.github.com/articles/creating-a-personal-access-token-for-the-command-line)."
     */
    post: operations["actions/create-workflow-dispatch"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable": {
    /**
     * Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
     *
     * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
     */
    put: operations["actions/enable-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs": {
    /**
     * List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
     */
    get: operations["actions/list-workflow-runs"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing": {
    /**
     * Gets the number of billable minutes used by a specific workflow during the current billing cycle. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
     *
     * You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["actions/get-workflow-usage"];
  };
  "/repos/{owner}/{repo}/assignees": {
    /** Lists the [available assignees](https://docs.github.com/articles/assigning-issues-and-pull-requests-to-other-github-users/) for issues in a repository. */
    get: operations["issues/list-assignees"];
  };
  "/repos/{owner}/{repo}/assignees/{assignee}": {
    /**
     * Checks if a user has permission to be assigned to an issue in this repository.
     *
     * If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
     *
     * Otherwise a `404` status code is returned.
     */
    get: operations["issues/check-user-can-be-assigned"];
  };
  "/repos/{owner}/{repo}/autolinks": {
    /**
     * This returns a list of autolinks configured for the given repository.
     *
     * Information about autolinks are only available to repository administrators.
     */
    get: operations["repos/list-autolinks"];
    /** Users with admin access to the repository can create an autolink. */
    post: operations["repos/create-autolink"];
  };
  "/repos/{owner}/{repo}/autolinks/{autolink_id}": {
    /**
     * This returns a single autolink reference by ID that was configured for the given repository.
     *
     * Information about autolinks are only available to repository administrators.
     */
    get: operations["repos/get-autolink"];
    /**
     * This deletes a single autolink reference by ID that was configured for the given repository.
     *
     * Information about autolinks are only available to repository administrators.
     */
    delete: operations["repos/delete-autolink"];
  };
  "/repos/{owner}/{repo}/automated-security-fixes": {
    /** Enables automated security fixes for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring automated security fixes](https://docs.github.com/en/articles/configuring-automated-security-fixes)". */
    put: operations["repos/enable-automated-security-fixes"];
    /** Disables automated security fixes for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring automated security fixes](https://docs.github.com/en/articles/configuring-automated-security-fixes)". */
    delete: operations["repos/disable-automated-security-fixes"];
  };
  "/repos/{owner}/{repo}/branches": {
    get: operations["repos/list-branches"];
  };
  "/repos/{owner}/{repo}/branches/{branch}": {
    get: operations["repos/get-branch"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection": {
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["repos/get-branch-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Protecting a branch requires admin or owner permissions to the repository.
     *
     * **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
     *
     * **Note**: The list of users, apps, and teams in total is limited to 100 items.
     */
    put: operations["repos/update-branch-protection"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    delete: operations["repos/delete-branch-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins": {
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["repos/get-admin-branch-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    post: operations["repos/set-admin-branch-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    delete: operations["repos/delete-admin-branch-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews": {
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["repos/get-pull-request-review-protection"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    delete: operations["repos/delete-pull-request-review-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
     *
     * **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
     */
    patch: operations["repos/update-pull-request-review-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://docs.github.com/articles/signing-commits-with-gpg) in GitHub Help.
     *
     * **Note**: You must enable branch protection to require signed commits.
     */
    get: operations["repos/get-commit-signature-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.
     */
    post: operations["repos/create-commit-signature-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.
     */
    delete: operations["repos/delete-commit-signature-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks": {
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["repos/get-status-checks-protection"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    delete: operations["repos/remove-status-check-protection"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.
     */
    patch: operations["repos/update-status-check-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts": {
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["repos/get-all-status-check-contexts"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    put: operations["repos/set-status-check-contexts"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    post: operations["repos/add-status-check-contexts"];
    /** Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    delete: operations["repos/remove-status-check-contexts"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists who has access to this protected branch.
     *
     * **Note**: Users, apps, and teams `restrictions` are only available for organization-owned repositories.
     */
    get: operations["repos/get-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Disables the ability to restrict who can push to this branch.
     */
    delete: operations["repos/delete-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists the GitHub Apps that have push access to this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
     */
    get: operations["repos/get-apps-with-access-to-protected-branch"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Replaces the list of apps that have push access to this branch. This removes all apps that previously had push access and grants push access to the new list of apps. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
     *
     * | Type    | Description                                                                                                                                                |
     * | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    put: operations["repos/set-app-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Grants the specified apps push access for this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
     *
     * | Type    | Description                                                                                                                                                |
     * | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    post: operations["repos/add-app-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removes the ability of an app to push to this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
     *
     * | Type    | Description                                                                                                                                                |
     * | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    delete: operations["repos/remove-app-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists the teams who have push access to this branch. The list includes child teams.
     */
    get: operations["repos/get-teams-with-access-to-protected-branch"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. Team restrictions include child teams.
     *
     * | Type    | Description                                                                                                                                |
     * | ------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
     * | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    put: operations["repos/set-team-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Grants the specified teams push access for this branch. You can also give push access to child teams.
     *
     * | Type    | Description                                                                                                                                |
     * | ------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
     * | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    post: operations["repos/add-team-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removes the ability of a team to push to this branch. You can also remove push access for child teams.
     *
     * | Type    | Description                                                                                                                                         |
     * | ------- | --------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Teams that should no longer have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    delete: operations["repos/remove-team-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists the people who have push access to this branch.
     */
    get: operations["repos/get-users-with-access-to-protected-branch"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.
     *
     * | Type    | Description                                                                                                                   |
     * | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    put: operations["repos/set-user-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Grants the specified people push access for this branch.
     *
     * | Type    | Description                                                                                                                   |
     * | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    post: operations["repos/add-user-access-restrictions"];
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Removes the ability of a user to push to this branch.
     *
     * | Type    | Description                                                                                                                                   |
     * | ------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
     * | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
     */
    delete: operations["repos/remove-user-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/rename": {
    /**
     * Renames a branch in a repository.
     *
     * **Note:** Although the API responds immediately, the branch rename process might take some extra time to complete in the background. You won't be able to push to the old branch name while the rename process is in progress. For more information, see "[Renaming a branch](https://docs.github.com/github/administering-a-repository/renaming-a-branch)".
     *
     * The permissions required to use this endpoint depends on whether you are renaming the default branch.
     *
     * To rename a non-default branch:
     *
     * * Users must have push access.
     * * GitHub Apps must have the `contents:write` repository permission.
     *
     * To rename the default branch:
     *
     * * Users must have admin or owner permissions.
     * * GitHub Apps must have the `administration:write` repository permission.
     */
    post: operations["repos/rename-branch"];
  };
  "/repos/{owner}/{repo}/check-runs": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Creates a new check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to create check runs.
     *
     * In a check suite, GitHub limits the number of check runs with the same name to 1000. Once these check runs exceed 1000, GitHub will start to automatically delete older check runs.
     */
    post: operations["checks/create"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Gets a single check run using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    get: operations["checks/get"];
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Updates a check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to edit check runs.
     */
    patch: operations["checks/update"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations": {
    /** Lists annotations for a check run using the annotation `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get annotations for a check run. OAuth Apps and authenticated users must have the `repo` scope to get annotations for a check run in a private repository. */
    get: operations["checks/list-annotations"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}/rerequest": {
    /**
     * Triggers GitHub to rerequest an existing check run, without pushing new code to a repository. This endpoint will trigger the [`check_run` webhook](https://docs.github.com/webhooks/event-payloads/#check_run) event with the action `rerequested`. When a check run is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
     *
     * To rerequest a check run, your GitHub App must have the `checks:read` permission on a private repository or pull access to a public repository.
     */
    post: operations["checks/rerequest-run"];
  };
  "/repos/{owner}/{repo}/check-suites": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * By default, check suites are automatically created when you create a [check run](https://docs.github.com/rest/reference/checks#check-runs). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Update repository preferences for check suites](https://docs.github.com/rest/reference/checks#update-repository-preferences-for-check-suites)". Your GitHub App must have the `checks:write` permission to create check suites.
     */
    post: operations["checks/create-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/preferences": {
    /** Changes the default automatic flow when creating check suites. By default, a check suite is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://docs.github.com/rest/reference/checks#create-a-check-suite). You must have admin permissions in the repository to set preferences for check suites. */
    patch: operations["checks/set-suites-preferences"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * Gets a single check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
     */
    get: operations["checks/get-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Lists check runs for a check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    get: operations["checks/list-for-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest": {
    /**
     * Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://docs.github.com/webhooks/event-payloads/#check_suite) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
     *
     * To rerequest a check suite, your GitHub App must have the `checks:read` permission on a private repository or pull access to a public repository.
     */
    post: operations["checks/rerequest-suite"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts": {
    /**
     * Lists all open code scanning alerts for the default branch (usually `main`
     * or `master`). You must use an access token with the `security_events` scope to use
     * this endpoint with private repos, the `public_repo` scope also grants permission to read
     * security events on public repos only. GitHub Apps must have the `security_events` read
     * permission to use this endpoint.
     *
     * The response includes a `most_recent_instance` object.
     * This provides details of the most recent instance of this alert
     * for the default branch or for the specified Git reference
     * (if you used `ref` in the request).
     */
    get: operations["code-scanning/list-alerts-for-repo"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}": {
    /**
     * Gets a single code scanning alert. You must use an access token with the `security_events` scope to use this endpoint with private repos, the `public_repo` scope also grants permission to read security events on public repos only. GitHub Apps must have the `security_events` read permission to use this endpoint.
     *
     * **Deprecation notice**:
     * The instances field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The same information can now be retrieved via a GET request to the URL specified by `instances_url`.
     */
    get: operations["code-scanning/get-alert"];
    /** Updates the status of a single code scanning alert. You must use an access token with the `security_events` scope to use this endpoint with private repositories. You can also use tokens with the `public_repo` scope for public repositories only. GitHub Apps must have the `security_events` write permission to use this endpoint. */
    patch: operations["code-scanning/update-alert"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}/instances": {
    /**
     * Lists all instances of the specified code scanning alert.
     * You must use an access token with the `security_events` scope to use this endpoint with private repos,
     * the `public_repo` scope also grants permission to read security events on public repos only.
     * GitHub Apps must have the `security_events` read permission to use this endpoint.
     */
    get: operations["code-scanning/list-alert-instances"];
  };
  "/repos/{owner}/{repo}/code-scanning/analyses": {
    /**
     * Lists the details of all code scanning analyses for a repository,
     * starting with the most recent.
     * The response is paginated and you can use the `page` and `per_page` parameters
     * to list the analyses you're interested in.
     * By default 30 analyses are listed per page.
     *
     * The `rules_count` field in the response give the number of rules
     * that were run in the analysis.
     * For very old analyses this data is not available,
     * and `0` is returned in this field.
     *
     * You must use an access token with the `security_events` scope to use this endpoint with private repos,
     * the `public_repo` scope also grants permission to read security events on public repos only.
     * GitHub Apps must have the `security_events` read permission to use this endpoint.
     *
     * **Deprecation notice**:
     * The `tool_name` field is deprecated and will, in future, not be included in the response for this endpoint. The example response reflects this change. The tool name can now be found inside the `tool` field.
     */
    get: operations["code-scanning/list-recent-analyses"];
  };
  "/repos/{owner}/{repo}/code-scanning/analyses/{analysis_id}": {
    /**
     * Gets a specified code scanning analysis for a repository.
     * You must use an access token with the `security_events` scope to use this endpoint with private repos,
     * the `public_repo` scope also grants permission to read security events on public repos only.
     * GitHub Apps must have the `security_events` read permission to use this endpoint.
     *
     * The default JSON response contains fields that describe the analysis.
     * This includes the Git reference and commit SHA to which the analysis relates,
     * the datetime of the analysis, the name of the code scanning tool,
     * and the number of alerts.
     *
     * The `rules_count` field in the default response give the number of rules
     * that were run in the analysis.
     * For very old analyses this data is not available,
     * and `0` is returned in this field.
     *
     * If you use the Accept header `application/sarif+json`,
     * the response contains the analysis data that was uploaded.
     * This is formatted as
     * [SARIF version 2.1.0](https://docs.oasis-open.org/sarif/sarif/v2.1.0/cs01/sarif-v2.1.0-cs01.html).
     */
    get: operations["code-scanning/get-analysis"];
    /**
     * Deletes a specified code scanning analysis from a repository. For
     * private repositories, you must use an access token with the `repo` scope. For public repositories,
     * you must use an access token with `public_repo` scope.
     * GitHub Apps must have the `security_events` write permission to use this endpoint.
     *
     * You can delete one analysis at a time.
     * To delete a series of analyses, start with the most recent analysis and work backwards.
     * Conceptually, the process is similar to the undo function in a text editor.
     *
     * When you list the analyses for a repository,
     * one or more will be identified as deletable in the response:
     *
     * ```
     * "deletable": true
     * ```
     *
     * An analysis is deletable when it's the most recent in a set of analyses.
     * Typically, a repository will have multiple sets of analyses
     * for each enabled code scanning tool,
     * where a set is determined by a unique combination of analysis values:
     *
     * * `ref`
     * * `tool`
     * * `analysis_key`
     * * `environment`
     *
     * If you attempt to delete an analysis that is not the most recent in a set,
     * you'll get a 400 response with the message:
     *
     * ```
     * Analysis specified is not deletable.
     * ```
     *
     * The response from a successful `DELETE` operation provides you with
     * two alternative URLs for deleting the next analysis in the set:
     * `next_analysis_url` and `confirm_delete_url`.
     * Use the `next_analysis_url` URL if you want to avoid accidentally deleting the final analysis
     * in a set. This is a useful option if you want to preserve at least one analysis
     * for the specified tool in your repository.
     * Use the `confirm_delete_url` URL if you are content to remove all analyses for a tool.
     * When you delete the last analysis in a set, the value of `next_analysis_url` and `confirm_delete_url`
     * in the 200 response is `null`.
     *
     * As an example of the deletion process,
     * let's imagine that you added a workflow that configured a particular code scanning tool
     * to analyze the code in a repository. This tool has added 15 analyses:
     * 10 on the default branch, and another 5 on a topic branch.
     * You therefore have two separate sets of analyses for this tool.
     * You've now decided that you want to remove all of the analyses for the tool.
     * To do this you must make 15 separate deletion requests.
     * To start, you must find an analysis that's identified as deletable.
     * Each set of analyses always has one that's identified as deletable.
     * Having found the deletable analysis for one of the two sets,
     * delete this analysis and then continue deleting the next analysis in the set until they're all deleted.
     * Then repeat the process for the second set.
     * The procedure therefore consists of a nested loop:
     *
     * **Outer loop**:
     * * List the analyses for the repository, filtered by tool.
     * * Parse this list to find a deletable analysis. If found:
     *
     *   **Inner loop**:
     *   * Delete the identified analysis.
     *   * Parse the response for the value of `confirm_delete_url` and, if found, use this in the next iteration.
     *
     * The above process assumes that you want to remove all trace of the tool's analyses from the GitHub user interface, for the specified repository, and it therefore uses the `confirm_delete_url` value. Alternatively, you could use the `next_analysis_url` value, which would leave the last analysis in each set undeleted to avoid removing a tool's analysis entirely.
     */
    delete: operations["code-scanning/delete-analysis"];
  };
  "/repos/{owner}/{repo}/code-scanning/sarifs": {
    /**
     * Uploads SARIF data containing the results of a code scanning analysis to make the results available in a repository. You must use an access token with the `security_events` scope to use this endpoint for private repositories. You can also use tokens with the `public_repo` scope for public repositories only. GitHub Apps must have the `security_events` write permission to use this endpoint.
     *
     * There are two places where you can upload code scanning results.
     *  - If you upload to a pull request, for example `--ref refs/pull/42/merge` or `--ref refs/pull/42/head`, then the results appear as alerts in a pull request check. For more information, see "[Triaging code scanning alerts in pull requests](/code-security/secure-coding/triaging-code-scanning-alerts-in-pull-requests)."
     *  - If you upload to a branch, for example `--ref refs/heads/my-branch`, then the results appear in the **Security** tab for your repository. For more information, see "[Managing code scanning alerts for your repository](/code-security/secure-coding/managing-code-scanning-alerts-for-your-repository#viewing-the-alerts-for-a-repository)."
     *
     * You must compress the SARIF-formatted analysis data that you want to upload, using `gzip`, and then encode it as a Base64 format string. For example:
     *
     * ```
     * gzip -c analysis-data.sarif | base64 -w0
     * ```
     *
     * SARIF upload supports a maximum of 5000 results per analysis run. Any results over this limit are ignored and any SARIF uploads with more than 25,000 results are rejected. Typically, but not necessarily, a SARIF file contains a single run of a single tool. If a code scanning tool generates too many results, you should update the analysis configuration to run only the most important rules or queries.
     *
     * The `202 Accepted`, response includes an `id` value.
     * You can use this ID to check the status of the upload by using this for the `/sarifs/{sarif_id}` endpoint.
     * For more information, see "[Get information about a SARIF upload](/rest/reference/code-scanning#get-information-about-a-sarif-upload)."
     */
    post: operations["code-scanning/upload-sarif"];
  };
  "/repos/{owner}/{repo}/code-scanning/sarifs/{sarif_id}": {
    /** Gets information about a SARIF upload, including the status and the URL of the analysis that was uploaded so that you can retrieve details of the analysis. For more information, see "[Get a code scanning analysis for a repository](/rest/reference/code-scanning#get-a-code-scanning-analysis-for-a-repository)." You must use an access token with the `security_events` scope to use this endpoint with private repos, the `public_repo` scope also grants permission to read security events on public repos only. GitHub Apps must have the `security_events` read permission to use this endpoint. */
    get: operations["code-scanning/get-sarif"];
  };
  "/repos/{owner}/{repo}/codeowners/errors": {
    /**
     * List any syntax errors that are detected in the CODEOWNERS
     * file.
     *
     * For more information about the correct CODEOWNERS syntax,
     * see "[About code owners](https://docs.github.com/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/about-code-owners)."
     */
    get: operations["repos/codeowners-errors"];
  };
  "/repos/{owner}/{repo}/codespaces": {
    /**
     * Lists the codespaces associated to a specified repository and the authenticated user.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces` repository permission to use this endpoint.
     */
    get: operations["codespaces/list-in-repository-for-authenticated-user"];
    /**
     * Creates a codespace owned by the authenticated user in the specified repository.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces` repository permission to use this endpoint.
     */
    post: operations["codespaces/create-with-repo-for-authenticated-user"];
  };
  "/repos/{owner}/{repo}/codespaces/devcontainers": {
    /**
     * Lists the devcontainer.json files associated with a specified repository and the authenticated user. These files
     * specify launchpoint configurations for codespaces created within the repository.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces_metadata` repository permission to use this endpoint.
     */
    get: operations["codespaces/list-devcontainers-in-repository-for-authenticated-user"];
  };
  "/repos/{owner}/{repo}/codespaces/machines": {
    /**
     * List the machine types available for a given repository based on its configuration.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces_metadata` repository permission to use this endpoint.
     */
    get: operations["codespaces/repo-machines-for-authenticated-user"];
  };
  "/repos/{owner}/{repo}/codespaces/secrets": {
    /** Lists all secrets available in a repository without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `codespaces_secrets` repository permission to use this endpoint. */
    get: operations["codespaces/list-repo-secrets"];
  };
  "/repos/{owner}/{repo}/codespaces/secrets/public-key": {
    /** Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `codespaces_secrets` repository permission to use this endpoint. */
    get: operations["codespaces/get-repo-public-key"];
  };
  "/repos/{owner}/{repo}/codespaces/secrets/{secret_name}": {
    /** Gets a single repository secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `codespaces_secrets` repository permission to use this endpoint. */
    get: operations["codespaces/get-repo-secret"];
    /**
     * Creates or updates a repository secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `repo` scope to use this endpoint. GitHub Apps must have the `codespaces_secrets` repository
     * permission to use this endpoint.
     *
     * #### Example of encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example of encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example of encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example of encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["codespaces/create-or-update-repo-secret"];
    /** Deletes a secret in a repository using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `codespaces_secrets` repository permission to use this endpoint. */
    delete: operations["codespaces/delete-repo-secret"];
  };
  "/repos/{owner}/{repo}/collaborators": {
    /**
     * For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
     * Organization members with write, maintain, or admin privileges on the organization-owned repository can use this endpoint.
     *
     * Team members will include the members of child teams.
     *
     * You must authenticate using an access token with the `read:org` and `repo` scopes with push access to use this
     * endpoint. GitHub Apps must have the `members` organization permission and `metadata` repository permission to use this
     * endpoint.
     */
    get: operations["repos/list-collaborators"];
  };
  "/repos/{owner}/{repo}/collaborators/{username}": {
    /**
     * For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
     *
     * Team members will include the members of child teams.
     *
     * You must authenticate using an access token with the `read:org` and `repo` scopes with push access to use this
     * endpoint. GitHub Apps must have the `members` organization permission and `metadata` repository permission to use this
     * endpoint.
     */
    get: operations["repos/check-collaborator"];
    /**
     * This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     *
     * Adding an outside collaborator may be restricted by enterprise administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/enterprise-cloud@latest/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)."
     *
     * For more information on permission levels, see "[Repository permission levels for an organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)". There are restrictions on which permissions can be granted to organization members when an organization base role is in place. In this case, the permission being given must be equal to or higher than the org base permission. Otherwise, the request will fail with:
     *
     * ```
     * Cannot assign {member} permission of {role name}
     * ```
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
     *
     * The invitee will receive a notification that they have been invited to the repository, which they must accept or decline. They may do this via the notifications page, the email they receive, or by using the [repository invitations API endpoints](https://docs.github.com/rest/reference/repos#invitations).
     *
     * **Updating an existing collaborator's permission level**
     *
     * The endpoint can also be used to change the permissions of an existing collaborator without first removing and re-adding the collaborator. To change the permissions, use the same endpoint and pass a different `permission` parameter. The response will be a `204`, with no other indication that the permission level changed.
     *
     * **Rate limits**
     *
     * You are limited to sending 50 invitations to a repository per 24 hour period. Note there is no limit if you are inviting organization members to an organization repository.
     */
    put: operations["repos/add-collaborator"];
    delete: operations["repos/remove-collaborator"];
  };
  "/repos/{owner}/{repo}/collaborators/{username}/permission": {
    /** Checks the repository permission of a collaborator. The possible repository permissions are `admin`, `write`, `read`, and `none`. */
    get: operations["repos/get-collaborator-permission-level"];
  };
  "/repos/{owner}/{repo}/comments": {
    /**
     * Commit Comments use [these custom media types](https://docs.github.com/rest/reference/repos#custom-media-types). You can read more about the use of media types in the API [here](https://docs.github.com/rest/overview/media-types/).
     *
     * Comments are ordered by ascending ID.
     */
    get: operations["repos/list-commit-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}": {
    get: operations["repos/get-commit-comment"];
    delete: operations["repos/delete-commit-comment"];
    patch: operations["repos/update-commit-comment"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}/reactions": {
    /** List the reactions to a [commit comment](https://docs.github.com/rest/reference/repos#comments). */
    get: operations["reactions/list-for-commit-comment"];
    /** Create a reaction to a [commit comment](https://docs.github.com/rest/reference/repos#comments). A response with an HTTP `200` status means that you already added the reaction type to this commit comment. */
    post: operations["reactions/create-for-commit-comment"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.
     *
     * Delete a reaction to a [commit comment](https://docs.github.com/rest/reference/repos#comments).
     */
    delete: operations["reactions/delete-for-commit-comment"];
  };
  "/repos/{owner}/{repo}/commits": {
    /**
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/list-commits"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head": {
    /**
     * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Returns all branches where the given commit SHA is the HEAD, or latest commit for the branch.
     */
    get: operations["repos/list-branches-for-head-commit"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/comments": {
    /** Use the `:commit_sha` to specify the commit that will have its comments listed. */
    get: operations["repos/list-comments-for-commit"];
    /**
     * Create a comment for a commit using its `:commit_sha`.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["repos/create-commit-comment"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/pulls": {
    /** Lists the merged pull request that introduced the commit to the repository. If the commit is not present in the default branch, additionally returns open pull requests associated with the commit. The results may include open and closed pull requests. */
    get: operations["repos/list-pull-requests-associated-with-commit"];
  };
  "/repos/{owner}/{repo}/commits/{ref}": {
    /**
     * Returns the contents of a single commit reference. You must have `read` access for the repository to use this endpoint.
     *
     * **Note:** If there are more than 300 files in the commit diff, the response will include pagination link headers for the remaining files, up to a limit of 3000 files. Each page contains the static commit information, and the only changes are to the file listing.
     *
     * You can pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to  fetch `diff` and `patch` formats. Diffs with binary data will have no `patch` property.
     *
     * To return only the SHA-1 hash of the commit reference, you can provide the `sha` custom [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) in the `Accept` header. You can use this endpoint to check if a remote reference's SHA-1 hash is the same as your local reference's SHA-1 hash by providing the local SHA-1 reference as the ETag.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/get-commit"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/check-runs": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
     *
     * Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
     */
    get: operations["checks/list-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/check-suites": {
    /**
     * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
     *
     * Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to list check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
     */
    get: operations["checks/list-suites-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/status": {
    /**
     * Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.
     *
     *
     * Additionally, a combined `state` is returned. The `state` is one of:
     *
     * *   **failure** if any of the contexts report as `error` or `failure`
     * *   **pending** if there are no statuses or a context is `pending`
     * *   **success** if the latest status for all contexts is `success`
     */
    get: operations["repos/get-combined-status-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/statuses": {
    /**
     * Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.
     *
     * This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.
     */
    get: operations["repos/list-commit-statuses-for-ref"];
  };
  "/repos/{owner}/{repo}/community/profile": {
    /**
     * This endpoint will return all community profile metrics, including an
     * overall health score, repository description, the presence of documentation, detected
     * code of conduct, detected license, and the presence of ISSUE\_TEMPLATE, PULL\_REQUEST\_TEMPLATE,
     * README, and CONTRIBUTING files.
     *
     * The `health_percentage` score is defined as a percentage of how many of
     * these four documents are present: README, CONTRIBUTING, LICENSE, and
     * CODE_OF_CONDUCT. For example, if all four documents are present, then
     * the `health_percentage` is `100`. If only one is present, then the
     * `health_percentage` is `25`.
     *
     * `content_reports_enabled` is only returned for organization-owned repositories.
     */
    get: operations["repos/get-community-profile-metrics"];
  };
  "/repos/{owner}/{repo}/compare/{basehead}": {
    /**
     * The `basehead` param is comprised of two parts: `base` and `head`. Both must be branch names in `repo`. To compare branches across other repositories in the same network as `repo`, use the format `<USERNAME>:branch`.
     *
     * The response from the API is equivalent to running the `git log base..head` command; however, commits are returned in chronological order. Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
     *
     * The response also includes details on the files that were changed between the two commits. This includes the status of the change (for example, if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
     *
     * **Working with large comparisons**
     *
     * To process a response with a large number of commits, you can use (`per_page` or `page`) to paginate the results. When using paging, the list of changed files is only returned with page 1, but includes all changed files for the entire comparison. For more information on working with pagination, see "[Traversing with pagination](/rest/guides/traversing-with-pagination)."
     *
     * When calling this API without any paging parameters (`per_page` or `page`), the returned list is limited to 250 commits and the last commit in the list is the most recent of the entire comparison. When a paging parameter is specified, the first commit in the returned list of each page is the earliest.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/compare-commits-with-basehead"];
  };
  "/repos/{owner}/{repo}/contents/{path}": {
    /**
     * Gets the contents of a file or directory in a repository. Specify the file path or directory in `:path`. If you omit
     * `:path`, you will receive the contents of the repository's root directory. See the description below regarding what the API response includes for directories.
     *
     * Files and symlinks support [a custom media type](https://docs.github.com/rest/reference/repos#custom-media-types) for
     * retrieving the raw content or rendered HTML (when supported). All content types support [a custom media
     * type](https://docs.github.com/rest/reference/repos#custom-media-types) to ensure the content is returned in a consistent
     * object format.
     *
     * **Note**:
     * *   To get a repository's contents recursively, you can [recursively get the tree](https://docs.github.com/rest/reference/git#trees).
     * *   This API has an upper limit of 1,000 files for a directory. If you need to retrieve more files, use the [Git Trees
     * API](https://docs.github.com/rest/reference/git#get-a-tree).
     *
     * #### Size limits
     * If the requested file's size is:
     * * 1 MB or smaller: All features of this endpoint are supported.
     * * Between 1-100 MB: Only the `raw` or `object` [custom media types](https://docs.github.com/rest/repos/contents#custom-media-types-for-repository-contents) are supported. Both will work as normal, except that when using the `object` media type, the `content` field will be an empty string and the `encoding` field will be `"none"`. To get the contents of these larger files, use the `raw` media type.
     *  * Greater than 100 MB: This endpoint is not supported.
     *
     * #### If the content is a directory
     * The response will be an array of objects, one object for each item in the directory.
     * When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value
     * _should_ be "submodule". This behavior exists in API v3 [for backwards compatibility purposes](https://git.io/v1YCW).
     * In the next major version of the API, the type will be returned as "submodule".
     *
     * #### If the content is a symlink
     * If the requested `:path` points to a symlink, and the symlink's target is a normal file in the repository, then the
     * API responds with the content of the file (in the format shown in the example. Otherwise, the API responds with an object
     * describing the symlink itself.
     *
     * #### If the content is a submodule
     * The `submodule_git_url` identifies the location of the submodule repository, and the `sha` identifies a specific
     * commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out
     * the submodule at that specific commit.
     *
     * If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the
     * github.com URLs (`html_url` and `_links["html"]`) will have null values.
     */
    get: operations["repos/get-content"];
    /** Creates a new file or replaces an existing file in a repository. */
    put: operations["repos/create-or-update-file-contents"];
    /**
     * Deletes a file in a repository.
     *
     * You can provide an additional `committer` parameter, which is an object containing information about the committer. Or, you can provide an `author` parameter, which is an object containing information about the author.
     *
     * The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.
     *
     * You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.
     */
    delete: operations["repos/delete-file"];
  };
  "/repos/{owner}/{repo}/contributors": {
    /**
     * Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API v3 caches contributor data to improve performance.
     *
     * GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.
     */
    get: operations["repos/list-contributors"];
  };
  "/repos/{owner}/{repo}/dependabot/secrets": {
    /** Lists all secrets available in a repository without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` repository permission to use this endpoint. */
    get: operations["dependabot/list-repo-secrets"];
  };
  "/repos/{owner}/{repo}/dependabot/secrets/public-key": {
    /** Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `dependabot_secrets` repository permission to use this endpoint. */
    get: operations["dependabot/get-repo-public-key"];
  };
  "/repos/{owner}/{repo}/dependabot/secrets/{secret_name}": {
    /** Gets a single repository secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` repository permission to use this endpoint. */
    get: operations["dependabot/get-repo-secret"];
    /**
     * Creates or updates a repository secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `repo` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` repository
     * permission to use this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["dependabot/create-or-update-repo-secret"];
    /** Deletes a secret in a repository using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` repository permission to use this endpoint. */
    delete: operations["dependabot/delete-repo-secret"];
  };
  "/repos/{owner}/{repo}/dependency-graph/compare/{basehead}": {
    /** Gets the diff of the dependency changes between two commits of a repository, based on the changes to the dependency manifests made in those commits. */
    get: operations["dependency-graph/diff-range"];
  };
  "/repos/{owner}/{repo}/dependency-graph/snapshots": {
    /** Create a new snapshot of a repository's dependencies. You must authenticate using an access token with the `repo` scope to use this endpoint for a repository that the requesting user has access to. */
    post: operations["dependency-graph/create-repository-snapshot"];
  };
  "/repos/{owner}/{repo}/deployments": {
    /** Simple filtering of deployments is available via query parameters: */
    get: operations["repos/list-deployments"];
    /**
     * Deployments offer a few configurable parameters with certain defaults.
     *
     * The `ref` parameter can be any named branch, tag, or SHA. At GitHub we often deploy branches and verify them
     * before we merge a pull request.
     *
     * The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have
     * multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter
     * makes it easier to track which environments have requested deployments. The default environment is `production`.
     *
     * The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If
     * the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds,
     * the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will
     * return a failure response.
     *
     * By default, [commit statuses](https://docs.github.com/rest/commits/statuses) for every submitted context must be in a `success`
     * state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to
     * specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do
     * not require any contexts or create any commit statuses, the deployment will always succeed.
     *
     * The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text
     * field that will be passed on when a deployment event is dispatched.
     *
     * The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might
     * be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an
     * application with debugging enabled.
     *
     * Users with `repo` or `repo_deployment` scopes can create a deployment for a given ref.
     *
     * #### Merged branch response
     * You will see this response when GitHub automatically merges the base branch into the topic branch instead of creating
     * a deployment. This auto-merge happens when:
     * *   Auto-merge option is enabled in the repository
     * *   Topic branch does not include the latest changes on the base branch, which is `master` in the response example
     * *   There are no merge conflicts
     *
     * If there are no new commits in the base branch, a new request to create a deployment should give a successful
     * response.
     *
     * #### Merge conflict response
     * This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't
     * be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.
     *
     * #### Failed commit status checks
     * This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success`
     * status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.
     */
    post: operations["repos/create-deployment"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}": {
    get: operations["repos/get-deployment"];
    /**
     * If the repository only has one deployment, you can delete the deployment regardless of its status. If the repository has more than one deployment, you can only delete inactive deployments. This ensures that repositories with multiple deployments will always have an active deployment. Anyone with `repo` or `repo_deployment` scopes can delete a deployment.
     *
     * To set a deployment as inactive, you must:
     *
     * *   Create a new deployment that is active so that the system has a record of the current state, then delete the previously active deployment.
     * *   Mark the active deployment as inactive by adding any non-successful deployment status.
     *
     * For more information, see "[Create a deployment](https://docs.github.com/rest/reference/repos/#create-a-deployment)" and "[Create a deployment status](https://docs.github.com/rest/reference/repos#create-a-deployment-status)."
     */
    delete: operations["repos/delete-deployment"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}/statuses": {
    /** Users with pull access can view deployment statuses for a deployment: */
    get: operations["repos/list-deployment-statuses"];
    /**
     * Users with `push` access can create deployment statuses for a given deployment.
     *
     * GitHub Apps require `read & write` access to "Deployments" and `read-only` access to "Repo contents" (for private repos). OAuth Apps require the `repo_deployment` scope.
     */
    post: operations["repos/create-deployment-status"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}": {
    /** Users with pull access can view a deployment status for a deployment: */
    get: operations["repos/get-deployment-status"];
  };
  "/repos/{owner}/{repo}/dispatches": {
    /**
     * You can use this endpoint to trigger a webhook event called `repository_dispatch` when you want activity that happens outside of GitHub to trigger a GitHub Actions workflow or GitHub App webhook. You must configure your GitHub Actions workflow or GitHub App to run when the `repository_dispatch` event occurs. For an example `repository_dispatch` webhook payload, see "[RepositoryDispatchEvent](https://docs.github.com/webhooks/event-payloads/#repository_dispatch)."
     *
     * The `client_payload` parameter is available for any extra information that your workflow might need. This parameter is a JSON payload that will be passed on when the webhook event is dispatched. For example, the `client_payload` can include a message that a user would like to send using a GitHub Actions workflow. Or the `client_payload` can be used as a test to debug your workflow.
     *
     * This endpoint requires write access to the repository by providing either:
     *
     *   - Personal access tokens with `repo` scope. For more information, see "[Creating a personal access token for the command line](https://docs.github.com/articles/creating-a-personal-access-token-for-the-command-line)" in the GitHub Help documentation.
     *   - GitHub Apps with both `metadata:read` and `contents:read&write` permissions.
     *
     * This input example shows how you can use the `client_payload` as a test to debug your workflow.
     */
    post: operations["repos/create-dispatch-event"];
  };
  "/repos/{owner}/{repo}/environments": {
    /**
     * Get all environments for a repository.
     *
     * Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
     */
    get: operations["repos/get-all-environments"];
  };
  "/repos/{owner}/{repo}/environments/{environment_name}": {
    /** Anyone with read access to the repository can use this endpoint. If the repository is private, you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. */
    get: operations["repos/get-environment"];
    /**
     * Create or update an environment with protection rules, such as required reviewers. For more information about environment protection rules, see "[Environments](/actions/reference/environments#environment-protection-rules)."
     *
     * **Note:** Although you can use this operation to specify that only branches that match specified name patterns can deploy to this environment, you must use the UI to set the name patterns. For more information, see "[Environments](/actions/reference/environments#deployment-branches)."
     *
     * **Note:** To create or update secrets for an environment, see "[Secrets](/rest/reference/actions#secrets)."
     *
     * You must authenticate using an access token with the repo scope to use this endpoint.
     */
    put: operations["repos/create-or-update-environment"];
    /** You must authenticate using an access token with the repo scope to use this endpoint. */
    delete: operations["repos/delete-an-environment"];
  };
  "/repos/{owner}/{repo}/events": {
    get: operations["activity/list-repo-events"];
  };
  "/repos/{owner}/{repo}/forks": {
    get: operations["repos/list-forks"];
    /**
     * Create a fork for the authenticated user.
     *
     * **Note**: Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
     */
    post: operations["repos/create-fork"];
  };
  "/repos/{owner}/{repo}/git/blobs": {
    post: operations["git/create-blob"];
  };
  "/repos/{owner}/{repo}/git/blobs/{file_sha}": {
    /**
     * The `content` in the response will always be Base64 encoded.
     *
     * _Note_: This API supports blobs up to 100 megabytes in size.
     */
    get: operations["git/get-blob"];
  };
  "/repos/{owner}/{repo}/git/commits": {
    /**
     * Creates a new Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    post: operations["git/create-commit"];
  };
  "/repos/{owner}/{repo}/git/commits/{commit_sha}": {
    /**
     * Gets a Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in the table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["git/get-commit"];
  };
  "/repos/{owner}/{repo}/git/matching-refs/{ref}": {
    /**
     * Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.
     *
     * When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.
     *
     * **Note:** You need to explicitly [request a pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
     *
     * If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.
     */
    get: operations["git/list-matching-refs"];
  };
  "/repos/{owner}/{repo}/git/ref/{ref}": {
    /**
     * Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.
     *
     * **Note:** You need to explicitly [request a pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
     */
    get: operations["git/get-ref"];
  };
  "/repos/{owner}/{repo}/git/refs": {
    /** Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches. */
    post: operations["git/create-ref"];
  };
  "/repos/{owner}/{repo}/git/refs/{ref}": {
    delete: operations["git/delete-ref"];
    patch: operations["git/update-ref"];
  };
  "/repos/{owner}/{repo}/git/tags": {
    /**
     * Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/rest/reference/git#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/rest/reference/git#create-a-reference) the tag reference - this call would be unnecessary.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    post: operations["git/create-tag"];
  };
  "/repos/{owner}/{repo}/git/tags/{tag_sha}": {
    /**
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["git/get-tag"];
  };
  "/repos/{owner}/{repo}/git/trees": {
    /**
     * The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.
     *
     * If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/rest/reference/git#create-a-commit)" and "[Update a reference](https://docs.github.com/rest/reference/git#update-a-reference)."
     */
    post: operations["git/create-tree"];
  };
  "/repos/{owner}/{repo}/git/trees/{tree_sha}": {
    /**
     * Returns a single tree using the SHA1 value for that tree.
     *
     * If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.
     */
    get: operations["git/get-tree"];
  };
  "/repos/{owner}/{repo}/hooks": {
    get: operations["repos/list-webhooks"];
    /**
     * Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can
     * share the same `config` as long as those webhooks do not have any `events` that overlap.
     */
    post: operations["repos/create-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}": {
    /** Returns a webhook configured in a repository. To get only the webhook `config` properties, see "[Get a webhook configuration for a repository](/rest/reference/repos#get-a-webhook-configuration-for-a-repository)." */
    get: operations["repos/get-webhook"];
    delete: operations["repos/delete-webhook"];
    /** Updates a webhook configured in a repository. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for a repository](/rest/reference/repos#update-a-webhook-configuration-for-a-repository)." */
    patch: operations["repos/update-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/config": {
    /**
     * Returns the webhook configuration for a repository. To get more information about the webhook, including the `active` state and `events`, use "[Get a repository webhook](/rest/reference/orgs#get-a-repository-webhook)."
     *
     * Access tokens must have the `read:repo_hook` or `repo` scope, and GitHub Apps must have the `repository_hooks:read` permission.
     */
    get: operations["repos/get-webhook-config-for-repo"];
    /**
     * Updates the webhook configuration for a repository. To update more information about the webhook, including the `active` state and `events`, use "[Update a repository webhook](/rest/reference/orgs#update-a-repository-webhook)."
     *
     * Access tokens must have the `write:repo_hook` or `repo` scope, and GitHub Apps must have the `repository_hooks:write` permission.
     */
    patch: operations["repos/update-webhook-config-for-repo"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/deliveries": {
    /** Returns a list of webhook deliveries for a webhook configured in a repository. */
    get: operations["repos/list-webhook-deliveries"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}": {
    /** Returns a delivery for a webhook configured in a repository. */
    get: operations["repos/get-webhook-delivery"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/deliveries/{delivery_id}/attempts": {
    /** Redeliver a webhook delivery for a webhook configured in a repository. */
    post: operations["repos/redeliver-webhook-delivery"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/pings": {
    /** This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook. */
    post: operations["repos/ping-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/tests": {
    /**
     * This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.
     *
     * **Note**: Previously `/repos/:owner/:repo/hooks/:hook_id/test`
     */
    post: operations["repos/test-push-webhook"];
  };
  "/repos/{owner}/{repo}/import": {
    /**
     * View the progress of an import.
     *
     * **Import status**
     *
     * This section includes details about the possible values of the `status` field of the Import Progress response.
     *
     * An import that does not have errors will progress through these steps:
     *
     * *   `detecting` - the "detection" step of the import is in progress because the request did not include a `vcs` parameter. The import is identifying the type of source control present at the URL.
     * *   `importing` - the "raw" step of the import is in progress. This is where commit data is fetched from the original repository. The import progress response will include `commit_count` (the total number of raw commits that will be imported) and `percent` (0 - 100, the current progress through the import).
     * *   `mapping` - the "rewrite" step of the import is in progress. This is where SVN branches are converted to Git branches, and where author updates are applied. The import progress response does not include progress information.
     * *   `pushing` - the "push" step of the import is in progress. This is where the importer updates the repository on GitHub. The import progress response will include `push_percent`, which is the percent value reported by `git push` when it is "Writing objects".
     * *   `complete` - the import is complete, and the repository is ready on GitHub.
     *
     * If there are problems, you will see one of these in the `status` field:
     *
     * *   `auth_failed` - the import requires authentication in order to connect to the original repository. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
     * *   `error` - the import encountered an error. The import progress response will include the `failed_step` and an error message. Contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api) for more information.
     * *   `detection_needs_auth` - the importer requires authentication for the originating repository to continue detection. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
     * *   `detection_found_nothing` - the importer didn't recognize any source control at the URL. To resolve, [Cancel the import](https://docs.github.com/rest/reference/migrations#cancel-an-import) and [retry](https://docs.github.com/rest/reference/migrations#start-an-import) with the correct URL.
     * *   `detection_found_multiple` - the importer found several projects or repositories at the provided URL. When this is the case, the Import Progress response will also include a `project_choices` field with the possible project choices as values. To update project choice, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
     *
     * **The project_choices field**
     *
     * When multiple projects are found at the provided URL, the response hash will include a `project_choices` field, the value of which is an array of hashes each representing a project choice. The exact key/value pairs of the project hashes will differ depending on the version control type.
     *
     * **Git LFS related fields**
     *
     * This section includes details about Git LFS related fields that may be present in the Import Progress response.
     *
     * *   `use_lfs` - describes whether the import has been opted in or out of using Git LFS. The value can be `opt_in`, `opt_out`, or `undecided` if no action has been taken.
     * *   `has_large_files` - the boolean value describing whether files larger than 100MB were found during the `importing` step.
     * *   `large_files_size` - the total size in gigabytes of files larger than 100MB found in the originating repository.
     * *   `large_files_count` - the total number of files larger than 100MB found in the originating repository. To see a list of these files, make a "Get Large Files" request.
     */
    get: operations["migrations/get-import-status"];
    /** Start a source import to a GitHub repository using GitHub Importer. */
    put: operations["migrations/start-import"];
    /** Stop an import for a repository. */
    delete: operations["migrations/cancel-import"];
    /**
     * An import can be updated with credentials or a project choice by passing in the appropriate parameters in this API
     * request. If no parameters are provided, the import will be restarted.
     *
     * Some servers (e.g. TFS servers) can have several projects at a single URL. In those cases the import progress will
     * have the status `detection_found_multiple` and the Import Progress response will include a `project_choices` array.
     * You can select the project to import by providing one of the objects in the `project_choices` array in the update request.
     */
    patch: operations["migrations/update-import"];
  };
  "/repos/{owner}/{repo}/import/authors": {
    /**
     * Each type of source control system represents authors in a different way. For example, a Git commit author has a display name and an email address, but a Subversion commit author just has a username. The GitHub Importer will make the author information valid, but the author might not be correct. For example, it will change the bare Subversion username `hubot` into something like `hubot <hubot@12341234-abab-fefe-8787-fedcba987654>`.
     *
     * This endpoint and the [Map a commit author](https://docs.github.com/rest/reference/migrations#map-a-commit-author) endpoint allow you to provide correct Git author information.
     */
    get: operations["migrations/get-commit-authors"];
  };
  "/repos/{owner}/{repo}/import/authors/{author_id}": {
    /** Update an author's identity for the import. Your application can continue updating authors any time before you push new commits to the repository. */
    patch: operations["migrations/map-commit-author"];
  };
  "/repos/{owner}/{repo}/import/large_files": {
    /** List files larger than 100MB found during the import */
    get: operations["migrations/get-large-files"];
  };
  "/repos/{owner}/{repo}/import/lfs": {
    /** You can import repositories from Subversion, Mercurial, and TFS that include files larger than 100MB. This ability is powered by [Git LFS](https://git-lfs.github.com). You can learn more about our LFS feature and working with large files [on our help site](https://docs.github.com/articles/versioning-large-files/). */
    patch: operations["migrations/set-lfs-preference"];
  };
  "/repos/{owner}/{repo}/installation": {
    /**
     * Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-repo-installation"];
  };
  "/repos/{owner}/{repo}/interaction-limits": {
    /** Shows which type of GitHub user can interact with this repository and when the restriction expires. If there are no restrictions, you will see an empty response. */
    get: operations["interactions/get-restrictions-for-repo"];
    /** Temporarily restricts interactions to a certain type of GitHub user within the given repository. You must have owner or admin access to set these restrictions. If an interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository. */
    put: operations["interactions/set-restrictions-for-repo"];
    /** Removes all interaction restrictions from the given repository. You must have owner or admin access to remove restrictions. If the interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository. */
    delete: operations["interactions/remove-restrictions-for-repo"];
  };
  "/repos/{owner}/{repo}/invitations": {
    /** When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations. */
    get: operations["repos/list-invitations"];
  };
  "/repos/{owner}/{repo}/invitations/{invitation_id}": {
    delete: operations["repos/delete-invitation"];
    patch: operations["repos/update-invitation"];
  };
  "/repos/{owner}/{repo}/issues": {
    /**
     * List issues in a repository.
     *
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
     */
    get: operations["issues/list-for-repo"];
    /**
     * Any user with pull access to a repository can create an issue. If [issues are disabled in the repository](https://docs.github.com/articles/disabling-issues/), the API returns a `410 Gone` status.
     *
     * This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["issues/create"];
  };
  "/repos/{owner}/{repo}/issues/comments": {
    /** By default, Issue Comments are ordered by ascending ID. */
    get: operations["issues/list-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}": {
    get: operations["issues/get-comment"];
    delete: operations["issues/delete-comment"];
    patch: operations["issues/update-comment"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions": {
    /** List the reactions to an [issue comment](https://docs.github.com/rest/reference/issues#comments). */
    get: operations["reactions/list-for-issue-comment"];
    /** Create a reaction to an [issue comment](https://docs.github.com/rest/reference/issues#comments). A response with an HTTP `200` status means that you already added the reaction type to this issue comment. */
    post: operations["reactions/create-for-issue-comment"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.
     *
     * Delete a reaction to an [issue comment](https://docs.github.com/rest/reference/issues#comments).
     */
    delete: operations["reactions/delete-for-issue-comment"];
  };
  "/repos/{owner}/{repo}/issues/events": {
    get: operations["issues/list-events-for-repo"];
  };
  "/repos/{owner}/{repo}/issues/events/{event_id}": {
    get: operations["issues/get-event"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}": {
    /**
     * The API returns a [`301 Moved Permanently` status](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-redirects-redirects) if the issue was
     * [transferred](https://docs.github.com/articles/transferring-an-issue-to-another-repository/) to another repository. If
     * the issue was transferred to or deleted from a repository where the authenticated user lacks read access, the API
     * returns a `404 Not Found` status. If the issue was deleted from a repository where the authenticated user has read
     * access, the API returns a `410 Gone` status. To receive webhook events for transferred and deleted issues, subscribe
     * to the [`issues`](https://docs.github.com/webhooks/event-payloads/#issues) webhook.
     *
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
     */
    get: operations["issues/get"];
    /** Issue owners and users with push access can edit an issue. */
    patch: operations["issues/update"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/assignees": {
    /** Adds up to 10 assignees to an issue. Users already assigned to an issue are not replaced. */
    post: operations["issues/add-assignees"];
    /** Removes one or more assignees from an issue. */
    delete: operations["issues/remove-assignees"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/comments": {
    /** Issue Comments are ordered by ascending ID. */
    get: operations["issues/list-comments"];
    /** This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details. */
    post: operations["issues/create-comment"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/events": {
    get: operations["issues/list-events"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/labels": {
    get: operations["issues/list-labels-on-issue"];
    /** Removes any previous labels and sets the new labels for an issue. */
    put: operations["issues/set-labels"];
    post: operations["issues/add-labels"];
    delete: operations["issues/remove-all-labels"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}": {
    /** Removes the specified label from the issue, and returns the remaining labels on the issue. This endpoint returns a `404 Not Found` status if the label does not exist. */
    delete: operations["issues/remove-label"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/lock": {
    /**
     * Users with push access can lock an issue or pull request's conversation.
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
     */
    put: operations["issues/lock"];
    /** Users with push access can unlock an issue's conversation. */
    delete: operations["issues/unlock"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/reactions": {
    /** List the reactions to an [issue](https://docs.github.com/rest/reference/issues). */
    get: operations["reactions/list-for-issue"];
    /** Create a reaction to an [issue](https://docs.github.com/rest/reference/issues/). A response with an HTTP `200` status means that you already added the reaction type to this issue. */
    post: operations["reactions/create-for-issue"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.
     *
     * Delete a reaction to an [issue](https://docs.github.com/rest/reference/issues/).
     */
    delete: operations["reactions/delete-for-issue"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/timeline": {
    get: operations["issues/list-events-for-timeline"];
  };
  "/repos/{owner}/{repo}/keys": {
    get: operations["repos/list-deploy-keys"];
    /** You can create a read-only deploy key. */
    post: operations["repos/create-deploy-key"];
  };
  "/repos/{owner}/{repo}/keys/{key_id}": {
    get: operations["repos/get-deploy-key"];
    /** Deploy keys are immutable. If you need to update a key, remove the key and create a new one instead. */
    delete: operations["repos/delete-deploy-key"];
  };
  "/repos/{owner}/{repo}/labels": {
    get: operations["issues/list-labels-for-repo"];
    post: operations["issues/create-label"];
  };
  "/repos/{owner}/{repo}/labels/{name}": {
    get: operations["issues/get-label"];
    delete: operations["issues/delete-label"];
    patch: operations["issues/update-label"];
  };
  "/repos/{owner}/{repo}/languages": {
    /** Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language. */
    get: operations["repos/list-languages"];
  };
  "/repos/{owner}/{repo}/lfs": {
    put: operations["repos/enable-lfs-for-repo"];
    delete: operations["repos/disable-lfs-for-repo"];
  };
  "/repos/{owner}/{repo}/license": {
    /**
     * This method returns the contents of the repository's license file, if one is detected.
     *
     * Similar to [Get repository content](https://docs.github.com/rest/reference/repos#get-repository-content), this method also supports [custom media types](https://docs.github.com/rest/overview/media-types) for retrieving the raw license content or rendered license HTML.
     */
    get: operations["licenses/get-for-repo"];
  };
  "/repos/{owner}/{repo}/merge-upstream": {
    /** Sync a branch of a forked repository to keep it up-to-date with the upstream repository. */
    post: operations["repos/merge-upstream"];
  };
  "/repos/{owner}/{repo}/merges": {
    post: operations["repos/merge"];
  };
  "/repos/{owner}/{repo}/milestones": {
    get: operations["issues/list-milestones"];
    post: operations["issues/create-milestone"];
  };
  "/repos/{owner}/{repo}/milestones/{milestone_number}": {
    get: operations["issues/get-milestone"];
    delete: operations["issues/delete-milestone"];
    patch: operations["issues/update-milestone"];
  };
  "/repos/{owner}/{repo}/milestones/{milestone_number}/labels": {
    get: operations["issues/list-labels-for-milestone"];
  };
  "/repos/{owner}/{repo}/notifications": {
    /** List all notifications for the current user. */
    get: operations["activity/list-repo-notifications-for-authenticated-user"];
    /** Marks all notifications in a repository as "read" removes them from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/rest/reference/activity#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`. */
    put: operations["activity/mark-repo-notifications-as-read"];
  };
  "/repos/{owner}/{repo}/pages": {
    get: operations["repos/get-pages"];
    /** Updates information for a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages). */
    put: operations["repos/update-information-about-pages-site"];
    /** Configures a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages)." */
    post: operations["repos/create-pages-site"];
    delete: operations["repos/delete-pages-site"];
  };
  "/repos/{owner}/{repo}/pages/builds": {
    get: operations["repos/list-pages-builds"];
    /**
     * You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.
     *
     * Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.
     */
    post: operations["repos/request-pages-build"];
  };
  "/repos/{owner}/{repo}/pages/builds/latest": {
    get: operations["repos/get-latest-pages-build"];
  };
  "/repos/{owner}/{repo}/pages/builds/{build_id}": {
    get: operations["repos/get-pages-build"];
  };
  "/repos/{owner}/{repo}/pages/health": {
    /**
     * Gets a health check of the DNS settings for the `CNAME` record configured for a repository's GitHub Pages.
     *
     * The first request to this endpoint returns a `202 Accepted` status and starts an asynchronous background task to get the results for the domain. After the background task completes, subsequent requests to this endpoint return a `200 OK` status with the health check results in the response.
     *
     * Users must have admin or owner permissions. GitHub Apps must have the `pages:write` and `administration:write` permission to use this endpoint.
     */
    get: operations["repos/get-pages-health-check"];
  };
  "/repos/{owner}/{repo}/projects": {
    /** Lists the projects in a repository. Returns a `404 Not Found` status if projects are disabled in the repository. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    get: operations["projects/list-for-repo"];
    /** Creates a repository project board. Returns a `404 Not Found` status if projects are disabled in the repository. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned. */
    post: operations["projects/create-for-repo"];
  };
  "/repos/{owner}/{repo}/pulls": {
    /** Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation. */
    get: operations["pulls/list"];
    /**
     * Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
     *
     * You can create a new pull request.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
     */
    post: operations["pulls/create"];
  };
  "/repos/{owner}/{repo}/pulls/comments": {
    /** Lists review comments for all pull requests in a repository. By default, review comments are in ascending order by ID. */
    get: operations["pulls/list-review-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}": {
    /** Provides details for a review comment. */
    get: operations["pulls/get-review-comment"];
    /** Deletes a review comment. */
    delete: operations["pulls/delete-review-comment"];
    /** Enables you to edit a review comment. */
    patch: operations["pulls/update-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions": {
    /** List the reactions to a [pull request review comment](https://docs.github.com/rest/reference/pulls#review-comments). */
    get: operations["reactions/list-for-pull-request-review-comment"];
    /** Create a reaction to a [pull request review comment](https://docs.github.com/rest/reference/pulls#comments). A response with an HTTP `200` status means that you already added the reaction type to this pull request review comment. */
    post: operations["reactions/create-for-pull-request-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`
     *
     * Delete a reaction to a [pull request review comment](https://docs.github.com/rest/reference/pulls#review-comments).
     */
    delete: operations["reactions/delete-for-pull-request-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}": {
    /**
     * Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Lists details of a pull request by providing its number.
     *
     * When you get, [create](https://docs.github.com/rest/reference/pulls/#create-a-pull-request), or [edit](https://docs.github.com/rest/reference/pulls#update-a-pull-request) a pull request, GitHub creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
     *
     * The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.
     *
     * The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:
     *
     * *   If merged as a [merge commit](https://docs.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
     * *   If merged via a [squash](https://docs.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
     * *   If [rebased](https://docs.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.
     *
     * Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
     */
    get: operations["pulls/get"];
    /**
     * Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
     */
    patch: operations["pulls/update"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/codespaces": {
    /**
     * Creates a codespace owned by the authenticated user for the specified pull request.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces` repository permission to use this endpoint.
     */
    post: operations["codespaces/create-with-pr-for-authenticated-user"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/comments": {
    /** Lists all review comments for a pull request. By default, review comments are in ascending order by ID. */
    get: operations["pulls/list-review-comments"];
    /**
     * Creates a review comment in the pull request diff. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/rest/reference/issues#create-an-issue-comment)." We recommend creating a review comment using `line`, `side`, and optionally `start_line` and `start_side` if your comment applies to more than one line in the pull request diff.
     *
     * The `position` parameter is deprecated. If you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required.
     *
     * **Note:** The position value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["pulls/create-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies": {
    /**
     * Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["pulls/create-reply-for-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/commits": {
    /** Lists a maximum of 250 commits for a pull request. To receive a complete commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/rest/reference/repos#list-commits) endpoint. */
    get: operations["pulls/list-commits"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/files": {
    /** **Note:** Responses include a maximum of 3000 files. The paginated response returns 30 files per page by default. */
    get: operations["pulls/list-files"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/merge": {
    get: operations["pulls/check-if-merged"];
    /** This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details. */
    put: operations["pulls/merge"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers": {
    get: operations["pulls/list-requested-reviewers"];
    /** This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details. */
    post: operations["pulls/request-reviewers"];
    delete: operations["pulls/remove-requested-reviewers"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews": {
    /** The list of reviews returns in chronological order. */
    get: operations["pulls/list-reviews"];
    /**
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     *
     * Pull request reviews created in the `PENDING` state do not include the `submitted_at` property in the response.
     *
     * **Note:** To comment on a specific line in a file, you need to first determine the _position_ of that line in the diff. The GitHub REST API v3 offers the `application/vnd.github.v3.diff` [media type](https://docs.github.com/rest/overview/media-types#commits-commit-comparison-and-pull-requests). To see a pull request diff, add this media type to the `Accept` header of a call to the [single pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) endpoint.
     *
     * The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
     */
    post: operations["pulls/create-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}": {
    get: operations["pulls/get-review"];
    /** Update the review summary comment with new text. */
    put: operations["pulls/update-review"];
    delete: operations["pulls/delete-pending-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments": {
    /** List comments for a specific pull request review. */
    get: operations["pulls/list-comments-for-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals": {
    /** **Note:** To dismiss a pull request review on a [protected branch](https://docs.github.com/rest/reference/repos#branches), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews. */
    put: operations["pulls/dismiss-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events": {
    post: operations["pulls/submit-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/update-branch": {
    /** Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch. */
    put: operations["pulls/update-branch"];
  };
  "/repos/{owner}/{repo}/readme": {
    /**
     * Gets the preferred README for a repository.
     *
     * READMEs support [custom media types](https://docs.github.com/rest/reference/repos#custom-media-types) for retrieving the raw content or rendered HTML.
     */
    get: operations["repos/get-readme"];
  };
  "/repos/{owner}/{repo}/readme/{dir}": {
    /**
     * Gets the README from a repository directory.
     *
     * READMEs support [custom media types](https://docs.github.com/rest/reference/repos#custom-media-types) for retrieving the raw content or rendered HTML.
     */
    get: operations["repos/get-readme-in-directory"];
  };
  "/repos/{owner}/{repo}/releases": {
    /**
     * This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://docs.github.com/rest/reference/repos#list-repository-tags).
     *
     * Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.
     */
    get: operations["repos/list-releases"];
    /**
     * Users with push access to the repository can create a release.
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["repos/create-release"];
  };
  "/repos/{owner}/{repo}/releases/assets/{asset_id}": {
    /** To download the asset's binary content, set the `Accept` header of the request to [`application/octet-stream`](https://docs.github.com/rest/overview/media-types). The API will either redirect the client to the location, or stream it directly if possible. API clients should handle both a `200` or `302` response. */
    get: operations["repos/get-release-asset"];
    delete: operations["repos/delete-release-asset"];
    /** Users with push access to the repository can edit a release asset. */
    patch: operations["repos/update-release-asset"];
  };
  "/repos/{owner}/{repo}/releases/generate-notes": {
    /** Generate a name and body describing a [release](https://docs.github.com/rest/reference/repos#releases). The body content will be markdown formatted and contain information like the changes since last release and users who contributed. The generated release notes are not saved anywhere. They are intended to be generated and used when creating a new release. */
    post: operations["repos/generate-release-notes"];
  };
  "/repos/{owner}/{repo}/releases/latest": {
    /**
     * View the latest published full release for the repository.
     *
     * The latest release is the most recent non-prerelease, non-draft release, sorted by the `created_at` attribute. The `created_at` attribute is the date of the commit used for the release, and not the date when the release was drafted or published.
     */
    get: operations["repos/get-latest-release"];
  };
  "/repos/{owner}/{repo}/releases/tags/{tag}": {
    /** Get a published release with the specified tag. */
    get: operations["repos/get-release-by-tag"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}": {
    /** **Note:** This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a [hypermedia resource](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia). */
    get: operations["repos/get-release"];
    /** Users with push access to the repository can delete a release. */
    delete: operations["repos/delete-release"];
    /** Users with push access to the repository can edit a release. */
    patch: operations["repos/update-release"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}/assets": {
    get: operations["repos/list-release-assets"];
    /**
     * This endpoint makes use of [a Hypermedia relation](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia) to determine which URL to access. The endpoint you call to upload release assets is specific to your release. Use the `upload_url` returned in
     * the response of the [Create a release endpoint](https://docs.github.com/rest/reference/repos#create-a-release) to upload a release asset.
     *
     * You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.
     *
     * Most libraries will set the required `Content-Length` header automatically. Use the required `Content-Type` header to provide the media type of the asset. For a list of media types, see [Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). For example:
     *
     * `application/zip`
     *
     * GitHub expects the asset data in its raw binary form, rather than JSON. You will send the raw binary content of the asset as the request body. Everything else about the endpoint is the same as the rest of the API. For example,
     * you'll still need to pass your authentication to be able to upload an asset.
     *
     * When an upstream failure occurs, you will receive a `502 Bad Gateway` status. This may leave an empty asset with a state of `starter`. It can be safely deleted.
     *
     * **Notes:**
     * *   GitHub renames asset filenames that have special characters, non-alphanumeric characters, and leading or trailing periods. The "[List assets for a release](https://docs.github.com/rest/reference/repos#list-assets-for-a-release)"
     * endpoint lists the renamed filenames. For more information and help, contact [GitHub Support](https://support.github.com/contact?tags=dotcom-rest-api).
     * *   If you upload an asset with the same filename as another uploaded asset, you'll receive an error and must delete the old file before you can re-upload the new asset.
     */
    post: operations["repos/upload-release-asset"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}/reactions": {
    /** List the reactions to a [release](https://docs.github.com/rest/reference/repos#releases). */
    get: operations["reactions/list-for-release"];
    /** Create a reaction to a [release](https://docs.github.com/rest/reference/repos#releases). A response with a `Status: 200 OK` means that you already added the reaction type to this release. */
    post: operations["reactions/create-for-release"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}/reactions/{reaction_id}": {
    /**
     * **Note:** You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/releases/:release_id/reactions/:reaction_id`.
     *
     * Delete a reaction to a [release](https://docs.github.com/rest/reference/repos#releases).
     */
    delete: operations["reactions/delete-for-release"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts": {
    /**
     * Lists secret scanning alerts for an eligible repository, from newest to oldest.
     * To use this endpoint, you must be an administrator for the repository or for the organization that owns the repository, and you must use a personal access token with the `repo` scope or `security_events` scope.
     * For public repositories, you may instead use the `public_repo` scope.
     *
     * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
     */
    get: operations["secret-scanning/list-alerts-for-repo"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}": {
    /**
     * Gets a single secret scanning alert detected in an eligible repository.
     * To use this endpoint, you must be an administrator for the repository or for the organization that owns the repository, and you must use a personal access token with the `repo` scope or `security_events` scope.
     * For public repositories, you may instead use the `public_repo` scope.
     *
     * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
     */
    get: operations["secret-scanning/get-alert"];
    /**
     * Updates the status of a secret scanning alert in an eligible repository.
     * To use this endpoint, you must be an administrator for the repository or for the organization that owns the repository, and you must use a personal access token with the `repo` scope or `security_events` scope.
     * For public repositories, you may instead use the `public_repo` scope.
     *
     * GitHub Apps must have the `secret_scanning_alerts` write permission to use this endpoint.
     */
    patch: operations["secret-scanning/update-alert"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}/locations": {
    /**
     * Lists all locations for a given secret scanning alert for an eligible repository.
     * To use this endpoint, you must be an administrator for the repository or for the organization that owns the repository, and you must use a personal access token with the `repo` scope or `security_events` scope.
     * For public repositories, you may instead use the `public_repo` scope.
     *
     * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
     */
    get: operations["secret-scanning/list-locations-for-alert"];
  };
  "/repos/{owner}/{repo}/stargazers": {
    /**
     * Lists the people that have starred the repository.
     *
     * You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
     */
    get: operations["activity/list-stargazers-for-repo"];
  };
  "/repos/{owner}/{repo}/stats/code_frequency": {
    /** Returns a weekly aggregate of the number of additions and deletions pushed to a repository. */
    get: operations["repos/get-code-frequency-stats"];
  };
  "/repos/{owner}/{repo}/stats/commit_activity": {
    /** Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`. */
    get: operations["repos/get-commit-activity-stats"];
  };
  "/repos/{owner}/{repo}/stats/contributors": {
    /**
     * Returns the `total` number of commits authored by the contributor. In addition, the response includes a Weekly Hash (`weeks` array) with the following information:
     *
     * *   `w` - Start of the week, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).
     * *   `a` - Number of additions
     * *   `d` - Number of deletions
     * *   `c` - Number of commits
     */
    get: operations["repos/get-contributors-stats"];
  };
  "/repos/{owner}/{repo}/stats/participation": {
    /**
     * Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.
     *
     * The array order is oldest week (index 0) to most recent week.
     */
    get: operations["repos/get-participation-stats"];
  };
  "/repos/{owner}/{repo}/stats/punch_card": {
    /**
     * Each array contains the day number, hour number, and number of commits:
     *
     * *   `0-6`: Sunday - Saturday
     * *   `0-23`: Hour of day
     * *   Number of commits
     *
     * For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.
     */
    get: operations["repos/get-punch-card-stats"];
  };
  "/repos/{owner}/{repo}/statuses/{sha}": {
    /**
     * Users with push access in a repository can create commit statuses for a given SHA.
     *
     * Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.
     */
    post: operations["repos/create-commit-status"];
  };
  "/repos/{owner}/{repo}/subscribers": {
    /** Lists the people watching the specified repository. */
    get: operations["activity/list-watchers-for-repo"];
  };
  "/repos/{owner}/{repo}/subscription": {
    get: operations["activity/get-repo-subscription"];
    /** If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/rest/reference/activity#delete-a-repository-subscription) completely. */
    put: operations["activity/set-repo-subscription"];
    /** This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/rest/reference/activity#set-a-repository-subscription). */
    delete: operations["activity/delete-repo-subscription"];
  };
  "/repos/{owner}/{repo}/tags": {
    get: operations["repos/list-tags"];
  };
  "/repos/{owner}/{repo}/tags/protection": {
    /**
     * This returns the tag protection states of a repository.
     *
     * This information is only available to repository administrators.
     */
    get: operations["repos/list-tag-protection"];
    /**
     * This creates a tag protection state for a repository.
     * This endpoint is only available to repository administrators.
     */
    post: operations["repos/create-tag-protection"];
  };
  "/repos/{owner}/{repo}/tags/protection/{tag_protection_id}": {
    /**
     * This deletes a tag protection state for a repository.
     * This endpoint is only available to repository administrators.
     */
    delete: operations["repos/delete-tag-protection"];
  };
  "/repos/{owner}/{repo}/tarball/{ref}": {
    /**
     * Gets a redirect URL to download a tar archive for a repository. If you omit `:ref`, the repository’s default branch (usually
     * `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
     * the `Location` header to make a second `GET` request.
     * **Note**: For private repositories, these links are temporary and expire after five minutes.
     */
    get: operations["repos/download-tarball-archive"];
  };
  "/repos/{owner}/{repo}/teams": {
    get: operations["repos/list-teams"];
  };
  "/repos/{owner}/{repo}/topics": {
    get: operations["repos/get-all-topics"];
    put: operations["repos/replace-all-topics"];
  };
  "/repos/{owner}/{repo}/traffic/clones": {
    /** Get the total number of clones and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday. */
    get: operations["repos/get-clones"];
  };
  "/repos/{owner}/{repo}/traffic/popular/paths": {
    /** Get the top 10 popular contents over the last 14 days. */
    get: operations["repos/get-top-paths"];
  };
  "/repos/{owner}/{repo}/traffic/popular/referrers": {
    /** Get the top 10 referrers over the last 14 days. */
    get: operations["repos/get-top-referrers"];
  };
  "/repos/{owner}/{repo}/traffic/views": {
    /** Get the total number of views and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday. */
    get: operations["repos/get-views"];
  };
  "/repos/{owner}/{repo}/transfer": {
    /** A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://docs.github.com/articles/about-repository-transfers/). */
    post: operations["repos/transfer"];
  };
  "/repos/{owner}/{repo}/vulnerability-alerts": {
    /** Shows whether dependency alerts are enabled or disabled for a repository. The authenticated user must have admin read access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)". */
    get: operations["repos/check-vulnerability-alerts"];
    /** Enables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)". */
    put: operations["repos/enable-vulnerability-alerts"];
    /** Disables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://docs.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)". */
    delete: operations["repos/disable-vulnerability-alerts"];
  };
  "/repos/{owner}/{repo}/zipball/{ref}": {
    /**
     * Gets a redirect URL to download a zip archive for a repository. If you omit `:ref`, the repository’s default branch (usually
     * `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
     * the `Location` header to make a second `GET` request.
     * **Note**: For private repositories, these links are temporary and expire after five minutes.
     */
    get: operations["repos/download-zipball-archive"];
  };
  "/repos/{template_owner}/{template_repo}/generate": {
    /**
     * Creates a new repository using a repository template. Use the `template_owner` and `template_repo` route parameters to specify the repository to use as the template. The authenticated user must own or be a member of an organization that owns the repository. To check if a repository is available to use as a template, get the repository's information using the [Get a repository](https://docs.github.com/rest/reference/repos#get-a-repository) endpoint and check that the `is_template` key is `true`.
     *
     * **OAuth scope requirements**
     *
     * When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
     *
     * *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
     * *   `repo` scope to create a private repository
     */
    post: operations["repos/create-using-template"];
  };
  "/repositories": {
    /**
     * Lists all public repositories in the order that they were created.
     *
     * Note:
     * - For GitHub Enterprise Server, this endpoint will only list repositories available to all users on the enterprise.
     * - Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of repositories.
     */
    get: operations["repos/list-public"];
  };
  "/repositories/{repository_id}/environments/{environment_name}/secrets": {
    /** Lists all secrets available in an environment without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/list-environment-secrets"];
  };
  "/repositories/{repository_id}/environments/{environment_name}/secrets/public-key": {
    /** Get the public key for an environment, which you need to encrypt environment secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/get-environment-public-key"];
  };
  "/repositories/{repository_id}/environments/{environment_name}/secrets/{secret_name}": {
    /** Gets a single environment secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    get: operations["actions/get-environment-secret"];
    /**
     * Creates or updates an environment secret with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
     * token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use
     * this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["actions/create-or-update-environment-secret"];
    /** Deletes a secret in an environment using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint. */
    delete: operations["actions/delete-environment-secret"];
  };
  "/scim/v2/enterprises/{enterprise}/Groups": {
    /** **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change. */
    get: operations["enterprise-admin/list-provisioned-groups-enterprise"];
    /**
     * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
     *
     * Provision an enterprise group, and invite users to the group. This sends invitation emails to the email address of the invited users to join the GitHub organization that the SCIM group corresponds to.
     */
    post: operations["enterprise-admin/provision-and-invite-enterprise-group"];
  };
  "/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}": {
    /** **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change. */
    get: operations["enterprise-admin/get-provisioning-information-for-enterprise-group"];
    /**
     * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
     *
     * Replaces an existing provisioned group’s information. You must provide all the information required for the group as if you were provisioning it for the first time. Any existing group information that you don't provide will be removed, including group membership. If you want to only update a specific attribute, use the [Update an attribute for a SCIM enterprise group](#update-an-attribute-for-a-scim-enterprise-group) endpoint instead.
     */
    put: operations["enterprise-admin/set-information-for-provisioned-enterprise-group"];
    /** **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change. */
    delete: operations["enterprise-admin/delete-scim-group-from-enterprise"];
    /**
     * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
     *
     * Allows you to change a provisioned group’s individual attributes. To change a group’s values, you must provide a specific Operations JSON format that contains at least one of the add, remove, or replace operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
     */
    patch: operations["enterprise-admin/update-attribute-for-enterprise-group"];
  };
  "/scim/v2/enterprises/{enterprise}/Users": {
    /**
     * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
     *
     * Retrieves a paginated list of all provisioned enterprise members, including pending invitations.
     *
     * When a user with a SAML-provisioned external identity leaves (or is removed from) an enterprise, the account's metadata is immediately removed. However, the returned list of user accounts might not always match the organization or enterprise member list you see on GitHub. This can happen in certain cases where an external identity associated with an organization will not match an organization member:
     *   - When a user with a SCIM-provisioned external identity is removed from an enterprise, the account's metadata is preserved to allow the user to re-join the organization in the future.
     *   - When inviting a user to join an organization, you can expect to see their external identity in the results before they accept the invitation, or if the invitation is cancelled (or never accepted).
     *   - When a user is invited over SCIM, an external identity is created that matches with the invitee's email address. However, this identity is only linked to a user account when the user accepts the invitation by going through SAML SSO.
     *
     * The returned list of external identities can include an entry for a `null` user. These are unlinked SAML identities that are created when a user goes through the following Single Sign-On (SSO) process but does not sign in to their GitHub account after completing SSO:
     *
     * 1. The user is granted access by the IdP and is not a member of the GitHub enterprise.
     *
     * 1. The user attempts to access the GitHub enterprise and initiates the SAML SSO process, and is not currently signed in to their GitHub account.
     *
     * 1. After successfully authenticating with the SAML SSO IdP, the `null` external identity entry is created and the user is prompted to sign in to their GitHub account:
     *    - If the user signs in, their GitHub account is linked to this entry.
     *    - If the user does not sign in (or does not create a new account when prompted), they are not added to the GitHub enterprise, and the external identity `null` entry remains in place.
     */
    get: operations["enterprise-admin/list-provisioned-identities-enterprise"];
    /**
     * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
     *
     * Provision enterprise membership for a user, and send organization invitation emails to the email address.
     *
     * You can optionally include the groups a user will be invited to join. If you do not provide a list of `groups`, the user is provisioned for the enterprise, but no organization invitation emails will be sent.
     */
    post: operations["enterprise-admin/provision-and-invite-enterprise-user"];
  };
  "/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}": {
    /** **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change. */
    get: operations["enterprise-admin/get-provisioning-information-for-enterprise-user"];
    /**
     * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
     *
     * Replaces an existing provisioned user's information. You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](#update-an-attribute-for-an-enterprise-scim-user) endpoint instead.
     *
     * You must at least provide the required values for the user: `userName`, `name`, and `emails`.
     *
     * **Warning:** Setting `active: false` removes the user from the enterprise, deletes the external identity, and deletes the associated `{scim_user_id}`.
     */
    put: operations["enterprise-admin/set-information-for-provisioned-enterprise-user"];
    /** **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change. */
    delete: operations["enterprise-admin/delete-user-from-enterprise"];
    /**
     * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
     *
     * Allows you to change a provisioned user's individual attributes. To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
     *
     * **Note:** Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.
     *
     * **Warning:** If you set `active:false` using the `replace` operation (as shown in the JSON example below), it removes the user from the enterprise, deletes the external identity, and deletes the associated `:scim_user_id`.
     *
     * ```
     * {
     *   "Operations":[{
     *     "op":"replace",
     *     "value":{
     *       "active":false
     *     }
     *   }]
     * }
     * ```
     */
    patch: operations["enterprise-admin/update-attribute-for-enterprise-user"];
  };
  "/scim/v2/organizations/{org}/Users": {
    /**
     * Retrieves a paginated list of all provisioned organization members, including pending invitations. If you provide the `filter` parameter, the resources for all matching provisions members are returned.
     *
     * When a user with a SAML-provisioned external identity leaves (or is removed from) an organization, the account's metadata is immediately removed. However, the returned list of user accounts might not always match the organization or enterprise member list you see on GitHub. This can happen in certain cases where an external identity associated with an organization will not match an organization member:
     *   - When a user with a SCIM-provisioned external identity is removed from an organization, the account's metadata is preserved to allow the user to re-join the organization in the future.
     *   - When inviting a user to join an organization, you can expect to see their external identity in the results before they accept the invitation, or if the invitation is cancelled (or never accepted).
     *   - When a user is invited over SCIM, an external identity is created that matches with the invitee's email address. However, this identity is only linked to a user account when the user accepts the invitation by going through SAML SSO.
     *
     * The returned list of external identities can include an entry for a `null` user. These are unlinked SAML identities that are created when a user goes through the following Single Sign-On (SSO) process but does not sign in to their GitHub account after completing SSO:
     *
     * 1. The user is granted access by the IdP and is not a member of the GitHub organization.
     *
     * 1. The user attempts to access the GitHub organization and initiates the SAML SSO process, and is not currently signed in to their GitHub account.
     *
     * 1. After successfully authenticating with the SAML SSO IdP, the `null` external identity entry is created and the user is prompted to sign in to their GitHub account:
     *    - If the user signs in, their GitHub account is linked to this entry.
     *    - If the user does not sign in (or does not create a new account when prompted), they are not added to the GitHub organization, and the external identity `null` entry remains in place.
     */
    get: operations["scim/list-provisioned-identities"];
    /** Provision organization membership for a user, and send an activation email to the email address. */
    post: operations["scim/provision-and-invite-user"];
  };
  "/scim/v2/organizations/{org}/Users/{scim_user_id}": {
    get: operations["scim/get-provisioning-information-for-user"];
    /**
     * Replaces an existing provisioned user's information. You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](https://docs.github.com/rest/reference/scim#update-an-attribute-for-a-scim-user) endpoint instead.
     *
     * You must at least provide the required values for the user: `userName`, `name`, and `emails`.
     *
     * **Warning:** Setting `active: false` removes the user from the organization, deletes the external identity, and deletes the associated `{scim_user_id}`.
     */
    put: operations["scim/set-information-for-provisioned-user"];
    delete: operations["scim/delete-user-from-org"];
    /**
     * Allows you to change a provisioned user's individual attributes. To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
     *
     * **Note:** Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.
     *
     * **Warning:** If you set `active:false` using the `replace` operation (as shown in the JSON example below), it removes the user from the organization, deletes the external identity, and deletes the associated `:scim_user_id`.
     *
     * ```
     * {
     *   "Operations":[{
     *     "op":"replace",
     *     "value":{
     *       "active":false
     *     }
     *   }]
     * }
     * ```
     */
    patch: operations["scim/update-attribute-for-user"];
  };
  "/search/code": {
    /**
     * Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:
     *
     * `q=addClass+in:file+language:js+repo:jquery/jquery`
     *
     * This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.
     *
     * #### Considerations for code search
     *
     * Due to the complexity of searching code, there are a few restrictions on how searches are performed:
     *
     * *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
     * *   Only files smaller than 384 KB are searchable.
     * *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
     * language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.
     */
    get: operations["search/code"];
  };
  "/search/commits": {
    /**
     * Find commits via various criteria on the default branch (usually `master`). This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
     * metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:
     *
     * `q=repo:octocat/Spoon-Knife+css`
     */
    get: operations["search/commits"];
  };
  "/search/issues": {
    /**
     * Find issues by state and keyword. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for issues, you can get text match metadata for the issue **title**, issue **body**, and issue **comment body** fields when you pass the `text-match` media type. For more details about how to receive highlighted
     * search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to find the oldest unresolved Python bugs on Windows. Your query might look something like this.
     *
     * `q=windows+label:bug+language:python+state:open&sort=created&order=asc`
     *
     * This query searches for the keyword `windows`, within any open issue that is labeled as `bug`. The search runs across repositories whose primary language is Python. The results are sorted by creation date in ascending order, which means the oldest issues appear first in the search results.
     *
     * **Note:** For [user-to-server](https://docs.github.com/developers/apps/identifying-and-authorizing-users-for-github-apps#user-to-server-requests) GitHub App requests, you can't retrieve a combination of issues and pull requests in a single query. Requests that don't include the `is:issue` or `is:pull-request` qualifier will receive an HTTP `422 Unprocessable Entity` response. To get results for both issues and pull requests, you must send separate queries for issues and pull requests. For more information about the `is` qualifier, see "[Searching only issues or pull requests](https://docs.github.com/github/searching-for-information-on-github/searching-issues-and-pull-requests#search-only-issues-or-pull-requests)."
     */
    get: operations["search/issues-and-pull-requests"];
  };
  "/search/labels": {
    /**
     * Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:
     *
     * `q=bug+defect+enhancement&repository_id=64778136`
     *
     * The labels that best match the query appear first in the search results.
     */
    get: operations["search/labels"];
  };
  "/search/repositories": {
    /**
     * Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:
     *
     * `q=tetris+language:assembly&sort=stars&order=desc`
     *
     * This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.
     */
    get: operations["search/repos"];
  };
  "/search/topics": {
    /**
     * Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination). See "[Searching topics](https://docs.github.com/articles/searching-topics/)" for a detailed list of qualifiers.
     *
     * When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
     *
     * For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:
     *
     * `q=ruby+is:featured`
     *
     * This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.
     */
    get: operations["search/topics"];
  };
  "/search/users": {
    /**
     * Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
     *
     * When searching for users, you can get text match metadata for the issue **login**, **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
     *
     * For example, if you're looking for a list of popular users, you might try this query:
     *
     * `q=tom+repos:%3E42+followers:%3E1000`
     *
     * This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.
     */
    get: operations["search/users"];
  };
  "/teams/{team_id}": {
    /** **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/rest/reference/teams#get-a-team-by-name) endpoint. */
    get: operations["teams/get-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/rest/reference/teams#delete-a-team) endpoint.
     *
     * To delete a team, the authenticated user must be an organization owner or team maintainer.
     *
     * If you are an organization owner, deleting a parent team will delete all of its child teams as well.
     */
    delete: operations["teams/delete-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/rest/reference/teams#update-a-team) endpoint.
     *
     * To edit a team, the authenticated user must either be an organization owner or a team maintainer.
     *
     * **Note:** With nested teams, the `privacy` for parent teams cannot be `secret`.
     */
    patch: operations["teams/update-legacy"];
  };
  "/teams/{team_id}/discussions": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/rest/reference/teams#list-discussions) endpoint.
     *
     * List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["teams/list-discussions-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/rest/reference/teams#create-a-discussion) endpoint.
     *
     * Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["teams/create-discussion-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/rest/reference/teams#get-a-discussion) endpoint.
     *
     * Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["teams/get-discussion-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/rest/reference/teams#delete-a-discussion) endpoint.
     *
     * Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    delete: operations["teams/delete-discussion-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/rest/reference/teams#update-a-discussion) endpoint.
     *
     * Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    patch: operations["teams/update-discussion-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/rest/reference/teams#list-discussion-comments) endpoint.
     *
     * List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["teams/list-discussion-comments-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/rest/reference/teams#create-a-discussion-comment) endpoint.
     *
     * Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     *
     * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
     */
    post: operations["teams/create-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/rest/reference/teams#get-a-discussion-comment) endpoint.
     *
     * Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["teams/get-discussion-comment-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/rest/reference/teams#delete-a-discussion-comment) endpoint.
     *
     * Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    delete: operations["teams/delete-discussion-comment-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/rest/reference/teams#update-a-discussion-comment) endpoint.
     *
     * Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    patch: operations["teams/update-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion-comment) endpoint.
     *
     * List the reactions to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["reactions/list-for-team-discussion-comment-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.
     *
     * Create a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion comment.
     */
    post: operations["reactions/create-for-team-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/reactions": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion) endpoint.
     *
     * List the reactions to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
     */
    get: operations["reactions/list-for-team-discussion-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion) endpoint.
     *
     * Create a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with an HTTP `200` status means that you already added the reaction type to this team discussion.
     */
    post: operations["reactions/create-for-team-discussion-legacy"];
  };
  "/teams/{team_id}/invitations": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List pending team invitations`](https://docs.github.com/rest/reference/teams#list-pending-team-invitations) endpoint.
     *
     * The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
     */
    get: operations["teams/list-pending-invitations-legacy"];
  };
  "/teams/{team_id}/members": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/rest/reference/teams#list-team-members) endpoint.
     *
     * Team members will include the members of child teams.
     */
    get: operations["teams/list-members-legacy"];
  };
  "/teams/{team_id}/members/{username}": {
    /**
     * The "Get team member" endpoint (described below) is deprecated.
     *
     * We recommend using the [Get team membership for a user](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.
     *
     * To list members in a team, the team must be visible to the authenticated user.
     */
    get: operations["teams/get-member-legacy"];
    /**
     * The "Add team member" endpoint (described below) is deprecated.
     *
     * We recommend using the [Add or update team membership for a user](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
     */
    put: operations["teams/add-member-legacy"];
    /**
     * The "Remove team member" endpoint (described below) is deprecated.
     *
     * We recommend using the [Remove team membership for a user](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     */
    delete: operations["teams/remove-member-legacy"];
  };
  "/teams/{team_id}/memberships/{username}": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user) endpoint.
     *
     * Team members will include the members of child teams.
     *
     * To get a user's membership with a team, the team must be visible to the authenticated user.
     *
     * **Note:**
     * The response contains the `state` of the membership and the member's `role`.
     *
     * The `role` for organization owners is set to `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/reference/teams#create-a-team).
     */
    get: operations["teams/get-membership-for-user-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user) endpoint.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     *
     * If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.
     *
     * If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
     */
    put: operations["teams/add-or-update-membership-for-user-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user) endpoint.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
     *
     * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://docs.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
     */
    delete: operations["teams/remove-membership-for-user-legacy"];
  };
  "/teams/{team_id}/projects": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team projects`](https://docs.github.com/rest/reference/teams#list-team-projects) endpoint.
     *
     * Lists the organization projects for a team.
     */
    get: operations["teams/list-projects-legacy"];
  };
  "/teams/{team_id}/projects/{project_id}": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a project](https://docs.github.com/rest/reference/teams#check-team-permissions-for-a-project) endpoint.
     *
     * Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
     */
    get: operations["teams/check-permissions-for-project-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team project permissions](https://docs.github.com/rest/reference/teams#add-or-update-team-project-permissions) endpoint.
     *
     * Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
     */
    put: operations["teams/add-or-update-project-permissions-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a project from a team](https://docs.github.com/rest/reference/teams#remove-a-project-from-a-team) endpoint.
     *
     * Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. **Note:** This endpoint removes the project from the team, but does not delete it.
     */
    delete: operations["teams/remove-project-legacy"];
  };
  "/teams/{team_id}/repos": {
    /** **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/rest/reference/teams#list-team-repositories) endpoint. */
    get: operations["teams/list-repos-legacy"];
  };
  "/teams/{team_id}/repos/{owner}/{repo}": {
    /**
     * **Note**: Repositories inherited through a parent team will also be checked.
     *
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/rest/reference/teams#check-team-permissions-for-a-repository) endpoint.
     *
     * You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
     */
    get: operations["teams/check-permissions-for-repo-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/rest/reference/teams#add-or-update-team-repository-permissions)" endpoint.
     *
     * To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.
     *
     * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
     */
    put: operations["teams/add-or-update-repo-permissions-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/rest/reference/teams#remove-a-repository-from-a-team) endpoint.
     *
     * If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
     */
    delete: operations["teams/remove-repo-legacy"];
  };
  "/teams/{team_id}/team-sync/group-mappings": {
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List IdP groups for a team`](https://docs.github.com/rest/reference/teams#list-idp-groups-for-a-team) endpoint.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * List IdP groups connected to a team on GitHub.
     */
    get: operations["teams/list-idp-groups-for-legacy"];
    /**
     * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create or update IdP group connections`](https://docs.github.com/rest/reference/teams#create-or-update-idp-group-connections) endpoint.
     *
     * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
     *
     * Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.
     */
    patch: operations["teams/create-or-update-idp-group-connections-legacy"];
  };
  "/teams/{team_id}/teams": {
    /** **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/rest/reference/teams#list-child-teams) endpoint. */
    get: operations["teams/list-child-legacy"];
  };
  "/user": {
    /**
     * If the authenticated user is authenticated through basic authentication or OAuth with the `user` scope, then the response lists public and private profile information.
     *
     * If the authenticated user is authenticated through OAuth without the `user` scope, then the response lists only public profile information.
     */
    get: operations["users/get-authenticated"];
    /** **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API. */
    patch: operations["users/update-authenticated"];
  };
  "/user/blocks": {
    /** List the users you've blocked on your personal account. */
    get: operations["users/list-blocked-by-authenticated-user"];
  };
  "/user/blocks/{username}": {
    get: operations["users/check-blocked"];
    put: operations["users/block"];
    delete: operations["users/unblock"];
  };
  "/user/codespaces": {
    /**
     * Lists the authenticated user's codespaces.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces` repository permission to use this endpoint.
     */
    get: operations["codespaces/list-for-authenticated-user"];
    /**
     * Creates a new codespace, owned by the authenticated user.
     *
     * This endpoint requires either a `repository_id` OR a `pull_request` but not both.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces` repository permission to use this endpoint.
     */
    post: operations["codespaces/create-for-authenticated-user"];
  };
  "/user/codespaces/secrets": {
    /**
     * Lists all secrets available for a user's Codespaces without revealing their
     * encrypted values.
     *
     * You must authenticate using an access token with the `codespace` or `codespace:secrets` scope to use this endpoint. User must have Codespaces access to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces_user_secrets` user permission to use this endpoint.
     */
    get: operations["codespaces/list-secrets-for-authenticated-user"];
  };
  "/user/codespaces/secrets/public-key": {
    /**
     * Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets.
     *
     * You must authenticate using an access token with the `codespace` or `codespace:secrets` scope to use this endpoint. User must have Codespaces access to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces_user_secrets` user permission to use this endpoint.
     */
    get: operations["codespaces/get-public-key-for-authenticated-user"];
  };
  "/user/codespaces/secrets/{secret_name}": {
    /**
     * Gets a secret available to a user's codespaces without revealing its encrypted value.
     *
     * You must authenticate using an access token with the `codespace` or `codespace:secrets` scope to use this endpoint. User must have Codespaces access to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces_user_secrets` user permission to use this endpoint.
     */
    get: operations["codespaces/get-secret-for-authenticated-user"];
    /**
     * Creates or updates a secret for a user's codespace with an encrypted value. Encrypt your secret using
     * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages).
     *
     * You must authenticate using an access token with the `codespace` or `codespace:secrets` scope to use this endpoint. User must also have Codespaces access to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces_user_secrets` user permission and `codespaces_secrets` repository permission on all referenced repositories to use this endpoint.
     *
     * #### Example encrypting a secret using Node.js
     *
     * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
     *
     * ```
     * const sodium = require('tweetsodium');
     *
     * const key = "base64-encoded-public-key";
     * const value = "plain-text-secret";
     *
     * // Convert the message and key to Uint8Array's (Buffer implements that interface)
     * const messageBytes = Buffer.from(value);
     * const keyBytes = Buffer.from(key, 'base64');
     *
     * // Encrypt using LibSodium.
     * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
     *
     * // Base64 the encrypted secret
     * const encrypted = Buffer.from(encryptedBytes).toString('base64');
     *
     * console.log(encrypted);
     * ```
     *
     *
     * #### Example encrypting a secret using Python
     *
     * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
     *
     * ```
     * from base64 import b64encode
     * from nacl import encoding, public
     *
     * def encrypt(public_key: str, secret_value: str) -> str:
     *   """Encrypt a Unicode string using the public key."""
     *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
     *   sealed_box = public.SealedBox(public_key)
     *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
     *   return b64encode(encrypted).decode("utf-8")
     * ```
     *
     * #### Example encrypting a secret using C#
     *
     * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
     *
     * ```
     * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
     * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
     *
     * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
     *
     * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
     * ```
     *
     * #### Example encrypting a secret using Ruby
     *
     * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
     *
     * ```ruby
     * require "rbnacl"
     * require "base64"
     *
     * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
     * public_key = RbNaCl::PublicKey.new(key)
     *
     * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
     * encrypted_secret = box.encrypt("my_secret")
     *
     * # Print the base64 encoded secret
     * puts Base64.strict_encode64(encrypted_secret)
     * ```
     */
    put: operations["codespaces/create-or-update-secret-for-authenticated-user"];
    /**
     * Deletes a secret from a user's codespaces using the secret name. Deleting the secret will remove access from all codespaces that were allowed to access the secret.
     *
     * You must authenticate using an access token with the `codespace` or `codespace:secrets` scope to use this endpoint. User must have Codespaces access to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces_user_secrets` user permission to use this endpoint.
     */
    delete: operations["codespaces/delete-secret-for-authenticated-user"];
  };
  "/user/codespaces/secrets/{secret_name}/repositories": {
    /**
     * List the repositories that have been granted the ability to use a user's codespace secret.
     *
     * You must authenticate using an access token with the `codespace` or `codespace:secrets` scope to use this endpoint. User must have Codespaces access to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces_user_secrets` user permission and write access to the `codespaces_secrets` repository permission on all referenced repositories to use this endpoint.
     */
    get: operations["codespaces/list-repositories-for-secret-for-authenticated-user"];
    /**
     * Select the repositories that will use a user's codespace secret.
     *
     * You must authenticate using an access token with the `codespace` or `codespace:secrets` scope to use this endpoint. User must have Codespaces access to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces_user_secrets` user permission and write access to the `codespaces_secrets` repository permission on all referenced repositories to use this endpoint.
     */
    put: operations["codespaces/set-repositories-for-secret-for-authenticated-user"];
  };
  "/user/codespaces/secrets/{secret_name}/repositories/{repository_id}": {
    /**
     * Adds a repository to the selected repositories for a user's codespace secret.
     * You must authenticate using an access token with the `codespace` or `codespace:secrets` scope to use this endpoint. User must have Codespaces access to use this endpoint.
     * GitHub Apps must have write access to the `codespaces_user_secrets` user permission and write access to the `codespaces_secrets` repository permission on the referenced repository to use this endpoint.
     */
    put: operations["codespaces/add-repository-for-secret-for-authenticated-user"];
    /**
     * Removes a repository from the selected repositories for a user's codespace secret.
     * You must authenticate using an access token with the `codespace` or `codespace:secrets` scope to use this endpoint. User must have Codespaces access to use this endpoint.
     * GitHub Apps must have write access to the `codespaces_user_secrets` user permission to use this endpoint.
     */
    delete: operations["codespaces/remove-repository-for-secret-for-authenticated-user"];
  };
  "/user/codespaces/{codespace_name}": {
    /**
     * Gets information about a user's codespace.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces` repository permission to use this endpoint.
     */
    get: operations["codespaces/get-for-authenticated-user"];
    /**
     * Deletes a user's codespace.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces` repository permission to use this endpoint.
     */
    delete: operations["codespaces/delete-for-authenticated-user"];
    /**
     * Updates a codespace owned by the authenticated user. Currently only the codespace's machine type and recent folders can be modified using this endpoint.
     *
     * If you specify a new machine type it will be applied the next time your codespace is started.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces` repository permission to use this endpoint.
     */
    patch: operations["codespaces/update-for-authenticated-user"];
  };
  "/user/codespaces/{codespace_name}/exports": {
    /**
     * Triggers an export of the specified codespace and returns a URL and ID where the status of the export can be monitored.
     *
     * You must authenticate using a personal access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces_lifecycle_admin` repository permission to use this endpoint.
     */
    post: operations["codespaces/export-for-authenticated-user"];
  };
  "/user/codespaces/{codespace_name}/exports/{export_id}": {
    /**
     * Gets information about an export of a codespace.
     *
     * You must authenticate using a personal access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces_lifecycle_admin` repository permission to use this endpoint.
     */
    get: operations["codespaces/get-export-details-for-authenticated-user"];
  };
  "/user/codespaces/{codespace_name}/machines": {
    /**
     * List the machine types a codespace can transition to use.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have read access to the `codespaces_metadata` repository permission to use this endpoint.
     */
    get: operations["codespaces/codespace-machines-for-authenticated-user"];
  };
  "/user/codespaces/{codespace_name}/start": {
    /**
     * Starts a user's codespace.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces_lifecycle_admin` repository permission to use this endpoint.
     */
    post: operations["codespaces/start-for-authenticated-user"];
  };
  "/user/codespaces/{codespace_name}/stop": {
    /**
     * Stops a user's codespace.
     *
     * You must authenticate using an access token with the `codespace` scope to use this endpoint.
     *
     * GitHub Apps must have write access to the `codespaces_lifecycle_admin` repository permission to use this endpoint.
     */
    post: operations["codespaces/stop-for-authenticated-user"];
  };
  "/user/email/visibility": {
    /** Sets the visibility for your primary email addresses. */
    patch: operations["users/set-primary-email-visibility-for-authenticated-user"];
  };
  "/user/emails": {
    /** Lists all of your email addresses, and specifies which one is visible to the public. This endpoint is accessible with the `user:email` scope. */
    get: operations["users/list-emails-for-authenticated-user"];
    /** This endpoint is accessible with the `user` scope. */
    post: operations["users/add-email-for-authenticated-user"];
    /** This endpoint is accessible with the `user` scope. */
    delete: operations["users/delete-email-for-authenticated-user"];
  };
  "/user/followers": {
    /** Lists the people following the authenticated user. */
    get: operations["users/list-followers-for-authenticated-user"];
  };
  "/user/following": {
    /** Lists the people who the authenticated user follows. */
    get: operations["users/list-followed-by-authenticated-user"];
  };
  "/user/following/{username}": {
    get: operations["users/check-person-is-followed-by-authenticated"];
    /**
     * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
     *
     * Following a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope.
     */
    put: operations["users/follow"];
    /** Unfollowing a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope. */
    delete: operations["users/unfollow"];
  };
  "/user/gpg_keys": {
    /** Lists the current user's GPG keys. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    get: operations["users/list-gpg-keys-for-authenticated-user"];
    /** Adds a GPG key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    post: operations["users/create-gpg-key-for-authenticated-user"];
  };
  "/user/gpg_keys/{gpg_key_id}": {
    /** View extended details for a single GPG key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    get: operations["users/get-gpg-key-for-authenticated-user"];
    /** Removes a GPG key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    delete: operations["users/delete-gpg-key-for-authenticated-user"];
  };
  "/user/installations": {
    /**
     * Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
     *
     * You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     *
     * You can find the permissions for the installation under the `permissions` key.
     */
    get: operations["apps/list-installations-for-authenticated-user"];
  };
  "/user/installations/{installation_id}/repositories": {
    /**
     * List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     *
     * You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
     *
     * The access the user has to each repository is included in the hash under the `permissions` key.
     */
    get: operations["apps/list-installation-repos-for-authenticated-user"];
  };
  "/user/installations/{installation_id}/repositories/{repository_id}": {
    /**
     * Add a single repository to an installation. The authenticated user must have admin access to the repository.
     *
     * You must use a personal access token (which you can create via the [command line](https://docs.github.com/github/authenticating-to-github/creating-a-personal-access-token) or [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication)) to access this endpoint.
     */
    put: operations["apps/add-repo-to-installation-for-authenticated-user"];
    /**
     * Remove a single repository from an installation. The authenticated user must have admin access to the repository.
     *
     * You must use a personal access token (which you can create via the [command line](https://docs.github.com/github/authenticating-to-github/creating-a-personal-access-token) or [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication)) to access this endpoint.
     */
    delete: operations["apps/remove-repo-from-installation-for-authenticated-user"];
  };
  "/user/interaction-limits": {
    /** Shows which type of GitHub user can interact with your public repositories and when the restriction expires. */
    get: operations["interactions/get-restrictions-for-authenticated-user"];
    /** Temporarily restricts which type of GitHub user can interact with your public repositories. Setting the interaction limit at the user level will overwrite any interaction limits that are set for individual repositories owned by the user. */
    put: operations["interactions/set-restrictions-for-authenticated-user"];
    /** Removes any interaction restrictions from your public repositories. */
    delete: operations["interactions/remove-restrictions-for-authenticated-user"];
  };
  "/user/issues": {
    /**
     * List issues across owned and member repositories assigned to the authenticated user.
     *
     * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
     * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
     * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
     * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
     */
    get: operations["issues/list-for-authenticated-user"];
  };
  "/user/keys": {
    /** Lists the public SSH keys for the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    get: operations["users/list-public-ssh-keys-for-authenticated-user"];
    /** Adds a public SSH key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    post: operations["users/create-public-ssh-key-for-authenticated-user"];
  };
  "/user/keys/{key_id}": {
    /** View extended details for a single public SSH key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    get: operations["users/get-public-ssh-key-for-authenticated-user"];
    /** Removes a public SSH key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). */
    delete: operations["users/delete-public-ssh-key-for-authenticated-user"];
  };
  "/user/marketplace_purchases": {
    /** Lists the active subscriptions for the authenticated user. You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/). */
    get: operations["apps/list-subscriptions-for-authenticated-user"];
  };
  "/user/marketplace_purchases/stubbed": {
    /** Lists the active subscriptions for the authenticated user. You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/). */
    get: operations["apps/list-subscriptions-for-authenticated-user-stubbed"];
  };
  "/user/memberships/orgs": {
    get: operations["orgs/list-memberships-for-authenticated-user"];
  };
  "/user/memberships/orgs/{org}": {
    get: operations["orgs/get-membership-for-authenticated-user"];
    patch: operations["orgs/update-membership-for-authenticated-user"];
  };
  "/user/migrations": {
    /** Lists all migrations a user has started. */
    get: operations["migrations/list-for-authenticated-user"];
    /** Initiates the generation of a user migration archive. */
    post: operations["migrations/start-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}": {
    /**
     * Fetches a single user migration. The response includes the `state` of the migration, which can be one of the following values:
     *
     * *   `pending` - the migration hasn't started yet.
     * *   `exporting` - the migration is in progress.
     * *   `exported` - the migration finished successfully.
     * *   `failed` - the migration failed.
     *
     * Once the migration has been `exported` you can [download the migration archive](https://docs.github.com/rest/reference/migrations#download-a-user-migration-archive).
     */
    get: operations["migrations/get-status-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}/archive": {
    /**
     * Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:
     *
     * *   attachments
     * *   bases
     * *   commit\_comments
     * *   issue\_comments
     * *   issue\_events
     * *   issues
     * *   milestones
     * *   organizations
     * *   projects
     * *   protected\_branches
     * *   pull\_request\_reviews
     * *   pull\_requests
     * *   releases
     * *   repositories
     * *   review\_comments
     * *   schema
     * *   users
     *
     * The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.
     */
    get: operations["migrations/get-archive-for-authenticated-user"];
    /** Deletes a previous migration archive. Downloadable migration archives are automatically deleted after seven days. Migration metadata, which is returned in the [List user migrations](https://docs.github.com/rest/reference/migrations#list-user-migrations) and [Get a user migration status](https://docs.github.com/rest/reference/migrations#get-a-user-migration-status) endpoints, will continue to be available even after an archive is deleted. */
    delete: operations["migrations/delete-archive-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}/repos/{repo_name}/lock": {
    /** Unlocks a repository. You can lock repositories when you [start a user migration](https://docs.github.com/rest/reference/migrations#start-a-user-migration). Once the migration is complete you can unlock each repository to begin using it again or [delete the repository](https://docs.github.com/rest/reference/repos#delete-a-repository) if you no longer need the source data. Returns a status of `404 Not Found` if the repository is not locked. */
    delete: operations["migrations/unlock-repo-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}/repositories": {
    /** Lists all the repositories for this user migration. */
    get: operations["migrations/list-repos-for-authenticated-user"];
  };
  "/user/orgs": {
    /**
     * List organizations for the authenticated user.
     *
     * **OAuth scope requirements**
     *
     * This only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope. OAuth requests with insufficient scope receive a `403 Forbidden` response.
     */
    get: operations["orgs/list-for-authenticated-user"];
  };
  "/user/packages": {
    /**
     * Lists packages owned by the authenticated user within the user's namespace.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/list-packages-for-authenticated-user"];
  };
  "/user/packages/{package_type}/{package_name}": {
    /**
     * Gets a specific package for a package owned by the authenticated user.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/get-package-for-authenticated-user"];
    /**
     * Deletes a package owned by the authenticated user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:delete` scopes.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    delete: operations["packages/delete-package-for-authenticated-user"];
  };
  "/user/packages/{package_type}/{package_name}/restore": {
    /**
     * Restores a package owned by the authenticated user.
     *
     * You can restore a deleted package under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:write` scopes. If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    post: operations["packages/restore-package-for-authenticated-user"];
  };
  "/user/packages/{package_type}/{package_name}/versions": {
    /**
     * Returns all package versions for a package owned by the authenticated user.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/get-all-package-versions-for-package-owned-by-authenticated-user"];
  };
  "/user/packages/{package_type}/{package_name}/versions/{package_version_id}": {
    /**
     * Gets a specific package version for a package owned by the authenticated user.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/get-package-version-for-authenticated-user"];
    /**
     * Deletes a specific package version for a package owned by the authenticated user.  If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
     *
     * To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:delete` scopes.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    delete: operations["packages/delete-package-version-for-authenticated-user"];
  };
  "/user/packages/{package_type}/{package_name}/versions/{package_version_id}/restore": {
    /**
     * Restores a package version owned by the authenticated user.
     *
     * You can restore a deleted package version under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:write` scopes. If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    post: operations["packages/restore-package-version-for-authenticated-user"];
  };
  "/user/projects": {
    post: operations["projects/create-for-authenticated-user"];
  };
  "/user/public_emails": {
    /** Lists your publicly visible email address, which you can set with the [Set primary email visibility for the authenticated user](https://docs.github.com/rest/reference/users#set-primary-email-visibility-for-the-authenticated-user) endpoint. This endpoint is accessible with the `user:email` scope. */
    get: operations["users/list-public-emails-for-authenticated-user"];
  };
  "/user/repos": {
    /**
     * Lists repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
     *
     * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
     */
    get: operations["repos/list-for-authenticated-user"];
    /**
     * Creates a new repository for the authenticated user.
     *
     * **OAuth scope requirements**
     *
     * When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
     *
     * *   `public_repo` scope or `repo` scope to create a public repository. Note: For GitHub AE, use `repo` scope to create an internal repository.
     * *   `repo` scope to create a private repository.
     */
    post: operations["repos/create-for-authenticated-user"];
  };
  "/user/repository_invitations": {
    /** When authenticating as a user, this endpoint will list all currently open repository invitations for that user. */
    get: operations["repos/list-invitations-for-authenticated-user"];
  };
  "/user/repository_invitations/{invitation_id}": {
    delete: operations["repos/decline-invitation-for-authenticated-user"];
    patch: operations["repos/accept-invitation-for-authenticated-user"];
  };
  "/user/starred": {
    /**
     * Lists repositories the authenticated user has starred.
     *
     * You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
     */
    get: operations["activity/list-repos-starred-by-authenticated-user"];
  };
  "/user/starred/{owner}/{repo}": {
    get: operations["activity/check-repo-is-starred-by-authenticated-user"];
    /** Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)." */
    put: operations["activity/star-repo-for-authenticated-user"];
    delete: operations["activity/unstar-repo-for-authenticated-user"];
  };
  "/user/subscriptions": {
    /** Lists repositories the authenticated user is watching. */
    get: operations["activity/list-watched-repos-for-authenticated-user"];
  };
  "/user/teams": {
    /** List all of the teams across all of the organizations to which the authenticated user belongs. This method requires `user`, `repo`, or `read:org` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/) when authenticating via [OAuth](https://docs.github.com/apps/building-oauth-apps/). */
    get: operations["teams/list-for-authenticated-user"];
  };
  "/users": {
    /**
     * Lists all users, in the order that they signed up on GitHub. This list includes personal user accounts and organization accounts.
     *
     * Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of users.
     */
    get: operations["users/list"];
  };
  "/users/{username}": {
    /**
     * Provides publicly available information about someone with a GitHub account.
     *
     * GitHub Apps with the `Plan` user permission can use this endpoint to retrieve information about a user's GitHub plan. The GitHub App must be authenticated as a user. See "[Identifying and authorizing users for GitHub Apps](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/)" for details about authentication. For an example response, see 'Response with GitHub plan information' below"
     *
     * The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be “public” which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://docs.github.com/rest/overview/resources-in-the-rest-api#authentication).
     *
     * The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see "[Emails API](https://docs.github.com/rest/reference/users#emails)".
     */
    get: operations["users/get-by-username"];
  };
  "/users/{username}/events": {
    /** If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events. */
    get: operations["activity/list-events-for-authenticated-user"];
  };
  "/users/{username}/events/orgs/{org}": {
    /** This is the user's organization dashboard. You must be authenticated as the user to view this. */
    get: operations["activity/list-org-events-for-authenticated-user"];
  };
  "/users/{username}/events/public": {
    get: operations["activity/list-public-events-for-user"];
  };
  "/users/{username}/followers": {
    /** Lists the people following the specified user. */
    get: operations["users/list-followers-for-user"];
  };
  "/users/{username}/following": {
    /** Lists the people who the specified user follows. */
    get: operations["users/list-following-for-user"];
  };
  "/users/{username}/following/{target_user}": {
    get: operations["users/check-following-for-user"];
  };
  "/users/{username}/gists": {
    /** Lists public gists for the specified user: */
    get: operations["gists/list-for-user"];
  };
  "/users/{username}/gpg_keys": {
    /** Lists the GPG keys for a user. This information is accessible by anyone. */
    get: operations["users/list-gpg-keys-for-user"];
  };
  "/users/{username}/hovercard": {
    /**
     * Provides hovercard information when authenticated through basic auth or OAuth with the `repo` scope. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.
     *
     * The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository via cURL, it would look like this:
     *
     * ```shell
     *  curl -u username:token
     *   https://api.github.com/users/octocat/hovercard?subject_type=repository&subject_id=1300192
     * ```
     */
    get: operations["users/get-context-for-user"];
  };
  "/users/{username}/installation": {
    /**
     * Enables an authenticated GitHub App to find the user’s installation information.
     *
     * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
     */
    get: operations["apps/get-user-installation"];
  };
  "/users/{username}/keys": {
    /** Lists the _verified_ public SSH keys for a user. This is accessible by anyone. */
    get: operations["users/list-public-keys-for-user"];
  };
  "/users/{username}/orgs": {
    /**
     * List [public organization memberships](https://docs.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.
     *
     * This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/rest/reference/orgs#list-organizations-for-the-authenticated-user) API instead.
     */
    get: operations["orgs/list-for-user"];
  };
  "/users/{username}/packages": {
    /**
     * Lists all packages in a user's namespace for which the requesting user has access.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/list-packages-for-user"];
  };
  "/users/{username}/packages/{package_type}/{package_name}": {
    /**
     * Gets a specific package metadata for a public package owned by a user.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/get-package-for-user"];
    /**
     * Deletes an entire package for a user. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:delete` scopes. In addition:
     * - If `package_type` is not `container`, your token must also include the `repo` scope.
     * - If `package_type` is `container`, you must also have admin permissions to the container you want to delete.
     */
    delete: operations["packages/delete-package-for-user"];
  };
  "/users/{username}/packages/{package_type}/{package_name}/restore": {
    /**
     * Restores an entire package for a user.
     *
     * You can restore a deleted package under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:write` scopes. In addition:
     * - If `package_type` is not `container`, your token must also include the `repo` scope.
     * - If `package_type` is `container`, you must also have admin permissions to the container that you want to restore.
     */
    post: operations["packages/restore-package-for-user"];
  };
  "/users/{username}/packages/{package_type}/{package_name}/versions": {
    /**
     * Returns all package versions for a public package owned by a specified user.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/get-all-package-versions-for-package-owned-by-user"];
  };
  "/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}": {
    /**
     * Gets a specific package version for a public package owned by a specified user.
     *
     * At this time, to use this endpoint, you must authenticate using an access token with the `packages:read` scope.
     * If `package_type` is not `container`, your token must also include the `repo` scope.
     */
    get: operations["packages/get-package-version-for-user"];
    /**
     * Deletes a specific package version for a user. If the package is public and the package version has more than 5,000 downloads, you cannot delete the package version. In this scenario, contact GitHub support for further assistance.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:delete` scopes. In addition:
     * - If `package_type` is not `container`, your token must also include the `repo` scope.
     * - If `package_type` is `container`, you must also have admin permissions to the container you want to delete.
     */
    delete: operations["packages/delete-package-version-for-user"];
  };
  "/users/{username}/packages/{package_type}/{package_name}/versions/{package_version_id}/restore": {
    /**
     * Restores a specific package version for a user.
     *
     * You can restore a deleted package under the following conditions:
     *   - The package was deleted within the last 30 days.
     *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
     *
     * To use this endpoint, you must authenticate using an access token with the `packages:read` and `packages:write` scopes. In addition:
     * - If `package_type` is not `container`, your token must also include the `repo` scope.
     * - If `package_type` is `container`, you must also have admin permissions to the container that you want to restore.
     */
    post: operations["packages/restore-package-version-for-user"];
  };
  "/users/{username}/projects": {
    get: operations["projects/list-for-user"];
  };
  "/users/{username}/received_events": {
    /** These are events that you've received by watching repos and following users. If you are authenticated as the given user, you will see private events. Otherwise, you'll only see public events. */
    get: operations["activity/list-received-events-for-user"];
  };
  "/users/{username}/received_events/public": {
    get: operations["activity/list-received-public-events-for-user"];
  };
  "/users/{username}/repos": {
    /** Lists public repositories for the specified user. Note: For GitHub AE, this endpoint will list internal repositories for the specified user. */
    get: operations["repos/list-for-user"];
  };
  "/users/{username}/settings/billing/actions": {
    /**
     * Gets the summary of the free and paid GitHub Actions minutes used.
     *
     * Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage returned includes any minute multipliers for macOS and Windows runners, and is rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
     *
     * Access tokens must have the `user` scope.
     */
    get: operations["billing/get-github-actions-billing-user"];
  };
  "/users/{username}/settings/billing/packages": {
    /**
     * Gets the free and paid storage used for GitHub Packages in gigabytes.
     *
     * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
     *
     * Access tokens must have the `user` scope.
     */
    get: operations["billing/get-github-packages-billing-user"];
  };
  "/users/{username}/settings/billing/shared-storage": {
    /**
     * Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.
     *
     * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
     *
     * Access tokens must have the `user` scope.
     */
    get: operations["billing/get-shared-storage-billing-user"];
  };
  "/users/{username}/starred": {
    /**
     * Lists repositories a user has starred.
     *
     * You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
     */
    get: operations["activity/list-repos-starred-by-user"];
  };
  "/users/{username}/subscriptions": {
    /** Lists repositories a user is watching. */
    get: operations["activity/list-repos-watched-by-user"];
  };
  "/zen": {
    /** Get a random sentence from the Zen of GitHub */
    get: operations["meta/get-zen"];
  };
  "/repos/{owner}/{repo}/compare/{base}...{head}": {
    /**
     * **Deprecated**: Use `repos.compareCommitsWithBasehead()` (`GET /repos/{owner}/{repo}/compare/{basehead}`) instead. Both `:base` and `:head` must be branch names in `:repo`. To compare branches across other repositories in the same network as `:repo`, use the format `<USERNAME>:branch`.
     *
     * The response from the API is equivalent to running the `git log base..head` command; however, commits are returned in chronological order. Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
     *
     * The response also includes details on the files that were changed between the two commits. This includes the status of the change (for example, if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
     *
     * **Working with large comparisons**
     *
     * To process a response with a large number of commits, you can use (`per_page` or `page`) to paginate the results. When using paging, the list of changed files is only returned with page 1, but includes all changed files for the entire comparison. For more information on working with pagination, see "[Traversing with pagination](/rest/guides/traversing-with-pagination)."
     *
     * When calling this API without any paging parameters (`per_page` or `page`), the returned list is limited to 250 commits and the last commit in the list is the most recent of the entire comparison. When a paging parameter is specified, the first commit in the returned list of each page is the earliest.
     *
     * **Signature verification object**
     *
     * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
     *
     * | Name | Type | Description |
     * | ---- | ---- | ----------- |
     * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
     * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
     * | `signature` | `string` | The signature that was extracted from the commit. |
     * | `payload` | `string` | The value that was signed. |
     *
     * These are the possible values for `reason` in the `verification` object:
     *
     * | Value | Description |
     * | ----- | ----------- |
     * | `expired_key` | The key that made the signature is expired. |
     * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
     * | `gpgverify_error` | There was an error communicating with the signature verification service. |
     * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
     * | `unsigned` | The object does not include a signature. |
     * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
     * | `no_user` | No user was associated with the `committer` email address in the commit. |
     * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
     * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
     * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
     * | `malformed_signature` | There was an error parsing the signature. |
     * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
     * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
     */
    get: operations["repos/compare-commits"];
  };
  "/repos/{owner}/{repo}/community/code_of_conduct": {
    /**
     * Returns the contents of the repository's code of conduct file, if one is detected.
     *
     * A code of conduct is detected if there is a file named `CODE_OF_CONDUCT` in the root directory of the repository. GitHub detects which code of conduct it is using fuzzy matching.
     */
    get: operations["codes-of-conduct/get-for-repo"];
  };
}

export interface components {
  schemas: {
    root: {
      current_user_url: string;
      current_user_authorizations_html_url: string;
      authorizations_url: string;
      code_search_url: string;
      commit_search_url: string;
      emails_url: string;
      emojis_url: string;
      events_url: string;
      feeds_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      hub_url: string;
      issue_search_url: string;
      issues_url: string;
      keys_url: string;
      label_search_url: string;
      notifications_url: string;
      organization_url: string;
      organization_repositories_url: string;
      organization_teams_url: string;
      public_gists_url: string;
      rate_limit_url: string;
      repository_url: string;
      repository_search_url: string;
      current_user_repositories_url: string;
      starred_url: string;
      starred_gists_url: string;
      topic_search_url?: string;
      user_url: string;
      user_organizations_url: string;
      user_repositories_url: string;
      user_search_url: string;
    };
    /** Simple User */
    "nullable-simple-user": {
      name?: string | null;
      email?: string | null;
      login: string;
      id: number;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      events_url: string;
      received_events_url: string;
      type: string;
      site_admin: boolean;
      starred_at?: string;
    } | null;
    /** GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub. */
    integration: {
      /** Unique identifier of the GitHub app */
      id: number;
      /** The slug name of the GitHub app */
      slug?: string;
      node_id: string;
      owner: components["schemas"]["nullable-simple-user"];
      /** The name of the GitHub app */
      name: string;
      description: string | null;
      external_url: string;
      html_url: string;
      created_at: string;
      updated_at: string;
      /** The set of permissions for the GitHub app */
      permissions: {
        issues?: string;
        checks?: string;
        metadata?: string;
        contents?: string;
        deployments?: string;
      } & { [key: string]: string };
      /** The list of events for the GitHub app */
      events: string[];
      /** The number of installations associated with the GitHub app */
      installations_count?: number;
      client_id?: string;
      client_secret?: string;
      webhook_secret?: string | null;
      pem?: string;
    };
    /** Basic Error */
    "basic-error": {
      message?: string;
      documentation_url?: string;
      url?: string;
      status?: string;
    };
    /** Validation Error Simple */
    "validation-error-simple": {
      message: string;
      documentation_url: string;
      errors?: string[];
    };
    /** The URL to which the payloads will be delivered. */
    "webhook-config-url": string;
    /** The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`. */
    "webhook-config-content-type": string;
    /** If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers). */
    "webhook-config-secret": string;
    "webhook-config-insecure-ssl": string | number;
    /** Configuration object of the webhook */
    "webhook-config": {
      url?: components["schemas"]["webhook-config-url"];
      content_type?: components["schemas"]["webhook-config-content-type"];
      secret?: components["schemas"]["webhook-config-secret"];
      insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
    };
    /** Delivery made by a webhook, without request and response information. */
    "hook-delivery-item": {
      /** Unique identifier of the webhook delivery. */
      id: number;
      /** Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event). */
      guid: string;
      /** Time when the webhook delivery occurred. */
      delivered_at: string;
      /** Whether the webhook delivery is a redelivery. */
      redelivery: boolean;
      /** Time spent delivering. */
      duration: number;
      /** Describes the response returned after attempting the delivery. */
      status: string;
      /** Status code received when delivery was made. */
      status_code: number;
      /** The event that triggered the delivery. */
      event: string;
      /** The type of activity for the event that triggered the delivery. */
      action: string | null;
      /** The id of the GitHub App installation associated with this event. */
      installation_id: number | null;
      /** The id of the repository associated with this event. */
      repository_id: number | null;
    };
    /** Scim Error */
    "scim-error": {
      message?: string | null;
      documentation_url?: string | null;
      detail?: string | null;
      status?: number;
      scimType?: string | null;
      schemas?: string[];
    };
    /** Validation Error */
    "validation-error": {
      message: string;
      documentation_url: string;
      errors?: {
        resource?: string;
        field?: string;
        message?: string;
        code: string;
        index?: number;
        value?: (string | null) | (number | null) | (string[] | null);
      }[];
    };
    /** Delivery made by a webhook. */
    "hook-delivery": {
      /** Unique identifier of the delivery. */
      id: number;
      /** Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event). */
      guid: string;
      /** Time when the delivery was delivered. */
      delivered_at: string;
      /** Whether the delivery is a redelivery. */
      redelivery: boolean;
      /** Time spent delivering. */
      duration: number;
      /** Description of the status of the attempted delivery */
      status: string;
      /** Status code received when delivery was made. */
      status_code: number;
      /** The event that triggered the delivery. */
      event: string;
      /** The type of activity for the event that triggered the delivery. */
      action: string | null;
      /** The id of the GitHub App installation associated with this event. */
      installation_id: number | null;
      /** The id of the repository associated with this event. */
      repository_id: number | null;
      /** The URL target of the delivery. */
      url?: string;
      request: {
        /** The request headers sent with the webhook delivery. */
        headers: { [key: string]: unknown } | null;
        /** The webhook payload. */
        payload: { [key: string]: unknown } | null;
      };
      response: {
        /** The response headers received when the delivery was made. */
        headers: { [key: string]: unknown } | null;
        /** The response payload received. */
        payload: string | null;
      };
    };
    /** Simple User */
    "simple-user": {
      name?: string | null;
      email?: string | null;
      login: string;
      id: number;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      events_url: string;
      received_events_url: string;
      type: string;
      site_admin: boolean;
      starred_at?: string;
    };
    /** An enterprise account */
    enterprise: {
      /** A short description of the enterprise. */
      description?: string | null;
      html_url: string;
      /** The enterprise's website URL. */
      website_url?: string | null;
      /** Unique identifier of the enterprise */
      id: number;
      node_id: string;
      /** The name of the enterprise. */
      name: string;
      /** The slug url identifier for the enterprise. */
      slug: string;
      created_at: string | null;
      updated_at: string | null;
      avatar_url: string;
    };
    /** The permissions granted to the user-to-server access token. */
    "app-permissions": {
      /** The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts. */
      actions?: "read" | "write";
      /** The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation. */
      administration?: "read" | "write";
      /** The level of permission to grant the access token for checks on code. */
      checks?: "read" | "write";
      /** The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges. */
      contents?: "read" | "write";
      /** The level of permission to grant the access token for deployments and deployment statuses. */
      deployments?: "read" | "write";
      /** The level of permission to grant the access token for managing repository environments. */
      environments?: "read" | "write";
      /** The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones. */
      issues?: "read" | "write";
      /** The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata. */
      metadata?: "read" | "write";
      /** The level of permission to grant the access token for packages published to GitHub Packages. */
      packages?: "read" | "write";
      /** The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds. */
      pages?: "read" | "write";
      /** The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges. */
      pull_requests?: "read" | "write";
      /** The level of permission to grant the access token to manage the post-receive hooks for a repository. */
      repository_hooks?: "read" | "write";
      /** The level of permission to grant the access token to manage repository projects, columns, and cards. */
      repository_projects?: "read" | "write" | "admin";
      /** The level of permission to grant the access token to view and manage secret scanning alerts. */
      secret_scanning_alerts?: "read" | "write";
      /** The level of permission to grant the access token to manage repository secrets. */
      secrets?: "read" | "write";
      /** The level of permission to grant the access token to view and manage security events like code scanning alerts. */
      security_events?: "read" | "write";
      /** The level of permission to grant the access token to manage just a single file. */
      single_file?: "read" | "write";
      /** The level of permission to grant the access token for commit statuses. */
      statuses?: "read" | "write";
      /** The level of permission to grant the access token to manage Dependabot alerts. */
      vulnerability_alerts?: "read" | "write";
      /** The level of permission to grant the access token to update GitHub Actions workflow files. */
      workflows?: "write";
      /** The level of permission to grant the access token for organization teams and members. */
      members?: "read" | "write";
      /** The level of permission to grant the access token to manage access to an organization. */
      organization_administration?: "read" | "write";
      /** The level of permission to grant the access token to manage the post-receive hooks for an organization. */
      organization_hooks?: "read" | "write";
      /** The level of permission to grant the access token for viewing an organization's plan. */
      organization_plan?: "read";
      /** The level of permission to grant the access token to manage organization projects and projects beta (where available). */
      organization_projects?: "read" | "write" | "admin";
      /** The level of permission to grant the access token for organization packages published to GitHub Packages. */
      organization_packages?: "read" | "write";
      /** The level of permission to grant the access token to manage organization secrets. */
      organization_secrets?: "read" | "write";
      /** The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization. */
      organization_self_hosted_runners?: "read" | "write";
      /** The level of permission to grant the access token to view and manage users blocked by the organization. */
      organization_user_blocking?: "read" | "write";
      /** The level of permission to grant the access token to manage team discussions and related comments. */
      team_discussions?: "read" | "write";
    };
    /** Installation */
    installation: {
      /** The ID of the installation. */
      id: number;
      account:
        | (Partial<components["schemas"]["simple-user"]> &
            Partial<components["schemas"]["enterprise"]>)
        | null;
      /** Describe whether all repositories have been selected or there's a selection involved */
      repository_selection: "all" | "selected";
      access_tokens_url: string;
      repositories_url: string;
      html_url: string;
      app_id: number;
      /** The ID of the user or organization this token is being scoped to. */
      target_id: number;
      target_type: string;
      permissions: components["schemas"]["app-permissions"];
      events: string[];
      created_at: string;
      updated_at: string;
      single_file_name: string | null;
      has_multiple_single_files?: boolean;
      single_file_paths?: string[];
      app_slug: string;
      suspended_by: components["schemas"]["nullable-simple-user"];
      suspended_at: string | null;
      contact_email?: string | null;
    };
    /** License Simple */
    "nullable-license-simple": {
      key: string;
      name: string;
      url: string | null;
      spdx_id: string | null;
      node_id: string;
      html_url?: string;
    } | null;
    /** A git repository */
    repository: {
      /** Unique identifier of the repository */
      id: number;
      node_id: string;
      /** The name of the repository. */
      name: string;
      full_name: string;
      license: components["schemas"]["nullable-license-simple"];
      organization?: components["schemas"]["nullable-simple-user"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["simple-user"];
      /** Whether the repository is private or public. */
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      deployments_url: string;
      downloads_url: string;
      events_url: string;
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      languages_url: string;
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url: string;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      tags_url: string;
      teams_url: string;
      trees_url: string;
      clone_url: string;
      mirror_url: string | null;
      hooks_url: string;
      svn_url: string;
      homepage: string | null;
      language: string | null;
      forks_count: number;
      stargazers_count: number;
      watchers_count: number;
      size: number;
      /** The default branch of the repository. */
      default_branch: string;
      open_issues_count: number;
      /** Whether this repository acts as a template that can be used to generate new repositories. */
      is_template?: boolean;
      topics?: string[];
      /** Whether issues are enabled. */
      has_issues: boolean;
      /** Whether projects are enabled. */
      has_projects: boolean;
      /** Whether the wiki is enabled. */
      has_wiki: boolean;
      has_pages: boolean;
      /** Whether downloads are enabled. */
      has_downloads: boolean;
      /** Whether the repository is archived. */
      archived: boolean;
      /** Returns whether or not this repository disabled. */
      disabled: boolean;
      /** The repository visibility: public, private, or internal. */
      visibility?: string;
      pushed_at: string | null;
      created_at: string | null;
      updated_at: string | null;
      /** Whether to allow rebase merges for pull requests. */
      allow_rebase_merge?: boolean;
      template_repository?: {
        id?: number;
        node_id?: string;
        name?: string;
        full_name?: string;
        owner?: {
          login?: string;
          id?: number;
          node_id?: string;
          avatar_url?: string;
          gravatar_id?: string;
          url?: string;
          html_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          starred_url?: string;
          subscriptions_url?: string;
          organizations_url?: string;
          repos_url?: string;
          events_url?: string;
          received_events_url?: string;
          type?: string;
          site_admin?: boolean;
        };
        private?: boolean;
        html_url?: string;
        description?: string;
        fork?: boolean;
        url?: string;
        archive_url?: string;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        deployments_url?: string;
        downloads_url?: string;
        events_url?: string;
        forks_url?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        languages_url?: string;
        merges_url?: string;
        milestones_url?: string;
        notifications_url?: string;
        pulls_url?: string;
        releases_url?: string;
        ssh_url?: string;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        tags_url?: string;
        teams_url?: string;
        trees_url?: string;
        clone_url?: string;
        mirror_url?: string;
        hooks_url?: string;
        svn_url?: string;
        homepage?: string;
        language?: string;
        forks_count?: number;
        stargazers_count?: number;
        watchers_count?: number;
        size?: number;
        default_branch?: string;
        open_issues_count?: number;
        is_template?: boolean;
        topics?: string[];
        has_issues?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        has_pages?: boolean;
        has_downloads?: boolean;
        archived?: boolean;
        disabled?: boolean;
        visibility?: string;
        pushed_at?: string;
        created_at?: string;
        updated_at?: string;
        permissions?: {
          admin?: boolean;
          maintain?: boolean;
          push?: boolean;
          triage?: boolean;
          pull?: boolean;
        };
        allow_rebase_merge?: boolean;
        temp_clone_token?: string;
        allow_squash_merge?: boolean;
        allow_auto_merge?: boolean;
        delete_branch_on_merge?: boolean;
        allow_update_branch?: boolean;
        use_squash_pr_title_as_default?: boolean;
        allow_merge_commit?: boolean;
        subscribers_count?: number;
        network_count?: number;
      } | null;
      temp_clone_token?: string;
      /** Whether to allow squash merges for pull requests. */
      allow_squash_merge?: boolean;
      /** Whether to allow Auto-merge to be used on pull requests. */
      allow_auto_merge?: boolean;
      /** Whether to delete head branches when pull requests are merged */
      delete_branch_on_merge?: boolean;
      /** Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging. */
      allow_update_branch?: boolean;
      /** Whether a squash merge commit can use the pull request title as default. */
      use_squash_pr_title_as_default?: boolean;
      /** Whether to allow merge commits for pull requests. */
      allow_merge_commit?: boolean;
      /** Whether to allow forking this repo */
      allow_forking?: boolean;
      subscribers_count?: number;
      network_count?: number;
      open_issues: number;
      watchers: number;
      master_branch?: string;
      starred_at?: string;
    };
    /** Authentication token for a GitHub App installed on a user or org. */
    "installation-token": {
      token: string;
      expires_at: string;
      permissions?: components["schemas"]["app-permissions"];
      repository_selection?: "all" | "selected";
      repositories?: components["schemas"]["repository"][];
      single_file?: string;
      has_multiple_single_files?: boolean;
      single_file_paths?: string[];
    };
    /** The authorization associated with an OAuth Access. */
    "application-grant": {
      id: number;
      url: string;
      app: {
        client_id: string;
        name: string;
        url: string;
      };
      created_at: string;
      updated_at: string;
      scopes: string[];
      user?: components["schemas"]["nullable-simple-user"];
    };
    "nullable-scoped-installation": {
      permissions: components["schemas"]["app-permissions"];
      /** Describe whether all repositories have been selected or there's a selection involved */
      repository_selection: "all" | "selected";
      single_file_name: string | null;
      has_multiple_single_files?: boolean;
      single_file_paths?: string[];
      repositories_url: string;
      account: components["schemas"]["simple-user"];
    } | null;
    /** The authorization for an OAuth app, GitHub App, or a Personal Access Token. */
    authorization: {
      id: number;
      url: string;
      /** A list of scopes that this authorization is in. */
      scopes: string[] | null;
      token: string;
      token_last_eight: string | null;
      hashed_token: string | null;
      app: {
        client_id: string;
        name: string;
        url: string;
      };
      note: string | null;
      note_url: string | null;
      updated_at: string;
      created_at: string;
      fingerprint: string | null;
      user?: components["schemas"]["nullable-simple-user"];
      installation?: components["schemas"]["nullable-scoped-installation"];
      expires_at: string | null;
    };
    /** Code Of Conduct */
    "code-of-conduct": {
      key: string;
      name: string;
      url: string;
      body?: string;
      html_url: string | null;
    };
    /** Response of S4 Proxy endpoint that provides GHES statistics */
    "server-statistics": {
      server_id?: string;
      collection_date?: string;
      schema_version?: string;
      ghes_version?: string;
      host_name?: string;
      github_connect?: {
        features_enabled?: string[];
      };
      ghe_stats?: {
        comments?: {
          total_commit_comments?: number;
          total_gist_comments?: number;
          total_issue_comments?: number;
          total_pull_request_comments?: number;
        };
        gists?: {
          total_gists?: number;
          private_gists?: number;
          public_gists?: number;
        };
        hooks?: {
          total_hooks?: number;
          active_hooks?: number;
          inactive_hooks?: number;
        };
        issues?: {
          total_issues?: number;
          open_issues?: number;
          closed_issues?: number;
        };
        milestones?: {
          total_milestones?: number;
          open_milestones?: number;
          closed_milestones?: number;
        };
        orgs?: {
          total_orgs?: number;
          disabled_orgs?: number;
          total_teams?: number;
          total_team_members?: number;
        };
        pages?: {
          total_pages?: number;
        };
        pulls?: {
          total_pulls?: number;
          merged_pulls?: number;
          mergeable_pulls?: number;
          unmergeable_pulls?: number;
        };
        repos?: {
          total_repos?: number;
          root_repos?: number;
          fork_repos?: number;
          org_repos?: number;
          total_pushes?: number;
          total_wikis?: number;
        };
        users?: {
          total_users?: number;
          admin_users?: number;
          suspended_users?: number;
        };
      };
      dormant_users?: {
        total_dormant_users?: number;
        dormancy_threshold?: string;
      };
    };
    "actions-cache-usage-org-enterprise": {
      /** The count of active caches across all repositories of an enterprise or an organization. */
      total_active_caches_count: number;
      /** The total size in bytes of all active cache items across all repositories of an enterprise or an organization. */
      total_active_caches_size_in_bytes: number;
    };
    "actions-oidc-custom-issuer-policy-for-enterprise": {
      /** Whether the enterprise customer requested a custom issuer URL. */
      include_enterprise_slug?: boolean;
    };
    /** The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions. */
    "enabled-organizations": "all" | "none" | "selected";
    /** The permissions policy that controls the actions and reusable workflows that are allowed to run. */
    "allowed-actions": "all" | "local_only" | "selected";
    /** The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`. */
    "selected-actions-url": string;
    "actions-enterprise-permissions": {
      enabled_organizations: components["schemas"]["enabled-organizations"];
      /** The API URL to use to get or set the selected organizations that are allowed to run GitHub Actions, when `enabled_organizations` is set to `selected`. */
      selected_organizations_url?: string;
      allowed_actions?: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    /** Organization Simple */
    "organization-simple": {
      login: string;
      id: number;
      node_id: string;
      url: string;
      repos_url: string;
      events_url: string;
      hooks_url: string;
      issues_url: string;
      members_url: string;
      public_members_url: string;
      avatar_url: string;
      description: string | null;
    };
    "selected-actions": {
      /** Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization. */
      github_owned_allowed?: boolean;
      /** Whether actions from GitHub Marketplace verified creators are allowed. Set to `true` to allow all actions by GitHub Marketplace verified creators. */
      verified_allowed?: boolean;
      /** Specifies a list of string-matching patterns to allow specific action(s) and reusable workflow(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`." */
      patterns_allowed?: string[];
    };
    /** The default workflow permissions granted to the GITHUB_TOKEN when running workflows. */
    "actions-default-workflow-permissions": "read" | "write";
    /** Whether GitHub Actions can approve pull requests. Enabling this can be a security risk. */
    "actions-can-approve-pull-request-reviews": boolean;
    "actions-get-default-workflow-permissions": {
      default_workflow_permissions: components["schemas"]["actions-default-workflow-permissions"];
      can_approve_pull_request_reviews: components["schemas"]["actions-can-approve-pull-request-reviews"];
    };
    "actions-set-default-workflow-permissions": {
      default_workflow_permissions?: components["schemas"]["actions-default-workflow-permissions"];
      can_approve_pull_request_reviews?: components["schemas"]["actions-can-approve-pull-request-reviews"];
    };
    "runner-groups-enterprise": {
      id: number;
      name: string;
      visibility: string;
      default: boolean;
      selected_organizations_url?: string;
      runners_url: string;
      allows_public_repositories: boolean;
      /** If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified. */
      workflow_restrictions_read_only?: boolean;
      /** If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array. */
      restricted_to_workflows?: boolean;
      /** List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`. */
      selected_workflows?: string[];
    };
    /** A label for a self hosted runner */
    "runner-label": {
      /** Unique identifier of the label. */
      id?: number;
      /** Name of the label. */
      name: string;
      /** The type of label. Read-only labels are applied automatically when the runner is configured. */
      type?: "read-only" | "custom";
    };
    /** A self hosted runner */
    runner: {
      /** The id of the runner. */
      id: number;
      /** The name of the runner. */
      name: string;
      /** The Operating System of the runner. */
      os: string;
      /** The status of the runner. */
      status: string;
      busy: boolean;
      labels: components["schemas"]["runner-label"][];
    };
    /** Runner Application */
    "runner-application": {
      os: string;
      architecture: string;
      download_url: string;
      filename: string;
      /** A short lived bearer token used to download the runner, if needed. */
      temp_download_token?: string;
      sha256_checksum?: string;
    };
    /** Authentication Token */
    "authentication-token": {
      /** The token used for authentication */
      token: string;
      /** The time this token expires */
      expires_at: string;
      permissions?: { [key: string]: unknown };
      /** The repositories this token has access to */
      repositories?: components["schemas"]["repository"][];
      single_file?: string | null;
      /** Describe whether all repositories have been selected or there's a selection involved */
      repository_selection?: "all" | "selected";
    };
    "audit-log-event": {
      /** The time the audit log event occurred, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time). */
      "@timestamp"?: number;
      /** The name of the action that was performed, for example `user.login` or `repo.create`. */
      action?: string;
      active?: boolean;
      active_was?: boolean;
      /** The actor who performed the action. */
      actor?: string;
      /** The id of the actor who performed the action. */
      actor_id?: number;
      actor_location?: {
        country_name?: string;
      };
      data?: { [key: string]: unknown };
      org_id?: number;
      /** The username of the account being blocked. */
      blocked_user?: string;
      business?: string;
      config?: { [key: string]: unknown }[];
      config_was?: { [key: string]: unknown }[];
      content_type?: string;
      /** The time the audit log event was recorded, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time). */
      created_at?: number;
      deploy_key_fingerprint?: string;
      /** A unique identifier for an audit event. */
      _document_id?: string;
      emoji?: string;
      events?: { [key: string]: unknown }[];
      events_were?: { [key: string]: unknown }[];
      explanation?: string;
      fingerprint?: string;
      hook_id?: number;
      limited_availability?: boolean;
      message?: string;
      name?: string;
      old_user?: string;
      openssh_public_key?: string;
      org?: string;
      previous_visibility?: string;
      read_only?: boolean;
      /** The name of the repository. */
      repo?: string;
      /** The name of the repository. */
      repository?: string;
      repository_public?: boolean;
      target_login?: string;
      team?: string;
      /** The type of protocol (for example, HTTP or SSH) used to transfer Git data. */
      transport_protocol?: number;
      /** A human readable name for the protocol (for example, HTTP or SSH) used to transfer Git data. */
      transport_protocol_name?: string;
      /** The user that was affected by the action performed (if available). */
      user?: string;
      /** The repository visibility, for example `public` or `private`. */
      visibility?: string;
    };
    /** The security alert number. */
    "alert-number": number;
    /** The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
    "alert-created-at": string;
    /** The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
    "nullable-alert-updated-at": string | null;
    /** The REST API URL of the alert resource. */
    "alert-url": string;
    /** The GitHub URL of the alert resource. */
    "alert-html-url": string;
    /** Sets the state of the secret scanning alert. Can be either `open` or `resolved`. You must provide `resolution` when you set the state to `resolved`. */
    "secret-scanning-alert-state": "open" | "resolved";
    /** **Required when the `state` is `resolved`.** The reason for resolving the alert. */
    "secret-scanning-alert-resolution":
      | ("false_positive" | "wont_fix" | "revoked" | "used_in_tests")
      | null;
    /** Simple Repository */
    "simple-repository": {
      /** A unique identifier of the repository. */
      id: number;
      /** The GraphQL identifier of the repository. */
      node_id: string;
      /** The name of the repository. */
      name: string;
      /** The full, globally unique, name of the repository. */
      full_name: string;
      owner: components["schemas"]["simple-user"];
      /** Whether the repository is private. */
      private: boolean;
      /** The URL to view the repository on GitHub.com. */
      html_url: string;
      /** The repository description. */
      description: string | null;
      /** Whether the repository is a fork. */
      fork: boolean;
      /** The URL to get more information about the repository from the GitHub API. */
      url: string;
      /** A template for the API URL to download the repository as an archive. */
      archive_url: string;
      /** A template for the API URL to list the available assignees for issues in the repository. */
      assignees_url: string;
      /** A template for the API URL to create or retrieve a raw Git blob in the repository. */
      blobs_url: string;
      /** A template for the API URL to get information about branches in the repository. */
      branches_url: string;
      /** A template for the API URL to get information about collaborators of the repository. */
      collaborators_url: string;
      /** A template for the API URL to get information about comments on the repository. */
      comments_url: string;
      /** A template for the API URL to get information about commits on the repository. */
      commits_url: string;
      /** A template for the API URL to compare two commits or refs. */
      compare_url: string;
      /** A template for the API URL to get the contents of the repository. */
      contents_url: string;
      /** A template for the API URL to list the contributors to the repository. */
      contributors_url: string;
      /** The API URL to list the deployments of the repository. */
      deployments_url: string;
      /** The API URL to list the downloads on the repository. */
      downloads_url: string;
      /** The API URL to list the events of the repository. */
      events_url: string;
      /** The API URL to list the forks of the repository. */
      forks_url: string;
      /** A template for the API URL to get information about Git commits of the repository. */
      git_commits_url: string;
      /** A template for the API URL to get information about Git refs of the repository. */
      git_refs_url: string;
      /** A template for the API URL to get information about Git tags of the repository. */
      git_tags_url: string;
      /** A template for the API URL to get information about issue comments on the repository. */
      issue_comment_url: string;
      /** A template for the API URL to get information about issue events on the repository. */
      issue_events_url: string;
      /** A template for the API URL to get information about issues on the repository. */
      issues_url: string;
      /** A template for the API URL to get information about deploy keys on the repository. */
      keys_url: string;
      /** A template for the API URL to get information about labels of the repository. */
      labels_url: string;
      /** The API URL to get information about the languages of the repository. */
      languages_url: string;
      /** The API URL to merge branches in the repository. */
      merges_url: string;
      /** A template for the API URL to get information about milestones of the repository. */
      milestones_url: string;
      /** A template for the API URL to get information about notifications on the repository. */
      notifications_url: string;
      /** A template for the API URL to get information about pull requests on the repository. */
      pulls_url: string;
      /** A template for the API URL to get information about releases on the repository. */
      releases_url: string;
      /** The API URL to list the stargazers on the repository. */
      stargazers_url: string;
      /** A template for the API URL to get information about statuses of a commit. */
      statuses_url: string;
      /** The API URL to list the subscribers on the repository. */
      subscribers_url: string;
      /** The API URL to subscribe to notifications for this repository. */
      subscription_url: string;
      /** The API URL to get information about tags on the repository. */
      tags_url: string;
      /** The API URL to list the teams on the repository. */
      teams_url: string;
      /** A template for the API URL to create or retrieve a raw Git tree of the repository. */
      trees_url: string;
      /** The API URL to list the hooks on the repository. */
      hooks_url: string;
    };
    "organization-secret-scanning-alert": {
      number?: components["schemas"]["alert-number"];
      created_at?: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["nullable-alert-updated-at"];
      url?: components["schemas"]["alert-url"];
      html_url?: components["schemas"]["alert-html-url"];
      /** The REST API URL of the code locations for this alert. */
      locations_url?: string;
      state?: components["schemas"]["secret-scanning-alert-state"];
      resolution?: components["schemas"]["secret-scanning-alert-resolution"];
      /** The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
      resolved_at?: string | null;
      resolved_by?: components["schemas"]["nullable-simple-user"];
      /** The type of secret that secret scanning detected. */
      secret_type?: string;
      /**
       * User-friendly name for the detected secret, matching the `secret_type`.
       * For a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."
       */
      secret_type_display_name?: string;
      /** The secret that was detected. */
      secret?: string;
      repository?: components["schemas"]["simple-repository"];
      /** Whether push protection was bypassed for the detected secret. */
      push_protection_bypassed?: boolean | null;
      push_protection_bypassed_by?: components["schemas"]["nullable-simple-user"];
      /** The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
      push_protection_bypassed_at?: string | null;
    };
    "actions-billing-usage": {
      /** The sum of the free and paid GitHub Actions minutes used. */
      total_minutes_used: number;
      /** The total paid GitHub Actions minutes used. */
      total_paid_minutes_used: number;
      /** The amount of free GitHub Actions minutes available. */
      included_minutes: number;
      minutes_used_breakdown: {
        /** Total minutes used on Ubuntu runner machines. */
        UBUNTU?: number;
        /** Total minutes used on macOS runner machines. */
        MACOS?: number;
        /** Total minutes used on Windows runner machines. */
        WINDOWS?: number;
        /** Total minutes used on Ubuntu 4 core runner machines. */
        ubuntu_4_core?: number;
        /** Total minutes used on Ubuntu 8 core runner machines. */
        ubuntu_8_core?: number;
        /** Total minutes used on Ubuntu 16 core runner machines. */
        ubuntu_16_core?: number;
        /** Total minutes used on Ubuntu 32 core runner machines. */
        ubuntu_32_core?: number;
        /** Total minutes used on Ubuntu 64 core runner machines. */
        ubuntu_64_core?: number;
        /** Total minutes used on Windows 4 core runner machines. */
        windows_4_core?: number;
        /** Total minutes used on Windows 8 core runner machines. */
        windows_8_core?: number;
        /** Total minutes used on Windows 16 core runner machines. */
        windows_16_core?: number;
        /** Total minutes used on Windows 32 core runner machines. */
        windows_32_core?: number;
        /** Total minutes used on Windows 64 core runner machines. */
        windows_64_core?: number;
        /** Total minutes used on all runner machines. */
        total?: number;
      };
    };
    "advanced-security-active-committers-user": {
      user_login: string;
      last_pushed_date: string;
    };
    "advanced-security-active-committers-repository": {
      name: string;
      advanced_security_committers: number;
      advanced_security_committers_breakdown: components["schemas"]["advanced-security-active-committers-user"][];
    };
    "advanced-security-active-committers": {
      total_advanced_security_committers?: number;
      total_count?: number;
      repositories: components["schemas"]["advanced-security-active-committers-repository"][];
    };
    "packages-billing-usage": {
      /** Sum of the free and paid storage space (GB) for GitHuub Packages. */
      total_gigabytes_bandwidth_used: number;
      /** Total paid storage space (GB) for GitHuub Packages. */
      total_paid_gigabytes_bandwidth_used: number;
      /** Free storage space (GB) for GitHub Packages. */
      included_gigabytes_bandwidth: number;
    };
    "combined-billing-usage": {
      /** Numbers of days left in billing cycle. */
      days_left_in_billing_cycle: number;
      /** Estimated storage space (GB) used in billing cycle. */
      estimated_paid_storage_for_month: number;
      /** Estimated sum of free and paid storage space (GB) used in billing cycle. */
      estimated_storage_for_month: number;
    };
    /** Actor */
    actor: {
      id: number;
      login: string;
      display_login?: string;
      gravatar_id: string | null;
      url: string;
      avatar_url: string;
    };
    /** A collection of related issues and pull requests. */
    "nullable-milestone": {
      url: string;
      html_url: string;
      labels_url: string;
      id: number;
      node_id: string;
      /** The number of the milestone. */
      number: number;
      /** The state of the milestone. */
      state: "open" | "closed";
      /** The title of the milestone. */
      title: string;
      description: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      open_issues: number;
      closed_issues: number;
      created_at: string;
      updated_at: string;
      closed_at: string | null;
      due_on: string | null;
    } | null;
    /** GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub. */
    "nullable-integration": {
      /** Unique identifier of the GitHub app */
      id: number;
      /** The slug name of the GitHub app */
      slug?: string;
      node_id: string;
      owner: components["schemas"]["nullable-simple-user"];
      /** The name of the GitHub app */
      name: string;
      description: string | null;
      external_url: string;
      html_url: string;
      created_at: string;
      updated_at: string;
      /** The set of permissions for the GitHub app */
      permissions: {
        issues?: string;
        checks?: string;
        metadata?: string;
        contents?: string;
        deployments?: string;
      } & { [key: string]: string };
      /** The list of events for the GitHub app */
      events: string[];
      /** The number of installations associated with the GitHub app */
      installations_count?: number;
      client_id?: string;
      client_secret?: string;
      webhook_secret?: string | null;
      pem?: string;
    } | null;
    /** How the author is associated with the repository. */
    author_association:
      | "COLLABORATOR"
      | "CONTRIBUTOR"
      | "FIRST_TIMER"
      | "FIRST_TIME_CONTRIBUTOR"
      | "MANNEQUIN"
      | "MEMBER"
      | "NONE"
      | "OWNER";
    "reaction-rollup": {
      url: string;
      total_count: number;
      "+1": number;
      "-1": number;
      laugh: number;
      confused: number;
      heart: number;
      hooray: number;
      eyes: number;
      rocket: number;
    };
    /** Issues are a great way to keep track of tasks, enhancements, and bugs for your projects. */
    issue: {
      id: number;
      node_id: string;
      /** URL for the issue */
      url: string;
      repository_url: string;
      labels_url: string;
      comments_url: string;
      events_url: string;
      html_url: string;
      /** Number uniquely identifying the issue within its repository */
      number: number;
      /** State of the issue; either 'open' or 'closed' */
      state: string;
      /** The reason for the current state */
      state_reason?: string | null;
      /** Title of the issue */
      title: string;
      /** Contents of the issue */
      body?: string | null;
      user: components["schemas"]["nullable-simple-user"];
      /** Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository */
      labels: (
        | string
        | {
            id?: number;
            node_id?: string;
            url?: string;
            name?: string;
            description?: string | null;
            color?: string | null;
            default?: boolean;
          }
      )[];
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      milestone: components["schemas"]["nullable-milestone"];
      locked: boolean;
      active_lock_reason?: string | null;
      comments: number;
      pull_request?: {
        merged_at?: string | null;
        diff_url: string | null;
        html_url: string | null;
        patch_url: string | null;
        url: string | null;
      };
      closed_at: string | null;
      created_at: string;
      updated_at: string;
      draft?: boolean;
      closed_by?: components["schemas"]["nullable-simple-user"];
      body_html?: string;
      body_text?: string;
      timeline_url?: string;
      repository?: components["schemas"]["repository"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      author_association: components["schemas"]["author_association"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /** Comments provide a way for people to collaborate on an issue. */
    "issue-comment": {
      /** Unique identifier of the issue comment */
      id: number;
      node_id: string;
      /** URL for the issue comment */
      url: string;
      /** Contents of the issue comment */
      body?: string;
      body_text?: string;
      body_html?: string;
      html_url: string;
      user: components["schemas"]["nullable-simple-user"];
      created_at: string;
      updated_at: string;
      issue_url: string;
      author_association: components["schemas"]["author_association"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /** Event */
    event: {
      id: string;
      type: string | null;
      actor: components["schemas"]["actor"];
      repo: {
        id: number;
        name: string;
        url: string;
      };
      org?: components["schemas"]["actor"];
      payload: {
        action?: string;
        issue?: components["schemas"]["issue"];
        comment?: components["schemas"]["issue-comment"];
        pages?: {
          page_name?: string;
          title?: string;
          summary?: string | null;
          action?: string;
          sha?: string;
          html_url?: string;
        }[];
      };
      public: boolean;
      created_at: string | null;
    };
    /** Hypermedia Link with Type */
    "link-with-type": {
      href: string;
      type: string;
    };
    /** Feed */
    feed: {
      timeline_url: string;
      user_url: string;
      current_user_public_url?: string;
      current_user_url?: string;
      current_user_actor_url?: string;
      current_user_organization_url?: string;
      current_user_organization_urls?: string[];
      security_advisories_url?: string;
      _links: {
        timeline: components["schemas"]["link-with-type"];
        user: components["schemas"]["link-with-type"];
        security_advisories?: components["schemas"]["link-with-type"];
        current_user?: components["schemas"]["link-with-type"];
        current_user_public?: components["schemas"]["link-with-type"];
        current_user_actor?: components["schemas"]["link-with-type"];
        current_user_organization?: components["schemas"]["link-with-type"];
        current_user_organizations?: components["schemas"]["link-with-type"][];
      };
    };
    /** Base Gist */
    "base-gist": {
      url: string;
      forks_url: string;
      commits_url: string;
      id: string;
      node_id: string;
      git_pull_url: string;
      git_push_url: string;
      html_url: string;
      files: {
        [key: string]: {
          filename?: string;
          type?: string;
          language?: string;
          raw_url?: string;
          size?: number;
        };
      };
      public: boolean;
      created_at: string;
      updated_at: string;
      description: string | null;
      comments: number;
      user: components["schemas"]["nullable-simple-user"];
      comments_url: string;
      owner?: components["schemas"]["simple-user"];
      truncated?: boolean;
      forks?: unknown[];
      history?: unknown[];
    };
    /** Public User */
    "public-user": {
      login: string;
      id: number;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      events_url: string;
      received_events_url: string;
      type: string;
      site_admin: boolean;
      name: string | null;
      company: string | null;
      blog: string | null;
      location: string | null;
      email: string | null;
      hireable: boolean | null;
      bio: string | null;
      twitter_username?: string | null;
      public_repos: number;
      public_gists: number;
      followers: number;
      following: number;
      created_at: string;
      updated_at: string;
      plan?: {
        collaborators: number;
        name: string;
        space: number;
        private_repos: number;
      };
      suspended_at?: string | null;
      private_gists?: number;
      total_private_repos?: number;
      owned_private_repos?: number;
      disk_usage?: number;
      collaborators?: number;
    };
    /** Gist History */
    "gist-history": {
      user?: components["schemas"]["nullable-simple-user"];
      version?: string;
      committed_at?: string;
      change_status?: {
        total?: number;
        additions?: number;
        deletions?: number;
      };
      url?: string;
    };
    /** Gist Simple */
    "gist-simple": {
      forks?:
        | {
            id?: string;
            url?: string;
            user?: components["schemas"]["public-user"];
            created_at?: string;
            updated_at?: string;
          }[]
        | null;
      history?: components["schemas"]["gist-history"][] | null;
      /** Gist */
      fork_of?: {
        url: string;
        forks_url: string;
        commits_url: string;
        id: string;
        node_id: string;
        git_pull_url: string;
        git_push_url: string;
        html_url: string;
        files: {
          [key: string]: {
            filename?: string;
            type?: string;
            language?: string;
            raw_url?: string;
            size?: number;
          };
        };
        public: boolean;
        created_at: string;
        updated_at: string;
        description: string | null;
        comments: number;
        user: components["schemas"]["nullable-simple-user"];
        comments_url: string;
        owner?: components["schemas"]["nullable-simple-user"];
        truncated?: boolean;
        forks?: unknown[];
        history?: unknown[];
      } | null;
      url?: string;
      forks_url?: string;
      commits_url?: string;
      id?: string;
      node_id?: string;
      git_pull_url?: string;
      git_push_url?: string;
      html_url?: string;
      files?: {
        [key: string]: {
          filename?: string;
          type?: string;
          language?: string;
          raw_url?: string;
          size?: number;
          truncated?: boolean;
          content?: string;
        } | null;
      };
      public?: boolean;
      created_at?: string;
      updated_at?: string;
      description?: string | null;
      comments?: number;
      user?: string | null;
      comments_url?: string;
      owner?: components["schemas"]["simple-user"];
      truncated?: boolean;
    };
    /** A comment made to a gist. */
    "gist-comment": {
      id: number;
      node_id: string;
      url: string;
      /** The comment text. */
      body: string;
      user: components["schemas"]["nullable-simple-user"];
      created_at: string;
      updated_at: string;
      author_association: components["schemas"]["author_association"];
    };
    /** Gist Commit */
    "gist-commit": {
      url: string;
      version: string;
      user: components["schemas"]["nullable-simple-user"];
      change_status: {
        total?: number;
        additions?: number;
        deletions?: number;
      };
      committed_at: string;
    };
    /** Gitignore Template */
    "gitignore-template": {
      name: string;
      source: string;
    };
    /** License Simple */
    "license-simple": {
      key: string;
      name: string;
      url: string | null;
      spdx_id: string | null;
      node_id: string;
      html_url?: string;
    };
    /** License */
    license: {
      key: string;
      name: string;
      spdx_id: string | null;
      url: string | null;
      node_id: string;
      html_url: string;
      description: string;
      implementation: string;
      permissions: string[];
      conditions: string[];
      limitations: string[];
      body: string;
      featured: boolean;
    };
    /** Marketplace Listing Plan */
    "marketplace-listing-plan": {
      url: string;
      accounts_url: string;
      id: number;
      number: number;
      name: string;
      description: string;
      monthly_price_in_cents: number;
      yearly_price_in_cents: number;
      price_model: string;
      has_free_trial: boolean;
      unit_name: string | null;
      state: string;
      bullets: string[];
    };
    /** Marketplace Purchase */
    "marketplace-purchase": {
      url: string;
      type: string;
      id: number;
      login: string;
      organization_billing_email?: string;
      email?: string | null;
      marketplace_pending_change?: {
        is_installed?: boolean;
        effective_date?: string;
        unit_count?: number | null;
        id?: number;
        plan?: components["schemas"]["marketplace-listing-plan"];
      } | null;
      marketplace_purchase: {
        billing_cycle?: string;
        next_billing_date?: string | null;
        is_installed?: boolean;
        unit_count?: number | null;
        on_free_trial?: boolean;
        free_trial_ends_on?: string | null;
        updated_at?: string;
        plan?: components["schemas"]["marketplace-listing-plan"];
      };
    };
    /** Api Overview */
    "api-overview": {
      verifiable_password_authentication: boolean;
      ssh_key_fingerprints?: {
        SHA256_RSA?: string;
        SHA256_DSA?: string;
        SHA256_ECDSA?: string;
        SHA256_ED25519?: string;
      };
      ssh_keys?: string[];
      hooks?: string[];
      web?: string[];
      api?: string[];
      git?: string[];
      packages?: string[];
      pages?: string[];
      importer?: string[];
      actions?: string[];
      dependabot?: string[];
    };
    /** A git repository */
    "nullable-repository": {
      /** Unique identifier of the repository */
      id: number;
      node_id: string;
      /** The name of the repository. */
      name: string;
      full_name: string;
      license: components["schemas"]["nullable-license-simple"];
      organization?: components["schemas"]["nullable-simple-user"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["simple-user"];
      /** Whether the repository is private or public. */
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      deployments_url: string;
      downloads_url: string;
      events_url: string;
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      languages_url: string;
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url: string;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      tags_url: string;
      teams_url: string;
      trees_url: string;
      clone_url: string;
      mirror_url: string | null;
      hooks_url: string;
      svn_url: string;
      homepage: string | null;
      language: string | null;
      forks_count: number;
      stargazers_count: number;
      watchers_count: number;
      size: number;
      /** The default branch of the repository. */
      default_branch: string;
      open_issues_count: number;
      /** Whether this repository acts as a template that can be used to generate new repositories. */
      is_template?: boolean;
      topics?: string[];
      /** Whether issues are enabled. */
      has_issues: boolean;
      /** Whether projects are enabled. */
      has_projects: boolean;
      /** Whether the wiki is enabled. */
      has_wiki: boolean;
      has_pages: boolean;
      /** Whether downloads are enabled. */
      has_downloads: boolean;
      /** Whether the repository is archived. */
      archived: boolean;
      /** Returns whether or not this repository disabled. */
      disabled: boolean;
      /** The repository visibility: public, private, or internal. */
      visibility?: string;
      pushed_at: string | null;
      created_at: string | null;
      updated_at: string | null;
      /** Whether to allow rebase merges for pull requests. */
      allow_rebase_merge?: boolean;
      template_repository?: {
        id?: number;
        node_id?: string;
        name?: string;
        full_name?: string;
        owner?: {
          login?: string;
          id?: number;
          node_id?: string;
          avatar_url?: string;
          gravatar_id?: string;
          url?: string;
          html_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          starred_url?: string;
          subscriptions_url?: string;
          organizations_url?: string;
          repos_url?: string;
          events_url?: string;
          received_events_url?: string;
          type?: string;
          site_admin?: boolean;
        };
        private?: boolean;
        html_url?: string;
        description?: string;
        fork?: boolean;
        url?: string;
        archive_url?: string;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        deployments_url?: string;
        downloads_url?: string;
        events_url?: string;
        forks_url?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        languages_url?: string;
        merges_url?: string;
        milestones_url?: string;
        notifications_url?: string;
        pulls_url?: string;
        releases_url?: string;
        ssh_url?: string;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        tags_url?: string;
        teams_url?: string;
        trees_url?: string;
        clone_url?: string;
        mirror_url?: string;
        hooks_url?: string;
        svn_url?: string;
        homepage?: string;
        language?: string;
        forks_count?: number;
        stargazers_count?: number;
        watchers_count?: number;
        size?: number;
        default_branch?: string;
        open_issues_count?: number;
        is_template?: boolean;
        topics?: string[];
        has_issues?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        has_pages?: boolean;
        has_downloads?: boolean;
        archived?: boolean;
        disabled?: boolean;
        visibility?: string;
        pushed_at?: string;
        created_at?: string;
        updated_at?: string;
        permissions?: {
          admin?: boolean;
          maintain?: boolean;
          push?: boolean;
          triage?: boolean;
          pull?: boolean;
        };
        allow_rebase_merge?: boolean;
        temp_clone_token?: string;
        allow_squash_merge?: boolean;
        allow_auto_merge?: boolean;
        delete_branch_on_merge?: boolean;
        allow_update_branch?: boolean;
        use_squash_pr_title_as_default?: boolean;
        allow_merge_commit?: boolean;
        subscribers_count?: number;
        network_count?: number;
      } | null;
      temp_clone_token?: string;
      /** Whether to allow squash merges for pull requests. */
      allow_squash_merge?: boolean;
      /** Whether to allow Auto-merge to be used on pull requests. */
      allow_auto_merge?: boolean;
      /** Whether to delete head branches when pull requests are merged */
      delete_branch_on_merge?: boolean;
      /** Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging. */
      allow_update_branch?: boolean;
      /** Whether a squash merge commit can use the pull request title as default. */
      use_squash_pr_title_as_default?: boolean;
      /** Whether to allow merge commits for pull requests. */
      allow_merge_commit?: boolean;
      /** Whether to allow forking this repo */
      allow_forking?: boolean;
      subscribers_count?: number;
      network_count?: number;
      open_issues: number;
      watchers: number;
      master_branch?: string;
      starred_at?: string;
    } | null;
    /** Minimal Repository */
    "minimal-repository": {
      id: number;
      node_id: string;
      name: string;
      full_name: string;
      owner: components["schemas"]["simple-user"];
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      deployments_url: string;
      downloads_url: string;
      events_url: string;
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url?: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      languages_url: string;
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url?: string;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      tags_url: string;
      teams_url: string;
      trees_url: string;
      clone_url?: string;
      mirror_url?: string | null;
      hooks_url: string;
      svn_url?: string;
      homepage?: string | null;
      language?: string | null;
      forks_count?: number;
      stargazers_count?: number;
      watchers_count?: number;
      size?: number;
      default_branch?: string;
      open_issues_count?: number;
      is_template?: boolean;
      topics?: string[];
      has_issues?: boolean;
      has_projects?: boolean;
      has_wiki?: boolean;
      has_pages?: boolean;
      has_downloads?: boolean;
      archived?: boolean;
      disabled?: boolean;
      visibility?: string;
      pushed_at?: string | null;
      created_at?: string | null;
      updated_at?: string | null;
      permissions?: {
        admin?: boolean;
        maintain?: boolean;
        push?: boolean;
        triage?: boolean;
        pull?: boolean;
      };
      role_name?: string;
      template_repository?: components["schemas"]["nullable-repository"];
      temp_clone_token?: string;
      delete_branch_on_merge?: boolean;
      subscribers_count?: number;
      network_count?: number;
      code_of_conduct?: components["schemas"]["code-of-conduct"];
      license?: {
        key?: string;
        name?: string;
        spdx_id?: string;
        url?: string;
        node_id?: string;
      } | null;
      forks?: number;
      open_issues?: number;
      watchers?: number;
      allow_forking?: boolean;
    };
    /** Thread */
    thread: {
      id: string;
      repository: components["schemas"]["minimal-repository"];
      subject: {
        title: string;
        url: string;
        latest_comment_url: string;
        type: string;
      };
      reason: string;
      unread: boolean;
      updated_at: string;
      last_read_at: string | null;
      url: string;
      subscription_url: string;
    };
    /** Thread Subscription */
    "thread-subscription": {
      subscribed: boolean;
      ignored: boolean;
      reason: string | null;
      created_at: string | null;
      url: string;
      thread_url?: string;
      repository_url?: string;
    };
    /** Custom repository roles created by organization administrators */
    "organization-custom-repository-role": {
      id: number;
      name: string;
    };
    /** A description of the machine powering a codespace. */
    "nullable-codespace-machine": {
      /** The name of the machine. */
      name: string;
      /** The display name of the machine includes cores, memory, and storage. */
      display_name: string;
      /** The operating system of the machine. */
      operating_system: string;
      /** How much storage is available to the codespace. */
      storage_in_bytes: number;
      /** How much memory is available to the codespace. */
      memory_in_bytes: number;
      /** How many cores are available to the codespace. */
      cpus: number;
      /** Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status. Old values "blob" and "pool" will be deprecated soon. */
      prebuild_availability:
        | ("none" | "blob" | "pool" | "ready" | "in_progress")
        | null;
    } | null;
    /** A codespace. */
    codespace: {
      id: number;
      /** Automatically generated name of this codespace. */
      name: string;
      /** Display name for this codespace. */
      display_name?: string | null;
      /** UUID identifying this codespace's environment. */
      environment_id: string | null;
      owner: components["schemas"]["simple-user"];
      billable_owner: components["schemas"]["simple-user"];
      repository: components["schemas"]["minimal-repository"];
      machine: components["schemas"]["nullable-codespace-machine"];
      /** Path to devcontainer.json from repo root used to create Codespace. */
      devcontainer_path?: string | null;
      /** Whether the codespace was created from a prebuild. */
      prebuild: boolean | null;
      created_at: string;
      updated_at: string;
      /** Last known time this codespace was started. */
      last_used_at: string;
      /** State of this codespace. */
      state:
        | "Unknown"
        | "Created"
        | "Queued"
        | "Provisioning"
        | "Available"
        | "Awaiting"
        | "Unavailable"
        | "Deleted"
        | "Moved"
        | "Shutdown"
        | "Archived"
        | "Starting"
        | "ShuttingDown"
        | "Failed"
        | "Exporting"
        | "Updating"
        | "Rebuilding";
      /** API URL for this codespace. */
      url: string;
      /** Details about the codespace's git repository. */
      git_status: {
        /** The number of commits the local repository is ahead of the remote. */
        ahead?: number;
        /** The number of commits the local repository is behind the remote. */
        behind?: number;
        /** Whether the local repository has unpushed changes. */
        has_unpushed_changes?: boolean;
        /** Whether the local repository has uncommitted changes. */
        has_uncommitted_changes?: boolean;
        /** The current branch (or SHA if in detached HEAD state) of the local repository. */
        ref?: string;
      };
      /** The Azure region where this codespace is located. */
      location: "EastUs" | "SouthEastAsia" | "WestEurope" | "WestUs2";
      /** The number of minutes of inactivity after which this codespace will be automatically stopped. */
      idle_timeout_minutes: number | null;
      /** URL to access this codespace on the web. */
      web_url: string;
      /** API URL to access available alternate machine types for this codespace. */
      machines_url: string;
      /** API URL to start this codespace. */
      start_url: string;
      /** API URL to stop this codespace. */
      stop_url: string;
      /** API URL for the Pull Request associated with this codespace, if any. */
      pulls_url: string | null;
      recent_folders: string[];
      runtime_constraints?: {
        /** The privacy settings a user can select from when forwarding a port. */
        allowed_port_privacy_settings?: string[] | null;
      };
      /** Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it. */
      pending_operation?: boolean | null;
      /** Text to show user when codespace is disabled by a pending operation */
      pending_operation_disabled_reason?: string | null;
      /** Text to show user when codespace idle timeout minutes has been overriden by an organization policy */
      idle_timeout_notice?: string | null;
    };
    /** Organization Full */
    "organization-full": {
      login: string;
      id: number;
      node_id: string;
      url: string;
      repos_url: string;
      events_url: string;
      hooks_url: string;
      issues_url: string;
      members_url: string;
      public_members_url: string;
      avatar_url: string;
      description: string | null;
      name?: string;
      company?: string;
      blog?: string;
      location?: string;
      email?: string;
      twitter_username?: string | null;
      is_verified?: boolean;
      has_organization_projects: boolean;
      has_repository_projects: boolean;
      public_repos: number;
      public_gists: number;
      followers: number;
      following: number;
      html_url: string;
      created_at: string;
      type: string;
      total_private_repos?: number;
      owned_private_repos?: number;
      private_gists?: number | null;
      disk_usage?: number | null;
      collaborators?: number | null;
      billing_email?: string | null;
      plan?: {
        name: string;
        space: number;
        private_repos: number;
        filled_seats?: number;
        seats?: number;
      };
      default_repository_permission?: string | null;
      members_can_create_repositories?: boolean | null;
      two_factor_requirement_enabled?: boolean | null;
      members_allowed_repository_creation_type?: string;
      members_can_create_public_repositories?: boolean;
      members_can_create_private_repositories?: boolean;
      members_can_create_internal_repositories?: boolean;
      members_can_create_pages?: boolean;
      members_can_create_public_pages?: boolean;
      members_can_create_private_pages?: boolean;
      members_can_fork_private_repositories?: boolean | null;
      updated_at: string;
    };
    /** GitHub Actions Cache Usage by repository. */
    "actions-cache-usage-by-repository": {
      /** The repository owner and name for the cache usage being shown. */
      full_name: string;
      /** The sum of the size in bytes of all the active cache items in the repository. */
      active_caches_size_in_bytes: number;
      /** The number of active caches in the repository. */
      active_caches_count: number;
    };
    /** Actions OIDC Subject customization */
    "oidc-custom-sub": {
      include_claim_keys: string[];
    };
    /** An object without any properties. */
    "empty-object": { [key: string]: unknown };
    /** The policy that controls the repositories in the organization that are allowed to run GitHub Actions. */
    "enabled-repositories": "all" | "none" | "selected";
    "actions-organization-permissions": {
      enabled_repositories: components["schemas"]["enabled-repositories"];
      /** The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`. */
      selected_repositories_url?: string;
      allowed_actions?: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    "runner-groups-org": {
      id: number;
      name: string;
      visibility: string;
      default: boolean;
      /** Link to the selected repositories resource for this runner group. Not present unless visibility was set to `selected` */
      selected_repositories_url?: string;
      runners_url: string;
      inherited: boolean;
      inherited_allows_public_repositories?: boolean;
      allows_public_repositories: boolean;
      /** If `true`, the `restricted_to_workflows` and `selected_workflows` fields cannot be modified. */
      workflow_restrictions_read_only?: boolean;
      /** If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array. */
      restricted_to_workflows?: boolean;
      /** List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`. */
      selected_workflows?: string[];
    };
    /** Secrets for GitHub Actions for an organization. */
    "organization-actions-secret": {
      /** The name of the secret. */
      name: string;
      created_at: string;
      updated_at: string;
      /** Visibility of a secret */
      visibility: "all" | "private" | "selected";
      selected_repositories_url?: string;
    };
    /** The public key used for setting Actions Secrets. */
    "actions-public-key": {
      /** The identifier for the key. */
      key_id: string;
      /** The Base64 encoded public key. */
      key: string;
      id?: number;
      url?: string;
      title?: string;
      created_at?: string;
    };
    /** The name of the tool used to generate the code scanning analysis. */
    "code-scanning-analysis-tool-name": string;
    /** The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data. */
    "code-scanning-analysis-tool-guid": string | null;
    /** State of a code scanning alert. */
    "code-scanning-alert-state": "open" | "closed" | "dismissed" | "fixed";
    /** The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
    "alert-updated-at": string;
    /** The REST API URL for fetching the list of instances for an alert. */
    "alert-instances-url": string;
    /** The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
    "code-scanning-alert-fixed-at": string | null;
    /** The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
    "code-scanning-alert-dismissed-at": string | null;
    /** **Required when the state is dismissed.** The reason for dismissing or closing the alert. */
    "code-scanning-alert-dismissed-reason":
      | ("false positive" | "won't fix" | "used in tests")
      | null;
    /** The dismissal comment associated with the dismissal of the alert. */
    "code-scanning-alert-dismissed-comment": string | null;
    "code-scanning-alert-rule": {
      /** A unique identifier for the rule used to detect the alert. */
      id?: string | null;
      /** The name of the rule used to detect the alert. */
      name?: string;
      /** The severity of the alert. */
      severity?: ("none" | "note" | "warning" | "error") | null;
      /** The security severity of the alert. */
      security_severity_level?: ("low" | "medium" | "high" | "critical") | null;
      /** A short description of the rule used to detect the alert. */
      description?: string;
      /** description of the rule used to detect the alert. */
      full_description?: string;
      /** A set of tags applicable for the rule. */
      tags?: string[] | null;
      /** Detailed documentation for the rule as GitHub Flavored Markdown. */
      help?: string | null;
    };
    /** The version of the tool used to generate the code scanning analysis. */
    "code-scanning-analysis-tool-version": string | null;
    "code-scanning-analysis-tool": {
      name?: components["schemas"]["code-scanning-analysis-tool-name"];
      version?: components["schemas"]["code-scanning-analysis-tool-version"];
      guid?: components["schemas"]["code-scanning-analysis-tool-guid"];
    };
    /**
     * The full Git reference, formatted as `refs/heads/<branch name>`,
     * `refs/pull/<number>/merge`, or `refs/pull/<number>/head`.
     */
    "code-scanning-ref": string;
    /** Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name. */
    "code-scanning-analysis-analysis-key": string;
    /** Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed. */
    "code-scanning-alert-environment": string;
    /** Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code. */
    "code-scanning-analysis-category": string;
    /** Describe a region within a file for the alert. */
    "code-scanning-alert-location": {
      path?: string;
      start_line?: number;
      end_line?: number;
      start_column?: number;
      end_column?: number;
    };
    /** A classification of the file. For example to identify it as generated. */
    "code-scanning-alert-classification":
      | ("source" | "generated" | "test" | "library")
      | null;
    "code-scanning-alert-instance": {
      ref?: components["schemas"]["code-scanning-ref"];
      analysis_key?: components["schemas"]["code-scanning-analysis-analysis-key"];
      environment?: components["schemas"]["code-scanning-alert-environment"];
      category?: components["schemas"]["code-scanning-analysis-category"];
      state?: components["schemas"]["code-scanning-alert-state"];
      commit_sha?: string;
      message?: {
        text?: string;
      };
      location?: components["schemas"]["code-scanning-alert-location"];
      html_url?: string;
      /**
       * Classifications that have been applied to the file that triggered the alert.
       * For example identifying it as documentation, or a generated file.
       */
      classifications?: components["schemas"]["code-scanning-alert-classification"][];
    };
    "code-scanning-organization-alert-items": {
      number: components["schemas"]["alert-number"];
      created_at: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["alert-updated-at"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      instances_url: components["schemas"]["alert-instances-url"];
      state: components["schemas"]["code-scanning-alert-state"];
      fixed_at?: components["schemas"]["code-scanning-alert-fixed-at"];
      dismissed_by: components["schemas"]["nullable-simple-user"];
      dismissed_at: components["schemas"]["code-scanning-alert-dismissed-at"];
      dismissed_reason: components["schemas"]["code-scanning-alert-dismissed-reason"];
      dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
      rule: components["schemas"]["code-scanning-alert-rule"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      most_recent_instance: components["schemas"]["code-scanning-alert-instance"];
      repository: components["schemas"]["simple-repository"];
    };
    /** Credential Authorization */
    "credential-authorization": {
      /** User login that owns the underlying credential. */
      login: string;
      /** Unique identifier for the credential. */
      credential_id: number;
      /** Human-readable description of the credential type. */
      credential_type: string;
      /** Last eight characters of the credential. Only included in responses with credential_type of personal access token. */
      token_last_eight?: string;
      /** Date when the credential was authorized for use. */
      credential_authorized_at: string;
      /** List of oauth scopes the token has been granted. */
      scopes?: string[];
      /** Unique string to distinguish the credential. Only included in responses with credential_type of SSH Key. */
      fingerprint?: string;
      /** Date when the credential was last accessed. May be null if it was never accessed */
      credential_accessed_at: string | null;
      authorized_credential_id: number | null;
      /** The title given to the ssh key. This will only be present when the credential is an ssh key. */
      authorized_credential_title?: string | null;
      /** The note given to the token. This will only be present when the credential is a token. */
      authorized_credential_note?: string | null;
      /** The expiry for the token. This will only be present when the credential is a token. */
      authorized_credential_expires_at?: string | null;
    };
    /** Secrets for GitHub Dependabot for an organization. */
    "organization-dependabot-secret": {
      /** The name of the secret. */
      name: string;
      created_at: string;
      updated_at: string;
      /** Visibility of a secret */
      visibility: "all" | "private" | "selected";
      selected_repositories_url?: string;
    };
    /** The public key used for setting Dependabot Secrets. */
    "dependabot-public-key": {
      /** The identifier for the key. */
      key_id: string;
      /** The Base64 encoded public key. */
      key: string;
    };
    /** Information about an external group's usage and its members */
    "external-group": {
      /** The internal ID of the group */
      group_id: number;
      /** The display name for the group */
      group_name: string;
      /** The date when the group was last updated_at */
      updated_at?: string;
      /** An array of teams linked to this group */
      teams: {
        /** The id for a team */
        team_id: number;
        /** The name of the team */
        team_name: string;
      }[];
      /** An array of external members linked to this group */
      members: {
        /** The internal user ID of the identity */
        member_id: number;
        /** The handle/login for the user */
        member_login: string;
        /** The user display name/profile name */
        member_name: string;
        /** An email attached to a user */
        member_email: string;
      }[];
    };
    /** A list of external groups available to be connected to a team */
    "external-groups": {
      /** An array of external groups available to be mapped to a team */
      groups?: {
        /** The internal ID of the group */
        group_id: number;
        /** The display name of the group */
        group_name: string;
        /** The time of the last update for this group */
        updated_at: string;
      }[];
    };
    /** Organization Invitation */
    "organization-invitation": {
      id: number;
      login: string | null;
      email: string | null;
      role: string;
      created_at: string;
      failed_at?: string | null;
      failed_reason?: string | null;
      inviter: components["schemas"]["simple-user"];
      team_count: number;
      node_id: string;
      invitation_teams_url: string;
    };
    /** Org Hook */
    "org-hook": {
      id: number;
      url: string;
      ping_url: string;
      deliveries_url?: string;
      name: string;
      events: string[];
      active: boolean;
      config: {
        url?: string;
        insecure_ssl?: string;
        content_type?: string;
        secret?: string;
      };
      updated_at: string;
      created_at: string;
      type: string;
    };
    /** The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect. */
    "interaction-group":
      | "existing_users"
      | "contributors_only"
      | "collaborators_only";
    /** Interaction limit settings. */
    "interaction-limit-response": {
      limit: components["schemas"]["interaction-group"];
      origin: string;
      expires_at: string;
    };
    /** The duration of the interaction restriction. Default: `one_day`. */
    "interaction-expiry":
      | "one_day"
      | "three_days"
      | "one_week"
      | "one_month"
      | "six_months";
    /** Limit interactions to a specific type of user for a specified duration */
    "interaction-limit": {
      limit: components["schemas"]["interaction-group"];
      expiry?: components["schemas"]["interaction-expiry"];
    };
    /** Groups of organization members that gives permissions on specified repositories. */
    "nullable-team-simple": {
      /** Unique identifier of the team */
      id: number;
      node_id: string;
      /** URL for the team */
      url: string;
      members_url: string;
      /** Name of the team */
      name: string;
      /** Description of the team */
      description: string | null;
      /** Permission that the team will have for its repositories */
      permission: string;
      /** The level of privacy this team should have */
      privacy?: string;
      html_url: string;
      repositories_url: string;
      slug: string;
      /** Distinguished Name (DN) that team maps to within LDAP environment */
      ldap_dn?: string;
    } | null;
    /** Groups of organization members that gives permissions on specified repositories. */
    team: {
      id: number;
      node_id: string;
      name: string;
      slug: string;
      description: string | null;
      privacy?: string;
      permission: string;
      permissions?: {
        pull: boolean;
        triage: boolean;
        push: boolean;
        maintain: boolean;
        admin: boolean;
      };
      url: string;
      html_url: string;
      members_url: string;
      repositories_url: string;
      parent: components["schemas"]["nullable-team-simple"];
    };
    /** Org Membership */
    "org-membership": {
      url: string;
      /** The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation. */
      state: "active" | "pending";
      /** The user's membership type in the organization. */
      role: "admin" | "member" | "billing_manager";
      organization_url: string;
      organization: components["schemas"]["organization-simple"];
      user: components["schemas"]["nullable-simple-user"];
      permissions?: {
        can_create_repository: boolean;
      };
    };
    /** A migration. */
    migration: {
      id: number;
      owner: components["schemas"]["nullable-simple-user"];
      guid: string;
      state: string;
      lock_repositories: boolean;
      exclude_metadata: boolean;
      exclude_git_data: boolean;
      exclude_attachments: boolean;
      exclude_releases: boolean;
      exclude_owner_projects: boolean;
      org_metadata_only: boolean;
      repositories: components["schemas"]["repository"][];
      url: string;
      created_at: string;
      updated_at: string;
      node_id: string;
      archive_url?: string;
      exclude?: unknown[];
    };
    /** Minimal Repository */
    "nullable-minimal-repository": {
      id: number;
      node_id: string;
      name: string;
      full_name: string;
      owner: components["schemas"]["simple-user"];
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      deployments_url: string;
      downloads_url: string;
      events_url: string;
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url?: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      languages_url: string;
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url?: string;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      tags_url: string;
      teams_url: string;
      trees_url: string;
      clone_url?: string;
      mirror_url?: string | null;
      hooks_url: string;
      svn_url?: string;
      homepage?: string | null;
      language?: string | null;
      forks_count?: number;
      stargazers_count?: number;
      watchers_count?: number;
      size?: number;
      default_branch?: string;
      open_issues_count?: number;
      is_template?: boolean;
      topics?: string[];
      has_issues?: boolean;
      has_projects?: boolean;
      has_wiki?: boolean;
      has_pages?: boolean;
      has_downloads?: boolean;
      archived?: boolean;
      disabled?: boolean;
      visibility?: string;
      pushed_at?: string | null;
      created_at?: string | null;
      updated_at?: string | null;
      permissions?: {
        admin?: boolean;
        maintain?: boolean;
        push?: boolean;
        triage?: boolean;
        pull?: boolean;
      };
      role_name?: string;
      template_repository?: components["schemas"]["nullable-repository"];
      temp_clone_token?: string;
      delete_branch_on_merge?: boolean;
      subscribers_count?: number;
      network_count?: number;
      code_of_conduct?: components["schemas"]["code-of-conduct"];
      license?: {
        key?: string;
        name?: string;
        spdx_id?: string;
        url?: string;
        node_id?: string;
      } | null;
      forks?: number;
      open_issues?: number;
      watchers?: number;
      allow_forking?: boolean;
    } | null;
    /** A software package */
    package: {
      /** Unique identifier of the package. */
      id: number;
      /** The name of the package. */
      name: string;
      package_type:
        | "npm"
        | "maven"
        | "rubygems"
        | "docker"
        | "nuget"
        | "container";
      url: string;
      html_url: string;
      /** The number of versions of the package. */
      version_count: number;
      visibility: "private" | "public";
      owner?: components["schemas"]["nullable-simple-user"];
      repository?: components["schemas"]["nullable-minimal-repository"];
      created_at: string;
      updated_at: string;
    };
    /** A version of a software package */
    "package-version": {
      /** Unique identifier of the package version. */
      id: number;
      /** The name of the package version. */
      name: string;
      url: string;
      package_html_url: string;
      html_url?: string;
      license?: string;
      description?: string;
      created_at: string;
      updated_at: string;
      deleted_at?: string;
      metadata?: {
        package_type:
          | "npm"
          | "maven"
          | "rubygems"
          | "docker"
          | "nuget"
          | "container";
        container?: {
          tags: string[];
        };
        docker?: {
          tag?: string[];
        } & {
          tags: unknown;
        };
      };
    };
    /** Projects are a way to organize columns and cards of work. */
    project: {
      owner_url: string;
      url: string;
      html_url: string;
      columns_url: string;
      id: number;
      node_id: string;
      /** Name of the project */
      name: string;
      /** Body of the project */
      body: string | null;
      number: number;
      /** State of the project; either 'open' or 'closed' */
      state: string;
      creator: components["schemas"]["nullable-simple-user"];
      created_at: string;
      updated_at: string;
      /** The baseline permission that all organization members have on this project. Only present if owner is an organization. */
      organization_permission?: "read" | "write" | "admin" | "none";
      /** Whether or not this project can be seen by everyone. Only present if owner is an organization. */
      private?: boolean;
    };
    /** External Groups to be mapped to a team for membership */
    "group-mapping": {
      /** Array of groups to be mapped to this team */
      groups?: {
        /** The ID of the group */
        group_id: string;
        /** The name of the group */
        group_name: string;
        /** a description of the group */
        group_description: string;
        /** synchronization status for this group mapping */
        status?: string;
        /** the time of the last sync for this group-mapping */
        synced_at?: string | null;
      }[];
    };
    /** Groups of organization members that gives permissions on specified repositories. */
    "team-full": {
      /** Unique identifier of the team */
      id: number;
      node_id: string;
      /** URL for the team */
      url: string;
      html_url: string;
      /** Name of the team */
      name: string;
      slug: string;
      description: string | null;
      /** The level of privacy this team should have */
      privacy?: "closed" | "secret";
      /** Permission that the team will have for its repositories */
      permission: string;
      members_url: string;
      repositories_url: string;
      parent?: components["schemas"]["nullable-team-simple"];
      members_count: number;
      repos_count: number;
      created_at: string;
      updated_at: string;
      organization: components["schemas"]["organization-full"];
      /** Distinguished Name (DN) that team maps to within LDAP environment */
      ldap_dn?: string;
    };
    /** A team discussion is a persistent record of a free-form conversation within a team. */
    "team-discussion": {
      author: components["schemas"]["nullable-simple-user"];
      /** The main text of the discussion. */
      body: string;
      body_html: string;
      /** The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server. */
      body_version: string;
      comments_count: number;
      comments_url: string;
      created_at: string;
      last_edited_at: string | null;
      html_url: string;
      node_id: string;
      /** The unique sequence number of a team discussion. */
      number: number;
      /** Whether or not this discussion should be pinned for easy retrieval. */
      pinned: boolean;
      /** Whether or not this discussion should be restricted to team members and organization administrators. */
      private: boolean;
      team_url: string;
      /** The title of the discussion. */
      title: string;
      updated_at: string;
      url: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /** A reply to a discussion within a team. */
    "team-discussion-comment": {
      author: components["schemas"]["nullable-simple-user"];
      /** The main text of the comment. */
      body: string;
      body_html: string;
      /** The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server. */
      body_version: string;
      created_at: string;
      last_edited_at: string | null;
      discussion_url: string;
      html_url: string;
      node_id: string;
      /** The unique sequence number of a team discussion comment. */
      number: number;
      updated_at: string;
      url: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /** Reactions to conversations provide a way to help people express their feelings more simply and effectively. */
    reaction: {
      id: number;
      node_id: string;
      user: components["schemas"]["nullable-simple-user"];
      /** The reaction to use */
      content:
        | "+1"
        | "-1"
        | "laugh"
        | "confused"
        | "heart"
        | "hooray"
        | "rocket"
        | "eyes";
      created_at: string;
    };
    /** Team Membership */
    "team-membership": {
      url: string;
      /** The role of the user in the team. */
      role: "member" | "maintainer";
      /** The state of the user's membership in the team. */
      state: "active" | "pending";
    };
    /** A team's access to a project. */
    "team-project": {
      owner_url: string;
      url: string;
      html_url: string;
      columns_url: string;
      id: number;
      node_id: string;
      name: string;
      body: string | null;
      number: number;
      state: string;
      creator: components["schemas"]["simple-user"];
      created_at: string;
      updated_at: string;
      /** The organization permission for this project. Only present when owner is an organization. */
      organization_permission?: string;
      /** Whether the project is private or not. Only present when owner is an organization. */
      private?: boolean;
      permissions: {
        read: boolean;
        write: boolean;
        admin: boolean;
      };
    };
    /** A team's access to a repository. */
    "team-repository": {
      /** Unique identifier of the repository */
      id: number;
      node_id: string;
      /** The name of the repository. */
      name: string;
      full_name: string;
      license: components["schemas"]["nullable-license-simple"];
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      role_name?: string;
      owner: components["schemas"]["nullable-simple-user"];
      /** Whether the repository is private or public. */
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      deployments_url: string;
      downloads_url: string;
      events_url: string;
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      languages_url: string;
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url: string;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      tags_url: string;
      teams_url: string;
      trees_url: string;
      clone_url: string;
      mirror_url: string | null;
      hooks_url: string;
      svn_url: string;
      homepage: string | null;
      language: string | null;
      forks_count: number;
      stargazers_count: number;
      watchers_count: number;
      size: number;
      /** The default branch of the repository. */
      default_branch: string;
      open_issues_count: number;
      /** Whether this repository acts as a template that can be used to generate new repositories. */
      is_template?: boolean;
      topics?: string[];
      /** Whether issues are enabled. */
      has_issues: boolean;
      /** Whether projects are enabled. */
      has_projects: boolean;
      /** Whether the wiki is enabled. */
      has_wiki: boolean;
      has_pages: boolean;
      /** Whether downloads are enabled. */
      has_downloads: boolean;
      /** Whether the repository is archived. */
      archived: boolean;
      /** Returns whether or not this repository disabled. */
      disabled: boolean;
      /** The repository visibility: public, private, or internal. */
      visibility?: string;
      pushed_at: string | null;
      created_at: string | null;
      updated_at: string | null;
      /** Whether to allow rebase merges for pull requests. */
      allow_rebase_merge?: boolean;
      template_repository?: components["schemas"]["nullable-repository"];
      temp_clone_token?: string;
      /** Whether to allow squash merges for pull requests. */
      allow_squash_merge?: boolean;
      /** Whether to allow Auto-merge to be used on pull requests. */
      allow_auto_merge?: boolean;
      /** Whether to delete head branches when pull requests are merged */
      delete_branch_on_merge?: boolean;
      /** Whether to allow merge commits for pull requests. */
      allow_merge_commit?: boolean;
      /** Whether to allow forking this repo */
      allow_forking?: boolean;
      subscribers_count?: number;
      network_count?: number;
      open_issues: number;
      watchers: number;
      master_branch?: string;
    };
    /** Project cards represent a scope of work. */
    "project-card": {
      url: string;
      /** The project card's ID */
      id: number;
      node_id: string;
      note: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      created_at: string;
      updated_at: string;
      /** Whether or not the card is archived */
      archived?: boolean;
      column_name?: string;
      project_id?: string;
      column_url: string;
      content_url?: string;
      project_url: string;
    };
    /** Project columns contain cards of work. */
    "project-column": {
      url: string;
      project_url: string;
      cards_url: string;
      /** The unique identifier of the project column */
      id: number;
      node_id: string;
      /** Name of the project column */
      name: string;
      created_at: string;
      updated_at: string;
    };
    /** Project Collaborator Permission */
    "project-collaborator-permission": {
      permission: string;
      user: components["schemas"]["nullable-simple-user"];
    };
    "rate-limit": {
      limit: number;
      remaining: number;
      reset: number;
      used: number;
    };
    /** Rate Limit Overview */
    "rate-limit-overview": {
      resources: {
        core: components["schemas"]["rate-limit"];
        graphql?: components["schemas"]["rate-limit"];
        search: components["schemas"]["rate-limit"];
        source_import?: components["schemas"]["rate-limit"];
        integration_manifest?: components["schemas"]["rate-limit"];
        code_scanning_upload?: components["schemas"]["rate-limit"];
        actions_runner_registration?: components["schemas"]["rate-limit"];
        scim?: components["schemas"]["rate-limit"];
      };
      rate: components["schemas"]["rate-limit"];
    };
    /** Code of Conduct Simple */
    "code-of-conduct-simple": {
      url: string;
      key: string;
      name: string;
      html_url: string | null;
    };
    "security-and-analysis": {
      advanced_security?: {
        status?: "enabled" | "disabled";
      };
      secret_scanning?: {
        status?: "enabled" | "disabled";
      };
      secret_scanning_push_protection?: {
        status?: "enabled" | "disabled";
      };
    } | null;
    /** Full Repository */
    "full-repository": {
      id: number;
      node_id: string;
      name: string;
      full_name: string;
      owner: components["schemas"]["simple-user"];
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      deployments_url: string;
      downloads_url: string;
      events_url: string;
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      languages_url: string;
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url: string;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      tags_url: string;
      teams_url: string;
      trees_url: string;
      clone_url: string;
      mirror_url: string | null;
      hooks_url: string;
      svn_url: string;
      homepage: string | null;
      language: string | null;
      forks_count: number;
      stargazers_count: number;
      watchers_count: number;
      size: number;
      default_branch: string;
      open_issues_count: number;
      is_template?: boolean;
      topics?: string[];
      has_issues: boolean;
      has_projects: boolean;
      has_wiki: boolean;
      has_pages: boolean;
      has_downloads: boolean;
      archived: boolean;
      /** Returns whether or not this repository disabled. */
      disabled: boolean;
      /** The repository visibility: public, private, or internal. */
      visibility?: string;
      pushed_at: string;
      created_at: string;
      updated_at: string;
      permissions?: {
        admin: boolean;
        maintain?: boolean;
        push: boolean;
        triage?: boolean;
        pull: boolean;
      };
      allow_rebase_merge?: boolean;
      template_repository?: components["schemas"]["nullable-repository"];
      temp_clone_token?: string | null;
      allow_squash_merge?: boolean;
      allow_auto_merge?: boolean;
      delete_branch_on_merge?: boolean;
      allow_merge_commit?: boolean;
      allow_update_branch?: boolean;
      use_squash_pr_title_as_default?: boolean;
      allow_forking?: boolean;
      subscribers_count: number;
      network_count: number;
      license: components["schemas"]["nullable-license-simple"];
      organization?: components["schemas"]["nullable-simple-user"];
      parent?: components["schemas"]["repository"];
      source?: components["schemas"]["repository"];
      forks: number;
      master_branch?: string;
      open_issues: number;
      watchers: number;
      /** Whether anonymous git access is allowed. */
      anonymous_access_enabled?: boolean;
      code_of_conduct?: components["schemas"]["code-of-conduct-simple"];
      security_and_analysis?: components["schemas"]["security-and-analysis"];
    };
    /** An artifact */
    artifact: {
      id: number;
      node_id: string;
      /** The name of the artifact. */
      name: string;
      /** The size in bytes of the artifact. */
      size_in_bytes: number;
      url: string;
      archive_download_url: string;
      /** Whether or not the artifact has expired. */
      expired: boolean;
      created_at: string | null;
      expires_at: string | null;
      updated_at: string | null;
      workflow_run?: {
        id?: number;
        repository_id?: number;
        head_repository_id?: number;
        head_branch?: string;
        head_sha?: string;
      } | null;
    };
    /** Repository actions caches */
    "actions-cache-list": {
      /** Total number of caches */
      total_count: number;
      /** Array of caches */
      actions_caches: {
        id?: number;
        ref?: string;
        key?: string;
        version?: string;
        last_accessed_at?: string;
        created_at?: string;
        size_in_bytes?: number;
      }[];
    };
    /** Information of a job execution in a workflow run */
    job: {
      /** The id of the job. */
      id: number;
      /** The id of the associated workflow run. */
      run_id: number;
      run_url: string;
      /** Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run. */
      run_attempt?: number;
      node_id: string;
      /** The SHA of the commit that is being run. */
      head_sha: string;
      url: string;
      html_url: string | null;
      /** The phase of the lifecycle that the job is currently in. */
      status: "queued" | "in_progress" | "completed";
      /** The outcome of the job. */
      conclusion: string | null;
      /** The time that the job started, in ISO 8601 format. */
      started_at: string;
      /** The time that the job finished, in ISO 8601 format. */
      completed_at: string | null;
      /** The name of the job. */
      name: string;
      /** Steps in this job. */
      steps?: {
        /** The phase of the lifecycle that the job is currently in. */
        status: "queued" | "in_progress" | "completed";
        /** The outcome of the job. */
        conclusion: string | null;
        /** The name of the job. */
        name: string;
        number: number;
        /** The time that the step started, in ISO 8601 format. */
        started_at?: string | null;
        /** The time that the job finished, in ISO 8601 format. */
        completed_at?: string | null;
      }[];
      check_run_url: string;
      /** Labels for the workflow job. Specified by the "runs_on" attribute in the action's workflow file. */
      labels: string[];
      /** The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.) */
      runner_id: number | null;
      /** The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.) */
      runner_name: string | null;
      /** The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.) */
      runner_group_id: number | null;
      /** The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.) */
      runner_group_name: string | null;
    };
    /** OIDC Customer Subject */
    "opt-out-oidc-custom-sub": {
      use_default: boolean;
    };
    /** Whether GitHub Actions is enabled on the repository. */
    "actions-enabled": boolean;
    "actions-repository-permissions": {
      enabled: components["schemas"]["actions-enabled"];
      allowed_actions?: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    "actions-workflow-access-to-repository": {
      /**
       * Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the
       * repository. `none` means access is only possible from workflows in this repository.
       */
      access_level: "none" | "organization" | "enterprise";
    };
    /** A workflow referenced/reused by the initial caller workflow */
    referenced_workflow: {
      path: string;
      sha: string;
      ref?: string;
    };
    "pull-request-minimal": {
      id: number;
      number: number;
      url: string;
      head: {
        ref: string;
        sha: string;
        repo: {
          id: number;
          url: string;
          name: string;
        };
      };
      base: {
        ref: string;
        sha: string;
        repo: {
          id: number;
          url: string;
          name: string;
        };
      };
    };
    /** Simple Commit */
    "nullable-simple-commit": {
      id: string;
      tree_id: string;
      message: string;
      timestamp: string;
      author: {
        name: string;
        email: string;
      } | null;
      committer: {
        name: string;
        email: string;
      } | null;
    } | null;
    /** An invocation of a workflow */
    "workflow-run": {
      /** The ID of the workflow run. */
      id: number;
      /** The name of the workflow run. */
      name?: string | null;
      node_id: string;
      /** The ID of the associated check suite. */
      check_suite_id?: number;
      /** The node ID of the associated check suite. */
      check_suite_node_id?: string;
      head_branch: string | null;
      /** The SHA of the head commit that points to the version of the workflow being run. */
      head_sha: string;
      /** The full path of the workflow */
      path: string;
      /** The auto incrementing run number for the workflow run. */
      run_number: number;
      /** Attempt number of the run, 1 for first attempt and higher if the workflow was re-run. */
      run_attempt?: number;
      referenced_workflows?:
        | components["schemas"]["referenced_workflow"][]
        | null;
      event: string;
      status: string | null;
      conclusion: string | null;
      /** The ID of the parent workflow. */
      workflow_id: number;
      /** The URL to the workflow run. */
      url: string;
      html_url: string;
      pull_requests: components["schemas"]["pull-request-minimal"][] | null;
      created_at: string;
      updated_at: string;
      actor?: components["schemas"]["simple-user"];
      triggering_actor?: components["schemas"]["simple-user"];
      /** The start time of the latest run. Resets on re-run. */
      run_started_at?: string;
      /** The URL to the jobs for the workflow run. */
      jobs_url: string;
      /** The URL to download the logs for the workflow run. */
      logs_url: string;
      /** The URL to the associated check suite. */
      check_suite_url: string;
      /** The URL to the artifacts for the workflow run. */
      artifacts_url: string;
      /** The URL to cancel the workflow run. */
      cancel_url: string;
      /** The URL to rerun the workflow run. */
      rerun_url: string;
      /** The URL to the previous attempted run of this workflow, if one exists. */
      previous_attempt_url?: string | null;
      /** The URL to the workflow. */
      workflow_url: string;
      head_commit: components["schemas"]["nullable-simple-commit"];
      repository: components["schemas"]["minimal-repository"];
      head_repository: components["schemas"]["minimal-repository"];
      head_repository_id?: number;
    };
    /** An entry in the reviews log for environment deployments */
    "environment-approvals": {
      /** The list of environments that were approved or rejected */
      environments: {
        /** The id of the environment. */
        id?: number;
        node_id?: string;
        /** The name of the environment. */
        name?: string;
        url?: string;
        html_url?: string;
        /** The time that the environment was created, in ISO 8601 format. */
        created_at?: string;
        /** The time that the environment was last updated, in ISO 8601 format. */
        updated_at?: string;
      }[];
      /** Whether deployment to the environment(s) was approved or rejected */
      state: "approved" | "rejected";
      user: components["schemas"]["simple-user"];
      /** The comment submitted with the deployment review */
      comment: string;
    };
    /** The type of reviewer. */
    "deployment-reviewer-type": "User" | "Team";
    /** Details of a deployment that is waiting for protection rules to pass */
    "pending-deployment": {
      environment: {
        /** The id of the environment. */
        id?: number;
        node_id?: string;
        /** The name of the environment. */
        name?: string;
        url?: string;
        html_url?: string;
      };
      /** The set duration of the wait timer */
      wait_timer: number;
      /** The time that the wait timer began. */
      wait_timer_started_at: string | null;
      /** Whether the currently authenticated user can approve the deployment */
      current_user_can_approve: boolean;
      /** The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed. */
      reviewers: {
        type?: components["schemas"]["deployment-reviewer-type"];
        reviewer?: Partial<components["schemas"]["simple-user"]> &
          Partial<components["schemas"]["team"]>;
      }[];
    };
    /** A request for a specific ref(branch,sha,tag) to be deployed */
    deployment: {
      url: string;
      /** Unique identifier of the deployment */
      id: number;
      node_id: string;
      sha: string;
      /** The ref to deploy. This can be a branch, tag, or sha. */
      ref: string;
      /** Parameter to specify a task to execute */
      task: string;
      payload: { [key: string]: unknown } | string;
      original_environment?: string;
      /** Name for the target deployment environment. */
      environment: string;
      description: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      created_at: string;
      updated_at: string;
      statuses_url: string;
      repository_url: string;
      /** Specifies if the given environment is will no longer exist at some point in the future. Default: false. */
      transient_environment?: boolean;
      /** Specifies if the given environment is one that end-users directly interact with. Default: false. */
      production_environment?: boolean;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /** Workflow Run Usage */
    "workflow-run-usage": {
      billable: {
        UBUNTU?: {
          total_ms: number;
          jobs: number;
          job_runs?: {
            job_id: number;
            duration_ms: number;
          }[];
        };
        MACOS?: {
          total_ms: number;
          jobs: number;
          job_runs?: {
            job_id: number;
            duration_ms: number;
          }[];
        };
        WINDOWS?: {
          total_ms: number;
          jobs: number;
          job_runs?: {
            job_id: number;
            duration_ms: number;
          }[];
        };
      };
      run_duration_ms?: number;
    };
    /** Set secrets for GitHub Actions. */
    "actions-secret": {
      /** The name of the secret. */
      name: string;
      created_at: string;
      updated_at: string;
    };
    /** A GitHub Actions workflow */
    workflow: {
      id: number;
      node_id: string;
      name: string;
      path: string;
      state:
        | "active"
        | "deleted"
        | "disabled_fork"
        | "disabled_inactivity"
        | "disabled_manually";
      created_at: string;
      updated_at: string;
      url: string;
      html_url: string;
      badge_url: string;
      deleted_at?: string;
    };
    /** Workflow Usage */
    "workflow-usage": {
      billable: {
        UBUNTU?: {
          total_ms?: number;
        };
        MACOS?: {
          total_ms?: number;
        };
        WINDOWS?: {
          total_ms?: number;
        };
      };
    };
    /** An autolink reference. */
    autolink: {
      id: number;
      /** The prefix of a key that is linkified. */
      key_prefix: string;
      /** A template for the target URL that is generated if a key was found. */
      url_template: string;
    };
    /** Protected Branch Required Status Check */
    "protected-branch-required-status-check": {
      url?: string;
      enforcement_level?: string;
      contexts: string[];
      checks: {
        context: string;
        app_id: number | null;
      }[];
      contexts_url?: string;
      strict?: boolean;
    };
    /** Protected Branch Admin Enforced */
    "protected-branch-admin-enforced": {
      url: string;
      enabled: boolean;
    };
    /** Protected Branch Pull Request Review */
    "protected-branch-pull-request-review": {
      url?: string;
      dismissal_restrictions?: {
        /** The list of users with review dismissal access. */
        users?: components["schemas"]["simple-user"][];
        /** The list of teams with review dismissal access. */
        teams?: components["schemas"]["team"][];
        /** The list of apps with review dismissal access. */
        apps?: components["schemas"]["integration"][];
        url?: string;
        users_url?: string;
        teams_url?: string;
      };
      /** Allow specific users, teams, or apps to bypass pull request requirements. */
      bypass_pull_request_allowances?: {
        /** The list of users allowed to bypass pull request requirements. */
        users?: components["schemas"]["simple-user"][];
        /** The list of teams allowed to bypass pull request requirements. */
        teams?: components["schemas"]["team"][];
        /** The list of apps allowed to bypass pull request requirements. */
        apps?: components["schemas"]["integration"][];
      };
      dismiss_stale_reviews: boolean;
      require_code_owner_reviews: boolean;
      required_approving_review_count?: number;
    };
    /** Branch Restriction Policy */
    "branch-restriction-policy": {
      url: string;
      users_url: string;
      teams_url: string;
      apps_url: string;
      users: {
        login?: string;
        id?: number;
        node_id?: string;
        avatar_url?: string;
        gravatar_id?: string;
        url?: string;
        html_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        starred_url?: string;
        subscriptions_url?: string;
        organizations_url?: string;
        repos_url?: string;
        events_url?: string;
        received_events_url?: string;
        type?: string;
        site_admin?: boolean;
      }[];
      teams: {
        id?: number;
        node_id?: string;
        url?: string;
        html_url?: string;
        name?: string;
        slug?: string;
        description?: string | null;
        privacy?: string;
        permission?: string;
        members_url?: string;
        repositories_url?: string;
        parent?: string | null;
      }[];
      apps: {
        id?: number;
        slug?: string;
        node_id?: string;
        owner?: {
          login?: string;
          id?: number;
          node_id?: string;
          url?: string;
          repos_url?: string;
          events_url?: string;
          hooks_url?: string;
          issues_url?: string;
          members_url?: string;
          public_members_url?: string;
          avatar_url?: string;
          description?: string;
          gravatar_id?: string;
          html_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          starred_url?: string;
          subscriptions_url?: string;
          organizations_url?: string;
          received_events_url?: string;
          type?: string;
          site_admin?: boolean;
        };
        name?: string;
        description?: string;
        external_url?: string;
        html_url?: string;
        created_at?: string;
        updated_at?: string;
        permissions?: {
          metadata?: string;
          contents?: string;
          issues?: string;
          single_file?: string;
        };
        events?: string[];
      }[];
    };
    /** Branch Protection */
    "branch-protection": {
      url?: string;
      enabled?: boolean;
      required_status_checks?: components["schemas"]["protected-branch-required-status-check"];
      enforce_admins?: components["schemas"]["protected-branch-admin-enforced"];
      required_pull_request_reviews?: components["schemas"]["protected-branch-pull-request-review"];
      restrictions?: components["schemas"]["branch-restriction-policy"];
      required_linear_history?: {
        enabled?: boolean;
      };
      allow_force_pushes?: {
        enabled?: boolean;
      };
      allow_deletions?: {
        enabled?: boolean;
      };
      block_creations?: {
        enabled?: boolean;
      };
      required_conversation_resolution?: {
        enabled?: boolean;
      };
      name?: string;
      protection_url?: string;
      required_signatures?: {
        url: string;
        enabled: boolean;
      };
    };
    /** Short Branch */
    "short-branch": {
      name: string;
      commit: {
        sha: string;
        url: string;
      };
      protected: boolean;
      protection?: components["schemas"]["branch-protection"];
      protection_url?: string;
    };
    /** Metaproperties for Git author/committer information. */
    "nullable-git-user": {
      name?: string;
      email?: string;
      date?: string;
    } | null;
    verification: {
      verified: boolean;
      reason: string;
      payload: string | null;
      signature: string | null;
    };
    /** Diff Entry */
    "diff-entry": {
      sha: string;
      filename: string;
      status:
        | "added"
        | "removed"
        | "modified"
        | "renamed"
        | "copied"
        | "changed"
        | "unchanged";
      additions: number;
      deletions: number;
      changes: number;
      blob_url: string;
      raw_url: string;
      contents_url: string;
      patch?: string;
      previous_filename?: string;
    };
    /** Commit */
    commit: {
      url: string;
      sha: string;
      node_id: string;
      html_url: string;
      comments_url: string;
      commit: {
        url: string;
        author: components["schemas"]["nullable-git-user"];
        committer: components["schemas"]["nullable-git-user"];
        message: string;
        comment_count: number;
        tree: {
          sha: string;
          url: string;
        };
        verification?: components["schemas"]["verification"];
      };
      author: components["schemas"]["nullable-simple-user"];
      committer: components["schemas"]["nullable-simple-user"];
      parents: {
        sha: string;
        url: string;
        html_url?: string;
      }[];
      stats?: {
        additions?: number;
        deletions?: number;
        total?: number;
      };
      files?: components["schemas"]["diff-entry"][];
    };
    /** Branch With Protection */
    "branch-with-protection": {
      name: string;
      commit: components["schemas"]["commit"];
      _links: {
        html: string;
        self: string;
      };
      protected: boolean;
      protection: components["schemas"]["branch-protection"];
      protection_url: string;
      pattern?: string;
      required_approving_review_count?: number;
    };
    /** Status Check Policy */
    "status-check-policy": {
      url: string;
      strict: boolean;
      contexts: string[];
      checks: {
        context: string;
        app_id: number | null;
      }[];
      contexts_url: string;
    };
    /** Branch protections protect branches */
    "protected-branch": {
      url: string;
      required_status_checks?: components["schemas"]["status-check-policy"];
      required_pull_request_reviews?: {
        url: string;
        dismiss_stale_reviews?: boolean;
        require_code_owner_reviews?: boolean;
        required_approving_review_count?: number;
        dismissal_restrictions?: {
          url: string;
          users_url: string;
          teams_url: string;
          users: components["schemas"]["simple-user"][];
          teams: components["schemas"]["team"][];
          apps?: components["schemas"]["integration"][];
        };
        bypass_pull_request_allowances?: {
          users: components["schemas"]["simple-user"][];
          teams: components["schemas"]["team"][];
          apps?: components["schemas"]["integration"][];
        };
      };
      required_signatures?: {
        url: string;
        enabled: boolean;
      };
      enforce_admins?: {
        url: string;
        enabled: boolean;
      };
      required_linear_history?: {
        enabled: boolean;
      };
      allow_force_pushes?: {
        enabled: boolean;
      };
      allow_deletions?: {
        enabled: boolean;
      };
      restrictions?: components["schemas"]["branch-restriction-policy"];
      required_conversation_resolution?: {
        enabled?: boolean;
      };
      block_creations?: {
        enabled: boolean;
      };
    };
    /** A deployment created as the result of an Actions check run from a workflow that references an environment */
    "deployment-simple": {
      url: string;
      /** Unique identifier of the deployment */
      id: number;
      node_id: string;
      /** Parameter to specify a task to execute */
      task: string;
      original_environment?: string;
      /** Name for the target deployment environment. */
      environment: string;
      description: string | null;
      created_at: string;
      updated_at: string;
      statuses_url: string;
      repository_url: string;
      /** Specifies if the given environment is will no longer exist at some point in the future. Default: false. */
      transient_environment?: boolean;
      /** Specifies if the given environment is one that end-users directly interact with. Default: false. */
      production_environment?: boolean;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /** A check performed on the code of a given code change */
    "check-run": {
      /** The id of the check. */
      id: number;
      /** The SHA of the commit that is being checked. */
      head_sha: string;
      node_id: string;
      external_id: string | null;
      url: string;
      html_url: string | null;
      details_url: string | null;
      /** The phase of the lifecycle that the check is currently in. */
      status: "queued" | "in_progress" | "completed";
      conclusion:
        | (
            | "success"
            | "failure"
            | "neutral"
            | "cancelled"
            | "skipped"
            | "timed_out"
            | "action_required"
          )
        | null;
      started_at: string | null;
      completed_at: string | null;
      output: {
        title: string | null;
        summary: string | null;
        text: string | null;
        annotations_count: number;
        annotations_url: string;
      };
      /** The name of the check. */
      name: string;
      check_suite: {
        id: number;
      } | null;
      app: components["schemas"]["nullable-integration"];
      pull_requests: components["schemas"]["pull-request-minimal"][];
      deployment?: components["schemas"]["deployment-simple"];
    };
    /** Check Annotation */
    "check-annotation": {
      path: string;
      start_line: number;
      end_line: number;
      start_column: number | null;
      end_column: number | null;
      annotation_level: string | null;
      title: string | null;
      message: string | null;
      raw_details: string | null;
      blob_href: string;
    };
    /** Simple Commit */
    "simple-commit": {
      id: string;
      tree_id: string;
      message: string;
      timestamp: string;
      author: {
        name: string;
        email: string;
      } | null;
      committer: {
        name: string;
        email: string;
      } | null;
    };
    /** A suite of checks performed on the code of a given code change */
    "check-suite": {
      id: number;
      node_id: string;
      head_branch: string | null;
      /** The SHA of the head commit that is being checked. */
      head_sha: string;
      status: ("queued" | "in_progress" | "completed") | null;
      conclusion:
        | (
            | "success"
            | "failure"
            | "neutral"
            | "cancelled"
            | "skipped"
            | "timed_out"
            | "action_required"
          )
        | null;
      url: string | null;
      before: string | null;
      after: string | null;
      pull_requests: components["schemas"]["pull-request-minimal"][] | null;
      app: components["schemas"]["nullable-integration"];
      repository: components["schemas"]["minimal-repository"];
      created_at: string | null;
      updated_at: string | null;
      head_commit: components["schemas"]["simple-commit"];
      latest_check_runs_count: number;
      check_runs_url: string;
      rerequestable?: boolean;
      runs_rerequestable?: boolean;
    };
    /** Check suite configuration preferences for a repository. */
    "check-suite-preference": {
      preferences: {
        auto_trigger_checks?: {
          app_id: number;
          setting: boolean;
        }[];
      };
      repository: components["schemas"]["minimal-repository"];
    };
    "code-scanning-alert-rule-summary": {
      /** A unique identifier for the rule used to detect the alert. */
      id?: string | null;
      /** The name of the rule used to detect the alert. */
      name?: string;
      /** A set of tags applicable for the rule. */
      tags?: string[] | null;
      /** The severity of the alert. */
      severity?: ("none" | "note" | "warning" | "error") | null;
      /** A short description of the rule used to detect the alert. */
      description?: string;
    };
    "code-scanning-alert-items": {
      number: components["schemas"]["alert-number"];
      created_at: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["alert-updated-at"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      instances_url: components["schemas"]["alert-instances-url"];
      state: components["schemas"]["code-scanning-alert-state"];
      fixed_at?: components["schemas"]["code-scanning-alert-fixed-at"];
      dismissed_by: components["schemas"]["nullable-simple-user"];
      dismissed_at: components["schemas"]["code-scanning-alert-dismissed-at"];
      dismissed_reason: components["schemas"]["code-scanning-alert-dismissed-reason"];
      dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
      rule: components["schemas"]["code-scanning-alert-rule-summary"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      most_recent_instance: components["schemas"]["code-scanning-alert-instance"];
    };
    "code-scanning-alert": {
      number: components["schemas"]["alert-number"];
      created_at: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["alert-updated-at"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      instances_url: components["schemas"]["alert-instances-url"];
      state: components["schemas"]["code-scanning-alert-state"];
      fixed_at?: components["schemas"]["code-scanning-alert-fixed-at"];
      dismissed_by: components["schemas"]["nullable-simple-user"];
      dismissed_at: components["schemas"]["code-scanning-alert-dismissed-at"];
      dismissed_reason: components["schemas"]["code-scanning-alert-dismissed-reason"];
      dismissed_comment?: components["schemas"]["code-scanning-alert-dismissed-comment"];
      rule: components["schemas"]["code-scanning-alert-rule"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      most_recent_instance: components["schemas"]["code-scanning-alert-instance"];
    };
    /** Sets the state of the code scanning alert. You must provide `dismissed_reason` when you set the state to `dismissed`. */
    "code-scanning-alert-set-state": "open" | "dismissed";
    /** An identifier for the upload. */
    "code-scanning-analysis-sarif-id": string;
    /** The SHA of the commit to which the analysis you are uploading relates. */
    "code-scanning-analysis-commit-sha": string;
    /** Identifies the variable values associated with the environment in which this analysis was performed. */
    "code-scanning-analysis-environment": string;
    /** The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
    "code-scanning-analysis-created-at": string;
    /** The REST API URL of the analysis resource. */
    "code-scanning-analysis-url": string;
    "code-scanning-analysis": {
      ref: components["schemas"]["code-scanning-ref"];
      commit_sha: components["schemas"]["code-scanning-analysis-commit-sha"];
      analysis_key: components["schemas"]["code-scanning-analysis-analysis-key"];
      environment: components["schemas"]["code-scanning-analysis-environment"];
      category?: components["schemas"]["code-scanning-analysis-category"];
      error: string;
      created_at: components["schemas"]["code-scanning-analysis-created-at"];
      /** The total number of results in the analysis. */
      results_count: number;
      /** The total number of rules used in the analysis. */
      rules_count: number;
      /** Unique identifier for this analysis. */
      id: number;
      url: components["schemas"]["code-scanning-analysis-url"];
      sarif_id: components["schemas"]["code-scanning-analysis-sarif-id"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
      deletable: boolean;
      /** Warning generated when processing the analysis */
      warning: string;
    };
    /** Successful deletion of a code scanning analysis */
    "code-scanning-analysis-deletion": {
      /** Next deletable analysis in chain, without last analysis deletion confirmation */
      next_analysis_url: string | null;
      /** Next deletable analysis in chain, with last analysis deletion confirmation */
      confirm_delete_url: string | null;
    };
    /** A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string. For more information, see "[SARIF support for code scanning](https://docs.github.com/code-security/secure-coding/sarif-support-for-code-scanning)." */
    "code-scanning-analysis-sarif-file": string;
    "code-scanning-sarifs-receipt": {
      id?: components["schemas"]["code-scanning-analysis-sarif-id"];
      /** The REST API URL for checking the status of the upload. */
      url?: string;
    };
    "code-scanning-sarifs-status": {
      /** `pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed. */
      processing_status?: "pending" | "complete" | "failed";
      /** The REST API URL for getting the analyses associated with the upload. */
      analyses_url?: string | null;
      /** Any errors that ocurred during processing of the delivery. */
      errors?: string[] | null;
    };
    /** A list of errors found in a repo's CODEOWNERS file */
    "codeowners-errors": {
      errors: {
        /** The line number where this errors occurs. */
        line: number;
        /** The column number where this errors occurs. */
        column: number;
        /** The contents of the line where the error occurs. */
        source?: string;
        /** The type of error. */
        kind: string;
        /** Suggested action to fix the error. This will usually be `null`, but is provided for some common errors. */
        suggestion?: string | null;
        /** A human-readable description of the error, combining information from multiple fields, laid out for display in a monospaced typeface (for example, a command-line setting). */
        message: string;
        /** The path of the file where the error occured. */
        path: string;
      }[];
    };
    /** A description of the machine powering a codespace. */
    "codespace-machine": {
      /** The name of the machine. */
      name: string;
      /** The display name of the machine includes cores, memory, and storage. */
      display_name: string;
      /** The operating system of the machine. */
      operating_system: string;
      /** How much storage is available to the codespace. */
      storage_in_bytes: number;
      /** How much memory is available to the codespace. */
      memory_in_bytes: number;
      /** How many cores are available to the codespace. */
      cpus: number;
      /** Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status. Old values "blob" and "pool" will be deprecated soon. */
      prebuild_availability:
        | ("none" | "blob" | "pool" | "ready" | "in_progress")
        | null;
    };
    /** Set repository secrets for GitHub Codespaces. */
    "repo-codespaces-secret": {
      /** The name of the secret. */
      name: string;
      created_at: string;
      updated_at: string;
    };
    /** The public key used for setting Codespaces secrets. */
    "codespaces-public-key": {
      /** The identifier for the key. */
      key_id: string;
      /** The Base64 encoded public key. */
      key: string;
      id?: number;
      url?: string;
      title?: string;
      created_at?: string;
    };
    /** Collaborator */
    collaborator: {
      login: string;
      id: number;
      email?: string | null;
      name?: string | null;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      events_url: string;
      received_events_url: string;
      type: string;
      site_admin: boolean;
      permissions?: {
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
        admin: boolean;
      };
      role_name: string;
    };
    /** Repository invitations let you manage who you collaborate with. */
    "repository-invitation": {
      /** Unique identifier of the repository invitation. */
      id: number;
      repository: components["schemas"]["minimal-repository"];
      invitee: components["schemas"]["nullable-simple-user"];
      inviter: components["schemas"]["nullable-simple-user"];
      /** The permission associated with the invitation. */
      permissions: "read" | "write" | "admin" | "triage" | "maintain";
      created_at: string;
      /** Whether or not the invitation has expired */
      expired?: boolean;
      /** URL for the repository invitation */
      url: string;
      html_url: string;
      node_id: string;
    };
    /** Collaborator */
    "nullable-collaborator": {
      login: string;
      id: number;
      email?: string | null;
      name?: string | null;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      events_url: string;
      received_events_url: string;
      type: string;
      site_admin: boolean;
      permissions?: {
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
        admin: boolean;
      };
      role_name: string;
    } | null;
    /** Repository Collaborator Permission */
    "repository-collaborator-permission": {
      permission: string;
      role_name: string;
      user: components["schemas"]["nullable-collaborator"];
    };
    /** Commit Comment */
    "commit-comment": {
      html_url: string;
      url: string;
      id: number;
      node_id: string;
      body: string;
      path: string | null;
      position: number | null;
      line: number | null;
      commit_id: string;
      user: components["schemas"]["nullable-simple-user"];
      created_at: string;
      updated_at: string;
      author_association: components["schemas"]["author_association"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /** Branch Short */
    "branch-short": {
      name: string;
      commit: {
        sha: string;
        url: string;
      };
      protected: boolean;
    };
    /** Hypermedia Link */
    link: {
      href: string;
    };
    /** The status of auto merging a pull request. */
    auto_merge: {
      enabled_by: components["schemas"]["simple-user"];
      /** The merge method to use. */
      merge_method: "merge" | "squash" | "rebase";
      /** Title for the merge commit message. */
      commit_title: string;
      /** Commit message for the merge commit. */
      commit_message: string;
    } | null;
    /** Pull Request Simple */
    "pull-request-simple": {
      url: string;
      id: number;
      node_id: string;
      html_url: string;
      diff_url: string;
      patch_url: string;
      issue_url: string;
      commits_url: string;
      review_comments_url: string;
      review_comment_url: string;
      comments_url: string;
      statuses_url: string;
      number: number;
      state: string;
      locked: boolean;
      title: string;
      user: components["schemas"]["nullable-simple-user"];
      body: string | null;
      labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string;
        color: string;
        default: boolean;
      }[];
      milestone: components["schemas"]["nullable-milestone"];
      active_lock_reason?: string | null;
      created_at: string;
      updated_at: string;
      closed_at: string | null;
      merged_at: string | null;
      merge_commit_sha: string | null;
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      requested_reviewers?: components["schemas"]["simple-user"][] | null;
      requested_teams?: components["schemas"]["team"][] | null;
      head: {
        label: string;
        ref: string;
        repo: components["schemas"]["repository"];
        sha: string;
        user: components["schemas"]["nullable-simple-user"];
      };
      base: {
        label: string;
        ref: string;
        repo: components["schemas"]["repository"];
        sha: string;
        user: components["schemas"]["nullable-simple-user"];
      };
      _links: {
        comments: components["schemas"]["link"];
        commits: components["schemas"]["link"];
        statuses: components["schemas"]["link"];
        html: components["schemas"]["link"];
        issue: components["schemas"]["link"];
        review_comments: components["schemas"]["link"];
        review_comment: components["schemas"]["link"];
        self: components["schemas"]["link"];
      };
      author_association: components["schemas"]["author_association"];
      auto_merge: components["schemas"]["auto_merge"];
      /** Indicates whether or not the pull request is a draft. */
      draft?: boolean;
    };
    "simple-commit-status": {
      description: string | null;
      id: number;
      node_id: string;
      state: string;
      context: string;
      target_url: string;
      required?: boolean | null;
      avatar_url: string | null;
      url: string;
      created_at: string;
      updated_at: string;
    };
    /** Combined Commit Status */
    "combined-commit-status": {
      state: string;
      statuses: components["schemas"]["simple-commit-status"][];
      sha: string;
      total_count: number;
      repository: components["schemas"]["minimal-repository"];
      commit_url: string;
      url: string;
    };
    /** The status of a commit. */
    status: {
      url: string;
      avatar_url: string | null;
      id: number;
      node_id: string;
      state: string;
      description: string;
      target_url: string;
      context: string;
      created_at: string;
      updated_at: string;
      creator: components["schemas"]["nullable-simple-user"];
    };
    /** Code of Conduct Simple */
    "nullable-code-of-conduct-simple": {
      url: string;
      key: string;
      name: string;
      html_url: string | null;
    } | null;
    "nullable-community-health-file": {
      url: string;
      html_url: string;
    } | null;
    /** Community Profile */
    "community-profile": {
      health_percentage: number;
      description: string | null;
      documentation: string | null;
      files: {
        code_of_conduct: components["schemas"]["nullable-code-of-conduct-simple"];
        code_of_conduct_file: components["schemas"]["nullable-community-health-file"];
        license: components["schemas"]["nullable-license-simple"];
        contributing: components["schemas"]["nullable-community-health-file"];
        readme: components["schemas"]["nullable-community-health-file"];
        issue_template: components["schemas"]["nullable-community-health-file"];
        pull_request_template: components["schemas"]["nullable-community-health-file"];
      };
      updated_at: string | null;
      content_reports_enabled?: boolean;
    };
    /** Commit Comparison */
    "commit-comparison": {
      url: string;
      html_url: string;
      permalink_url: string;
      diff_url: string;
      patch_url: string;
      base_commit: components["schemas"]["commit"];
      merge_base_commit: components["schemas"]["commit"];
      status: "diverged" | "ahead" | "behind" | "identical";
      ahead_by: number;
      behind_by: number;
      total_commits: number;
      commits: components["schemas"]["commit"][];
      files?: components["schemas"]["diff-entry"][];
    };
    /** Content Tree */
    "content-tree": {
      type: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      url: string;
      git_url: string | null;
      html_url: string | null;
      download_url: string | null;
      entries?: {
        type: string;
        size: number;
        name: string;
        path: string;
        content?: string;
        sha: string;
        url: string;
        git_url: string | null;
        html_url: string | null;
        download_url: string | null;
        _links: {
          git: string | null;
          html: string | null;
          self: string;
        };
      }[];
      _links: {
        git: string | null;
        html: string | null;
        self: string;
      };
    } & {
      content: unknown;
      encoding: unknown;
    };
    /** A list of directory items */
    "content-directory": {
      type: string;
      size: number;
      name: string;
      path: string;
      content?: string;
      sha: string;
      url: string;
      git_url: string | null;
      html_url: string | null;
      download_url: string | null;
      _links: {
        git: string | null;
        html: string | null;
        self: string;
      };
    }[];
    /** Content File */
    "content-file": {
      type: string;
      encoding: string;
      size: number;
      name: string;
      path: string;
      content: string;
      sha: string;
      url: string;
      git_url: string | null;
      html_url: string | null;
      download_url: string | null;
      _links: {
        git: string | null;
        html: string | null;
        self: string;
      };
      target?: string;
      submodule_git_url?: string;
    };
    /** An object describing a symlink */
    "content-symlink": {
      type: string;
      target: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      url: string;
      git_url: string | null;
      html_url: string | null;
      download_url: string | null;
      _links: {
        git: string | null;
        html: string | null;
        self: string;
      };
    };
    /** An object describing a symlink */
    "content-submodule": {
      type: string;
      submodule_git_url: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      url: string;
      git_url: string | null;
      html_url: string | null;
      download_url: string | null;
      _links: {
        git: string | null;
        html: string | null;
        self: string;
      };
    };
    /** File Commit */
    "file-commit": {
      content: {
        name?: string;
        path?: string;
        sha?: string;
        size?: number;
        url?: string;
        html_url?: string;
        git_url?: string;
        download_url?: string;
        type?: string;
        _links?: {
          self?: string;
          git?: string;
          html?: string;
        };
      } | null;
      commit: {
        sha?: string;
        node_id?: string;
        url?: string;
        html_url?: string;
        author?: {
          date?: string;
          name?: string;
          email?: string;
        };
        committer?: {
          date?: string;
          name?: string;
          email?: string;
        };
        message?: string;
        tree?: {
          url?: string;
          sha?: string;
        };
        parents?: {
          url?: string;
          html_url?: string;
          sha?: string;
        }[];
        verification?: {
          verified?: boolean;
          reason?: string;
          signature?: string | null;
          payload?: string | null;
        };
      };
    };
    /** Contributor */
    contributor: {
      login?: string;
      id?: number;
      node_id?: string;
      avatar_url?: string;
      gravatar_id?: string | null;
      url?: string;
      html_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      starred_url?: string;
      subscriptions_url?: string;
      organizations_url?: string;
      repos_url?: string;
      events_url?: string;
      received_events_url?: string;
      type: string;
      site_admin?: boolean;
      contributions: number;
      email?: string;
      name?: string;
    };
    /** Set secrets for Dependabot. */
    "dependabot-secret": {
      /** The name of the secret. */
      name: string;
      created_at: string;
      updated_at: string;
    };
    /** A diff of the dependencies between two commits. */
    "dependency-graph-diff": {
      change_type: "added" | "removed";
      manifest: string;
      ecosystem: string;
      name: string;
      version: string;
      package_url: string | null;
      license: string | null;
      source_repository_url: string | null;
      vulnerabilities: {
        severity: string;
        advisory_ghsa_id: string;
        advisory_summary: string;
        advisory_url: string;
      }[];
    }[];
    /** User-defined metadata to store domain-specific information limited to 8 keys with scalar values. */
    metadata: {
      [key: string]: Partial<string> & Partial<number> & Partial<boolean>;
    };
    /** A single package dependency. */
    dependency: {
      /** Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details. */
      package_url?: string;
      metadata?: components["schemas"]["metadata"];
      /** A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency. */
      relationship?: "direct" | "indirect";
      /** A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes. */
      scope?: "runtime" | "development";
      /** Array of package-url (PURLs) of direct child dependencies. */
      dependencies?: string[];
    };
    /** A collection of related dependencies declared in a file or representing a logical group of dependencies. */
    manifest: {
      /** The name of the manifest. */
      name: string;
      file?: {
        /** The path of the manifest file relative to the root of the Git repository. */
        source_location?: string;
      };
      metadata?: components["schemas"]["metadata"];
      resolved?: { [key: string]: components["schemas"]["dependency"] };
    };
    /** Create a new snapshot of a repository's dependencies. */
    snapshot: {
      /** The version of the repository snapshot submission. */
      version: number;
      job: {
        /** The external ID of the job. */
        id: string;
        /** Correlator provides a key that is used to group snapshots submitted over time. Only the "latest" submitted snapshot for a given combination of `job.correlator` and `detector.name` will be considered when calculating a repository's current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given "wave" of CI workflow you run. If you're using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you're using a build matrix, then you'll also need to add additional key(s) to distinguish between each submission inside a matrix variation. */
        correlator: string;
        /** The url for the job. */
        html_url?: string;
      };
      /** The commit SHA associated with this dependency snapshot. */
      sha: string;
      /** The repository branch that triggered this snapshot. */
      ref: string;
      /** A description of the detector used. */
      detector: {
        /** The name of the detector used. */
        name: string;
        /** The version of the detector used. */
        version: string;
        /** The url of the detector used. */
        url: string;
      };
      metadata?: components["schemas"]["metadata"];
      /** A collection of package manifests */
      manifests?: { [key: string]: components["schemas"]["manifest"] };
      /** The time at which the snapshot was scanned. */
      scanned: string;
    };
    /** The status of a deployment. */
    "deployment-status": {
      url: string;
      id: number;
      node_id: string;
      /** The state of the status. */
      state:
        | "error"
        | "failure"
        | "inactive"
        | "pending"
        | "success"
        | "queued"
        | "in_progress";
      creator: components["schemas"]["nullable-simple-user"];
      /** A short description of the status. */
      description: string;
      /** The environment of the deployment that the status is for. */
      environment?: string;
      /** Deprecated: the URL to associate with this status. */
      target_url: string;
      created_at: string;
      updated_at: string;
      deployment_url: string;
      repository_url: string;
      /** The URL for accessing your environment. */
      environment_url?: string;
      /** The URL to associate with this status. */
      log_url?: string;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /** The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days). */
    "wait-timer": number;
    /** The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`. */
    deployment_branch_policy: {
      /** Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`. */
      protected_branches: boolean;
      /** Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`. */
      custom_branch_policies: boolean;
    } | null;
    /** Details of a deployment environment */
    environment: {
      /** The id of the environment. */
      id: number;
      node_id: string;
      /** The name of the environment. */
      name: string;
      url: string;
      html_url: string;
      /** The time that the environment was created, in ISO 8601 format. */
      created_at: string;
      /** The time that the environment was last updated, in ISO 8601 format. */
      updated_at: string;
      protection_rules?: (Partial<{
        id: number;
        node_id: string;
        type: string;
        wait_timer?: components["schemas"]["wait-timer"];
      }> &
        Partial<{
          id: number;
          node_id: string;
          type: string;
          /** The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed. */
          reviewers?: {
            type?: components["schemas"]["deployment-reviewer-type"];
            reviewer?: Partial<components["schemas"]["simple-user"]> &
              Partial<components["schemas"]["team"]>;
          }[];
        }> &
        Partial<{
          id: number;
          node_id: string;
          type: string;
        }>)[];
      deployment_branch_policy?: components["schemas"]["deployment_branch_policy"];
    };
    /** Short Blob */
    "short-blob": {
      url: string;
      sha: string;
    };
    /** Blob */
    blob: {
      content: string;
      encoding: string;
      url: string;
      sha: string;
      size: number | null;
      node_id: string;
      highlighted_content?: string;
    };
    /** Low-level Git commit operations within a repository */
    "git-commit": {
      /** SHA for the commit */
      sha: string;
      node_id: string;
      url: string;
      /** Identifying information for the git-user */
      author: {
        /** Timestamp of the commit */
        date: string;
        /** Git email address of the user */
        email: string;
        /** Name of the git user */
        name: string;
      };
      /** Identifying information for the git-user */
      committer: {
        /** Timestamp of the commit */
        date: string;
        /** Git email address of the user */
        email: string;
        /** Name of the git user */
        name: string;
      };
      /** Message describing the purpose of the commit */
      message: string;
      tree: {
        /** SHA for the commit */
        sha: string;
        url: string;
      };
      parents: {
        /** SHA for the commit */
        sha: string;
        url: string;
        html_url: string;
      }[];
      verification: {
        verified: boolean;
        reason: string;
        signature: string | null;
        payload: string | null;
      };
      html_url: string;
    };
    /** Git references within a repository */
    "git-ref": {
      ref: string;
      node_id: string;
      url: string;
      object: {
        type: string;
        /** SHA for the reference */
        sha: string;
        url: string;
      };
    };
    /** Metadata for a Git tag */
    "git-tag": {
      node_id: string;
      /** Name of the tag */
      tag: string;
      sha: string;
      /** URL for the tag */
      url: string;
      /** Message describing the purpose of the tag */
      message: string;
      tagger: {
        date: string;
        email: string;
        name: string;
      };
      object: {
        sha: string;
        type: string;
        url: string;
      };
      verification?: components["schemas"]["verification"];
    };
    /** The hierarchy between files in a Git repository. */
    "git-tree": {
      sha: string;
      url: string;
      truncated: boolean;
      /** Objects specifying a tree structure */
      tree: {
        path?: string;
        mode?: string;
        type?: string;
        sha?: string;
        size?: number;
        url?: string;
      }[];
    };
    "hook-response": {
      code: number | null;
      status: string | null;
      message: string | null;
    };
    /** Webhooks for repositories. */
    hook: {
      type: string;
      /** Unique identifier of the webhook. */
      id: number;
      /** The name of a valid service, use 'web' for a webhook. */
      name: string;
      /** Determines whether the hook is actually triggered on pushes. */
      active: boolean;
      /** Determines what events the hook is triggered for. Default: ['push']. */
      events: string[];
      config: {
        email?: string;
        password?: string;
        room?: string;
        subdomain?: string;
        url?: components["schemas"]["webhook-config-url"];
        insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
        content_type?: components["schemas"]["webhook-config-content-type"];
        digest?: string;
        secret?: components["schemas"]["webhook-config-secret"];
        token?: string;
      };
      updated_at: string;
      created_at: string;
      url: string;
      test_url: string;
      ping_url: string;
      deliveries_url?: string;
      last_response: components["schemas"]["hook-response"];
    };
    /** A repository import from an external source. */
    import: {
      vcs: string | null;
      use_lfs?: boolean;
      /** The URL of the originating repository. */
      vcs_url: string;
      svc_root?: string;
      tfvc_project?: string;
      status:
        | "auth"
        | "error"
        | "none"
        | "detecting"
        | "choose"
        | "auth_failed"
        | "importing"
        | "mapping"
        | "waiting_to_push"
        | "pushing"
        | "complete"
        | "setup"
        | "unknown"
        | "detection_found_multiple"
        | "detection_found_nothing"
        | "detection_needs_auth";
      status_text?: string | null;
      failed_step?: string | null;
      error_message?: string | null;
      import_percent?: number | null;
      commit_count?: number | null;
      push_percent?: number | null;
      has_large_files?: boolean;
      large_files_size?: number;
      large_files_count?: number;
      project_choices?: {
        vcs?: string;
        tfvc_project?: string;
        human_name?: string;
      }[];
      message?: string;
      authors_count?: number | null;
      url: string;
      html_url: string;
      authors_url: string;
      repository_url: string;
      svn_root?: string;
    };
    /** Porter Author */
    "porter-author": {
      id: number;
      remote_id: string;
      remote_name: string;
      email: string;
      name: string;
      url: string;
      import_url: string;
    };
    /** Porter Large File */
    "porter-large-file": {
      ref_name: string;
      path: string;
      oid: string;
      size: number;
    };
    /** Issues are a great way to keep track of tasks, enhancements, and bugs for your projects. */
    "nullable-issue": {
      id: number;
      node_id: string;
      /** URL for the issue */
      url: string;
      repository_url: string;
      labels_url: string;
      comments_url: string;
      events_url: string;
      html_url: string;
      /** Number uniquely identifying the issue within its repository */
      number: number;
      /** State of the issue; either 'open' or 'closed' */
      state: string;
      /** The reason for the current state */
      state_reason?: string | null;
      /** Title of the issue */
      title: string;
      /** Contents of the issue */
      body?: string | null;
      user: components["schemas"]["nullable-simple-user"];
      /** Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository */
      labels: (
        | string
        | {
            id?: number;
            node_id?: string;
            url?: string;
            name?: string;
            description?: string | null;
            color?: string | null;
            default?: boolean;
          }
      )[];
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      milestone: components["schemas"]["nullable-milestone"];
      locked: boolean;
      active_lock_reason?: string | null;
      comments: number;
      pull_request?: {
        merged_at?: string | null;
        diff_url: string | null;
        html_url: string | null;
        patch_url: string | null;
        url: string | null;
      };
      closed_at: string | null;
      created_at: string;
      updated_at: string;
      draft?: boolean;
      closed_by?: components["schemas"]["nullable-simple-user"];
      body_html?: string;
      body_text?: string;
      timeline_url?: string;
      repository?: components["schemas"]["repository"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      author_association: components["schemas"]["author_association"];
      reactions?: components["schemas"]["reaction-rollup"];
    } | null;
    /** Issue Event Label */
    "issue-event-label": {
      name: string | null;
      color: string | null;
    };
    "issue-event-dismissed-review": {
      state: string;
      review_id: number;
      dismissal_message: string | null;
      dismissal_commit_id?: string | null;
    };
    /** Issue Event Milestone */
    "issue-event-milestone": {
      title: string;
    };
    /** Issue Event Project Card */
    "issue-event-project-card": {
      url: string;
      id: number;
      project_url: string;
      project_id: number;
      column_name: string;
      previous_column_name?: string;
    };
    /** Issue Event Rename */
    "issue-event-rename": {
      from: string;
      to: string;
    };
    /** Issue Event */
    "issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["nullable-simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      issue?: components["schemas"]["nullable-issue"];
      label?: components["schemas"]["issue-event-label"];
      assignee?: components["schemas"]["nullable-simple-user"];
      assigner?: components["schemas"]["nullable-simple-user"];
      review_requester?: components["schemas"]["nullable-simple-user"];
      requested_reviewer?: components["schemas"]["nullable-simple-user"];
      requested_team?: components["schemas"]["team"];
      dismissed_review?: components["schemas"]["issue-event-dismissed-review"];
      milestone?: components["schemas"]["issue-event-milestone"];
      project_card?: components["schemas"]["issue-event-project-card"];
      rename?: components["schemas"]["issue-event-rename"];
      author_association?: components["schemas"]["author_association"];
      lock_reason?: string | null;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
    };
    /** Labeled Issue Event */
    "labeled-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      label: {
        name: string;
        color: string;
      };
    };
    /** Unlabeled Issue Event */
    "unlabeled-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      label: {
        name: string;
        color: string;
      };
    };
    /** Assigned Issue Event */
    "assigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["integration"];
      assignee: components["schemas"]["simple-user"];
      assigner: components["schemas"]["simple-user"];
    };
    /** Unassigned Issue Event */
    "unassigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      assignee: components["schemas"]["simple-user"];
      assigner: components["schemas"]["simple-user"];
    };
    /** Milestoned Issue Event */
    "milestoned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      milestone: {
        title: string;
      };
    };
    /** Demilestoned Issue Event */
    "demilestoned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      milestone: {
        title: string;
      };
    };
    /** Renamed Issue Event */
    "renamed-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      rename: {
        from: string;
        to: string;
      };
    };
    /** Review Requested Issue Event */
    "review-requested-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      review_requester: components["schemas"]["simple-user"];
      requested_team?: components["schemas"]["team"];
      requested_reviewer?: components["schemas"]["simple-user"];
    };
    /** Review Request Removed Issue Event */
    "review-request-removed-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      review_requester: components["schemas"]["simple-user"];
      requested_team?: components["schemas"]["team"];
      requested_reviewer?: components["schemas"]["simple-user"];
    };
    /** Review Dismissed Issue Event */
    "review-dismissed-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      dismissed_review: {
        state: string;
        review_id: number;
        dismissal_message: string | null;
        dismissal_commit_id?: string;
      };
    };
    /** Locked Issue Event */
    "locked-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      lock_reason: string | null;
    };
    /** Added to Project Issue Event */
    "added-to-project-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      project_card?: {
        id: number;
        url: string;
        project_id: number;
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /** Moved Column in Project Issue Event */
    "moved-column-in-project-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      project_card?: {
        id: number;
        url: string;
        project_id: number;
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /** Removed from Project Issue Event */
    "removed-from-project-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      project_card?: {
        id: number;
        url: string;
        project_id: number;
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /** Converted Note to Issue Issue Event */
    "converted-note-to-issue-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["integration"];
      project_card?: {
        id: number;
        url: string;
        project_id: number;
        project_url: string;
        column_name: string;
        previous_column_name?: string;
      };
    };
    /** Issue Event for Issue */
    "issue-event-for-issue": Partial<
      components["schemas"]["labeled-issue-event"]
    > &
      Partial<components["schemas"]["unlabeled-issue-event"]> &
      Partial<components["schemas"]["assigned-issue-event"]> &
      Partial<components["schemas"]["unassigned-issue-event"]> &
      Partial<components["schemas"]["milestoned-issue-event"]> &
      Partial<components["schemas"]["demilestoned-issue-event"]> &
      Partial<components["schemas"]["renamed-issue-event"]> &
      Partial<components["schemas"]["review-requested-issue-event"]> &
      Partial<components["schemas"]["review-request-removed-issue-event"]> &
      Partial<components["schemas"]["review-dismissed-issue-event"]> &
      Partial<components["schemas"]["locked-issue-event"]> &
      Partial<components["schemas"]["added-to-project-issue-event"]> &
      Partial<components["schemas"]["moved-column-in-project-issue-event"]> &
      Partial<components["schemas"]["removed-from-project-issue-event"]> &
      Partial<components["schemas"]["converted-note-to-issue-issue-event"]>;
    /** Color-coded labels help you categorize and filter your issues (just like labels in Gmail). */
    label: {
      id: number;
      node_id: string;
      /** URL for the label */
      url: string;
      /** The name of the label. */
      name: string;
      description: string | null;
      /** 6-character hex code, without the leading #, identifying the color */
      color: string;
      default: boolean;
    };
    /** Timeline Comment Event */
    "timeline-comment-event": {
      event: string;
      actor: components["schemas"]["simple-user"];
      /** Unique identifier of the issue comment */
      id: number;
      node_id: string;
      /** URL for the issue comment */
      url: string;
      /** Contents of the issue comment */
      body?: string;
      body_text?: string;
      body_html?: string;
      html_url: string;
      user: components["schemas"]["simple-user"];
      created_at: string;
      updated_at: string;
      issue_url: string;
      author_association: components["schemas"]["author_association"];
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /** Timeline Cross Referenced Event */
    "timeline-cross-referenced-event": {
      event: string;
      actor?: components["schemas"]["simple-user"];
      created_at: string;
      updated_at: string;
      source: {
        type?: string;
        issue?: components["schemas"]["issue"];
      };
    };
    /** Timeline Committed Event */
    "timeline-committed-event": {
      event?: string;
      /** SHA for the commit */
      sha: string;
      node_id: string;
      url: string;
      /** Identifying information for the git-user */
      author: {
        /** Timestamp of the commit */
        date: string;
        /** Git email address of the user */
        email: string;
        /** Name of the git user */
        name: string;
      };
      /** Identifying information for the git-user */
      committer: {
        /** Timestamp of the commit */
        date: string;
        /** Git email address of the user */
        email: string;
        /** Name of the git user */
        name: string;
      };
      /** Message describing the purpose of the commit */
      message: string;
      tree: {
        /** SHA for the commit */
        sha: string;
        url: string;
      };
      parents: {
        /** SHA for the commit */
        sha: string;
        url: string;
        html_url: string;
      }[];
      verification: {
        verified: boolean;
        reason: string;
        signature: string | null;
        payload: string | null;
      };
      html_url: string;
    };
    /** Timeline Reviewed Event */
    "timeline-reviewed-event": {
      event: string;
      /** Unique identifier of the review */
      id: number;
      node_id: string;
      user: components["schemas"]["simple-user"];
      /** The text of the review. */
      body: string | null;
      state: string;
      html_url: string;
      pull_request_url: string;
      _links: {
        html: {
          href: string;
        };
        pull_request: {
          href: string;
        };
      };
      submitted_at?: string;
      /** A commit SHA for the review. */
      commit_id: string;
      body_html?: string;
      body_text?: string;
      author_association: components["schemas"]["author_association"];
    };
    /** Pull Request Review Comments are comments on a portion of the Pull Request's diff. */
    "pull-request-review-comment": {
      /** URL for the pull request review comment */
      url: string;
      /** The ID of the pull request review to which the comment belongs. */
      pull_request_review_id: number | null;
      /** The ID of the pull request review comment. */
      id: number;
      /** The node ID of the pull request review comment. */
      node_id: string;
      /** The diff of the line that the comment refers to. */
      diff_hunk: string;
      /** The relative path of the file to which the comment applies. */
      path: string;
      /** The line index in the diff to which the comment applies. This field is deprecated; use `line` instead. */
      position: number;
      /** The index of the original line in the diff to which the comment applies. This field is deprecated; use `original_line` instead. */
      original_position: number;
      /** The SHA of the commit to which the comment applies. */
      commit_id: string;
      /** The SHA of the original commit to which the comment applies. */
      original_commit_id: string;
      /** The comment ID to reply to. */
      in_reply_to_id?: number;
      user: components["schemas"]["simple-user"];
      /** The text of the comment. */
      body: string;
      created_at: string;
      updated_at: string;
      /** HTML URL for the pull request review comment. */
      html_url: string;
      /** URL for the pull request that the review comment belongs to. */
      pull_request_url: string;
      author_association: components["schemas"]["author_association"];
      _links: {
        self: {
          href: string;
        };
        html: {
          href: string;
        };
        pull_request: {
          href: string;
        };
      };
      /** The first line of the range for a multi-line comment. */
      start_line?: number | null;
      /** The first line of the range for a multi-line comment. */
      original_start_line?: number | null;
      /** The side of the first line of the range for a multi-line comment. */
      start_side?: ("LEFT" | "RIGHT") | null;
      /** The line of the blob to which the comment applies. The last line of the range for a multi-line comment */
      line?: number;
      /** The line of the blob to which the comment applies. The last line of the range for a multi-line comment */
      original_line?: number;
      /** The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment */
      side?: "LEFT" | "RIGHT";
      reactions?: components["schemas"]["reaction-rollup"];
      body_html?: string;
      body_text?: string;
    };
    /** Timeline Line Commented Event */
    "timeline-line-commented-event": {
      event?: string;
      node_id?: string;
      comments?: components["schemas"]["pull-request-review-comment"][];
    };
    /** Timeline Commit Commented Event */
    "timeline-commit-commented-event": {
      event?: string;
      node_id?: string;
      commit_id?: string;
      comments?: components["schemas"]["commit-comment"][];
    };
    /** Timeline Assigned Issue Event */
    "timeline-assigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      assignee: components["schemas"]["simple-user"];
    };
    /** Timeline Unassigned Issue Event */
    "timeline-unassigned-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      assignee: components["schemas"]["simple-user"];
    };
    /** State Change Issue Event */
    "state-change-issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"];
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      performed_via_github_app: components["schemas"]["nullable-integration"];
      state_reason?: string | null;
    };
    /** Timeline Event */
    "timeline-issue-events": Partial<
      components["schemas"]["labeled-issue-event"]
    > &
      Partial<components["schemas"]["unlabeled-issue-event"]> &
      Partial<components["schemas"]["milestoned-issue-event"]> &
      Partial<components["schemas"]["demilestoned-issue-event"]> &
      Partial<components["schemas"]["renamed-issue-event"]> &
      Partial<components["schemas"]["review-requested-issue-event"]> &
      Partial<components["schemas"]["review-request-removed-issue-event"]> &
      Partial<components["schemas"]["review-dismissed-issue-event"]> &
      Partial<components["schemas"]["locked-issue-event"]> &
      Partial<components["schemas"]["added-to-project-issue-event"]> &
      Partial<components["schemas"]["moved-column-in-project-issue-event"]> &
      Partial<components["schemas"]["removed-from-project-issue-event"]> &
      Partial<components["schemas"]["converted-note-to-issue-issue-event"]> &
      Partial<components["schemas"]["timeline-comment-event"]> &
      Partial<components["schemas"]["timeline-cross-referenced-event"]> &
      Partial<components["schemas"]["timeline-committed-event"]> &
      Partial<components["schemas"]["timeline-reviewed-event"]> &
      Partial<components["schemas"]["timeline-line-commented-event"]> &
      Partial<components["schemas"]["timeline-commit-commented-event"]> &
      Partial<components["schemas"]["timeline-assigned-issue-event"]> &
      Partial<components["schemas"]["timeline-unassigned-issue-event"]> &
      Partial<components["schemas"]["state-change-issue-event"]>;
    /** An SSH key granting access to a single repository. */
    "deploy-key": {
      id: number;
      key: string;
      url: string;
      title: string;
      verified: boolean;
      created_at: string;
      read_only: boolean;
    };
    /** Language */
    language: { [key: string]: number };
    /** License Content */
    "license-content": {
      name: string;
      path: string;
      sha: string;
      size: number;
      url: string;
      html_url: string | null;
      git_url: string | null;
      download_url: string | null;
      type: string;
      content: string;
      encoding: string;
      _links: {
        git: string | null;
        html: string | null;
        self: string;
      };
      license: components["schemas"]["nullable-license-simple"];
    };
    /** Results of a successful merge upstream request */
    "merged-upstream": {
      message?: string;
      merge_type?: "merge" | "fast-forward" | "none";
      base_branch?: string;
    };
    /** A collection of related issues and pull requests. */
    milestone: {
      url: string;
      html_url: string;
      labels_url: string;
      id: number;
      node_id: string;
      /** The number of the milestone. */
      number: number;
      /** The state of the milestone. */
      state: "open" | "closed";
      /** The title of the milestone. */
      title: string;
      description: string | null;
      creator: components["schemas"]["nullable-simple-user"];
      open_issues: number;
      closed_issues: number;
      created_at: string;
      updated_at: string;
      closed_at: string | null;
      due_on: string | null;
    };
    "pages-source-hash": {
      branch: string;
      path: string;
    };
    "pages-https-certificate": {
      state:
        | "new"
        | "authorization_created"
        | "authorization_pending"
        | "authorized"
        | "authorization_revoked"
        | "issued"
        | "uploaded"
        | "approved"
        | "errored"
        | "bad_authz"
        | "destroy_pending"
        | "dns_changed";
      description: string;
      /** Array of the domain set and its alternate name (if it is configured) */
      domains: string[];
      expires_at?: string;
    };
    /** The configuration for GitHub Pages for a repository. */
    page: {
      /** The API address for accessing this Page resource. */
      url: string;
      /** The status of the most recent build of the Page. */
      status: ("built" | "building" | "errored") | null;
      /** The Pages site's custom domain */
      cname: string | null;
      /** The state if the domain is verified */
      protected_domain_state?: ("pending" | "verified" | "unverified") | null;
      /** The timestamp when a pending domain becomes unverified. */
      pending_domain_unverified_at?: string | null;
      /** Whether the Page has a custom 404 page. */
      custom_404: boolean;
      /** The web address the Page can be accessed from. */
      html_url?: string;
      /** The process in which the Page will be built. */
      build_type?: ("legacy" | "workflow") | null;
      source?: components["schemas"]["pages-source-hash"];
      /** Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site. */
      public: boolean;
      https_certificate?: components["schemas"]["pages-https-certificate"];
      /** Whether https is enabled on the domain */
      https_enforced?: boolean;
    };
    /** Page Build */
    "page-build": {
      url: string;
      status: string;
      error: {
        message: string | null;
      };
      pusher: components["schemas"]["nullable-simple-user"];
      commit: string;
      duration: number;
      created_at: string;
      updated_at: string;
    };
    /** Page Build Status */
    "page-build-status": {
      url: string;
      status: string;
    };
    /** Pages Health Check Status */
    "pages-health-check": {
      domain?: {
        host?: string;
        uri?: string;
        nameservers?: string;
        dns_resolves?: boolean;
        is_proxied?: boolean | null;
        is_cloudflare_ip?: boolean | null;
        is_fastly_ip?: boolean | null;
        is_old_ip_address?: boolean | null;
        is_a_record?: boolean | null;
        has_cname_record?: boolean | null;
        has_mx_records_present?: boolean | null;
        is_valid_domain?: boolean;
        is_apex_domain?: boolean;
        should_be_a_record?: boolean | null;
        is_cname_to_github_user_domain?: boolean | null;
        is_cname_to_pages_dot_github_dot_com?: boolean | null;
        is_cname_to_fastly?: boolean | null;
        is_pointed_to_github_pages_ip?: boolean | null;
        is_non_github_pages_ip_present?: boolean | null;
        is_pages_domain?: boolean;
        is_served_by_pages?: boolean | null;
        is_valid?: boolean;
        reason?: string | null;
        responds_to_https?: boolean;
        enforces_https?: boolean;
        https_error?: string | null;
        is_https_eligible?: boolean | null;
        caa_error?: string | null;
      };
      alt_domain?: {
        host?: string;
        uri?: string;
        nameservers?: string;
        dns_resolves?: boolean;
        is_proxied?: boolean | null;
        is_cloudflare_ip?: boolean | null;
        is_fastly_ip?: boolean | null;
        is_old_ip_address?: boolean | null;
        is_a_record?: boolean | null;
        has_cname_record?: boolean | null;
        has_mx_records_present?: boolean | null;
        is_valid_domain?: boolean;
        is_apex_domain?: boolean;
        should_be_a_record?: boolean | null;
        is_cname_to_github_user_domain?: boolean | null;
        is_cname_to_pages_dot_github_dot_com?: boolean | null;
        is_cname_to_fastly?: boolean | null;
        is_pointed_to_github_pages_ip?: boolean | null;
        is_non_github_pages_ip_present?: boolean | null;
        is_pages_domain?: boolean;
        is_served_by_pages?: boolean | null;
        is_valid?: boolean;
        reason?: string | null;
        responds_to_https?: boolean;
        enforces_https?: boolean;
        https_error?: string | null;
        is_https_eligible?: boolean | null;
        caa_error?: string | null;
      } | null;
    };
    /** Groups of organization members that gives permissions on specified repositories. */
    "team-simple": {
      /** Unique identifier of the team */
      id: number;
      node_id: string;
      /** URL for the team */
      url: string;
      members_url: string;
      /** Name of the team */
      name: string;
      /** Description of the team */
      description: string | null;
      /** Permission that the team will have for its repositories */
      permission: string;
      /** The level of privacy this team should have */
      privacy?: string;
      html_url: string;
      repositories_url: string;
      slug: string;
      /** Distinguished Name (DN) that team maps to within LDAP environment */
      ldap_dn?: string;
    };
    /** Pull requests let you tell others about changes you've pushed to a repository on GitHub. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary. */
    "pull-request": {
      url: string;
      id: number;
      node_id: string;
      html_url: string;
      diff_url: string;
      patch_url: string;
      issue_url: string;
      commits_url: string;
      review_comments_url: string;
      review_comment_url: string;
      comments_url: string;
      statuses_url: string;
      /** Number uniquely identifying the pull request within its repository. */
      number: number;
      /** State of this Pull Request. Either `open` or `closed`. */
      state: "open" | "closed";
      locked: boolean;
      /** The title of the pull request. */
      title: string;
      user: components["schemas"]["nullable-simple-user"];
      body: string | null;
      labels: {
        id: number;
        node_id: string;
        url: string;
        name: string;
        description: string | null;
        color: string;
        default: boolean;
      }[];
      milestone: components["schemas"]["nullable-milestone"];
      active_lock_reason?: string | null;
      created_at: string;
      updated_at: string;
      closed_at: string | null;
      merged_at: string | null;
      merge_commit_sha: string | null;
      assignee: components["schemas"]["nullable-simple-user"];
      assignees?: components["schemas"]["simple-user"][] | null;
      requested_reviewers?: components["schemas"]["simple-user"][] | null;
      requested_teams?: components["schemas"]["team-simple"][] | null;
      head: {
        label: string;
        ref: string;
        repo: {
          archive_url: string;
          assignees_url: string;
          blobs_url: string;
          branches_url: string;
          collaborators_url: string;
          comments_url: string;
          commits_url: string;
          compare_url: string;
          contents_url: string;
          contributors_url: string;
          deployments_url: string;
          description: string | null;
          downloads_url: string;
          events_url: string;
          fork: boolean;
          forks_url: string;
          full_name: string;
          git_commits_url: string;
          git_refs_url: string;
          git_tags_url: string;
          hooks_url: string;
          html_url: string;
          id: number;
          node_id: string;
          issue_comment_url: string;
          issue_events_url: string;
          issues_url: string;
          keys_url: string;
          labels_url: string;
          languages_url: string;
          merges_url: string;
          milestones_url: string;
          name: string;
          notifications_url: string;
          owner: {
            avatar_url: string;
            events_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            gravatar_id: string | null;
            html_url: string;
            id: number;
            node_id: string;
            login: string;
            organizations_url: string;
            received_events_url: string;
            repos_url: string;
            site_admin: boolean;
            starred_url: string;
            subscriptions_url: string;
            type: string;
            url: string;
          };
          private: boolean;
          pulls_url: string;
          releases_url: string;
          stargazers_url: string;
          statuses_url: string;
          subscribers_url: string;
          subscription_url: string;
          tags_url: string;
          teams_url: string;
          trees_url: string;
          url: string;
          clone_url: string;
          default_branch: string;
          forks: number;
          forks_count: number;
          git_url: string;
          has_downloads: boolean;
          has_issues: boolean;
          has_projects: boolean;
          has_wiki: boolean;
          has_pages: boolean;
          homepage: string | null;
          language: string | null;
          master_branch?: string;
          archived: boolean;
          disabled: boolean;
          /** The repository visibility: public, private, or internal. */
          visibility?: string;
          mirror_url: string | null;
          open_issues: number;
          open_issues_count: number;
          permissions?: {
            admin: boolean;
            maintain?: boolean;
            push: boolean;
            triage?: boolean;
            pull: boolean;
          };
          temp_clone_token?: string;
          allow_merge_commit?: boolean;
          allow_squash_merge?: boolean;
          allow_rebase_merge?: boolean;
          license: {
            key: string;
            name: string;
            url: string | null;
            spdx_id: string | null;
            node_id: string;
          } | null;
          pushed_at: string;
          size: number;
          ssh_url: string;
          stargazers_count: number;
          svn_url: string;
          topics?: string[];
          watchers: number;
          watchers_count: number;
          created_at: string;
          updated_at: string;
          allow_forking?: boolean;
          is_template?: boolean;
        } | null;
        sha: string;
        user: {
          avatar_url: string;
          events_url: string;
          followers_url: string;
          following_url: string;
          gists_url: string;
          gravatar_id: string | null;
          html_url: string;
          id: number;
          node_id: string;
          login: string;
          organizations_url: string;
          received_events_url: string;
          repos_url: string;
          site_admin: boolean;
          starred_url: string;
          subscriptions_url: string;
          type: string;
          url: string;
        };
      };
      base: {
        label: string;
        ref: string;
        repo: {
          archive_url: string;
          assignees_url: string;
          blobs_url: string;
          branches_url: string;
          collaborators_url: string;
          comments_url: string;
          commits_url: string;
          compare_url: string;
          contents_url: string;
          contributors_url: string;
          deployments_url: string;
          description: string | null;
          downloads_url: string;
          events_url: string;
          fork: boolean;
          forks_url: string;
          full_name: string;
          git_commits_url: string;
          git_refs_url: string;
          git_tags_url: string;
          hooks_url: string;
          html_url: string;
          id: number;
          is_template?: boolean;
          node_id: string;
          issue_comment_url: string;
          issue_events_url: string;
          issues_url: string;
          keys_url: string;
          labels_url: string;
          languages_url: string;
          merges_url: string;
          milestones_url: string;
          name: string;
          notifications_url: string;
          owner: {
            avatar_url: string;
            events_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            gravatar_id: string | null;
            html_url: string;
            id: number;
            node_id: string;
            login: string;
            organizations_url: string;
            received_events_url: string;
            repos_url: string;
            site_admin: boolean;
            starred_url: string;
            subscriptions_url: string;
            type: string;
            url: string;
          };
          private: boolean;
          pulls_url: string;
          releases_url: string;
          stargazers_url: string;
          statuses_url: string;
          subscribers_url: string;
          subscription_url: string;
          tags_url: string;
          teams_url: string;
          trees_url: string;
          url: string;
          clone_url: string;
          default_branch: string;
          forks: number;
          forks_count: number;
          git_url: string;
          has_downloads: boolean;
          has_issues: boolean;
          has_projects: boolean;
          has_wiki: boolean;
          has_pages: boolean;
          homepage: string | null;
          language: string | null;
          master_branch?: string;
          archived: boolean;
          disabled: boolean;
          /** The repository visibility: public, private, or internal. */
          visibility?: string;
          mirror_url: string | null;
          open_issues: number;
          open_issues_count: number;
          permissions?: {
            admin: boolean;
            maintain?: boolean;
            push: boolean;
            triage?: boolean;
            pull: boolean;
          };
          temp_clone_token?: string;
          allow_merge_commit?: boolean;
          allow_squash_merge?: boolean;
          allow_rebase_merge?: boolean;
          license: components["schemas"]["nullable-license-simple"];
          pushed_at: string;
          size: number;
          ssh_url: string;
          stargazers_count: number;
          svn_url: string;
          topics?: string[];
          watchers: number;
          watchers_count: number;
          created_at: string;
          updated_at: string;
          allow_forking?: boolean;
        };
        sha: string;
        user: {
          avatar_url: string;
          events_url: string;
          followers_url: string;
          following_url: string;
          gists_url: string;
          gravatar_id: string | null;
          html_url: string;
          id: number;
          node_id: string;
          login: string;
          organizations_url: string;
          received_events_url: string;
          repos_url: string;
          site_admin: boolean;
          starred_url: string;
          subscriptions_url: string;
          type: string;
          url: string;
        };
      };
      _links: {
        comments: components["schemas"]["link"];
        commits: components["schemas"]["link"];
        statuses: components["schemas"]["link"];
        html: components["schemas"]["link"];
        issue: components["schemas"]["link"];
        review_comments: components["schemas"]["link"];
        review_comment: components["schemas"]["link"];
        self: components["schemas"]["link"];
      };
      author_association: components["schemas"]["author_association"];
      auto_merge: components["schemas"]["auto_merge"];
      /** Indicates whether or not the pull request is a draft. */
      draft?: boolean;
      merged: boolean;
      mergeable: boolean | null;
      rebaseable?: boolean | null;
      mergeable_state: string;
      merged_by: components["schemas"]["nullable-simple-user"];
      comments: number;
      review_comments: number;
      /** Indicates whether maintainers can modify the pull request. */
      maintainer_can_modify: boolean;
      commits: number;
      additions: number;
      deletions: number;
      changed_files: number;
    };
    /** Pull Request Merge Result */
    "pull-request-merge-result": {
      sha: string;
      merged: boolean;
      message: string;
    };
    /** Pull Request Review Request */
    "pull-request-review-request": {
      users: components["schemas"]["simple-user"][];
      teams: components["schemas"]["team"][];
    };
    /** Pull Request Reviews are reviews on pull requests. */
    "pull-request-review": {
      /** Unique identifier of the review */
      id: number;
      node_id: string;
      user: components["schemas"]["nullable-simple-user"];
      /** The text of the review. */
      body: string;
      state: string;
      html_url: string;
      pull_request_url: string;
      _links: {
        html: {
          href: string;
        };
        pull_request: {
          href: string;
        };
      };
      submitted_at?: string;
      /** A commit SHA for the review. */
      commit_id: string;
      body_html?: string;
      body_text?: string;
      author_association: components["schemas"]["author_association"];
    };
    /** Legacy Review Comment */
    "review-comment": {
      url: string;
      pull_request_review_id: number | null;
      id: number;
      node_id: string;
      diff_hunk: string;
      path: string;
      position: number | null;
      original_position: number;
      commit_id: string;
      original_commit_id: string;
      in_reply_to_id?: number;
      user: components["schemas"]["nullable-simple-user"];
      body: string;
      created_at: string;
      updated_at: string;
      html_url: string;
      pull_request_url: string;
      author_association: components["schemas"]["author_association"];
      _links: {
        self: components["schemas"]["link"];
        html: components["schemas"]["link"];
        pull_request: components["schemas"]["link"];
      };
      body_text?: string;
      body_html?: string;
      reactions?: components["schemas"]["reaction-rollup"];
      /** The side of the first line of the range for a multi-line comment. */
      side?: "LEFT" | "RIGHT";
      /** The side of the first line of the range for a multi-line comment. */
      start_side?: ("LEFT" | "RIGHT") | null;
      /** The line of the blob to which the comment applies. The last line of the range for a multi-line comment */
      line?: number;
      /** The original line of the blob to which the comment applies. The last line of the range for a multi-line comment */
      original_line?: number;
      /** The first line of the range for a multi-line comment. */
      start_line?: number | null;
      /** The original first line of the range for a multi-line comment. */
      original_start_line?: number | null;
    };
    /** Data related to a release. */
    "release-asset": {
      url: string;
      browser_download_url: string;
      id: number;
      node_id: string;
      /** The file name of the asset. */
      name: string;
      label: string | null;
      /** State of the release asset. */
      state: "uploaded" | "open";
      content_type: string;
      size: number;
      download_count: number;
      created_at: string;
      updated_at: string;
      uploader: components["schemas"]["nullable-simple-user"];
    };
    /** A release. */
    release: {
      url: string;
      html_url: string;
      assets_url: string;
      upload_url: string;
      tarball_url: string | null;
      zipball_url: string | null;
      id: number;
      node_id: string;
      /** The name of the tag. */
      tag_name: string;
      /** Specifies the commitish value that determines where the Git tag is created from. */
      target_commitish: string;
      name: string | null;
      body?: string | null;
      /** true to create a draft (unpublished) release, false to create a published one. */
      draft: boolean;
      /** Whether to identify the release as a prerelease or a full release. */
      prerelease: boolean;
      created_at: string;
      published_at: string | null;
      author: components["schemas"]["simple-user"];
      assets: components["schemas"]["release-asset"][];
      body_html?: string;
      body_text?: string;
      mentions_count?: number;
      /** The URL of the release discussion. */
      discussion_url?: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /** Generated name and body describing a release */
    "release-notes-content": {
      /** The generated name of the release */
      name: string;
      /** The generated body describing the contents of the release supporting markdown formatting */
      body: string;
    };
    "secret-scanning-alert": {
      number?: components["schemas"]["alert-number"];
      created_at?: components["schemas"]["alert-created-at"];
      updated_at?: components["schemas"]["alert-updated-at"];
      url?: components["schemas"]["alert-url"];
      html_url?: components["schemas"]["alert-html-url"];
      /** The REST API URL of the code locations for this alert. */
      locations_url?: string;
      state?: components["schemas"]["secret-scanning-alert-state"];
      resolution?: components["schemas"]["secret-scanning-alert-resolution"];
      /** The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
      resolved_at?: string | null;
      resolved_by?: components["schemas"]["nullable-simple-user"];
      /** The type of secret that secret scanning detected. */
      secret_type?: string;
      /**
       * User-friendly name for the detected secret, matching the `secret_type`.
       * For a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."
       */
      secret_type_display_name?: string;
      /** The secret that was detected. */
      secret?: string;
      /** Whether push protection was bypassed for the detected secret. */
      push_protection_bypassed?: boolean | null;
      push_protection_bypassed_by?: components["schemas"]["nullable-simple-user"];
      /** The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. */
      push_protection_bypassed_at?: string | null;
    };
    /** Represents a 'commit' secret scanning location type. This location type shows that a secret was detected inside a commit to a repository. */
    "secret-scanning-location-commit": {
      /** The file path in the repository */
      path: string;
      /** Line number at which the secret starts in the file */
      start_line: number;
      /** Line number at which the secret ends in the file */
      end_line: number;
      /** The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII */
      start_column: number;
      /** The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII */
      end_column: number;
      /** SHA-1 hash ID of the associated blob */
      blob_sha: string;
      /** The API URL to get the associated blob resource */
      blob_url: string;
      /** SHA-1 hash ID of the associated commit */
      commit_sha: string;
      /** The API URL to get the associated commit resource */
      commit_url: string;
    };
    "secret-scanning-location": {
      /** The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found. */
      type: "commit";
      details: components["schemas"]["secret-scanning-location-commit"];
    };
    /** Stargazer */
    stargazer: {
      starred_at: string;
      user: components["schemas"]["nullable-simple-user"];
    };
    /** Code Frequency Stat */
    "code-frequency-stat": number[];
    /** Commit Activity */
    "commit-activity": {
      days: number[];
      total: number;
      week: number;
    };
    /** Contributor Activity */
    "contributor-activity": {
      author: components["schemas"]["nullable-simple-user"];
      total: number;
      weeks: {
        w?: number;
        a?: number;
        d?: number;
        c?: number;
      }[];
    };
    "participation-stats": {
      all: number[];
      owner: number[];
    };
    /** Repository invitations let you manage who you collaborate with. */
    "repository-subscription": {
      /** Determines if notifications should be received from this repository. */
      subscribed: boolean;
      /** Determines if all notifications should be blocked from this repository. */
      ignored: boolean;
      reason: string | null;
      created_at: string;
      url: string;
      repository_url: string;
    };
    /** Tag */
    tag: {
      name: string;
      commit: {
        sha: string;
        url: string;
      };
      zipball_url: string;
      tarball_url: string;
      node_id: string;
    };
    /** Tag protection */
    "tag-protection": {
      id?: number;
      created_at?: string;
      updated_at?: string;
      enabled?: boolean;
      pattern: string;
    };
    /** A topic aggregates entities that are related to a subject. */
    topic: {
      names: string[];
    };
    traffic: {
      timestamp: string;
      uniques: number;
      count: number;
    };
    /** Clone Traffic */
    "clone-traffic": {
      count: number;
      uniques: number;
      clones: components["schemas"]["traffic"][];
    };
    /** Content Traffic */
    "content-traffic": {
      path: string;
      title: string;
      count: number;
      uniques: number;
    };
    /** Referrer Traffic */
    "referrer-traffic": {
      referrer: string;
      count: number;
      uniques: number;
    };
    /** View Traffic */
    "view-traffic": {
      count: number;
      uniques: number;
      views: components["schemas"]["traffic"][];
    };
    "scim-group-list-enterprise": {
      schemas: string[];
      totalResults: number;
      itemsPerPage: number;
      startIndex: number;
      Resources: {
        schemas: string[];
        id: string;
        externalId?: string | null;
        displayName?: string;
        members?: {
          value?: string;
          $ref?: string;
          display?: string;
        }[];
        meta?: {
          resourceType?: string;
          created?: string;
          lastModified?: string;
          location?: string;
        };
      }[];
    };
    "scim-enterprise-group": {
      schemas: string[];
      id: string;
      externalId?: string | null;
      displayName?: string;
      members?: {
        value?: string;
        $ref?: string;
        display?: string;
      }[];
      meta?: {
        resourceType?: string;
        created?: string;
        lastModified?: string;
        location?: string;
      };
    };
    "scim-user-list-enterprise": {
      schemas: string[];
      totalResults: number;
      itemsPerPage: number;
      startIndex: number;
      Resources: {
        schemas: string[];
        id: string;
        externalId?: string;
        userName?: string;
        name?: {
          givenName?: string;
          familyName?: string;
        };
        emails?: {
          value?: string;
          primary?: boolean;
          type?: string;
        }[];
        groups?: {
          value?: string;
        }[];
        active?: boolean;
        meta?: {
          resourceType?: string;
          created?: string;
          lastModified?: string;
          location?: string;
        };
      }[];
    };
    "scim-enterprise-user": {
      schemas: string[];
      id: string;
      externalId?: string;
      userName?: string;
      name?: {
        givenName?: string;
        familyName?: string;
      };
      emails?: {
        value?: string;
        type?: string;
        primary?: boolean;
      }[];
      groups?: {
        value?: string;
      }[];
      active?: boolean;
      meta?: {
        resourceType?: string;
        created?: string;
        lastModified?: string;
        location?: string;
      };
    };
    /** SCIM /Users provisioning endpoints */
    "scim-user": {
      /** SCIM schema used. */
      schemas: string[];
      /** Unique identifier of an external identity */
      id: string;
      /** The ID of the User. */
      externalId: string | null;
      /** Configured by the admin. Could be an email, login, or username */
      userName: string | null;
      /** The name of the user, suitable for display to end-users */
      displayName?: string | null;
      name: {
        givenName: string | null;
        familyName: string | null;
        formatted?: string | null;
      };
      /** user emails */
      emails: {
        value: string;
        primary?: boolean;
      }[];
      /** The active status of the User. */
      active: boolean;
      meta: {
        resourceType?: string;
        created?: string;
        lastModified?: string;
        location?: string;
      };
      /** The ID of the organization. */
      organization_id?: number;
      /** Set of operations to be performed */
      operations?: {
        op: "add" | "remove" | "replace";
        path?: string;
        value?: string | { [key: string]: unknown } | unknown[];
      }[];
      /** associated groups */
      groups?: {
        value?: string;
        display?: string;
      }[];
    };
    /** SCIM User List */
    "scim-user-list": {
      /** SCIM schema used. */
      schemas: string[];
      totalResults: number;
      itemsPerPage: number;
      startIndex: number;
      Resources: components["schemas"]["scim-user"][];
    };
    "search-result-text-matches": {
      object_url?: string;
      object_type?: string | null;
      property?: string;
      fragment?: string;
      matches?: {
        text?: string;
        indices?: number[];
      }[];
    }[];
    /** Code Search Result Item */
    "code-search-result-item": {
      name: string;
      path: string;
      sha: string;
      url: string;
      git_url: string;
      html_url: string;
      repository: components["schemas"]["minimal-repository"];
      score: number;
      file_size?: number;
      language?: string | null;
      last_modified_at?: string;
      line_numbers?: string[];
      text_matches?: components["schemas"]["search-result-text-matches"];
    };
    /** Commit Search Result Item */
    "commit-search-result-item": {
      url: string;
      sha: string;
      html_url: string;
      comments_url: string;
      commit: {
        author: {
          name: string;
          email: string;
          date: string;
        };
        committer: components["schemas"]["nullable-git-user"];
        comment_count: number;
        message: string;
        tree: {
          sha: string;
          url: string;
        };
        url: string;
        verification?: components["schemas"]["verification"];
      };
      author: components["schemas"]["nullable-simple-user"];
      committer: components["schemas"]["nullable-git-user"];
      parents: {
        url?: string;
        html_url?: string;
        sha?: string;
      }[];
      repository: components["schemas"]["minimal-repository"];
      score: number;
      node_id: string;
      text_matches?: components["schemas"]["search-result-text-matches"];
    };
    /** Issue Search Result Item */
    "issue-search-result-item": {
      url: string;
      repository_url: string;
      labels_url: string;
      comments_url: string;
      events_url: string;
      html_url: string;
      id: number;
      node_id: string;
      number: number;
      title: string;
      locked: boolean;
      active_lock_reason?: string | null;
      assignees?: components["schemas"]["simple-user"][] | null;
      user: components["schemas"]["nullable-simple-user"];
      labels: {
        id?: number;
        node_id?: string;
        url?: string;
        name?: string;
        color?: string;
        default?: boolean;
        description?: string | null;
      }[];
      state: string;
      state_reason?: string | null;
      assignee: components["schemas"]["nullable-simple-user"];
      milestone: components["schemas"]["nullable-milestone"];
      comments: number;
      created_at: string;
      updated_at: string;
      closed_at: string | null;
      text_matches?: components["schemas"]["search-result-text-matches"];
      pull_request?: {
        merged_at?: string | null;
        diff_url: string | null;
        html_url: string | null;
        patch_url: string | null;
        url: string | null;
      };
      body?: string;
      score: number;
      author_association: components["schemas"]["author_association"];
      draft?: boolean;
      repository?: components["schemas"]["repository"];
      body_html?: string;
      body_text?: string;
      timeline_url?: string;
      performed_via_github_app?: components["schemas"]["nullable-integration"];
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /** Label Search Result Item */
    "label-search-result-item": {
      id: number;
      node_id: string;
      url: string;
      name: string;
      color: string;
      default: boolean;
      description: string | null;
      score: number;
      text_matches?: components["schemas"]["search-result-text-matches"];
    };
    /** Repo Search Result Item */
    "repo-search-result-item": {
      id: number;
      node_id: string;
      name: string;
      full_name: string;
      owner: components["schemas"]["nullable-simple-user"];
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      created_at: string;
      updated_at: string;
      pushed_at: string;
      homepage: string | null;
      size: number;
      stargazers_count: number;
      watchers_count: number;
      language: string | null;
      forks_count: number;
      open_issues_count: number;
      master_branch?: string;
      default_branch: string;
      score: number;
      forks_url: string;
      keys_url: string;
      collaborators_url: string;
      teams_url: string;
      hooks_url: string;
      issue_events_url: string;
      events_url: string;
      assignees_url: string;
      branches_url: string;
      tags_url: string;
      blobs_url: string;
      git_tags_url: string;
      git_refs_url: string;
      trees_url: string;
      statuses_url: string;
      languages_url: string;
      stargazers_url: string;
      contributors_url: string;
      subscribers_url: string;
      subscription_url: string;
      commits_url: string;
      git_commits_url: string;
      comments_url: string;
      issue_comment_url: string;
      contents_url: string;
      compare_url: string;
      merges_url: string;
      archive_url: string;
      downloads_url: string;
      issues_url: string;
      pulls_url: string;
      milestones_url: string;
      notifications_url: string;
      labels_url: string;
      releases_url: string;
      deployments_url: string;
      git_url: string;
      ssh_url: string;
      clone_url: string;
      svn_url: string;
      forks: number;
      open_issues: number;
      watchers: number;
      topics?: string[];
      mirror_url: string | null;
      has_issues: boolean;
      has_projects: boolean;
      has_pages: boolean;
      has_wiki: boolean;
      has_downloads: boolean;
      archived: boolean;
      /** Returns whether or not this repository disabled. */
      disabled: boolean;
      /** The repository visibility: public, private, or internal. */
      visibility?: string;
      license: components["schemas"]["nullable-license-simple"];
      permissions?: {
        admin: boolean;
        maintain?: boolean;
        push: boolean;
        triage?: boolean;
        pull: boolean;
      };
      text_matches?: components["schemas"]["search-result-text-matches"];
      temp_clone_token?: string;
      allow_merge_commit?: boolean;
      allow_squash_merge?: boolean;
      allow_rebase_merge?: boolean;
      allow_auto_merge?: boolean;
      delete_branch_on_merge?: boolean;
      allow_forking?: boolean;
      is_template?: boolean;
    };
    /** Topic Search Result Item */
    "topic-search-result-item": {
      name: string;
      display_name: string | null;
      short_description: string | null;
      description: string | null;
      created_by: string | null;
      released: string | null;
      created_at: string;
      updated_at: string;
      featured: boolean;
      curated: boolean;
      score: number;
      repository_count?: number | null;
      logo_url?: string | null;
      text_matches?: components["schemas"]["search-result-text-matches"];
      related?:
        | {
            topic_relation?: {
              id?: number;
              name?: string;
              topic_id?: number;
              relation_type?: string;
            };
          }[]
        | null;
      aliases?:
        | {
            topic_relation?: {
              id?: number;
              name?: string;
              topic_id?: number;
              relation_type?: string;
            };
          }[]
        | null;
    };
    /** User Search Result Item */
    "user-search-result-item": {
      login: string;
      id: number;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      received_events_url: string;
      type: string;
      score: number;
      following_url: string;
      gists_url: string;
      starred_url: string;
      events_url: string;
      public_repos?: number;
      public_gists?: number;
      followers?: number;
      following?: number;
      created_at?: string;
      updated_at?: string;
      name?: string | null;
      bio?: string | null;
      email?: string | null;
      location?: string | null;
      site_admin: boolean;
      hireable?: boolean | null;
      text_matches?: components["schemas"]["search-result-text-matches"];
      blog?: string | null;
      company?: string | null;
      suspended_at?: string | null;
    };
    /** Private User */
    "private-user": {
      login: string;
      id: number;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      events_url: string;
      received_events_url: string;
      type: string;
      site_admin: boolean;
      name: string | null;
      company: string | null;
      blog: string | null;
      location: string | null;
      email: string | null;
      hireable: boolean | null;
      bio: string | null;
      twitter_username?: string | null;
      public_repos: number;
      public_gists: number;
      followers: number;
      following: number;
      created_at: string;
      updated_at: string;
      private_gists: number;
      total_private_repos: number;
      owned_private_repos: number;
      disk_usage: number;
      collaborators: number;
      two_factor_authentication: boolean;
      plan?: {
        collaborators: number;
        name: string;
        space: number;
        private_repos: number;
      };
      suspended_at?: string | null;
      business_plus?: boolean;
      ldap_dn?: string;
    };
    /** Secrets for a GitHub Codespace. */
    "codespaces-secret": {
      /** The name of the secret. */
      name: string;
      created_at: string;
      updated_at: string;
      /** Visibility of a secret */
      visibility: "all" | "private" | "selected";
      selected_repositories_url: string;
    };
    /** The public key used for setting user Codespaces' Secrets. */
    "codespaces-user-public-key": {
      /** The identifier for the key. */
      key_id: string;
      /** The Base64 encoded public key. */
      key: string;
    };
    /** An export of a codespace. Also, latest export details for a codespace can be fetched with id = latest */
    "codespace-export-details": {
      /** State of the latest export */
      state?: string | null;
      /** Completion time of the last export operation */
      completed_at?: string | null;
      /** Name of the exported branch */
      branch?: string | null;
      /** Git commit SHA of the exported branch */
      sha?: string | null;
      /** Id for the export details */
      id?: string;
      /** Url for fetching export details */
      export_url?: string;
      /** Web url for the exported branch */
      html_url?: string | null;
    };
    /** Email */
    email: {
      email: string;
      primary: boolean;
      verified: boolean;
      visibility: string | null;
    };
    /** A unique encryption key */
    "gpg-key": {
      id: number;
      name?: string | null;
      primary_key_id: number | null;
      key_id: string;
      public_key: string;
      emails: {
        email?: string;
        verified?: boolean;
      }[];
      subkeys: {
        id?: number;
        primary_key_id?: number;
        key_id?: string;
        public_key?: string;
        emails?: unknown[];
        subkeys?: unknown[];
        can_sign?: boolean;
        can_encrypt_comms?: boolean;
        can_encrypt_storage?: boolean;
        can_certify?: boolean;
        created_at?: string;
        expires_at?: string | null;
        raw_key?: string | null;
        revoked?: boolean;
      }[];
      can_sign: boolean;
      can_encrypt_comms: boolean;
      can_encrypt_storage: boolean;
      can_certify: boolean;
      created_at: string;
      expires_at: string | null;
      revoked: boolean;
      raw_key: string | null;
    };
    /** Key */
    key: {
      key: string;
      id: number;
      url: string;
      title: string;
      created_at: string;
      verified: boolean;
      read_only: boolean;
    };
    "marketplace-account": {
      url: string;
      id: number;
      type: string;
      node_id?: string;
      login: string;
      email?: string | null;
      organization_billing_email?: string | null;
    };
    /** User Marketplace Purchase */
    "user-marketplace-purchase": {
      billing_cycle: string;
      next_billing_date: string | null;
      unit_count: number | null;
      on_free_trial: boolean;
      free_trial_ends_on: string | null;
      updated_at: string | null;
      account: components["schemas"]["marketplace-account"];
      plan: components["schemas"]["marketplace-listing-plan"];
    };
    /** Starred Repository */
    "starred-repository": {
      starred_at: string;
      repo: components["schemas"]["repository"];
    };
    /** Hovercard */
    hovercard: {
      contexts: {
        message: string;
        octicon: string;
      }[];
    };
    /** Key Simple */
    "key-simple": {
      id: number;
      key: string;
    };
  };
  responses: {
    /** Resource not found */
    not_found: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Validation failed */
    validation_failed_simple: {
      content: {
        "application/json": components["schemas"]["validation-error-simple"];
      };
    };
    /** Bad Request */
    bad_request: {
      content: {
        "application/json": components["schemas"]["basic-error"];
        "application/scim+json": components["schemas"]["scim-error"];
      };
    };
    /** Validation failed */
    validation_failed: {
      content: {
        "application/json": components["schemas"]["validation-error"];
      };
    };
    /** Accepted */
    accepted: {
      content: {
        "application/json": { [key: string]: unknown };
      };
    };
    /** Forbidden */
    forbidden: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Requires authentication */
    requires_authentication: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Not modified */
    not_modified: unknown;
    /** Gone */
    gone: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Response */
    actions_runner_labels: {
      content: {
        "application/json": {
          total_count: number;
          labels: components["schemas"]["runner-label"][];
        };
      };
    };
    /** Response */
    actions_runner_labels_readonly: {
      content: {
        "application/json": {
          total_count: number;
          labels: components["schemas"]["runner-label"][];
        };
      };
    };
    /** Service unavailable */
    service_unavailable: {
      content: {
        "application/json": {
          code?: string;
          message?: string;
          documentation_url?: string;
        };
      };
    };
    /** Response if GitHub Advanced Security is not enabled for this repository */
    code_scanning_forbidden_read: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Forbidden Gist */
    forbidden_gist: {
      content: {
        "application/json": {
          block?: {
            reason?: string;
            created_at?: string;
            html_url?: string | null;
          };
          message?: string;
          documentation_url?: string;
        };
      };
    };
    /** Moved permanently */
    moved_permanently: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Internal Error */
    internal_error: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Conflict */
    conflict: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Temporary Redirect */
    temporary_redirect: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Response if the repository is archived or if github advanced security is not enabled for this repository */
    code_scanning_forbidden_write: {
      content: {
        "application/json": components["schemas"]["basic-error"];
      };
    };
    /** Found */
    found: unknown;
    /** A header with no content is returned. */
    no_content: unknown;
    /** Resource not found */
    scim_not_found: {
      content: {
        "application/json": components["schemas"]["scim-error"];
        "application/scim+json": components["schemas"]["scim-error"];
      };
    };
    /** Forbidden */
    scim_forbidden: {
      content: {
        "application/json": components["schemas"]["scim-error"];
        "application/scim+json": components["schemas"]["scim-error"];
      };
    };
    /** Bad Request */
    scim_bad_request: {
      content: {
        "application/json": components["schemas"]["scim-error"];
        "application/scim+json": components["schemas"]["scim-error"];
      };
    };
    /** Too Many Requests */
    scim_too_many_requests: {
      content: {
        "application/json": components["schemas"]["scim-error"];
        "application/scim+json": components["schemas"]["scim-error"];
      };
    };
    /** Internal Error */
    scim_internal_error: {
      content: {
        "application/json": components["schemas"]["scim-error"];
        "application/scim+json": components["schemas"]["scim-error"];
      };
    };
    /** Conflict */
    scim_conflict: {
      content: {
        "application/json": components["schemas"]["scim-error"];
        "application/scim+json": components["schemas"]["scim-error"];
      };
    };
  };
  parameters: {
    /** The number of results per page (max 100). */
    "per-page": number;
    /** Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors. */
    cursor: string;
    "delivery-id": number;
    /** Page number of the results to fetch. */
    page: number;
    /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
    since: string;
    /** The unique identifier of the installation. */
    "installation-id": number;
    /** The unique identifier of the grant. */
    "grant-id": number;
    /** The client ID of the GitHub app. */
    "client-id": string;
    "app-slug": string;
    /** The unique identifier of the authorization. */
    "authorization-id": number;
    /** The slug version of the enterprise name or the login of an organization. */
    enterprise_or_org: string;
    /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
    enterprise: string;
    /** The unique identifier of the organization. */
    "org-id": number;
    /** Only return runner groups that are allowed to be used by this organization. */
    "visible-to-organization": string;
    /** Unique identifier of the self-hosted runner group. */
    "runner-group-id": number;
    /** Unique identifier of the self-hosted runner. */
    "runner-id": number;
    /** The name of a self-hosted runner's custom label. */
    "runner-label-name": string;
    /** A search phrase. For more information, see [Searching the audit log](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log). */
    "audit-log-phrase": string;
    /**
     * The event types to include:
     *
     * - `web` - returns web (non-Git) events.
     * - `git` - returns Git events.
     * - `all` - returns both web and Git events.
     *
     * The default is `web`.
     */
    "audit-log-include": "web" | "git" | "all";
    /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor. */
    "audit-log-after": string;
    /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. */
    "audit-log-before": string;
    /**
     * The order of audit log events. To list newest events first, specify `desc`. To list oldest events first, specify `asc`.
     *
     * The default is `desc`.
     */
    "audit-log-order": "desc" | "asc";
    /** Set to `open` or `resolved` to only list secret scanning alerts in a specific state. */
    "secret-scanning-alert-state": "open" | "resolved";
    /**
     * A comma-separated list of secret types to return. By default all secret types are returned.
     * See "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)"
     * for a complete list of secret types.
     */
    "secret-scanning-alert-secret-type": string;
    /** A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`. */
    "secret-scanning-alert-resolution": string;
    /** The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved. */
    "secret-scanning-alert-sort": "created" | "updated";
    /** The direction to sort the results by. */
    direction: "asc" | "desc";
    /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. */
    "pagination-before": string;
    /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor. */
    "pagination-after": string;
    /** The unique identifier of the gist. */
    "gist-id": string;
    /** The unique identifier of the comment. */
    "comment-id": number;
    /** A list of comma separated label names. Example: `bug,ui,@high` */
    labels: string;
    /** account_id parameter */
    "account-id": number;
    /** The unique identifier of the plan. */
    "plan-id": number;
    /** The property to sort the results by. `created` means when the repository was starred. `updated` means when the repository was last pushed to. */
    sort: "created" | "updated";
    /** The account owner of the repository. The name is not case sensitive. */
    owner: string;
    /** The name of the repository. The name is not case sensitive. */
    repo: string;
    /** If `true`, show notifications marked as read. */
    all: boolean;
    /** If `true`, only shows notifications in which the user is directly participating or mentioned. */
    participating: boolean;
    /** Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
    before: string;
    /** The unique identifier of the pull request thread. */
    "thread-id": number;
    /** An organization ID. Only return organizations with an ID greater than this ID. */
    "since-org": number;
    /** The organization name. The name is not case sensitive. */
    org: string;
    /** The unique identifier of the repository. */
    "repository-id": number;
    /** Only return runner groups that are allowed to be used by this repository. */
    "visible-to-repository": string;
    /** The name of the secret. */
    "secret-name": string;
    /** The handle for the GitHub user account. */
    username: string;
    /** The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both. */
    "tool-name": components["schemas"]["code-scanning-analysis-tool-name"];
    /** The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both. */
    "tool-guid": components["schemas"]["code-scanning-analysis-tool-guid"];
    /** The unique identifier of the group. */
    "group-id": number;
    /** The unique identifier of the hook. */
    "hook-id": number;
    /** The unique identifier of the invitation. */
    "invitation-id": number;
    /** The name of the codespace. */
    "codespace-name": string;
    /** The unique identifier of the migration. */
    "migration-id": number;
    /** repo_name parameter */
    "repo-name": string;
    /** The selected visibility of the packages. Only `container` package_types currently support `internal` visibility properly. For other ecosystems `internal` is synonymous with `private`. This parameter is optional and only filters an existing result set. */
    "package-visibility": "public" | "private" | "internal";
    /** The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry. */
    "package-type":
      | "npm"
      | "maven"
      | "rubygems"
      | "docker"
      | "nuget"
      | "container";
    /** The name of the package. */
    "package-name": string;
    /** Unique identifier of the package version. */
    "package-version-id": number;
    /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. To receive an initial cursor on your first request, include an empty "before" query string. */
    "secret-scanning-pagination-before-org-repo": string;
    /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor.  To receive an initial cursor on your first request, include an empty "after" query string. */
    "secret-scanning-pagination-after-org-repo": string;
    /** The slug of the team name. */
    "team-slug": string;
    /** The number that identifies the discussion. */
    "discussion-number": number;
    /** The number that identifies the comment. */
    "comment-number": number;
    /** The unique identifier of the reaction. */
    "reaction-id": number;
    /** The unique identifier of the project. */
    "project-id": number;
    /** The unique identifier of the card. */
    "card-id": number;
    /** The unique identifier of the column. */
    "column-id": number;
    /** The unique identifier of the artifact. */
    "artifact-id": number;
    /** The Git reference for the results you want to list. The `ref` for a branch can be formatted either as `refs/heads/<branch name>` or simply `<branch name>`. To reference a pull request use `refs/pull/<number>/merge`. */
    "git-ref": components["schemas"]["code-scanning-ref"];
    /** An explicit key or prefix for identifying the cache */
    "actions-cache-key": string;
    /** The property to sort the results by. `created_at` means when the cache was created. `last_accessed_at` means when the cache was last accessed. `size_in_bytes` is the size of the cache in bytes. */
    "actions-cache-list-sort":
      | "created_at"
      | "last_accessed_at"
      | "size_in_bytes";
    /** A key for identifying the cache. */
    "actions-cache-key-required": string;
    /** The unique identifier of the GitHub Actions cache. */
    "cache-id": number;
    /** The unique identifier of the job. */
    "job-id": number;
    /** Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run. */
    actor: string;
    /** Returns workflow runs associated with a branch. Use the name of the branch of the `push`. */
    "workflow-run-branch": string;
    /** Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://docs.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)." */
    event: string;
    /** Returns workflow runs with the check run `status` or `conclusion` that you specify. For example, a conclusion can be `success` or a status can be `in_progress`. Only GitHub can set a status of `waiting` or `requested`. For a list of the possible `status` and `conclusion` options, see "[Create a check run](https://docs.github.com/rest/reference/checks#create-a-check-run)." */
    "workflow-run-status":
      | "completed"
      | "action_required"
      | "cancelled"
      | "failure"
      | "neutral"
      | "skipped"
      | "stale"
      | "success"
      | "timed_out"
      | "in_progress"
      | "queued"
      | "requested"
      | "waiting";
    /** Returns workflow runs created within the given date-time range. For more information on the syntax, see "[Understanding the search syntax](https://docs.github.com/search-github/getting-started-with-searching-on-github/understanding-the-search-syntax#query-for-dates)." */
    created: string;
    /** If `true` pull requests are omitted from the response (empty array). */
    "exclude-pull-requests": boolean;
    /** Returns workflow runs with the `check_suite_id` that you specify. */
    "workflow-run-check-suite-id": number;
    /** The unique identifier of the workflow run. */
    "run-id": number;
    /** The attempt number of the workflow run. */
    "attempt-number": number;
    /** The ID of the workflow. You can also pass the workflow file name as a string. */
    "workflow-id": number | string;
    /** The unique identifier of the autolink. */
    "autolink-id": number;
    /** The name of the branch. */
    branch: string;
    /** The unique identifier of the check run. */
    "check-run-id": number;
    /** The unique identifier of the check suite. */
    "check-suite-id": number;
    /** Returns check runs with the specified `name`. */
    "check-name": string;
    /** Returns check runs with the specified `status`. */
    status: "queued" | "in_progress" | "completed";
    /** The number that identifies an alert. You can find this at the end of the URL for a code scanning alert within GitHub, and in the `number` field in the response from the `GET /repos/{owner}/{repo}/code-scanning/alerts` operation. */
    "alert-number": components["schemas"]["alert-number"];
    /** The SHA of the commit. */
    "commit-sha": string;
    /** The full path, relative to the repository root, of the dependency manifest file. */
    "manifest-path": string;
    /** deployment_id parameter */
    "deployment-id": number;
    /** The name of the environment */
    "environment-name": string;
    /** A user ID. Only return users with an ID greater than this ID. */
    "since-user": number;
    /** The number that identifies the issue. */
    "issue-number": number;
    /** The unique identifier of the key. */
    "key-id": number;
    /** The number that identifies the milestone. */
    "milestone-number": number;
    /** The number that identifies the pull request. */
    "pull-number": number;
    /** The unique identifier of the review. */
    "review-id": number;
    /** The unique identifier of the asset. */
    "asset-id": number;
    /** The unique identifier of the release. */
    "release-id": number;
    /** The unique identifier of the tag protection. */
    tag_protection_id: number;
    /** The time frame to display results for. */
    per: "" | "day" | "week";
    /** A repository ID. Only return repositories with an ID greater than this ID. */
    "since-repo": number;
    /** Used for pagination: the index of the first result to return. */
    "start-index": number;
    /** Used for pagination: the number of results to return. */
    count: number;
    /** Identifier generated by the GitHub SCIM endpoint. */
    "scim-group-id": string;
    /** The unique identifier of the SCIM user. */
    "scim-user-id": string;
    /** Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`. */
    order: "desc" | "asc";
    /** The unique identifier of the team. */
    "team-id": number;
    /** ID of the Repository to filter on */
    "repository-id-in-query": number;
    /** The ID of the export operation, or `latest`. Currently only `latest` is currently supported. */
    "export-id": string;
    /** The unique identifier of the GPG key. */
    "gpg-key-id": number;
  };
  headers: {
    link?: string;
    "content-type"?: string;
    "x-common-marker-version"?: string;
    "x-rate-limit-limit"?: number;
    "x-rate-limit-remaining"?: number;
    "x-rate-limit-reset"?: number;
    location?: string;
  };
}

export interface operations {
  /** Get Hypermedia links to resources accessible in GitHub's REST API */
  "meta/root": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["root"];
        };
      };
    };
  };
  /**
   * Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/rest/reference/apps#list-installations-for-the-authenticated-app)" endpoint.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-authenticated": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["integration"];
        };
      };
    };
  };
  /** Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`. */
  "apps/create-from-manifest": {
    parameters: {
      path: {
        code: string;
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["integration"] &
            ({
              client_id: string;
              client_secret: string;
              webhook_secret: string | null;
              pem: string;
            } & { [key: string]: unknown });
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed_simple"];
    };
  };
  /**
   * Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-webhook-config-for-app": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["webhook-config"];
        };
      };
    };
  };
  /**
   * Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/update-webhook-config-for-app": {
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["webhook-config"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          url?: components["schemas"]["webhook-config-url"];
          content_type?: components["schemas"]["webhook-config-content-type"];
          secret?: components["schemas"]["webhook-config-secret"];
          insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
        };
      };
    };
  };
  /**
   * Returns a list of webhook deliveries for the webhook configured for a GitHub App.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/list-webhook-deliveries": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors. */
        cursor?: components["parameters"]["cursor"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["hook-delivery-item"][];
        };
      };
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /**
   * Returns a delivery for the webhook configured for a GitHub App.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-webhook-delivery": {
    parameters: {
      path: {
        delivery_id: components["parameters"]["delivery-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["hook-delivery"];
        };
      };
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /**
   * Redeliver a delivery for the webhook configured for a GitHub App.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/redeliver-webhook-delivery": {
    parameters: {
      path: {
        delivery_id: components["parameters"]["delivery-id"];
      };
    };
    responses: {
      202: components["responses"]["accepted"];
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /**
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   *
   * The permissions the installation has are included under the `permissions` key.
   */
  "apps/list-installations": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        outdated?: string;
      };
    };
    responses: {
      /** The permissions the installation has are included under the `permissions` key. */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["installation"][];
        };
      };
    };
  };
  /**
   * Enables an authenticated GitHub App to find an installation's information using the installation id.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-installation": {
    parameters: {
      path: {
        /** The unique identifier of the installation. */
        installation_id: components["parameters"]["installation-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["installation"];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Uninstalls a GitHub App on a user, organization, or business account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/rest/reference/apps/#suspend-an-app-installation)" endpoint.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/delete-installation": {
    parameters: {
      path: {
        /** The unique identifier of the installation. */
        installation_id: components["parameters"]["installation-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access. To restrict the access to specific repositories, you can provide the `repository_ids` when creating the token. When you omit `repository_ids`, the response does not contain the `repositories` key.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/create-installation-access-token": {
    parameters: {
      path: {
        /** The unique identifier of the installation. */
        installation_id: components["parameters"]["installation-id"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["installation-token"];
        };
      };
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** List of repository names that the token should have access to */
          repositories?: string[];
          /** List of repository IDs that the token should have access to */
          repository_ids?: number[];
          permissions?: components["schemas"]["app-permissions"];
        };
      };
    };
  };
  /**
   * Suspends a GitHub App on a user, organization, or business account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub API or webhook events is blocked for that account.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/suspend-installation": {
    parameters: {
      path: {
        /** The unique identifier of the installation. */
        installation_id: components["parameters"]["installation-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Removes a GitHub App installation suspension.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/unsuspend-installation": {
    parameters: {
      path: {
        /** The unique identifier of the installation. */
        installation_id: components["parameters"]["installation-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * You can use this API to list the set of OAuth applications that have been granted access to your account. Unlike the [list your authorizations](https://docs.github.com/rest/reference/oauth-authorizations#list-your-authorizations) API, this API does not manage individual tokens. This API will return one entry for each OAuth application that has been granted access to your account, regardless of the number of tokens an application has generated for your user. The list of OAuth applications returned matches what is shown on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized). The `scopes` returned are the union of scopes authorized for the application. For example, if an application has one token with `repo` scope and another token with `user` scope, the grant will return `["repo", "user"]`.
   */
  "oauth-authorizations/list-grants": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The client ID of your GitHub app. */
        client_id?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["application-grant"][];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
  "oauth-authorizations/get-grant": {
    parameters: {
      path: {
        /** The unique identifier of the grant. */
        grant_id: components["parameters"]["grant-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["application-grant"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for your user. Once deleted, the application has no access to your account and is no longer listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
   */
  "oauth-authorizations/delete-grant": {
    parameters: {
      path: {
        /** The unique identifier of the grant. */
        grant_id: components["parameters"]["grant-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
   * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
   */
  "apps/delete-authorization": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The OAuth access token used to authenticate to the GitHub API. */
          access_token: string;
        };
      };
    };
  };
  /** OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) to use this endpoint, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`. */
  "apps/check-token": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The access_token of the OAuth application. */
          access_token: string;
        };
      };
    };
  };
  /** OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. */
  "apps/delete-token": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The OAuth access token used to authenticate to the GitHub API. */
          access_token: string;
        };
      };
    };
  };
  /** OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`. */
  "apps/reset-token": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The access_token of the OAuth application. */
          access_token: string;
        };
      };
    };
  };
  /** Use a non-scoped user-to-server OAuth access token to create a repository scoped and/or permission scoped user-to-server OAuth access token. You can specify which repositories the token can access and which permissions are granted to the token. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`. */
  "apps/scope-token": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The OAuth access token used to authenticate to the GitHub API. */
          access_token: string;
          /** The name of the user or organization to scope the user-to-server access token to. **Required** unless `target_id` is specified. */
          target?: string;
          /** The ID of the user or organization to scope the user-to-server access token to. **Required** unless `target` is specified. */
          target_id?: number;
          /** The list of repository names to scope the user-to-server access token to. `repositories` may not be specified if `repository_ids` is specified. */
          repositories?: string[];
          /** The list of repository IDs to scope the user-to-server access token to. `repository_ids` may not be specified if `repositories` is specified. */
          repository_ids?: number[];
          permissions?: components["schemas"]["app-permissions"];
        };
      };
    };
  };
  /**
   * **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
   *
   * If the GitHub App you specify is public, you can access this endpoint without authenticating. If the GitHub App you specify is private, you must authenticate with a [personal access token](https://docs.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
   */
  "apps/get-by-slug": {
    parameters: {
      path: {
        app_slug: components["parameters"]["app-slug"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["integration"];
        };
      };
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
  "oauth-authorizations/list-authorizations": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The client ID of your GitHub app. */
        client_id?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["authorization"][];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
   *
   * Creates OAuth tokens using [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication). If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   *
   * To create tokens for a particular OAuth application using this endpoint, you must authenticate as the user you want to create an authorization for and provide the app's client ID and secret, found on your OAuth application's settings page. If your OAuth application intends to create multiple tokens for one user, use `fingerprint` to differentiate between them.
   *
   * You can also create tokens on GitHub from the [personal access tokens settings](https://github.com/settings/tokens) page. Read more about these tokens in [the GitHub Help documentation](https://docs.github.com/articles/creating-an-access-token-for-command-line-use).
   *
   * Organizations that enforce SAML SSO require personal access tokens to be allowed. Read more about allowing tokens in [the GitHub Help documentation](https://docs.github.com/articles/about-identity-and-access-management-with-saml-single-sign-on).
   */
  "oauth-authorizations/create-authorization": {
    parameters: {};
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      410: components["responses"]["gone"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** A list of scopes that this authorization is in. */
          scopes?: string[] | null;
          /** A note to remind you what the OAuth token is for. */
          note?: string;
          /** A URL to remind you what app the OAuth token is for. */
          note_url?: string;
          /** The OAuth app client key for which to create the token. */
          client_id?: string;
          /** The OAuth app client secret for which to create the token. */
          client_secret?: string;
          /** A unique string to distinguish an authorization from others created for the same client ID and user. */
          fingerprint?: string;
        };
      };
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
   *
   * Creates a new authorization for the specified OAuth application, only if an authorization for that application doesn't already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
   *
   * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   *
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   */
  "oauth-authorizations/get-or-create-authorization-for-app": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
      };
    };
    responses: {
      /** if returning an existing token */
      200: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      /** **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The OAuth app client secret for which to create the token. */
          client_secret: string;
          /** A list of scopes that this authorization is in. */
          scopes?: string[] | null;
          /** A note to remind you what the OAuth token is for. */
          note?: string;
          /** A URL to remind you what app the OAuth token is for. */
          note_url?: string;
          /** A unique string to distinguish an authorization from others created for the same client ID and user. */
          fingerprint?: string;
        };
      };
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
   *
   * This method will create a new authorization for the specified OAuth application, only if an authorization for that application and fingerprint do not already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. `fingerprint` is a unique string to distinguish an authorization from others created for the same client ID and user. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
   *
   * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   */
  "oauth-authorizations/get-or-create-authorization-for-app-and-fingerprint": {
    parameters: {
      path: {
        /** The client ID of the GitHub app. */
        client_id: components["parameters"]["client-id"];
        fingerprint: string;
      };
    };
    responses: {
      /** if returning an existing token */
      200: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      /** Response if returning a new token */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The OAuth app client secret for which to create the token. */
          client_secret: string;
          /** A list of scopes that this authorization is in. */
          scopes?: string[] | null;
          /** A note to remind you what the OAuth token is for. */
          note?: string;
          /** A URL to remind you what app the OAuth token is for. */
          note_url?: string;
        };
      };
    };
  };
  /** **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
  "oauth-authorizations/get-authorization": {
    parameters: {
      path: {
        /** The unique identifier of the authorization. */
        authorization_id: components["parameters"]["authorization-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /** **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/). */
  "oauth-authorizations/delete-authorization": {
    parameters: {
      path: {
        /** The unique identifier of the authorization. */
        authorization_id: components["parameters"]["authorization-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   *
   * You can only send one of these scope keys at a time.
   */
  "oauth-authorizations/update-authorization": {
    parameters: {
      path: {
        /** The unique identifier of the authorization. */
        authorization_id: components["parameters"]["authorization-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["authorization"];
        };
      };
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** A list of scopes that this authorization is in. */
          scopes?: string[] | null;
          /** A list of scopes to add to this authorization. */
          add_scopes?: string[];
          /** A list of scopes to remove from this authorization. */
          remove_scopes?: string[];
          /** A note to remind you what the OAuth token is for. */
          note?: string;
          /** A URL to remind you what app the OAuth token is for. */
          note_url?: string;
          /** A unique string to distinguish an authorization from others created for the same client ID and user. */
          fingerprint?: string;
        };
      };
    };
  };
  "codes-of-conduct/get-all-codes-of-conduct": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["code-of-conduct"][];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  "codes-of-conduct/get-conduct-code": {
    parameters: {
      path: {
        key: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["code-of-conduct"];
        };
      };
      304: components["responses"]["not_modified"];
      404: components["responses"]["not_found"];
    };
  };
  /** Lists all the emojis available to use on GitHub. */
  "emojis/get": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": { [key: string]: string };
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  /**
   * Returns aggregate usage metrics for your GitHub Enterprise Server 3.5+ instance for a specified time period up to 365 days.
   *
   * To use this endpoint, your GitHub Enterprise Server instance must be connected to GitHub Enterprise Cloud using GitHub Connect. You must enable Server Statistics, and for the API request provide your enterprise account name or organization name connected to the GitHub Enterprise Server. For more information, see "[Enabling Server Statistics for your enterprise](/admin/configuration/configuring-github-connect/enabling-server-statistics-for-your-enterprise)" in the GitHub Enterprise Server documentation.
   *
   * You'll need to use a personal access token:
   *   - If you connected your GitHub Enterprise Server to an enterprise account and enabled Server Statistics, you'll need a personal access token with the `read:enterprise` permission.
   *   - If you connected your GitHub Enterprise Server to an organization account and enabled Server Statistics, you'll need a personal access token with the `read:org` permission.
   *
   * For more information on creating a personal access token, see "[Creating a personal access token](/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token)."
   */
  "enterprise-admin/get-server-statistics": {
    parameters: {
      path: {
        /** The slug version of the enterprise name or the login of an organization. */
        enterprise_or_org: components["parameters"]["enterprise_or_org"];
      };
      query: {
        /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor. */
        date_start?: string;
        /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. */
        date_end?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["server-statistics"];
        };
      };
    };
  };
  /**
   * Gets the total GitHub Actions cache usage for an enterprise.
   * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "actions/get-actions-cache-usage-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["actions-cache-usage-org-enterprise"];
        };
      };
    };
  };
  /**
   * Sets the GitHub Actions OpenID Connect (OIDC) custom issuer policy for an enterprise.
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   * GitHub Apps must have the `enterprise_administration:write` permission to use this endpoint.
   */
  "actions/set-actions-oidc-custom-issuer-policy-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["actions-oidc-custom-issuer-policy-for-enterprise"];
      };
    };
  };
  /**
   * Gets the GitHub Actions permissions policy for organizations and allowed actions and reusable workflows in an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-github-actions-permissions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["actions-enterprise-permissions"];
        };
      };
    };
  };
  /**
   * Sets the GitHub Actions permissions policy for organizations and allowed actions and reusable workflows in an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-github-actions-permissions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          enabled_organizations: components["schemas"]["enabled-organizations"];
          allowed_actions?: components["schemas"]["allowed-actions"];
        };
      };
    };
  };
  /**
   * Lists the organizations that are selected to have GitHub Actions enabled in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-selected-organizations-enabled-github-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            organizations: components["schemas"]["organization-simple"][];
          };
        };
      };
    };
  };
  /**
   * Replaces the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-selected-organizations-enabled-github-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** List of organization IDs to enable for GitHub Actions. */
          selected_organization_ids: number[];
        };
      };
    };
  };
  /**
   * Adds an organization to the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/enable-selected-organization-github-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** The unique identifier of the organization. */
        org_id: components["parameters"]["org-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Removes an organization from the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/disable-selected-organization-github-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** The unique identifier of the organization. */
        org_id: components["parameters"]["org-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Gets the selected actions and reusable workflows that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-allowed-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["selected-actions"];
        };
      };
    };
  };
  /**
   * Sets the actions and reusable workflows that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-allowed-actions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["selected-actions"];
      };
    };
  };
  /**
   * Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an enterprise,
   * as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
   * "[Enforcing a policy for workflow permissions in your enterprise](https://docs.github.com/enterprise-cloud@latest/admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise#enforcing-a-policy-for-workflow-permissions-in-your-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   * GitHub Apps must have the `enterprise_administration:write` permission to use this endpoint.
   */
  "actions/get-github-actions-default-workflow-permissions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Success response */
      200: {
        content: {
          "application/json": components["schemas"]["actions-get-default-workflow-permissions"];
        };
      };
    };
  };
  /**
   * Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an enterprise, and sets
   * whether GitHub Actions can submit approving pull request reviews. For more information, see
   * "[Enforcing a policy for workflow permissions in your enterprise](https://docs.github.com/enterprise-cloud@latest/admin/policies/enforcing-policies-for-your-enterprise/enforcing-policies-for-github-actions-in-your-enterprise#enforcing-a-policy-for-workflow-permissions-in-your-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   * GitHub Apps must have the `enterprise_administration:write` permission to use this endpoint.
   */
  "actions/set-github-actions-default-workflow-permissions-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Success response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["actions-set-default-workflow-permissions"];
      };
    };
  };
  /**
   * Lists all self-hosted runner groups for an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-self-hosted-runner-groups-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** Only return runner groups that are allowed to be used by this organization. */
        visible_to_organization?: components["parameters"]["visible-to-organization"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            runner_groups: components["schemas"]["runner-groups-enterprise"][];
          };
        };
      };
    };
  };
  /**
   * Creates a new self-hosted runner group for an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/create-self-hosted-runner-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["runner-groups-enterprise"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** Name of the runner group. */
          name: string;
          /** Visibility of a runner group. You can select all organizations or select individual organization. */
          visibility?: "selected" | "all";
          /** List of organization IDs that can access the runner group. */
          selected_organization_ids?: number[];
          /** List of runner IDs to add to the runner group. */
          runners?: number[];
          /** Whether the runner group can be used by `public` repositories. */
          allows_public_repositories?: boolean;
          /** If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array. */
          restricted_to_workflows?: boolean;
          /** List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`. */
          selected_workflows?: string[];
        };
      };
    };
  };
  /**
   * Gets a specific self-hosted runner group for an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-self-hosted-runner-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-groups-enterprise"];
        };
      };
    };
  };
  /**
   * Deletes a self-hosted runner group for an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/delete-self-hosted-runner-group-from-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Updates the `name` and `visibility` of a self-hosted runner group in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/update-self-hosted-runner-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-groups-enterprise"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** Name of the runner group. */
          name?: string;
          /** Visibility of a runner group. You can select all organizations or select individual organizations. */
          visibility?: "selected" | "all";
          /** Whether the runner group can be used by `public` repositories. */
          allows_public_repositories?: boolean;
          /** If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array. */
          restricted_to_workflows?: boolean;
          /** List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`. */
          selected_workflows?: string[];
        };
      };
    };
  };
  /**
   * Lists the organizations with access to a self-hosted runner group.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            organizations: components["schemas"]["organization-simple"][];
          };
        };
      };
    };
  };
  /**
   * Replaces the list of organizations that have access to a self-hosted runner configured in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** List of organization IDs that can access the runner group. */
          selected_organization_ids: number[];
        };
      };
    };
  };
  /**
   * Adds an organization to the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/add-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** The unique identifier of the organization. */
        org_id: components["parameters"]["org-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Removes an organization from the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/remove-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** The unique identifier of the organization. */
        org_id: components["parameters"]["org-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Lists the self-hosted runners that are in a specific enterprise group.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-self-hosted-runners-in-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            runners: components["schemas"]["runner"][];
          };
        };
      };
    };
  };
  /**
   * Replaces the list of self-hosted runners that are part of an enterprise runner group.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-self-hosted-runners-in-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** List of runner IDs to add to the runner group. */
          runners: number[];
        };
      };
    };
  };
  /**
   * Adds a self-hosted runner to a runner group configured in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise`
   * scope to use this endpoint.
   */
  "enterprise-admin/add-self-hosted-runner-to-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Removes a self-hosted runner from a group configured in an enterprise. The runner is then returned to the default group.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/remove-self-hosted-runner-from-group-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Lists all self-hosted runners configured for an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-self-hosted-runners-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count?: number;
            runners?: components["schemas"]["runner"][];
          };
        };
      };
    };
  };
  /**
   * Lists binaries for the runner application that you can download and run.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-runner-applications-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-application"][];
        };
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script. The token expires after one hour.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   *
   * #### Example using registration token
   *
   * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
   *
   * ```
   * ./config.sh --url https://github.com/enterprises/octo-enterprise --token TOKEN
   * ```
   */
  "enterprise-admin/create-registration-token-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["authentication-token"];
        };
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script to remove a self-hosted runner from an enterprise. The token expires after one hour.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   *
   * #### Example using remove token
   *
   * To remove your self-hosted runner from an enterprise, replace `TOKEN` with the remove token provided by this
   * endpoint.
   *
   * ```
   * ./config.sh remove --token TOKEN
   * ```
   */
  "enterprise-admin/create-remove-token-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["authentication-token"];
        };
      };
    };
  };
  /**
   * Gets a specific self-hosted runner configured in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-self-hosted-runner-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner"];
        };
      };
    };
  };
  /**
   * Forces the removal of a self-hosted runner from an enterprise. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/delete-self-hosted-runner-from-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Lists all labels for a self-hosted runner configured in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-labels-for-self-hosted-runner-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      200: components["responses"]["actions_runner_labels"];
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Remove all previous custom labels and set the new custom labels for a specific
   * self-hosted runner configured in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-custom-labels-for-self-hosted-runner-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      200: components["responses"]["actions_runner_labels"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed_simple"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The names of the custom labels to set for the runner. You can pass an empty array to remove all custom labels. */
          labels: string[];
        };
      };
    };
  };
  /**
   * Add custom labels to a self-hosted runner configured in an enterprise.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/add-custom-labels-to-self-hosted-runner-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      200: components["responses"]["actions_runner_labels"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed_simple"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The names of the custom labels to add to the runner. */
          labels: string[];
        };
      };
    };
  };
  /**
   * Remove all custom labels from a self-hosted runner configured in an
   * enterprise. Returns the remaining read-only labels from the runner.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/remove-all-custom-labels-from-self-hosted-runner-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      200: components["responses"]["actions_runner_labels_readonly"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed_simple"];
    };
  };
  /**
   * Remove a custom label from a self-hosted runner configured
   * in an enterprise. Returns the remaining labels from the runner.
   *
   * This endpoint returns a `404 Not Found` status if the custom label is not
   * present on the runner.
   *
   * You must authenticate using an access token with the `manage_runners:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/remove-custom-label-from-self-hosted-runner-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
        /** The name of a self-hosted runner's custom label. */
        name: components["parameters"]["runner-label-name"];
      };
    };
    responses: {
      200: components["responses"]["actions_runner_labels"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed_simple"];
    };
  };
  /** Gets the audit log for an enterprise. To use this endpoint, you must be an enterprise admin, and you must use an access token with the `admin:enterprise` scope. */
  "enterprise-admin/get-audit-log": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        /** A search phrase. For more information, see [Searching the audit log](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log). */
        phrase?: components["parameters"]["audit-log-phrase"];
        /**
         * The event types to include:
         *
         * - `web` - returns web (non-Git) events.
         * - `git` - returns Git events.
         * - `all` - returns both web and Git events.
         *
         * The default is `web`.
         */
        include?: components["parameters"]["audit-log-include"];
        /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor. */
        after?: components["parameters"]["audit-log-after"];
        /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. */
        before?: components["parameters"]["audit-log-before"];
        /**
         * The order of audit log events. To list newest events first, specify `desc`. To list oldest events first, specify `asc`.
         *
         * The default is `desc`.
         */
        order?: components["parameters"]["audit-log-order"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["audit-log-event"][];
        };
      };
    };
  };
  /**
   * Lists secret scanning alerts for eligible repositories in an enterprise, from newest to oldest.
   * To use this endpoint, you must be a member of the enterprise, and you must use an access token with the `repo` scope or `security_events` scope. Alerts are only returned for organizations in the enterprise for which you are an organization owner or a [security manager](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-security-managers-in-your-organization).
   */
  "secret-scanning/list-alerts-for-enterprise": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        /** Set to `open` or `resolved` to only list secret scanning alerts in a specific state. */
        state?: components["parameters"]["secret-scanning-alert-state"];
        /**
         * A comma-separated list of secret types to return. By default all secret types are returned.
         * See "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)"
         * for a complete list of secret types.
         */
        secret_type?: components["parameters"]["secret-scanning-alert-secret-type"];
        /** A comma-separated list of resolutions. Only secret scanning alerts with one of these resolutions are listed. Valid resolutions are `false_positive`, `wont_fix`, `revoked`, `pattern_edited`, `pattern_deleted` or `used_in_tests`. */
        resolution?: components["parameters"]["secret-scanning-alert-resolution"];
        /** The property to sort the results by. `created` means when the alert was created. `updated` means when the alert was updated or resolved. */
        sort?: components["parameters"]["secret-scanning-alert-sort"];
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. */
        before?: components["parameters"]["pagination-before"];
        /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor. */
        after?: components["parameters"]["pagination-after"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["organization-secret-scanning-alert"][];
        };
      };
      404: components["responses"]["not_found"];
      503: components["responses"]["service_unavailable"];
    };
  };
  /**
   * Gets the summary of the free and paid GitHub Actions minutes used.
   *
   * Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
   *
   * The authenticated user must be an enterprise admin.
   */
  "billing/get-github-actions-billing-ghe": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["actions-billing-usage"];
        };
      };
    };
  };
  /**
   * Gets the GitHub Advanced Security active committers for an enterprise per repository.
   * Each distinct user login across all repositories is counted as a single Advanced Security seat, so the total_advanced_security_committers is not the sum of active_users for each repository.
   */
  "billing/get-github-advanced-security-billing-ghe": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Success */
      200: {
        content: {
          "application/json": components["schemas"]["advanced-security-active-committers"];
        };
      };
      403: components["responses"]["code_scanning_forbidden_read"];
    };
  };
  /**
   * Gets the free and paid storage used for GitHub Packages in gigabytes.
   *
   * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
   *
   * The authenticated user must be an enterprise admin.
   */
  "billing/get-github-packages-billing-ghe": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["packages-billing-usage"];
        };
      };
    };
  };
  /**
   * Gets the estimated paid and estimated total storage used for GitHub Actions and GitHub Packages.
   *
   * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://docs.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
   *
   * The authenticated user must be an enterprise admin.
   */
  "billing/get-shared-storage-billing-ghe": {
    parameters: {
      path: {
        /** The slug version of the enterprise name. You can also substitute this value with the enterprise id. */
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["combined-billing-usage"];
        };
      };
    };
  };
  /** We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago. */
  "activity/list-public-events": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["event"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      503: components["responses"]["service_unavailable"];
    };
  };
  /**
   * GitHub provides several timeline resources in [Atom](http://en.wikipedia.org/wiki/Atom_(standard)) format. The Feeds API lists all the feeds available to the authenticated user:
   *
   * *   **Timeline**: The GitHub global public timeline
   * *   **User**: The public timeline for any user, using [URI template](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia)
   * *   **Current user public**: The public timeline for the authenticated user
   * *   **Current user**: The private timeline for the authenticated user
   * *   **Current user actor**: The private timeline for activity created by the authenticated user
   * *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
   * *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.
   *
   * **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
   */
  "activity/get-feeds": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["feed"];
        };
      };
    };
  };
  /** Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists: */
  "gists/list": {
    parameters: {
      query: {
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["base-gist"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * Allows you to add a new gist with one or more files.
   *
   * **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
   */
  "gists/create": {
    parameters: {};
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["gist-simple"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** Description of the gist */
          description?: string;
          /** Names and content for the files that make up the gist */
          files: {
            [key: string]: {
              /** Content of the file */
              content: string;
            };
          };
          public?: boolean | ("true" | "false");
        };
      };
    };
  };
  /**
   * List public gists sorted by most recently updated to least recently updated.
   *
   * Note: With [pagination](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
   */
  "gists/list-public": {
    parameters: {
      query: {
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["base-gist"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** List the authenticated user's starred gists: */
  "gists/list-starred": {
    parameters: {
      query: {
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["base-gist"][];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  "gists/get": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gist-simple"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden_gist"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/delete": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** Allows you to update or delete a gist file and rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged. */
  "gists/update": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gist-simple"];
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** Description of the gist */
          description?: string;
          /** Names of files to be updated */
          files?: { [key: string]: Partial<{ [key: string]: unknown }> };
        } | null;
      };
    };
  };
  "gists/list-comments": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["gist-comment"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/create-comment": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["gist-comment"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The comment text. */
          body: string;
        };
      };
    };
  };
  "gists/get-comment": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
        /** The unique identifier of the comment. */
        comment_id: components["parameters"]["comment-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gist-comment"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden_gist"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/delete-comment": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
        /** The unique identifier of the comment. */
        comment_id: components["parameters"]["comment-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/update-comment": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
        /** The unique identifier of the comment. */
        comment_id: components["parameters"]["comment-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gist-comment"];
        };
      };
      404: components["responses"]["not_found"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The comment text. */
          body: string;
        };
      };
    };
  };
  "gists/list-commits": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {
          Link?: string;
        };
        content: {
          "application/json": components["schemas"]["gist-commit"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/list-forks": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["gist-simple"][];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** **Note**: This was previously `/gists/:gist_id/fork`. */
  "gists/fork": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["base-gist"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
  };
  "gists/check-is-starred": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response if gist is starred */
      204: never;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      /** Not Found if gist is not starred */
      404: {
        content: {
          "application/json": { [key: string]: unknown };
        };
      };
    };
  };
  /** Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)." */
  "gists/star": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/unstar": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "gists/get-revision": {
    parameters: {
      path: {
        /** The unique identifier of the gist. */
        gist_id: components["parameters"]["gist-id"];
        sha: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gist-simple"];
        };
      };
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** List all templates available to pass as an option when [creating a repository](https://docs.github.com/rest/reference/repos#create-a-repository-for-the-authenticated-user). */
  "gitignore/get-all-templates": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": string[];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  /**
   * The API also allows fetching the source of a single template.
   * Use the raw [media type](https://docs.github.com/rest/overview/media-types/) to get the raw contents.
   */
  "gitignore/get-template": {
    parameters: {
      path: {
        name: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["gitignore-template"];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  /**
   * List repositories that an app installation can access.
   *
   * You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
   */
  "apps/list-repos-accessible-to-installation": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            repositories: components["schemas"]["repository"][];
            repository_selection?: string;
          };
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * Revokes the installation token you're using to authenticate as an installation and access this endpoint.
   *
   * Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/rest/reference/apps#create-an-installation-access-token-for-an-app)" endpoint.
   *
   * You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
   */
  "apps/revoke-installation-access-token": {
    parameters: {};
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * List issues assigned to the authenticated user across all visible repositories including owned repositories, member
   * repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
   * necessarily assigned to you.
   *
   *
   * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
   * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
   * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
   * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
   */
  "issues/list": {
    parameters: {
      query: {
        /** Indicates which sorts of issues to return. `assigned` means issues assigned to you. `created` means issues created by you. `mentioned` means issues mentioning you. `subscribed` means issues you're subscribed to updates for. `all` or `repos` means all issues you can see, regardless of participation or creation. */
        filter?:
          | "assigned"
          | "created"
          | "mentioned"
          | "subscribed"
          | "repos"
          | "all";
        /** Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`. */
        state?: "open" | "closed" | "all";
        /** A list of comma separated label names. Example: `bug,ui,@high` */
        labels?: components["parameters"]["labels"];
        /** What to sort results by. Can be either `created`, `updated`, `comments`. */
        sort?: "created" | "updated" | "comments";
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        collab?: boolean;
        orgs?: boolean;
        owned?: boolean;
        pulls?: boolean;
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["issue"][];
        };
      };
      304: components["responses"]["not_modified"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
  };
  "licenses/get-all-commonly-used": {
    parameters: {
      query: {
        featured?: boolean;
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["license-simple"][];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  "licenses/get": {
    parameters: {
      path: {
        license: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["license"];
        };
      };
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  "markdown/render": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        headers: {
          "Content-Length"?: string;
        };
        content: {
          "text/html": string;
        };
      };
      304: components["responses"]["not_modified"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The Markdown text to render in HTML. */
          text: string;
          /** The rendering mode. Can be either `markdown` or `gfm`. */
          mode?: "markdown" | "gfm";
          /** The repository context to use when creating references in `gfm` mode.  For example, setting `context` to `octo-org/octo-repo` will change the text `#42` into an HTML link to issue 42 in the `octo-org/octo-repo` repository. */
          context?: string;
        };
      };
    };
  };
  /** You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less. */
  "markdown/render-raw": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "text/html": string;
        };
      };
      304: components["responses"]["not_modified"];
    };
    requestBody: {
      content: {
        "text/plain": string;
        "text/x-markdown": string;
      };
    };
  };
  /**
   * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/get-subscription-plan-for-account": {
    parameters: {
      path: {
        /** account_id parameter */
        account_id: components["parameters"]["account-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["marketplace-purchase"];
        };
      };
      401: components["responses"]["requires_authentication"];
      /** Not Found when the account has not purchased the listing */
      404: {
        content: {
          "application/json": components["schemas"]["basic-error"];
        };
      };
    };
  };
  /**
   * Lists all plans that are part of your GitHub Marketplace listing.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/list-plans": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["marketplace-listing-plan"][];
        };
      };
      401: components["responses"]["requires_authentication"];
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Returns user and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/list-accounts-for-plan": {
    parameters: {
      path: {
        /** The unique identifier of the plan. */
        plan_id: components["parameters"]["plan-id"];
      };
      query: {
        /** The property to sort the results by. `created` means when the repository was starred. `updated` means when the repository was last pushed to. */
        sort?: components["parameters"]["sort"];
        /** To return the oldest accounts first, set to `asc`. Ignored without the `sort` parameter. */
        direction?: "asc" | "desc";
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["marketplace-purchase"][];
        };
      };
      401: components["responses"]["requires_authentication"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
  };
  /**
   * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/get-subscription-plan-for-account-stubbed": {
    parameters: {
      path: {
        /** account_id parameter */
        account_id: components["parameters"]["account-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["marketplace-purchase"];
        };
      };
      401: components["responses"]["requires_authentication"];
      /** Not Found when the account has not purchased the listing */
      404: unknown;
    };
  };
  /**
   * Lists all plans that are part of your GitHub Marketplace listing.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/list-plans-stubbed": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["marketplace-listing-plan"][];
        };
      };
      401: components["responses"]["requires_authentication"];
    };
  };
  /**
   * Returns repository and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/list-accounts-for-plan-stubbed": {
    parameters: {
      path: {
        /** The unique identifier of the plan. */
        plan_id: components["parameters"]["plan-id"];
      };
      query: {
        /** The property to sort the results by. `created` means when the repository was starred. `updated` means when the repository was last pushed to. */
        sort?: components["parameters"]["sort"];
        /** To return the oldest accounts first, set to `asc`. Ignored without the `sort` parameter. */
        direction?: "asc" | "desc";
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["marketplace-purchase"][];
        };
      };
      401: components["responses"]["requires_authentication"];
    };
  };
  /**
   * Returns meta information about GitHub, including a list of GitHub's IP addresses. For more information, see "[About GitHub's IP addresses](https://docs.github.com/articles/about-github-s-ip-addresses/)."
   *
   * **Note:** The IP addresses shown in the documentation's response are only example values. You must always query the API directly to get the latest list of IP addresses.
   */
  "meta/get": {
    parameters: {};
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["api-overview"];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  "activity/list-public-events-for-repo-network": {
    parameters: {
      path: {
        /** The account owner of the repository. The name is not case sensitive. */
        owner: components["parameters"]["owner"];
        /** The name of the repository. The name is not case sensitive. */
        repo: components["parameters"]["repo"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["event"][];
        };
      };
      301: components["responses"]["moved_permanently"];
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** List all notifications for the current user, sorted by most recently updated. */
  "activity/list-notifications-for-authenticated-user": {
    parameters: {
      query: {
        /** If `true`, show notifications marked as read. */
        all?: components["parameters"]["all"];
        /** If `true`, only shows notifications in which the user is directly participating or mentioned. */
        participating?: components["parameters"]["participating"];
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        /** Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        before?: components["parameters"]["before"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["thread"][];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** Marks all notifications as "read" removes it from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/rest/reference/activity#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`. */
  "activity/mark-notifications-as-read": {
    parameters: {};
    responses: {
      /** Response */
      202: {
        content: {
          "application/json": {
            message?: string;
          };
        };
      };
      /** Reset Content */
      205: unknown;
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp. */
          last_read_at?: string;
          /** Whether the notification has been read. */
          read?: boolean;
        };
      };
    };
  };
  "activity/get-thread": {
    parameters: {
      path: {
        /** The unique identifier of the pull request thread. */
        thread_id: components["parameters"]["thread-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["thread"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  "activity/mark-thread-as-read": {
    parameters: {
      path: {
        /** The unique identifier of the pull request thread. */
        thread_id: components["parameters"]["thread-id"];
      };
    };
    responses: {
      /** Reset Content */
      205: unknown;
      304: components["responses"]["not_modified"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/rest/reference/activity#get-a-repository-subscription).
   *
   * Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
   */
  "activity/get-thread-subscription-for-authenticated-user": {
    parameters: {
      path: {
        /** The unique identifier of the pull request thread. */
        thread_id: components["parameters"]["thread-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["thread-subscription"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
   *
   * You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
   *
   * Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/rest/reference/activity#delete-a-thread-subscription) endpoint.
   */
  "activity/set-thread-subscription": {
    parameters: {
      path: {
        /** The unique identifier of the pull request thread. */
        thread_id: components["parameters"]["thread-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["thread-subscription"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** Whether to block all notifications from a thread. */
          ignored?: boolean;
        };
      };
    };
  };
  /** Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/rest/reference/activity#set-a-thread-subscription) endpoint and set `ignore` to `true`. */
  "activity/delete-thread-subscription": {
    parameters: {
      path: {
        /** The unique identifier of the pull request thread. */
        thread_id: components["parameters"]["thread-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /** Get the octocat as ASCII art */
  "meta/get-octocat": {
    parameters: {
      query: {
        /** The words to show in Octocat's speech bubble */
        s?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/octocat-stream": string;
        };
      };
    };
  };
  /**
   * Lists all organizations, in the order that they were created on GitHub.
   *
   * **Note:** Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of organizations.
   */
  "orgs/list": {
    parameters: {
      query: {
        /** An organization ID. Only return organizations with an ID greater than this ID. */
        since?: components["parameters"]["since-org"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {
          Link?: string;
        };
        content: {
          "application/json": components["schemas"]["organization-simple"][];
        };
      };
      304: components["responses"]["not_modified"];
    };
  };
  /**
   * List the custom repository roles available in this organization. In order to see custom
   * repository roles in an organization, the authenticated user must be an organization owner.
   *
   * For more information on custom repository roles, see "[Managing custom repository roles for an organization](https://docs.github.com/organizations/managing-peoples-access-to-your-organization-with-roles/managing-custom-repository-roles-for-an-organization)".
   */
  "orgs/list-custom-roles": {
    parameters: {
      path: {
        organization_id: string;
      };
    };
    responses: {
      /** Response - list of custom role names */
      200: {
        content: {
          "application/json": {
            /** The number of custom roles in this organization */
            total_count?: number;
            custom_roles?: components["schemas"]["organization-custom-repository-role"][];
          };
        };
      };
    };
  };
  /**
   * Lists the codespaces associated to a specified organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "codespaces/list-in-organization": {
    parameters: {
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
      path: {
        /** The unique identifier of the organization. */
        org_id: components["parameters"]["org-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            codespaces: components["schemas"]["codespace"][];
          };
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      500: components["responses"]["internal_error"];
    };
  };
  /**
   * To see many of the organization response values, you need to be an authenticated organization owner with the `admin:org` scope. When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, and outside collaborators to enable [two-factor authentication](https://docs.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
   *
   * GitHub Apps with the `Organization plan` permission can use this endpoint to retrieve information about an organization's GitHub plan. See "[Authenticating with GitHub Apps](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/)" for details. For an example response, see 'Response with GitHub plan information' below."
   */
  "orgs/get": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["organization-full"];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /**
   * **Parameter Deprecation Notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
   *
   * Enables an authenticated organization owner with the `admin:org` scope to update the organization's profile and member privileges.
   */
  "orgs/update": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["organization-full"];
        };
      };
      409: components["responses"]["conflict"];
      /** Validation failed */
      422: {
        content: {
          "application/json":
            | components["schemas"]["validation-error"]
            | components["schemas"]["validation-error-simple"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** Billing email address. This address is not publicized. */
          billing_email?: string;
          /** The company name. */
          company?: string;
          /** The publicly visible email address. */
          email?: string;
          /** The Twitter username of the company. */
          twitter_username?: string;
          /** The location. */
          location?: string;
          /** The shorthand name of the company. */
          name?: string;
          /** The description of the company. */
          description?: string;
          /** Whether an organization can use organization projects. */
          has_organization_projects?: boolean;
          /** Whether repositories that belong to the organization can use repository projects. */
          has_repository_projects?: boolean;
          /** Default permission level members have for organization repositories. */
          default_repository_permission?: "read" | "write" | "admin" | "none";
          /** Whether of non-admin organization members can create repositories. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. */
          members_can_create_repositories?: boolean;
          /** Whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation. */
          members_can_create_internal_repositories?: boolean;
          /** Whether organization members can create private repositories, which are visible to organization members with permission. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation. */
          members_can_create_private_repositories?: boolean;
          /** Whether organization members can create public repositories, which are visible to anyone. For more information, see "[Restricting repository creation in your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation. */
          members_can_create_public_repositories?: boolean;
          /**
           * Specifies which types of repositories non-admin organization members can create. `private` is only available to repositories that are part of an organization on GitHub Enterprise Cloud.
           * **Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See the parameter deprecation notice in the operation description for details.
           */
          members_allowed_repository_creation_type?: "all" | "private" | "none";
          /** Whether organization members can create GitHub Pages sites. Existing published sites will not be impacted. */
          members_can_create_pages?: boolean;
          /** Whether organization members can create public GitHub Pages sites. Existing published sites will not be impacted. */
          members_can_create_public_pages?: boolean;
          /** Whether organization members can create private GitHub Pages sites. Existing published sites will not be impacted. */
          members_can_create_private_pages?: boolean;
          /** Whether organization members can fork private organization repositories. */
          members_can_fork_private_repositories?: boolean;
          blog?: string;
        };
      };
    };
  };
  /**
   * Gets the total GitHub Actions cache usage for an organization.
   * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
   * You must authenticate using an access token with the `read:org` scope to use this endpoint. GitHub Apps must have the `organization_admistration:read` permission to use this endpoint.
   */
  "actions/get-actions-cache-usage-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["actions-cache-usage-org-enterprise"];
        };
      };
    };
  };
  /**
   * Lists repositories and their GitHub Actions cache usage for an organization.
   * The data fetched using this API is refreshed approximately every 5 minutes, so values returned from this endpoint may take at least 5 minutes to get updated.
   * You must authenticate using an access token with the `read:org` scope to use this endpoint. GitHub Apps must have the `organization_admistration:read` permission to use this endpoint.
   */
  "actions/get-actions-cache-usage-by-repo-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            repository_cache_usages: components["schemas"]["actions-cache-usage-by-repository"][];
          };
        };
      };
    };
  };
  /**
   * Gets the customization template for an OpenID Connect (OIDC) subject claim.
   * You must authenticate using an access token with the `read:org` scope to use this endpoint.
   * GitHub Apps must have the `organization_administration:write` permission to use this endpoint.
   */
  "oidc/get-oidc-custom-sub-template-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** A JSON serialized template for OIDC subject claim customization */
      200: {
        content: {
          "application/json": components["schemas"]["oidc-custom-sub"];
        };
      };
    };
  };
  /**
   * Creates or updates the customization template for an OpenID Connect (OIDC) subject claim.
   * You must authenticate using an access token with the `write:org` scope to use this endpoint.
   * GitHub Apps must have the `admin:org` permission to use this endpoint.
   */
  "oidc/update-oidc-custom-sub-template-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Empty response */
      201: {
        content: {
          "application/json": components["schemas"]["empty-object"];
        };
      };
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["oidc-custom-sub"];
      };
    };
  };
  /**
   * Gets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/get-github-actions-permissions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["actions-organization-permissions"];
        };
      };
    };
  };
  /**
   * Sets the GitHub Actions permissions policy for repositories and allowed actions and reusable workflows in an organization.
   *
   * If the organization belongs to an enterprise that has set restrictive permissions at the enterprise level, such as `allowed_actions` to `selected` actions and reusable workflows, then you cannot override them for the organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/set-github-actions-permissions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          enabled_repositories: components["schemas"]["enabled-repositories"];
          allowed_actions?: components["schemas"]["allowed-actions"];
        };
      };
    };
  };
  /**
   * Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/list-selected-repositories-enabled-github-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            repositories: components["schemas"]["repository"][];
          };
        };
      };
    };
  };
  /**
   * Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/set-selected-repositories-enabled-github-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** List of repository IDs to enable for GitHub Actions. */
          selected_repository_ids: number[];
        };
      };
    };
  };
  /**
   * Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/enable-selected-repository-github-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the repository. */
        repository_id: components["parameters"]["repository-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/disable-selected-repository-github-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the repository. */
        repository_id: components["parameters"]["repository-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Gets the selected actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization).""
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/get-allowed-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["selected-actions"];
        };
      };
    };
  };
  /**
   * Sets the actions and reusable workflows that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * If the organization belongs to an enterprise that has `selected` actions and reusable workflows set at the enterprise level, then you cannot override any of the enterprise's allowed actions and reusable workflows settings.
   *
   * To use the `patterns_allowed` setting for private repositories, the organization must belong to an enterprise. If the organization does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories in the organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/set-allowed-actions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["selected-actions"];
      };
    };
  };
  /**
   * Gets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization,
   * as well as whether GitHub Actions can submit approving pull request reviews. For more information, see
   * "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/get-github-actions-default-workflow-permissions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["actions-get-default-workflow-permissions"];
        };
      };
    };
  };
  /**
   * Sets the default workflow permissions granted to the `GITHUB_TOKEN` when running workflows in an organization, and sets if GitHub Actions
   * can submit approving pull request reviews. For more information, see
   * "[Setting the permissions of the GITHUB_TOKEN for your organization](https://docs.github.com/organizations/managing-organization-settings/disabling-or-limiting-github-actions-for-your-organization#setting-the-permissions-of-the-github_token-for-your-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/set-github-actions-default-workflow-permissions-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Success response */
      204: never;
      /** Conflict response when changing a setting is prevented by the owning enterprise */
      409: unknown;
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["actions-set-default-workflow-permissions"];
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-self-hosted-runner-groups-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** Only return runner groups that are allowed to be used by this repository. */
        visible_to_repository?: components["parameters"]["visible-to-repository"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            runner_groups: components["schemas"]["runner-groups-org"][];
          };
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Creates a new self-hosted runner group for an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/create-self-hosted-runner-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["runner-groups-org"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** Name of the runner group. */
          name: string;
          /** Visibility of a runner group. You can select all repositories, select individual repositories, or limit access to private repositories. */
          visibility?: "selected" | "all" | "private";
          /** List of repository IDs that can access the runner group. */
          selected_repository_ids?: number[];
          /** List of runner IDs to add to the runner group. */
          runners?: number[];
          /** Whether the runner group can be used by `public` repositories. */
          allows_public_repositories?: boolean;
          /** If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array. */
          restricted_to_workflows?: boolean;
          /** List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`. */
          selected_workflows?: string[];
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Gets a specific self-hosted runner group for an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/get-self-hosted-runner-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-groups-org"];
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Deletes a self-hosted runner group for an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/delete-self-hosted-runner-group-from-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Updates the `name` and `visibility` of a self-hosted runner group in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/update-self-hosted-runner-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-groups-org"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          /** Name of the runner group. */
          name: string;
          /** Visibility of a runner group. You can select all repositories, select individual repositories, or all private repositories. */
          visibility?: "selected" | "all" | "private";
          /** Whether the runner group can be used by `public` repositories. */
          allows_public_repositories?: boolean;
          /** If `true`, the runner group will be restricted to running only the workflows specified in the `selected_workflows` array. */
          restricted_to_workflows?: boolean;
          /** List of workflows the runner group should be allowed to run. This setting will be ignored unless `restricted_to_workflows` is set to `true`. */
          selected_workflows?: string[];
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Lists the repositories with access to a self-hosted runner group configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
      query: {
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            repositories: components["schemas"]["minimal-repository"][];
          };
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/set-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** List of repository IDs that can access the runner group. */
          selected_repository_ids: number[];
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   *
   * Adds a repository to the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org`
   * scope to use this endpoint.
   */
  "actions/add-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** The unique identifier of the repository. */
        repository_id: components["parameters"]["repository-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   *
   * Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/remove-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** The unique identifier of the repository. */
        repository_id: components["parameters"]["repository-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Lists self-hosted runners that are in a specific organization group.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-self-hosted-runners-in-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            runners: components["schemas"]["runner"][];
          };
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Replaces the list of self-hosted runners that are part of an organization runner group.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/set-self-hosted-runners-in-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** List of runner IDs to add to the runner group. */
          runners: number[];
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   *
   * Adds a self-hosted runner to a runner group configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org`
   * scope to use this endpoint.
   */
  "actions/add-self-hosted-runner-to-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   *
   * Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/remove-self-hosted-runner-from-group-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner group. */
        runner_group_id: components["parameters"]["runner-group-id"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Lists all self-hosted runners configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-self-hosted-runners-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            runners: components["schemas"]["runner"][];
          };
        };
      };
    };
  };
  /**
   * Lists binaries for the runner application that you can download and run.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-runner-applications-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner-application"][];
        };
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script. The token expires after one hour.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   *
   * #### Example using registration token
   *
   * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
   *
   * ```
   * ./config.sh --url https://github.com/octo-org --token TOKEN
   * ```
   */
  "actions/create-registration-token-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["authentication-token"];
        };
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   *
   * #### Example using remove token
   *
   * To remove your self-hosted runner from an organization, replace `TOKEN` with the remove token provided by this
   * endpoint.
   *
   * ```
   * ./config.sh remove --token TOKEN
   * ```
   */
  "actions/create-remove-token-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["authentication-token"];
        };
      };
    };
  };
  /**
   * Gets a specific self-hosted runner configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/get-self-hosted-runner-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["runner"];
        };
      };
    };
  };
  /**
   * Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/delete-self-hosted-runner-from-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Lists all labels for a self-hosted runner configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-labels-for-self-hosted-runner-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      200: components["responses"]["actions_runner_labels"];
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Remove all previous custom labels and set the new custom labels for a specific
   * self-hosted runner configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/set-custom-labels-for-self-hosted-runner-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      200: components["responses"]["actions_runner_labels"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed_simple"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The names of the custom labels to set for the runner. You can pass an empty array to remove all custom labels. */
          labels: string[];
        };
      };
    };
  };
  /**
   * Add custom labels to a self-hosted runner configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/add-custom-labels-to-self-hosted-runner-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      200: components["responses"]["actions_runner_labels"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed_simple"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** The names of the custom labels to add to the runner. */
          labels: string[];
        };
      };
    };
  };
  /**
   * Remove all custom labels from a self-hosted runner configured in an
   * organization. Returns the remaining read-only labels from the runner.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/remove-all-custom-labels-from-self-hosted-runner-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
      };
    };
    responses: {
      200: components["responses"]["actions_runner_labels_readonly"];
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Remove a custom label from a self-hosted runner configured
   * in an organization. Returns the remaining labels from the runner.
   *
   * This endpoint returns a `404 Not Found` status if the custom label is not
   * present on the runner.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/remove-custom-label-from-self-hosted-runner-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** Unique identifier of the self-hosted runner. */
        runner_id: components["parameters"]["runner-id"];
        /** The name of a self-hosted runner's custom label. */
        name: components["parameters"]["runner-label-name"];
      };
    };
    responses: {
      200: components["responses"]["actions_runner_labels"];
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed_simple"];
    };
  };
  /** Lists all secrets available in an organization without revealing their encrypted values. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/list-org-secrets": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            secrets: components["schemas"]["organization-actions-secret"][];
          };
        };
      };
    };
  };
  /** Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/get-org-public-key": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["actions-public-key"];
        };
      };
    };
  };
  /** Gets a single organization secret without revealing its encrypted value. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/get-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["organization-actions-secret"];
        };
      };
    };
  };
  /**
   * Creates or updates an organization secret with an encrypted value. Encrypt your secret using
   * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
   * token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to
   * use this endpoint.
   *
   * #### Example encrypting a secret using Node.js
   *
   * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
   *
   * ```
   * const sodium = require('tweetsodium');
   *
   * const key = "base64-encoded-public-key";
   * const value = "plain-text-secret";
   *
   * // Convert the message and key to Uint8Array's (Buffer implements that interface)
   * const messageBytes = Buffer.from(value);
   * const keyBytes = Buffer.from(key, 'base64');
   *
   * // Encrypt using LibSodium.
   * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
   *
   * // Base64 the encrypted secret
   * const encrypted = Buffer.from(encryptedBytes).toString('base64');
   *
   * console.log(encrypted);
   * ```
   *
   *
   * #### Example encrypting a secret using Python
   *
   * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
   *
   * ```
   * from base64 import b64encode
   * from nacl import encoding, public
   *
   * def encrypt(public_key: str, secret_value: str) -> str:
   *   """Encrypt a Unicode string using the public key."""
   *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
   *   sealed_box = public.SealedBox(public_key)
   *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
   *   return b64encode(encrypted).decode("utf-8")
   * ```
   *
   * #### Example encrypting a secret using C#
   *
   * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
   *
   * ```
   * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
   * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
   *
   * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
   *
   * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
   * ```
   *
   * #### Example encrypting a secret using Ruby
   *
   * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
   *
   * ```ruby
   * require "rbnacl"
   * require "base64"
   *
   * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
   * public_key = RbNaCl::PublicKey.new(key)
   *
   * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
   * encrypted_secret = box.encrypt("my_secret")
   *
   * # Print the base64 encoded secret
   * puts Base64.strict_encode64(encrypted_secret)
   * ```
   */
  "actions/create-or-update-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response when creating a secret */
      201: {
        content: {
          "application/json": components["schemas"]["empty-object"];
        };
      };
      /** Response when updating a secret */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/reference/actions#get-an-organization-public-key) endpoint. */
          encrypted_value?: string;
          /** ID of the key you used to encrypt the secret. */
          key_id?: string;
          /** Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret. */
          visibility: "all" | "private" | "selected";
          /** An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/reference/actions#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/reference/actions#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/reference/actions#remove-selected-repository-from-an-organization-secret) endpoints. */
          selected_repository_ids?: string[];
        };
      };
    };
  };
  /** Deletes a secret in an organization using the secret name. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/delete-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /** Lists all repositories that have been selected when the `visibility` for repository access to a secret is set to `selected`. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/list-selected-repos-for-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
      query: {
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            repositories: components["schemas"]["minimal-repository"][];
          };
        };
      };
    };
  };
  /** Replaces all repositories for an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/set-selected-repos-for-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/rest/reference/actions#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/reference/actions#remove-selected-repository-from-an-organization-secret) endpoints. */
          selected_repository_ids: number[];
        };
      };
    };
  };
  /** Adds a repository to an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/add-selected-repo-to-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
        repository_id: number;
      };
    };
    responses: {
      /** No Content when repository was added to the selected list */
      204: never;
      /** Conflict when visibility type is not set to selected */
      409: unknown;
    };
  };
  /** Removes a repository from an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint. */
  "actions/remove-selected-repo-from-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
        repository_id: number;
      };
    };
    responses: {
      /** Response when repository was removed from the selected list */
      204: never;
      /** Conflict when visibility type not set to selected */
      409: unknown;
    };
  };
  /**
   * Gets the audit log for an organization. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization)."
   *
   * This endpoint is available for organizations on GitHub Enterprise Cloud. To use this endpoint, you must be an organization owner, and you must use an access token with the `admin:org` scope. GitHub Apps must have the `organization_administration` read permission to use this endpoint.
   *
   * By default, the response includes up to 30 events from the past three months. Use the `phrase` parameter to filter results and retrieve older events. For example, use the `phrase` parameter with the `created` qualifier to filter events based on when the events occurred. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/organizations/keeping-your-organization-secure/managing-security-settings-for-your-organization/reviewing-the-audit-log-for-your-organization#searching-the-audit-log)."
   *
   * Use pagination to retrieve fewer or more than 30 events. For more information, see "[Resources in the REST API](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination)."
   */
  "orgs/get-audit-log": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** A search phrase. For more information, see [Searching the audit log](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log). */
        phrase?: components["parameters"]["audit-log-phrase"];
        /**
         * The event types to include:
         *
         * - `web` - returns web (non-Git) events.
         * - `git` - returns Git events.
         * - `all` - returns both web and Git events.
         *
         * The default is `web`.
         */
        include?: components["parameters"]["audit-log-include"];
        /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor. */
        after?: components["parameters"]["audit-log-after"];
        /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. */
        before?: components["parameters"]["audit-log-before"];
        /**
         * The order of audit log events. To list newest events first, specify `desc`. To list oldest events first, specify `asc`.
         *
         * The default is `desc`.
         */
        order?: components["parameters"]["audit-log-order"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["audit-log-event"][];
        };
      };
    };
  };
  /** List the users blocked by an organization. */
  "orgs/list-blocked-users": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["simple-user"][];
        };
      };
    };
  };
  "orgs/check-blocked-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** If the user is blocked: */
      204: never;
      /** If the user is not blocked: */
      404: {
        content: {
          "application/json": components["schemas"]["basic-error"];
        };
      };
    };
  };
  "orgs/block-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
      422: components["responses"]["validation_failed"];
    };
  };
  "orgs/unblock-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /**
   * Lists all code scanning alerts for the default branch (usually `main`
   * or `master`) for all eligible repositories in an organization.
   * To use this endpoint, you must be an administrator or security manager for the organization, and you must use an access token with the `repo` scope or `security_events` scope.
   *
   * GitHub Apps must have the `security_events` read permission to use this endpoint.
   */
  "code-scanning/list-alerts-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The name of a code scanning tool. Only results by this tool will be listed. You can specify the tool by using either `tool_name` or `tool_guid`, but not both. */
        tool_name?: components["parameters"]["tool-name"];
        /** The GUID of a code scanning tool. Only results by this tool will be listed. Note that some code scanning tools may not include a GUID in their analysis data. You can specify the tool by using either `tool_guid` or `tool_name`, but not both. */
        tool_guid?: components["parameters"]["tool-guid"];
        /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor. */
        before?: components["parameters"]["pagination-before"];
        /** A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor. */
        after?: components["parameters"]["pagination-after"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        /** Set to `open`, `closed`, `fixed`, or `dismissed` to list code scanning alerts in a specific state. */
        state?: components["schemas"]["code-scanning-alert-state"];
        /** The property by which to sort the results. */
        sort?: "created" | "updated";
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["code-scanning-organization-alert-items"][];
        };
      };
      403: components["responses"]["code_scanning_forbidden_read"];
      404: components["responses"]["not_found"];
      503: components["responses"]["service_unavailable"];
    };
  };
  /**
   * Listing and deleting credential authorizations is available to organizations with GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products).
   *
   * An authenticated organization owner with the `read:org` scope can list all credential authorizations for an organization that uses SAML single sign-on (SSO). The credentials are either personal access tokens or SSH keys that organization members have authorized for the organization. For more information, see [About authentication with SAML single sign-on](https://docs.github.com/en/articles/about-authentication-with-saml-single-sign-on).
   */
  "orgs/list-saml-sso-authorizations": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page token */
        page?: number;
        /** Limits the list of credentials authorizations for an organization to a specific login */
        login?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["credential-authorization"][];
        };
      };
    };
  };
  /**
   * Listing and deleting credential authorizations is available to organizations with GitHub Enterprise Cloud. For more information, see [GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products).
   *
   * An authenticated organization owner with the `admin:org` scope can remove a credential authorization for an organization that uses SAML SSO. Once you remove someone's credential authorization, they will need to create a new personal access token or SSH key and authorize it for the organization they want to access.
   */
  "orgs/remove-saml-sso-authorization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        credential_id: number;
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /** Lists all secrets available in an organization without revealing their encrypted values. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
  "dependabot/list-org-secrets": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            secrets: components["schemas"]["organization-dependabot-secret"][];
          };
        };
      };
    };
  };
  /** Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
  "dependabot/get-org-public-key": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["dependabot-public-key"];
        };
      };
    };
  };
  /** Gets a single organization secret without revealing its encrypted value. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
  "dependabot/get-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["organization-dependabot-secret"];
        };
      };
    };
  };
  /**
   * Creates or updates an organization secret with an encrypted value. Encrypt your secret using
   * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
   * token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization
   * permission to use this endpoint.
   *
   * #### Example encrypting a secret using Node.js
   *
   * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
   *
   * ```
   * const sodium = require('tweetsodium');
   *
   * const key = "base64-encoded-public-key";
   * const value = "plain-text-secret";
   *
   * // Convert the message and key to Uint8Array's (Buffer implements that interface)
   * const messageBytes = Buffer.from(value);
   * const keyBytes = Buffer.from(key, 'base64');
   *
   * // Encrypt using LibSodium.
   * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
   *
   * // Base64 the encrypted secret
   * const encrypted = Buffer.from(encryptedBytes).toString('base64');
   *
   * console.log(encrypted);
   * ```
   *
   *
   * #### Example encrypting a secret using Python
   *
   * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/latest/public/#nacl-public-sealedbox) with Python 3.
   *
   * ```
   * from base64 import b64encode
   * from nacl import encoding, public
   *
   * def encrypt(public_key: str, secret_value: str) -> str:
   *   """Encrypt a Unicode string using the public key."""
   *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
   *   sealed_box = public.SealedBox(public_key)
   *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
   *   return b64encode(encrypted).decode("utf-8")
   * ```
   *
   * #### Example encrypting a secret using C#
   *
   * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
   *
   * ```
   * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
   * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
   *
   * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
   *
   * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
   * ```
   *
   * #### Example encrypting a secret using Ruby
   *
   * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
   *
   * ```ruby
   * require "rbnacl"
   * require "base64"
   *
   * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
   * public_key = RbNaCl::PublicKey.new(key)
   *
   * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
   * encrypted_secret = box.encrypt("my_secret")
   *
   * # Print the base64 encoded secret
   * puts Base64.strict_encode64(encrypted_secret)
   * ```
   */
  "dependabot/create-or-update-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response when creating a secret */
      201: {
        content: {
          "application/json": components["schemas"]["empty-object"];
        };
      };
      /** Response when updating a secret */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/reference/dependabot#get-an-organization-public-key) endpoint. */
          encrypted_value?: string;
          /** ID of the key you used to encrypt the secret. */
          key_id?: string;
          /** Which type of organization repositories have access to the organization secret. `selected` means only the repositories specified by `selected_repository_ids` can access the secret. */
          visibility: "all" | "private" | "selected";
          /** An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/reference/dependabot#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/reference/dependabot#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/reference/dependabot#remove-selected-repository-from-an-organization-secret) endpoints. */
          selected_repository_ids?: string[];
        };
      };
    };
  };
  /** Deletes a secret in an organization using the secret name. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
  "dependabot/delete-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /** Lists all repositories that have been selected when the `visibility` for repository access to a secret is set to `selected`. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
  "dependabot/list-selected-repos-for-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
      query: {
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": {
            total_count: number;
            repositories: components["schemas"]["minimal-repository"][];
          };
        };
      };
    };
  };
  /** Replaces all repositories for an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/dependabot#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
  "dependabot/set-selected-repos-for-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
    requestBody: {
      content: {
        "application/json": {
          /** An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/rest/reference/dependabot#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/reference/dependabot#remove-selected-repository-from-an-organization-secret) endpoints. */
          selected_repository_ids: number[];
        };
      };
    };
  };
  /** Adds a repository to an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/dependabot#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
  "dependabot/add-selected-repo-to-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
        repository_id: number;
      };
    };
    responses: {
      /** No Content when repository was added to the selected list */
      204: never;
      /** Conflict when visibility type is not set to selected */
      409: unknown;
    };
  };
  /** Removes a repository from an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/dependabot#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `dependabot_secrets` organization permission to use this endpoint. */
  "dependabot/remove-selected-repo-from-org-secret": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The name of the secret. */
        secret_name: components["parameters"]["secret-name"];
        repository_id: number;
      };
    };
    responses: {
      /** Response when repository was removed from the selected list */
      204: never;
      /** Conflict when visibility type not set to selected */
      409: unknown;
    };
  };
  "activity/list-public-org-events": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["event"][];
        };
      };
    };
  };
  /**
   * Displays information about the specific group's usage.  Provides a list of the group's external members as well as a list of teams that this group is connected to.
   *
   * You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.
   */
  "teams/external-idp-group-info-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the group. */
        group_id: components["parameters"]["group-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["external-group"];
        };
      };
    };
  };
  /**
   * Lists external groups available in an organization. You can query the groups using the `display_name` parameter, only groups with a `group_name` containing the text provided in the `display_name` parameter will be returned.  You can also limit your page results using the `per_page` parameter. GitHub generates a url-encoded `page` token using a cursor value for where the next page begins. For more information on cursor pagination, see "[Offset and Cursor Pagination explained](https://dev.to/jackmarchant/offset-and-cursor-pagination-explained-b89)."
   *
   * You can manage team membership with your identity provider using Enterprise Managed Users for GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)" in the GitHub Help documentation.
   */
  "teams/list-external-idp-groups-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page token */
        page?: number;
        /** Limits the list to groups containing the text in the group name */
        display_name?: string;
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {
          Link?: string;
        };
        content: {
          "application/json": components["schemas"]["external-groups"];
        };
      };
    };
  };
  /** The return hash contains `failed_at` and `failed_reason` fields which represent the time at which the invitation failed and the reason for the failure. */
  "orgs/list-failed-invitations": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["organization-invitation"][];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  "orgs/list-webhooks": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["org-hook"][];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /** Here's how you can create a hook that posts payloads in JSON format: */
  "orgs/create-webhook": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        headers: {
          Location?: string;
        };
        content: {
          "application/json": components["schemas"]["org-hook"];
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** Must be passed as "web". */
          name: string;
          /** Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/rest/reference/orgs#create-hook-config-params). */
          config: {
            url: components["schemas"]["webhook-config-url"];
            content_type?: components["schemas"]["webhook-config-content-type"];
            secret?: components["schemas"]["webhook-config-secret"];
            insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
            username?: string;
            password?: string;
          };
          /** Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for. */
          events?: string[];
          /** Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications. */
          active?: boolean;
        };
      };
    };
  };
  /** Returns a webhook configured in an organization. To get only the webhook `config` properties, see "[Get a webhook configuration for an organization](/rest/reference/orgs#get-a-webhook-configuration-for-an-organization)." */
  "orgs/get-webhook": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-hook"];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  "orgs/delete-webhook": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /** Updates a webhook configured in an organization. When you update a webhook, the `secret` will be overwritten. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for an organization](/rest/reference/orgs#update-a-webhook-configuration-for-an-organization)." */
  "orgs/update-webhook": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-hook"];
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/rest/reference/orgs#update-hook-config-params). */
          config?: {
            url: components["schemas"]["webhook-config-url"];
            content_type?: components["schemas"]["webhook-config-content-type"];
            secret?: components["schemas"]["webhook-config-secret"];
            insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
          };
          /** Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for. */
          events?: string[];
          /** Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications. */
          active?: boolean;
          name?: string;
        };
      };
    };
  };
  /**
   * Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/reference/orgs#get-an-organization-webhook)."
   *
   * Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:read` permission.
   */
  "orgs/get-webhook-config-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["webhook-config"];
        };
      };
    };
  };
  /**
   * Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/reference/orgs#update-an-organization-webhook)."
   *
   * Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:write` permission.
   */
  "orgs/update-webhook-config-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["webhook-config"];
        };
      };
    };
    requestBody: {
      content: {
        "application/json": {
          url?: components["schemas"]["webhook-config-url"];
          content_type?: components["schemas"]["webhook-config-content-type"];
          secret?: components["schemas"]["webhook-config-secret"];
          insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
        };
      };
    };
  };
  /** Returns a list of webhook deliveries for a webhook configured in an organization. */
  "orgs/list-webhook-deliveries": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Used for pagination: the starting delivery from which the page of deliveries is fetched. Refer to the `link` header for the next and previous page cursors. */
        cursor?: components["parameters"]["cursor"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["hook-delivery-item"][];
        };
      };
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** Returns a delivery for a webhook configured in an organization. */
  "orgs/get-webhook-delivery": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
        delivery_id: components["parameters"]["delivery-id"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["hook-delivery"];
        };
      };
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** Redeliver a delivery for a webhook configured in an organization. */
  "orgs/redeliver-webhook-delivery": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
        delivery_id: components["parameters"]["delivery-id"];
      };
    };
    responses: {
      202: components["responses"]["accepted"];
      400: components["responses"]["bad_request"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook. */
  "orgs/ping-webhook": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the hook. */
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Enables an authenticated GitHub App to find the organization's installation information.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-org-installation": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["installation"];
        };
      };
    };
  };
  /** Lists all GitHub Apps in an organization. The installation count includes all GitHub Apps installed on repositories in the organization. You must be an organization owner with `admin:read` scope to use this endpoint. */
  "orgs/list-app-installations": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": {
            total_count: number;
            installations: components["schemas"]["installation"][];
          };
        };
      };
    };
  };
  /** Shows which type of GitHub user can interact with this organization and when the restriction expires. If there is no restrictions, you will see an empty response. */
  "interactions/get-restrictions-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": Partial<
            components["schemas"]["interaction-limit-response"]
          > &
            Partial<{ [key: string]: unknown }>;
        };
      };
    };
  };
  /** Temporarily restricts interactions to a certain type of GitHub user in any public repository in the given organization. You must be an organization owner to set these restrictions. Setting the interaction limit at the organization level will overwrite any interaction limits that are set for individual repositories owned by the organization. */
  "interactions/set-restrictions-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["interaction-limit-response"];
        };
      };
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["interaction-limit"];
      };
    };
  };
  /** Removes all interaction restrictions from public repositories in the given organization. You must be an organization owner to remove restrictions. */
  "interactions/remove-restrictions-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      204: never;
    };
  };
  /** The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`. */
  "orgs/list-pending-invitations": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["organization-invitation"][];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.
   *
   * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in secondary rate limiting. See "[Secondary rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#secondary-rate-limits)" and "[Dealing with secondary rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-secondary-rate-limits)" for details.
   */
  "orgs/create-invitation": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["organization-invitation"];
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** **Required unless you provide `email`**. GitHub user ID for the person you are inviting. */
          invitee_id?: number;
          /** **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user. */
          email?: string;
          /**
           * The role for the new member.
           * \* `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.
           * \* `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.
           * \* `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.
           */
          role?: "admin" | "direct_member" | "billing_manager";
          /** Specify IDs for the teams you want to invite new members to. */
          team_ids?: number[];
        };
      };
    };
  };
  /**
   * Cancel an organization invitation. In order to cancel an organization invitation, the authenticated user must be an organization owner.
   *
   * This endpoint triggers [notifications](https://docs.github.com/en/github/managing-subscriptions-and-notifications-on-github/about-notifications).
   */
  "orgs/cancel-invitation": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the invitation. */
        invitation_id: components["parameters"]["invitation-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
  };
  /** List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner. */
  "orgs/list-invitation-teams": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the invitation. */
        invitation_id: components["parameters"]["invitation-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["team"][];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /**
   * List issues in an organization assigned to the authenticated user.
   *
   * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
   * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
   * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
   * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
   */
  "issues/list-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** Indicates which sorts of issues to return. `assigned` means issues assigned to you. `created` means issues created by you. `mentioned` means issues mentioning you. `subscribed` means issues you're subscribed to updates for. `all` or `repos` means all issues you can see, regardless of participation or creation. */
        filter?:
          | "assigned"
          | "created"
          | "mentioned"
          | "subscribed"
          | "repos"
          | "all";
        /** Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`. */
        state?: "open" | "closed" | "all";
        /** A list of comma separated label names. Example: `bug,ui,@high` */
        labels?: components["parameters"]["labels"];
        /** What to sort results by. Can be either `created`, `updated`, `comments`. */
        sort?: "created" | "updated" | "comments";
        /** The direction to sort the results by. */
        direction?: components["parameters"]["direction"];
        /** Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. */
        since?: components["parameters"]["since"];
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["issue"][];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /** List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned. */
  "orgs/list-members": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** Filter members returned in the list. `2fa_disabled` means that only members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled will be returned. This options is only available for organization owners. */
        filter?: "2fa_disabled" | "all";
        /** Filter members returned by their role. */
        role?: "all" | "admin" | "member";
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["simple-user"][];
        };
      };
      /** Response if requester is not an organization member */
      302: never;
      422: components["responses"]["validation_failed"];
    };
  };
  /** Check if a user is, publicly or privately, a member of the organization. */
  "orgs/check-membership-for-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response if requester is an organization member and user is a member */
      204: never;
      /** Response if requester is not an organization member */
      302: never;
      /** Not Found if requester is an organization member and user is not a member */
      404: unknown;
    };
  };
  /** Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories. */
  "orgs/remove-member": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * Deletes a user's codespace.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "codespaces/delete-from-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
        /** The name of the codespace. */
        codespace_name: components["parameters"]["codespace-name"];
      };
    };
    responses: {
      202: components["responses"]["accepted"];
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      500: components["responses"]["internal_error"];
    };
  };
  /**
   * Stops a user's codespace.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "codespaces/stop-in-organization": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
        /** The name of the codespace. */
        codespace_name: components["parameters"]["codespace-name"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["codespace"];
        };
      };
      304: components["responses"]["not_modified"];
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
      500: components["responses"]["internal_error"];
    };
  };
  /** In order to get a user's membership with an organization, the authenticated user must be an organization member. The `state` parameter in the response can be used to identify the user's membership status. */
  "orgs/get-membership-for-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-membership"];
        };
      };
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Only authenticated organization owners can add a member to the organization or update the member's role.
   *
   * *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/rest/reference/orgs#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
   *
   * *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
   *
   * **Rate limits**
   *
   * To prevent abuse, the authenticated user is limited to 50 organization invitations per 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
   */
  "orgs/set-membership-for-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["org-membership"];
        };
      };
      403: components["responses"]["forbidden"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /**
           * The role to give the user in the organization. Can be one of:
           * \* `admin` - The user will become an owner of the organization.
           * \* `member` - The user will become a non-owner member of the organization.
           */
          role?: "admin" | "member";
        };
      };
    };
  };
  /**
   * In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
   *
   * If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
   */
  "orgs/remove-membership-for-user": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /** Lists the most recent migrations. */
  "migrations/list-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
        /** Exclude attributes from the API response to improve performance */
        exclude?: "repositories"[];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["migration"][];
        };
      };
    };
  };
  /** Initiates the generation of a migration archive. */
  "migrations/start-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      201: {
        content: {
          "application/json": components["schemas"]["migration"];
        };
      };
      404: components["responses"]["not_found"];
      422: components["responses"]["validation_failed"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** A list of arrays indicating which repositories should be migrated. */
          repositories: string[];
          /** Indicates whether repositories should be locked (to prevent manipulation) while migrating data. */
          lock_repositories?: boolean;
          /** Indicates whether metadata should be excluded and only git source should be included for the migration. */
          exclude_metadata?: boolean;
          /** Indicates whether the repository git data should be excluded from the migration. */
          exclude_git_data?: boolean;
          /** Indicates whether attachments should be excluded from the migration (to reduce migration archive file size). */
          exclude_attachments?: boolean;
          /** Indicates whether releases should be excluded from the migration (to reduce migration archive file size). */
          exclude_releases?: boolean;
          /** Indicates whether projects owned by the organization or users should be excluded. from the migration. */
          exclude_owner_projects?: boolean;
          /** Indicates whether this should only include organization metadata (repositories array should be empty and will ignore other flags). */
          org_metadata_only?: boolean;
          exclude?: "repositories"[];
        };
      };
    };
  };
  /**
   * Fetches the status of a migration.
   *
   * The `state` of a migration can be one of the following values:
   *
   * *   `pending`, which means the migration hasn't started yet.
   * *   `exporting`, which means the migration is in progress.
   * *   `exported`, which means the migration finished successfully.
   * *   `failed`, which means the migration failed.
   */
  "migrations/get-status-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the migration. */
        migration_id: components["parameters"]["migration-id"];
      };
      query: {
        /** Exclude attributes from the API response to improve performance */
        exclude?: "repositories"[];
      };
    };
    responses: {
      /**
       * *   `pending`, which means the migration hasn't started yet.
       * *   `exporting`, which means the migration is in progress.
       * *   `exported`, which means the migration finished successfully.
       * *   `failed`, which means the migration failed.
       */
      200: {
        content: {
          "application/json": components["schemas"]["migration"];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /** Fetches the URL to a migration archive. */
  "migrations/download-archive-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the migration. */
        migration_id: components["parameters"]["migration-id"];
      };
    };
    responses: {
      /** Response */
      302: never;
      404: components["responses"]["not_found"];
    };
  };
  /** Deletes a previous migration archive. Migration archives are automatically deleted after seven days. */
  "migrations/delete-archive-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the migration. */
        migration_id: components["parameters"]["migration-id"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /** Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/rest/reference/repos#delete-a-repository) when the migration is complete and you no longer need the source data. */
  "migrations/unlock-repo-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the migration. */
        migration_id: components["parameters"]["migration-id"];
        /** repo_name parameter */
        repo_name: components["parameters"]["repo-name"];
      };
    };
    responses: {
      /** Response */
      204: never;
      404: components["responses"]["not_found"];
    };
  };
  /** List all the repositories for this organization migration. */
  "migrations/list-repos-for-org": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The unique identifier of the migration. */
        migration_id: components["parameters"]["migration-id"];
      };
      query: {
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["minimal-repository"][];
        };
      };
      404: components["responses"]["not_found"];
    };
  };
  /** List all users who are outside collaborators of an organization. */
  "orgs/list-outside-collaborators": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** Filter the list of outside collaborators. `2fa_disabled` means that only outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled will be returned. */
        filter?: "2fa_disabled" | "all";
        /** The number of results per page (max 100). */
        per_page?: components["parameters"]["per-page"];
        /** Page number of the results to fetch. */
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /** Response */
      200: {
        headers: {};
        content: {
          "application/json": components["schemas"]["simple-user"][];
        };
      };
    };
  };
  /** When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://docs.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)". Converting an organization member to an outside collaborator may be restricted by enterprise administrators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/enterprise-cloud@latest/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)." */
  "orgs/convert-member-to-outside-collaborator": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** User is getting converted asynchronously */
      202: {
        content: {
          "application/json": { [key: string]: unknown };
        };
      };
      /** User was converted */
      204: never;
      /** Forbidden if user is the last owner of the organization, not a member of the organization, or if the enterprise enforces a policy for inviting outside collaborators. For more information, see "[Enforcing repository management policies in your enterprise](https://docs.github.com/en/enterprise-cloud@latest/admin/policies/enforcing-policies-for-your-enterprise/enforcing-repository-management-policies-in-your-enterprise#enforcing-a-policy-for-inviting-outside-collaborators-to-repositories)." */
      403: unknown;
      404: components["responses"]["not_found"];
    };
    requestBody: {
      content: {
        "application/json": {
          /** When set to `true`, the request will be performed asynchronously. Returns a 202 status code when the job is successfully queued. */
          async?: boolean;
        };
      };
    };
  };
  /** Removing a user from this list will remove them from all the organization's repositories. */
  "orgs/remove-outside-collaborator": {
    parameters: {
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
        /** The handle for the GitHub user account. */
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /** Response */
      204: never;
      /** Unprocessable Entity if user is a member of the organization */
      422: {
        content: {
          "application/json": {
            message?: string;
            documentation_url?: string;
          };
        };
      };
    };
  };
  /**
   * Lists all packages in an organization readable by the user.
   *
   * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
   * If `package_type` is not `container`, your token must also include the `repo` scope.
   */
  "packages/list-packages-for-organization": {
    parameters: {
      query: {
        /** The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry. */
        package_type:
          | "npm"
          | "maven"
          | "rubygems"
          | "docker"
          | "nuget"
          | "container";
        /** The selected visibility of the packages. Only `container` package_types currently support `internal` visibility properly. For other ecosystems `internal` is synonymous with `private`. This parameter is optional and only filters an existing result set. */
        visibility?: components["parameters"]["package-visibility"];
      };
      path: {
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["package"][];
        };
      };
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
    };
  };
  /**
   * Gets a specific package in an organization.
   *
   * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
   * If `package_type` is not `container`, your token must also include the `repo` scope.
   */
  "packages/get-package-for-organization": {
    parameters: {
      path: {
        /** The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry. */
        package_type: components["parameters"]["package-type"];
        /** The name of the package. */
        package_name: components["parameters"]["package-name"];
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      200: {
        content: {
          "application/json": components["schemas"]["package"];
        };
      };
    };
  };
  /**
   * Deletes an entire package in an organization. You cannot delete a public package if any version of the package has more than 5,000 downloads. In this scenario, contact GitHub support for further assistance.
   *
   * To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:delete` scopes. In addition:
   * - If `package_type` is not `container`, your token must also include the `repo` scope.
   * - If `package_type` is `container`, you must also have admin permissions to the container you want to delete.
   */
  "packages/delete-package-for-org": {
    parameters: {
      path: {
        /** The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry. */
        package_type: components["parameters"]["package-type"];
        /** The name of the package. */
        package_name: components["parameters"]["package-name"];
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /** Response */
      204: never;
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Restores an entire package in an organization.
   *
   * You can restore a deleted package under the following conditions:
   *   - The package was deleted within the last 30 days.
   *   - The same package namespace and version is still available and not reused for a new package. If the same package namespace is not available, you will not be able to restore your package. In this scenario, to restore the deleted package, you must delete the new package that uses the deleted package's namespace first.
   *
   * To use this endpoint, you must have admin permissions in the organization and authenticate using an access token with the `packages:read` and `packages:write` scopes. In addition:
   * - If `package_type` is not `container`, your token must also include the `repo` scope.
   * - If `package_type` is `container`, you must also have admin permissions to the container that you want to restore.
   */
  "packages/restore-package-for-org": {
    parameters: {
      path: {
        /** The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry. */
        package_type: components["parameters"]["package-type"];
        /** The name of the package. */
        package_name: components["parameters"]["package-name"];
        /** The organization name. The name is not case sensitive. */
        org: components["parameters"]["org"];
      };
      query: {
        /** package token */
        token?: string;
      };
    };
    responses: {
      /** Response */
      204: never;
      401: components["responses"]["requires_authentication"];
      403: components["responses"]["forbidden"];
      404: components["responses"]["not_found"];
    };
  };
  /**
   * Returns all package versions for a package owned by an organization.
   *
   * To use this endpoint, you must authenticate using an access token with the `packages:read` scope.
   * If `package_type` is not `container`, your token must also include the `repo` scope.
   */
  "packages/get-all-package-versions-for-package-owned-by-org": {
    parameters: {
      path: {
        /** The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry. */
        package_type: components["parameters"]["package-type"];
        /** The name of the package. */
        package