
import { HttpHandler, HttpRequest, HttpResponse } from "@aws-sdk/protocol-http";
import { HttpHandlerOptions, Provider } from "@aws-sdk/types";
import { Agent as hAgent } from "http";
import { Agent as hsAgent } from "https";

export interface NodeHttpHandlerOptions {
    
    connectionTimeout?: number;
    
    socketTimeout?: number;
    httpAgent?: hAgent;
    httpsAgent?: hsAgent;
}
export declare class NodeHttpHandler implements HttpHandler {
    private config?;
    private readonly configProvider;
    readonly metadata: {
        handlerProtocol: string;
    };
    constructor(options?: NodeHttpHandlerOptions | Provider<NodeHttpHandlerOptions | void>);
    private resolveDefaultConfig;
    destroy(): void;
    handle(request: HttpRequest, { abortSignal }?: HttpHandlerOptions): Promise<{
        response: HttpResponse;
    }>;
}
