import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ListSecretsRequest, ListSecretsResponse } from "../models/models_0";
import { SecretsManagerClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../SecretsManagerClient";
export interface ListSecretsCommandInput extends ListSecretsRequest {
}
export interface ListSecretsCommandOutput extends ListSecretsResponse, __MetadataBearer {
}

export declare class ListSecretsCommand extends $Command<ListSecretsCommandInput, ListSecretsCommandOutput, SecretsManagerClientResolvedConfig> {
    readonly input: ListSecretsCommandInput;
    constructor(input: ListSecretsCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: SecretsManagerClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ListSecretsCommandInput, ListSecretsCommandOutput>;
    private serialize;
    private deserialize;
}
