import { HttpHandlerOptions as __HttpHandlerOptions } from "@aws-sdk/types";
import { CancelRotateSecretCommandInput, CancelRotateSecretCommandOutput } from "./commands/CancelRotateSecretCommand";
import { CreateSecretCommandInput, CreateSecretCommandOutput } from "./commands/CreateSecretCommand";
import { DeleteResourcePolicyCommandInput, DeleteResourcePolicyCommandOutput } from "./commands/DeleteResourcePolicyCommand";
import { DeleteSecretCommandInput, DeleteSecretCommandOutput } from "./commands/DeleteSecretCommand";
import { DescribeSecretCommandInput, DescribeSecretCommandOutput } from "./commands/DescribeSecretCommand";
import { GetRandomPasswordCommandInput, GetRandomPasswordCommandOutput } from "./commands/GetRandomPasswordCommand";
import { GetResourcePolicyCommandInput, GetResourcePolicyCommandOutput } from "./commands/GetResourcePolicyCommand";
import { GetSecretValueCommandInput, GetSecretValueCommandOutput } from "./commands/GetSecretValueCommand";
import { ListSecretsCommandInput, ListSecretsCommandOutput } from "./commands/ListSecretsCommand";
import { ListSecretVersionIdsCommandInput, ListSecretVersionIdsCommandOutput } from "./commands/ListSecretVersionIdsCommand";
import { PutResourcePolicyCommandInput, PutResourcePolicyCommandOutput } from "./commands/PutResourcePolicyCommand";
import { PutSecretValueCommandInput, PutSecretValueCommandOutput } from "./commands/PutSecretValueCommand";
import { RemoveRegionsFromReplicationCommandInput, RemoveRegionsFromReplicationCommandOutput } from "./commands/RemoveRegionsFromReplicationCommand";
import { ReplicateSecretToRegionsCommandInput, ReplicateSecretToRegionsCommandOutput } from "./commands/ReplicateSecretToRegionsCommand";
import { RestoreSecretCommandInput, RestoreSecretCommandOutput } from "./commands/RestoreSecretCommand";
import { RotateSecretCommandInput, RotateSecretCommandOutput } from "./commands/RotateSecretCommand";
import { StopReplicationToReplicaCommandInput, StopReplicationToReplicaCommandOutput } from "./commands/StopReplicationToReplicaCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdateSecretCommandInput, UpdateSecretCommandOutput } from "./commands/UpdateSecretCommand";
import { UpdateSecretVersionStageCommandInput, UpdateSecretVersionStageCommandOutput } from "./commands/UpdateSecretVersionStageCommand";
import { ValidateResourcePolicyCommandInput, ValidateResourcePolicyCommandOutput } from "./commands/ValidateResourcePolicyCommand";
import { SecretsManagerClient } from "./SecretsManagerClient";

export declare class SecretsManager extends SecretsManagerClient {
    
    cancelRotateSecret(args: CancelRotateSecretCommandInput, options?: __HttpHandlerOptions): Promise<CancelRotateSecretCommandOutput>;
    cancelRotateSecret(args: CancelRotateSecretCommandInput, cb: (err: any, data?: CancelRotateSecretCommandOutput) => void): void;
    cancelRotateSecret(args: CancelRotateSecretCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CancelRotateSecretCommandOutput) => void): void;
    
    createSecret(args: CreateSecretCommandInput, options?: __HttpHandlerOptions): Promise<CreateSecretCommandOutput>;
    createSecret(args: CreateSecretCommandInput, cb: (err: any, data?: CreateSecretCommandOutput) => void): void;
    createSecret(args: CreateSecretCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateSecretCommandOutput) => void): void;
    
    deleteResourcePolicy(args: DeleteResourcePolicyCommandInput, options?: __HttpHandlerOptions): Promise<DeleteResourcePolicyCommandOutput>;
    deleteResourcePolicy(args: DeleteResourcePolicyCommandInput, cb: (err: any, data?: DeleteResourcePolicyCommandOutput) => void): void;
    deleteResourcePolicy(args: DeleteResourcePolicyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteResourcePolicyCommandOutput) => void): void;
    
    deleteSecret(args: DeleteSecretCommandInput, options?: __HttpHandlerOptions): Promise<DeleteSecretCommandOutput>;
    deleteSecret(args: DeleteSecretCommandInput, cb: (err: any, data?: DeleteSecretCommandOutput) => void): void;
    deleteSecret(args: DeleteSecretCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteSecretCommandOutput) => void): void;
    
    describeSecret(args: DescribeSecretCommandInput, options?: __HttpHandlerOptions): Promise<DescribeSecretCommandOutput>;
    describeSecret(args: DescribeSecretCommandInput, cb: (err: any, data?: DescribeSecretCommandOutput) => void): void;
    describeSecret(args: DescribeSecretCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DescribeSecretCommandOutput) => void): void;
    
    getRandomPassword(args: GetRandomPasswordCommandInput, options?: __HttpHandlerOptions): Promise<GetRandomPasswordCommandOutput>;
    getRandomPassword(args: GetRandomPasswordCommandInput, cb: (err: any, data?: GetRandomPasswordCommandOutput) => void): void;
    getRandomPassword(args: GetRandomPasswordCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetRandomPasswordCommandOutput) => void): void;
    
    getResourcePolicy(args: GetResourcePolicyCommandInput, options?: __HttpHandlerOptions): Promise<GetResourcePolicyCommandOutput>;
    getResourcePolicy(args: GetResourcePolicyCommandInput, cb: (err: any, data?: GetResourcePolicyCommandOutput) => void): void;
    getResourcePolicy(args: GetResourcePolicyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetResourcePolicyCommandOutput) => void): void;
    
    getSecretValue(args: GetSecretValueCommandInput, options?: __HttpHandlerOptions): Promise<GetSecretValueCommandOutput>;
    getSecretValue(args: GetSecretValueCommandInput, cb: (err: any, data?: GetSecretValueCommandOutput) => void): void;
    getSecretValue(args: GetSecretValueCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetSecretValueCommandOutput) => void): void;
    
    listSecrets(args: ListSecretsCommandInput, options?: __HttpHandlerOptions): Promise<ListSecretsCommandOutput>;
    listSecrets(args: ListSecretsCommandInput, cb: (err: any, data?: ListSecretsCommandOutput) => void): void;
    listSecrets(args: ListSecretsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListSecretsCommandOutput) => void): void;
    
    listSecretVersionIds(args: ListSecretVersionIdsCommandInput, options?: __HttpHandlerOptions): Promise<ListSecretVersionIdsCommandOutput>;
    listSecretVersionIds(args: ListSecretVersionIdsCommandInput, cb: (err: any, data?: ListSecretVersionIdsCommandOutput) => void): void;
    listSecretVersionIds(args: ListSecretVersionIdsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListSecretVersionIdsCommandOutput) => void): void;
    
    putResourcePolicy(args: PutResourcePolicyCommandInput, options?: __HttpHandlerOptions): Promise<PutResourcePolicyCommandOutput>;
    putResourcePolicy(args: PutResourcePolicyCommandInput, cb: (err: any, data?: PutResourcePolicyCommandOutput) => void): void;
    putResourcePolicy(args: PutResourcePolicyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutResourcePolicyCommandOutput) => void): void;
    
    putSecretValue(args: PutSecretValueCommandInput, options?: __HttpHandlerOptions): Promise<PutSecretValueCommandOutput>;
    putSecretValue(args: PutSecretValueCommandInput, cb: (err: any, data?: PutSecretValueCommandOutput) => void): void;
    putSecretValue(args: PutSecretValueCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutSecretValueCommandOutput) => void): void;
    
    removeRegionsFromReplication(args: RemoveRegionsFromReplicationCommandInput, options?: __HttpHandlerOptions): Promise<RemoveRegionsFromReplicationCommandOutput>;
    removeRegionsFromReplication(args: RemoveRegionsFromReplicationCommandInput, cb: (err: any, data?: RemoveRegionsFromReplicationCommandOutput) => void): void;
    removeRegionsFromReplication(args: RemoveRegionsFromReplicationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RemoveRegionsFromReplicationCommandOutput) => void): void;
    
    replicateSecretToRegions(args: ReplicateSecretToRegionsCommandInput, options?: __HttpHandlerOptions): Promise<ReplicateSecretToRegionsCommandOutput>;
    replicateSecretToRegions(args: ReplicateSecretToRegionsCommandInput, cb: (err: any, data?: ReplicateSecretToRegionsCommandOutput) => void): void;
    replicateSecretToRegions(args: ReplicateSecretToRegionsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ReplicateSecretToRegionsCommandOutput) => void): void;
    
    restoreSecret(args: RestoreSecretCommandInput, options?: __HttpHandlerOptions): Promise<RestoreSecretCommandOutput>;
    restoreSecret(args: RestoreSecretCommandInput, cb: (err: any, data?: RestoreSecretCommandOutput) => void): void;
    restoreSecret(args: RestoreSecretCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RestoreSecretCommandOutput) => void): void;
    
    rotateSecret(args: RotateSecretCommandInput, options?: __HttpHandlerOptions): Promise<RotateSecretCommandOutput>;
    rotateSecret(args: RotateSecretCommandInput, cb: (err: any, data?: RotateSecretCommandOutput) => void): void;
    rotateSecret(args: RotateSecretCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RotateSecretCommandOutput) => void): void;
    
    stopReplicationToReplica(args: StopReplicationToReplicaCommandInput, options?: __HttpHandlerOptions): Promise<StopReplicationToReplicaCommandOutput>;
    stopReplicationToReplica(args: StopReplicationToReplicaCommandInput, cb: (err: any, data?: StopReplicationToReplicaCommandOutput) => void): void;
    stopReplicationToReplica(args: StopReplicationToReplicaCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: StopReplicationToReplicaCommandOutput) => void): void;
    
    tagResource(args: TagResourceCommandInput, options?: __HttpHandlerOptions): Promise<TagResourceCommandOutput>;
    tagResource(args: TagResourceCommandInput, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    tagResource(args: TagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    
    untagResource(args: UntagResourceCommandInput, options?: __HttpHandlerOptions): Promise<UntagResourceCommandOutput>;
    untagResource(args: UntagResourceCommandInput, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    untagResource(args: UntagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    
    updateSecret(args: UpdateSecretCommandInput, options?: __HttpHandlerOptions): Promise<UpdateSecretCommandOutput>;
    updateSecret(args: UpdateSecretCommandInput, cb: (err: any, data?: UpdateSecretCommandOutput) => void): void;
    updateSecret(args: UpdateSecretCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateSecretCommandOutput) => void): void;
    
    updateSecretVersionStage(args: UpdateSecretVersionStageCommandInput, options?: __HttpHandlerOptions): Promise<UpdateSecretVersionStageCommandOutput>;
    updateSecretVersionStage(args: UpdateSecretVersionStageCommandInput, cb: (err: any, data?: UpdateSecretVersionStageCommandOutput) => void): void;
    updateSecretVersionStage(args: UpdateSecretVersionStageCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateSecretVersionStageCommandOutput) => void): void;
    
    validateResourcePolicy(args: ValidateResourcePolicyCommandInput, options?: __HttpHandlerOptions): Promise<ValidateResourcePolicyCommandOutput>;
    validateResourcePolicy(args: ValidateResourcePolicyCommandInput, cb: (err: any, data?: ValidateResourcePolicyCommandOutput) => void): void;
    validateResourcePolicy(args: ValidateResourcePolicyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ValidateResourcePolicyCommandOutput) => void): void;
}
