"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encryptValue = void 0;
// Need to import it like that because projen doesnt support esModuleInterop
// eslint-disable-next-line @typescript-eslint/no-require-imports
const _sodium = require('libsodium-wrappers');
// Compatible with the same `Uint8Array` arguments as `tweetsodium.seal()`
async function async_encrypt(messageBytes, publicKey) {
    await _sodium.ready;
    const libsodium = _sodium;
    return libsodium.crypto_box_seal(messageBytes, publicKey);
}
exports.encryptValue = async (valueToEncrypt, key) => {
    // Convert the message and key to Uint8Array's (Buffer implements that interface)
    const messageBytes = Buffer.from(valueToEncrypt);
    const keyBytes = Buffer.from(key, 'base64');
    // Encrypt using LibSodium.
    const encryptedBytes = await async_encrypt(messageBytes, keyBytes);
    // Base64 the encrypted secret
    const encrypted = Buffer.from(encryptedBytes).toString('base64');
    return encrypted;
};
//# sourceMappingURL=data:application/json;base64,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