"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAlertsPolicy = exports.AlertsPolicyInputIncidentPreference = exports.toJson_AlertsPolicyInput = exports.toJson_CfnAlertsPolicyProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnAlertsPolicyProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnAlertsPolicyProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccountId': obj.accountId,
        'AlertsPolicy': toJson_AlertsPolicyInput(obj.alertsPolicy),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnAlertsPolicyProps = toJson_CfnAlertsPolicyProps;
/**
 * Converts an object of type 'AlertsPolicyInput' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AlertsPolicyInput(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'IncidentPreference': obj.incidentPreference,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AlertsPolicyInput = toJson_AlertsPolicyInput;
/* eslint-enable max-len, quote-props */
/**
 * @schema AlertsPolicyInputIncidentPreference
 */
var AlertsPolicyInputIncidentPreference;
(function (AlertsPolicyInputIncidentPreference) {
    /** PER_CONDITION */
    AlertsPolicyInputIncidentPreference["PER_CONDITION"] = "PER_CONDITION";
    /** PER_CONDITION_AND_TARGET */
    AlertsPolicyInputIncidentPreference["PER_CONDITION_AND_TARGET"] = "PER_CONDITION_AND_TARGET";
    /** PER_POLICY */
    AlertsPolicyInputIncidentPreference["PER_POLICY"] = "PER_POLICY";
})(AlertsPolicyInputIncidentPreference = exports.AlertsPolicyInputIncidentPreference || (exports.AlertsPolicyInputIncidentPreference = {}));
/**
 * A CloudFormation `NewRelic::Alert::AlertsPolicy`
 *
 * @cloudformationResource NewRelic::Alert::AlertsPolicy
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-newrelic-resource-providers.git
 */
class CfnAlertsPolicy extends cdk.CfnResource {
    /**
     * Create a new `NewRelic::Alert::AlertsPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAlertsPolicy.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnAlertsPolicyProps(props) });
        this.props = props;
        this.attrAlertsPolicyId = cdk.Token.asNumber(this.getAtt('AlertsPolicyId'));
    }
}
exports.CfnAlertsPolicy = CfnAlertsPolicy;
_a = JSII_RTTI_SYMBOL_1;
CfnAlertsPolicy[_a] = { fqn: "@cdk-cloudformation/newrelic-alert-alertspolicy.CfnAlertsPolicy", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnAlertsPolicy.CFN_RESOURCE_TYPE_NAME = "NewRelic::Alert::AlertsPolicy";
//# sourceMappingURL=data:application/json;base64,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