import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage New Relic AlertsPolicy
 *
 * @schema CfnAlertsPolicyProps
 */
export interface CfnAlertsPolicyProps {
    /**
     * Account ID the alerts policy should belong to.
     *
     * @schema CfnAlertsPolicyProps#AccountId
     */
    readonly accountId: number;
    /**
     * @schema CfnAlertsPolicyProps#AlertsPolicy
     */
    readonly alertsPolicy: AlertsPolicyInput;
}
/**
 * Converts an object of type 'CfnAlertsPolicyProps' to JSON representation.
 */
export declare function toJson_CfnAlertsPolicyProps(obj: CfnAlertsPolicyProps | undefined): Record<string, any> | undefined;
/**
 * @schema AlertsPolicyInput
 */
export interface AlertsPolicyInput {
    /**
     * Name of the alerts policy.
     *
     * @schema AlertsPolicyInput#Name
     */
    readonly name?: string;
    /**
     * @schema AlertsPolicyInput#IncidentPreference
     */
    readonly incidentPreference?: AlertsPolicyInputIncidentPreference;
}
/**
 * Converts an object of type 'AlertsPolicyInput' to JSON representation.
 */
export declare function toJson_AlertsPolicyInput(obj: AlertsPolicyInput | undefined): Record<string, any> | undefined;
/**
 * @schema AlertsPolicyInputIncidentPreference
 */
export declare enum AlertsPolicyInputIncidentPreference {
    /** PER_CONDITION */
    PER_CONDITION = "PER_CONDITION",
    /** PER_CONDITION_AND_TARGET */
    PER_CONDITION_AND_TARGET = "PER_CONDITION_AND_TARGET",
    /** PER_POLICY */
    PER_POLICY = "PER_POLICY"
}
/**
 * A CloudFormation `NewRelic::Alert::AlertsPolicy`
 *
 * @cloudformationResource NewRelic::Alert::AlertsPolicy
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-newrelic-resource-providers.git
 */
export declare class CfnAlertsPolicy extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "NewRelic::Alert::AlertsPolicy";
    /**
     * Resource props.
     */
    readonly props: CfnAlertsPolicyProps;
    /**
     * Attribute `NewRelic::Alert::AlertsPolicy.AlertsPolicyId`
     * @link https://github.com/aws-ia/cloudformation-newrelic-resource-providers.git
     */
    readonly attrAlertsPolicyId: number;
    /**
     * Create a new `NewRelic::Alert::AlertsPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnAlertsPolicyProps);
}
