# Contributing

For contributing to this repository, please first submit an issue via an [issue](https://github.com/ansible/ansible-risk-insight/issues).
All the related PRs should refer to this issue.

## Pull Request Process

1. Create an [issue](https://github.com/ansible/ansible-risk-insight/issues).
2. Fork the ansible-risk-insight repository to your own github account and clone it locally.
3. Apply your changes to the local codes.
4. Update the README.md and some other documents if needed, especially if you change any interface such as CLI parameters, environment variables and data models.
5. Write your commit message to describe your changes concisely. 
6. Submit a pull request with your sign-off signature like `Signed-off-by: XXXX xxxx@example.com`
7. Ensure that CI passes, if it fails, fix the failures.
8. Every pull request requires a review before merging.
9. If your pull request consists of more than one commit, your commits will be squashed when the PR is merged.